/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager.bundlers;

import com.sun.javafx.tools.packager.Log;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.packager.bundlers.IOUtils;
import com.sun.javafx.tools.packager.bundlers.MacAppBundler;
import com.sun.javafx.tools.resource.mac.MacResources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import sun.misc.BASE64Encoder;

public class MacDMGBundler
extends Bundler {
    private MacAppBundler appBundler = new MacAppBundler();
    private File configRoot = null;
    private BundleParams params = null;
    File appImageDir;
    static final String DEFAULT_BACKGROUND_IMAGE = "background.png";
    static final String DEFAULT_DMG_SETUP_SCRIPT = "DMGsetup.scpt";
    static final String DEFAULT_LICENSE_PLIST = "lic_template.plist";
    private static final String hdiutil = "/usr/bin/hdiutil";

    public MacDMGBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    boolean validate(BundleParams p) throws Bundler.UnsupportedPlatformException, Bundler.ConfigException {
        if (p.type != Bundler.BundleType.ALL && p.type != Bundler.BundleType.INSTALLER || p.bundleFormat != null && !"dmg".equals(p.bundleFormat)) {
            return false;
        }
        this.appBundler.doValidate(p);
        return true;
    }

    private boolean prepareProto(BundleParams p) {
        return this.appBundler.doBundle(p, this.appImageDir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean bundle(BundleParams p, File outdir) {
        boolean configScript2;
        block32: {
            boolean bl;
            block31: {
                Log.info("Building DMG package for " + p.name);
                this.params = p;
                this.appImageDir = new File(this.imagesRoot, "dmg.image");
                try {
                    try {
                        this.appImageDir.mkdirs();
                        if (this.prepareProto(p) && this.prepareConfigFiles()) {
                            File configScript2 = this.getConfig_Script();
                            if (configScript2.exists()) {
                                Log.info("Running shell script on application image [" + configScript2.getAbsolutePath() + "]");
                                IOUtils.run("bash", configScript2, this.verbose);
                            }
                            bl = this.buildDMG(p, outdir);
                            Object var6_8 = null;
                            break block31;
                        }
                        configScript2 = false;
                        break block32;
                    }
                    catch (IOException ex) {
                        Log.verbose(ex);
                        boolean bl2 = false;
                        Object var6_10 = null;
                        try {
                            if (this.appImageDir != null && !Log.isDebug()) {
                                IOUtils.deleteRecursive(this.appImageDir);
                            } else if (this.appImageDir != null) {
                                Log.info("[DEBUG] Intermediate application bundle image: " + this.appImageDir.getAbsolutePath());
                            }
                            if (!this.verbose) {
                                this.cleanupConfigFiles();
                            } else {
                                Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                            }
                            this.appImageDir = null;
                            return bl2;
                        }
                        catch (FileNotFoundException ex2) {
                            return false;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    try {}
                    catch (FileNotFoundException ex2) {
                        return false;
                    }
                    if (this.appImageDir != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(this.appImageDir);
                    } else if (this.appImageDir != null) {
                        Log.info("[DEBUG] Intermediate application bundle image: " + this.appImageDir.getAbsolutePath());
                    }
                    if (!this.verbose) {
                        this.cleanupConfigFiles();
                    } else {
                        Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
                    }
                    this.appImageDir = null;
                    throw throwable;
                }
            }
            try {}
            catch (FileNotFoundException ex2) {
                return false;
            }
            if (this.appImageDir != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(this.appImageDir);
            } else if (this.appImageDir != null) {
                Log.info("[DEBUG] Intermediate application bundle image: " + this.appImageDir.getAbsolutePath());
            }
            if (!this.verbose) {
                this.cleanupConfigFiles();
            } else {
                Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
            }
            this.appImageDir = null;
            return bl;
        }
        Object var6_9 = null;
        try {}
        catch (FileNotFoundException ex2) {
            return false;
        }
        if (this.appImageDir != null && !Log.isDebug()) {
            IOUtils.deleteRecursive(this.appImageDir);
        } else if (this.appImageDir != null) {
            Log.info("[DEBUG] Intermediate application bundle image: " + this.appImageDir.getAbsolutePath());
        }
        if (!this.verbose) {
            this.cleanupConfigFiles();
        } else {
            Log.info("  Config files are saved to " + this.configRoot.getAbsolutePath() + ". Use them to customize package.");
        }
        this.appImageDir = null;
        return configScript2;
    }

    protected void cleanupConfigFiles() {
        if (this.getConfig_VolumeBackground() != null) {
            this.getConfig_VolumeBackground().delete();
        }
        if (this.getConfig_VolumeIcon() != null) {
            this.getConfig_VolumeIcon().delete();
        }
        if (this.getConfig_VolumeScript() != null) {
            this.getConfig_VolumeScript().delete();
        }
        if (this.getConfig_Script() != null) {
            this.getConfig_Script().delete();
        }
        if (this.getConfig_LicenseFile() != null) {
            this.getConfig_LicenseFile().delete();
        }
        this.appBundler.cleanupConfigFiles();
    }

    public String toString() {
        return "MacOS DMG Bundler";
    }

    public void setVerbose(boolean m) {
        super.setVerbose(m);
        this.appBundler.setVerbose(m);
    }

    protected void setBuildRoot(File dir) {
        super.setBuildRoot(dir);
        this.configRoot = new File(dir, "macosx");
        this.configRoot.mkdirs();
        this.appBundler.setBuildRoot(dir);
    }

    private void prepareDMGSetupScript(String volumeName, BundleParams p) throws IOException {
        boolean systemWide;
        File dmgSetup = this.getConfig_VolumeScript();
        Log.verbose("Preparing dmg setup: " + dmgSetup.getAbsolutePath());
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("DEPLOY_ACTUAL_VOLUME_NAME", volumeName);
        data.put("DEPLOY_APPLICATION_NAME", p.name);
        boolean bl = systemWide = p.systemWide == null || p.systemWide != false;
        if (systemWide) {
            data.put("DEPLOY_INSTALL_LOCATION", "POSIX file \"/Applications\"");
            data.put("DEPLOY_INSTALL_NAME", "Applications");
        } else {
            data.put("DEPLOY_INSTALL_LOCATION", "(path to desktop folder)");
            data.put("DEPLOY_INSTALL_NAME", "Desktop");
        }
        BufferedWriter w = new BufferedWriter(new FileWriter(dmgSetup));
        w.write(this.preprocessTextResource(MacAppBundler.MAC_BUNDLER_PREFIX + dmgSetup.getName(), "DMG setup script", DEFAULT_DMG_SETUP_SCRIPT, data));
        ((Writer)w).close();
    }

    private File getConfig_VolumeScript() {
        return new File(this.configRoot, this.params.name + "-dmg-setup.scpt");
    }

    private File getConfig_VolumeBackground() {
        return new File(this.configRoot, this.params.name + "-background.png");
    }

    private File getConfig_VolumeIcon() {
        return new File(this.configRoot, this.params.name + "-volume.icns");
    }

    private File getConfig_LicenseFile() {
        return new File(this.configRoot, this.params.name + "-license.plist");
    }

    private void prepareLicense() {
        try {
            if (this.params.licenseFile.isEmpty()) {
                return;
            }
            File licFile = new File(this.params.appResources.getBaseDirectory(), this.params.licenseFile.get(0));
            byte[] licenseContentOriginal = IOUtils.readFully(licFile);
            BASE64Encoder encoder = new BASE64Encoder();
            String licenseInBase64 = encoder.encode(licenseContentOriginal);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("APPLICATION_LICENSE_TEXT", licenseInBase64);
            BufferedWriter w = new BufferedWriter(new FileWriter(this.getConfig_LicenseFile()));
            w.write(this.preprocessTextResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_LicenseFile().getName(), "License setup", DEFAULT_LICENSE_PLIST, data));
            ((Writer)w).close();
        }
        catch (IOException ex) {
            Log.verbose(ex);
        }
    }

    private boolean prepareConfigFiles() throws IOException {
        File bgTarget = this.getConfig_VolumeBackground();
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + bgTarget.getName(), "dmg background", DEFAULT_BACKGROUND_IMAGE, bgTarget);
        File iconTarget = this.getConfig_VolumeIcon();
        if (this.params.icon == null || !this.params.icon.exists()) {
            this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + iconTarget.getName(), "volume icon", "GenericApp.icns", iconTarget);
        } else {
            this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + iconTarget.getName(), "volume icon", this.params.icon, iconTarget);
        }
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_Script().getName(), "script to run after application image is populated", (String)null, this.getConfig_Script());
        this.prepareLicense();
        this.prepareDMGSetupScript(this.params.name, this.params);
        return true;
    }

    private File getConfig_Script() {
        return new File(this.configRoot, this.params.name + "-post-image.sh");
    }

    private String findSetFileUtility() {
        String[] typicalPaths;
        for (String path : typicalPaths = new String[]{"/Developer/Tools/SetFile", "/usr/bin/SetFile", "/Developer/usr/bin/SetFile"}) {
            File f = new File(path);
            if (!f.exists() || !f.canExecute()) continue;
            return path;
        }
        try {
            String path;
            File f;
            ProcessBuilder pb = new ProcessBuilder("xcrun", "-find", "SetFile");
            Process p = pb.start();
            InputStreamReader isr = new InputStreamReader(p.getInputStream());
            BufferedReader br = new BufferedReader(isr);
            String lineRead = br.readLine();
            if (lineRead != null && (f = new File(path = lineRead)).exists() && f.canExecute()) {
                return f.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private boolean buildDMG(BundleParams p, File outdir) throws IOException {
        File protoDMG = new File(this.imagesRoot, p.name + "-tmp.dmg");
        File finalDMG = new File(outdir, p.name + ".dmg");
        File srcFolder = this.appImageDir;
        Log.verbose(" Creating DMG file: " + finalDMG.getAbsolutePath());
        protoDMG.delete();
        if (finalDMG.exists() && !finalDMG.delete()) {
            throw new IOException("Dmg file exists (" + finalDMG.getAbsolutePath() + " and can not be removed.");
        }
        protoDMG.getParentFile().mkdirs();
        finalDMG.getParentFile().mkdirs();
        ProcessBuilder pb = new ProcessBuilder(hdiutil, "create", "-quiet", "-srcfolder", srcFolder.getAbsolutePath(), "-volname", p.name, "-ov", protoDMG.getAbsolutePath(), "-format", "UDRW");
        IOUtils.exec(pb, this.verbose);
        pb = new ProcessBuilder(hdiutil, "attach", protoDMG.getAbsolutePath(), "-quiet", "-mountroot", this.imagesRoot.getAbsolutePath());
        IOUtils.exec(pb, this.verbose);
        File mountedRoot = new File(this.imagesRoot.getAbsolutePath(), p.name);
        File bgdir = new File(mountedRoot, ".background");
        bgdir.mkdirs();
        IOUtils.copyFile(this.getConfig_VolumeBackground(), new File(bgdir, DEFAULT_BACKGROUND_IMAGE));
        File volumeIconFile = new File(mountedRoot, ".VolumeIcon.icns");
        IOUtils.copyFile(this.getConfig_VolumeIcon(), volumeIconFile);
        pb = new ProcessBuilder("osascript", this.getConfig_VolumeScript().getAbsolutePath());
        IOUtils.exec(pb, this.verbose);
        String setFileUtility = this.findSetFileUtility();
        if (setFileUtility != null) {
            volumeIconFile.setWritable(true);
            pb = new ProcessBuilder(setFileUtility, "-c", "icnC", volumeIconFile.getAbsolutePath());
            IOUtils.exec(pb, this.verbose);
            volumeIconFile.setReadOnly();
            pb = new ProcessBuilder(setFileUtility, "-a", "C", mountedRoot.getAbsolutePath());
            IOUtils.exec(pb, this.verbose);
        } else {
            Log.verbose("Skip enabling custom icon as SetFile utility is not found");
        }
        pb = new ProcessBuilder(hdiutil, "detach", "-quiet", mountedRoot.getAbsolutePath());
        IOUtils.exec(pb, this.verbose);
        pb = new ProcessBuilder(hdiutil, "convert", protoDMG.getAbsolutePath(), "-quiet", "-format", "UDZO", "-o", finalDMG.getAbsolutePath());
        IOUtils.exec(pb, this.verbose);
        if (this.getConfig_LicenseFile().exists()) {
            pb = new ProcessBuilder(hdiutil, "unflatten", finalDMG.getAbsolutePath());
            IOUtils.exec(pb, this.verbose);
            pb = new ProcessBuilder(hdiutil, "udifrez", finalDMG.getAbsolutePath(), "-xml", this.getConfig_LicenseFile().getAbsolutePath());
            IOUtils.exec(pb, this.verbose);
            pb = new ProcessBuilder(hdiutil, "flatten", finalDMG.getAbsolutePath());
            IOUtils.exec(pb, this.verbose);
        }
        protoDMG.delete();
        Log.info("Result DMG installer for " + p.name + ": " + finalDMG.getAbsolutePath());
        return true;
    }
}

