/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.core.output2.options.LinkStyleModel;
import org.netbeans.core.output2.options.OutputOptions;
import org.netbeans.core.output2.options.OutputSettingsOptionsPanelController;
import org.netbeans.core.output2.options.PreviewIOProvider;
import org.netbeans.core.output2.ui.AbstractOutputTab;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputSettingsPanel
extends JPanel {
    private OutputOptions outputOptions;
    private InputOutput previewInputOutput = null;
    private final OutputSettingsOptionsPanelController controller;
    private LinkStyleModel linkStyleModel = new LinkStyleModel();
    private JButton btnRestore;
    private JButton btnSelectFont;
    private JComboBox cmbBackgroundColor;
    private JComboBox cmbErrorColor;
    private JComboBox cmbImportantLinkColor;
    private JComboBox cmbLinkColor;
    private JComboBox cmbLinkStyle;
    private JComboBox cmbStandardColor;
    private JTextField fldFontFamily;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JLabel lblBackgroundColor;
    private JLabel lblErrorColor;
    private JLabel lblFontFamily;
    private JLabel lblFontSize;
    private JLabel lblLinkColor;
    private JLabel lblLinkStyle;
    private JLabel lblStandardColor;
    private JLabel lblTitle;
    private JLabel lblUnwrappedOnly;
    private JPanel previewPanel;
    private JSpinner spnFontSize;

    OutputSettingsPanel(OutputSettingsOptionsPanelController outputSettingsOptionsPanelController) {
        this.controller = outputSettingsOptionsPanelController;
        this.initComponents();
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblFontFamily = new JLabel();
        this.lblStandardColor = new JLabel();
        this.lblErrorColor = new JLabel();
        this.lblBackgroundColor = new JLabel();
        this.lblLinkColor = new JLabel();
        this.cmbLinkColor = new ColorComboBox();
        this.cmbBackgroundColor = new ColorComboBox();
        this.cmbErrorColor = new ColorComboBox();
        this.cmbStandardColor = new ColorComboBox();
        this.lblFontSize = new JLabel();
        this.spnFontSize = new JSpinner();
        this.btnSelectFont = new JButton();
        this.cmbLinkStyle = new JComboBox();
        this.lblLinkStyle = new JLabel();
        this.fldFontFamily = new JTextField();
        this.cmbImportantLinkColor = new ColorComboBox();
        this.jLabel1 = new JLabel();
        this.lblUnwrappedOnly = new JLabel();
        this.previewPanel = new JPanel();
        this.btnRestore = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblTitle.text"));
        this.lblFontFamily.setLabelFor(this.btnSelectFont);
        Mnemonics.setLocalizedText((JLabel)this.lblFontFamily, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblFontFamily.text"));
        this.lblStandardColor.setLabelFor(this.cmbStandardColor);
        Mnemonics.setLocalizedText((JLabel)this.lblStandardColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblStandardColor.text"));
        this.lblErrorColor.setLabelFor(this.cmbErrorColor);
        Mnemonics.setLocalizedText((JLabel)this.lblErrorColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblErrorColor.text"));
        this.lblBackgroundColor.setLabelFor(this.cmbBackgroundColor);
        Mnemonics.setLocalizedText((JLabel)this.lblBackgroundColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblBackgroundColor.text"));
        this.lblLinkColor.setLabelFor(this.cmbLinkColor);
        Mnemonics.setLocalizedText((JLabel)this.lblLinkColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblLinkColor.text"));
        this.cmbLinkColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbLinkColor.toolTipText"));
        this.cmbLinkColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.cmbLinkColorActionPerformed(actionEvent);
            }
        });
        this.cmbBackgroundColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbBackgroundColor.toolTipText"));
        this.cmbBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.cmbBackgroundColorActionPerformed(actionEvent);
            }
        });
        this.cmbErrorColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbErrorColor.toolTipText"));
        this.cmbErrorColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.cmbErrorColorActionPerformed(actionEvent);
            }
        });
        this.cmbStandardColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbStandardColor.toolTipText"));
        this.cmbStandardColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.cmbStandardColorActionPerformed(actionEvent);
            }
        });
        this.lblFontSize.setLabelFor(this.spnFontSize);
        Mnemonics.setLocalizedText((JLabel)this.lblFontSize, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblFontSize.text"));
        this.spnFontSize.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.spnFontSize.toolTipText"));
        this.spnFontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                OutputSettingsPanel.this.spnFontSizeStateChanged(changeEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFont, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnSelectFont.text"));
        this.btnSelectFont.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnSelectFont.toolTipText"));
        this.btnSelectFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.btnSelectFontActionPerformed(actionEvent);
            }
        });
        this.cmbLinkStyle.setModel(this.linkStyleModel);
        this.cmbLinkStyle.setSelectedIndex(0);
        this.cmbLinkStyle.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbLinkStyle.toolTipText"));
        this.cmbLinkStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.cmbLinkStyleActionPerformed(actionEvent);
            }
        });
        this.lblLinkStyle.setLabelFor(this.cmbLinkStyle);
        Mnemonics.setLocalizedText((JLabel)this.lblLinkStyle, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblLinkStyle.text"));
        this.fldFontFamily.setEditable(false);
        this.fldFontFamily.setText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.fldFontFamily.text"));
        this.cmbImportantLinkColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbImportantLinkColor.toolTipText"));
        this.cmbImportantLinkColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.cmbImportantLinkColorActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setLabelFor(this.cmbImportantLinkColor);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblUnwrappedOnly, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblUnwrappedOnly.text"));
        GroupLayout groupLayout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblErrorColor).addComponent(this.lblStandardColor).addComponent(this.lblLinkColor).addComponent(this.lblFontFamily).addComponent(this.lblBackgroundColor).addComponent(this.lblFontSize).addComponent(this.jLabel1).addComponent(this.lblLinkStyle)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.fldFontFamily).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectFont)).addComponent(this.lblUnwrappedOnly).addComponent(this.spnFontSize, -2, 71, -2).addComponent(this.cmbBackgroundColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbStandardColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbErrorColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbLinkColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbImportantLinkColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbLinkStyle, 0, -1, Short.MAX_VALUE)).addGap(1, 1, 1)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFontFamily).addComponent(this.btnSelectFont).addComponent(this.fldFontFamily, -2, -1, -2)).addGap(1, 1, 1).addComponent(this.lblUnwrappedOnly).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFontSize).addComponent(this.spnFontSize, -2, -1, -2)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBackgroundColor).addComponent(this.cmbBackgroundColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbStandardColor, -2, -1, -2).addComponent(this.lblStandardColor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbErrorColor, -2, -1, -2).addComponent(this.lblErrorColor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLinkColor).addComponent(this.cmbLinkColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbImportantLinkColor, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbLinkStyle, -2, -1, -2).addComponent(this.lblLinkStyle)).addContainerGap(-1, Short.MAX_VALUE)));
        this.previewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.previewPanel.setLayout(new BoxLayout(this.previewPanel, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRestore, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnRestore.text"));
        this.btnRestore.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnRestore.toolTipText"));
        this.btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OutputSettingsPanel.this.btnRestoreActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.previewPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 103, Short.MAX_VALUE).addComponent(this.btnRestore))).addContainerGap()))));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTitle).addComponent(this.btnRestore)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, 81, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnSelectFontActionPerformed(ActionEvent actionEvent) {
        PropertyEditor propertyEditor = PropertyEditorManager.findEditor(Font.class);
        if (propertyEditor != null) {
            propertyEditor.setValue(this.outputOptions.getFont());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertyEditor.getCustomEditor(), NbBundle.getMessage(Controller.class, (String)"LBL_Font_Chooser_Title"));
            String string = NbBundle.getMessage(Controller.class, (String)"BTN_Defaul_Font");
            dialogDescriptor.setOptions(new Object[]{DialogDescriptor.OK_OPTION, string, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                Font font = (Font)propertyEditor.getValue();
                this.outputOptions.setFont(font);
            } else if (dialogDescriptor.getValue() == string) {
                this.outputOptions.setFont(null);
            }
            this.updateFontField();
        }
    }

    private void cmbStandardColorActionPerformed(ActionEvent actionEvent) {
        Color color = ((ColorComboBox)this.cmbStandardColor).getSelectedColor();
        if (color != null) {
            this.outputOptions.setColorStandard(color);
        }
    }

    private void spnFontSizeStateChanged(ChangeEvent changeEvent) {
        int n = (Integer)this.spnFontSize.getValue();
        this.outputOptions.setFont(this.outputOptions.getFont().deriveFont((float)n));
        this.updateFontField();
    }

    private void cmbBackgroundColorActionPerformed(ActionEvent actionEvent) {
        Color color = ((ColorComboBox)this.cmbBackgroundColor).getSelectedColor();
        if (color != null) {
            this.outputOptions.setColorBackground(color);
        }
    }

    private void cmbErrorColorActionPerformed(ActionEvent actionEvent) {
        Color color = ((ColorComboBox)this.cmbErrorColor).getSelectedColor();
        if (color != null) {
            this.outputOptions.setColorError(color);
        }
    }

    private void cmbLinkColorActionPerformed(ActionEvent actionEvent) {
        Color color = ((ColorComboBox)this.cmbLinkColor).getSelectedColor();
        if (color != null) {
            this.outputOptions.setColorLink(color);
        }
    }

    private void cmbImportantLinkColorActionPerformed(ActionEvent actionEvent) {
        Color color = ((ColorComboBox)this.cmbImportantLinkColor).getSelectedColor();
        if (color != null) {
            this.outputOptions.setColorLinkImportant(color);
        }
    }

    private void btnRestoreActionPerformed(ActionEvent actionEvent) {
        this.outputOptions.resetToDefault();
        this.updateControlsByModel();
    }

    private void cmbLinkStyleActionPerformed(ActionEvent actionEvent) {
        this.outputOptions.setLinkStyle(this.linkStyleModel.getLinkStyle());
    }

    void load() {
        if (this.previewInputOutput == null) {
            this.initPreview();
        }
        this.updateControlsByModel();
    }

    private void selectColor(JComboBox jComboBox, Color color) {
        ((ColorComboBox)jComboBox).setSelectedColor(color);
    }

    private void updateFontField() {
        Font font = this.outputOptions.getFont();
        this.fldFontFamily.setText(font.getFamily() + " " + font.getSize());
    }

    void store() {
        Controller.getDefault().updateOptions(this.outputOptions);
        OutputOptions.getDefault().assign(this.outputOptions);
        OutputOptions.storeDefault();
    }

    void cancel() {
        if (this.previewInputOutput != null) {
            this.previewInputOutput.closeInputOutput();
        }
    }

    boolean valid() {
        return true;
    }

    private void initPreview() {
        this.previewInputOutput = this.initPreviewInputOutput();
        this.outputOptions = (OutputOptions)((Lookup.Provider)this.previewInputOutput).getLookup().lookup(OutputOptions.class);
        this.previewInputOutput.getOut().println("Standard Output");
        this.previewInputOutput.getErr().println("Error Output");
        OutputListenerImpl outputListenerImpl = new OutputListenerImpl();
        try {
            IOColorPrint.print((InputOutput)this.previewInputOutput, (CharSequence)"Standard Link", (OutputListener)outputListenerImpl, (boolean)false, null);
            this.previewInputOutput.getOut().println();
            IOColorPrint.print((InputOutput)this.previewInputOutput, (CharSequence)"Important Link", (OutputListener)outputListenerImpl, (boolean)true, null);
            this.previewInputOutput.getOut().print(" ");
        }
        catch (IOException iOException) {
            iOException.printStackTrace((PrintWriter)this.previewInputOutput.getErr());
        }
        this.previewInputOutput.getOut().close();
        this.previewInputOutput.getErr().close();
        this.outputOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                OutputSettingsPanel.this.controller.changed();
                OutputSettingsPanel.this.updateControlsByModel();
            }
        });
    }

    private InputOutput initPreviewInputOutput() throws NullPointerException {
        IOContainer iOContainer = IOContainer.create((IOContainer.Provider)new PreviewIOProvider(this.previewPanel));
        InputOutput inputOutput = NbIOProvider.getDefault().getIO("Preview", false, new Action[0], iOContainer);
        Component component = this.previewPanel.getComponent(0);
        if (component instanceof AbstractOutputTab) {
            ((AbstractOutputTab)component).getOutputPane().setWrapped(false);
        }
        return inputOutput;
    }

    private void updateControlsByModel() {
        this.updateFontField();
        this.spnFontSize.setValue(this.outputOptions.getFont().getSize());
        this.selectColor(this.cmbStandardColor, this.outputOptions.getColorStandard());
        this.selectColor(this.cmbErrorColor, this.outputOptions.getColorError());
        this.selectColor(this.cmbBackgroundColor, this.outputOptions.getColorBackground());
        this.selectColor(this.cmbLinkColor, this.outputOptions.getColorLink());
        this.selectColor(this.cmbImportantLinkColor, this.outputOptions.getColorLinkImportant());
        this.cmbLinkStyle.setSelectedItem(this.linkStyleModel.itemFor(this.outputOptions.getLinkStyle()));
        this.cmbLinkStyle.repaint();
    }

    private static class OutputListenerImpl
    implements OutputListener {
        public void outputLineSelected(OutputEvent outputEvent) {
        }

        public void outputLineAction(OutputEvent outputEvent) {
        }

        public void outputLineCleared(OutputEvent outputEvent) {
        }
    }
}

