/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.core.output2.Lines;
import org.openide.windows.IOColors;
import org.openide.windows.OutputListener;

public class LineInfo {
    List<Segment> segments = new CopyOnWriteArrayList<Segment>();
    final Lines parent;

    LineInfo(Lines lines) {
        this.parent = lines;
    }

    LineInfo(Lines lines, int n) {
        this(lines, n, false, null, null, null, false);
    }

    LineInfo(Lines lines, int n, boolean bl, OutputListener outputListener, Color color, Color color2, boolean bl2) {
        this.parent = lines;
        this.addSegment(n, bl, outputListener, color, color2, bl2);
    }

    int getEnd() {
        return this.segments.isEmpty() ? 0 : this.segments.get(this.segments.size() - 1).getEnd();
    }

    void addSegment(int n, boolean bl, OutputListener outputListener, Color color, Color color2, boolean bl2) {
        boolean bl3;
        Segment segment = null;
        if (!this.segments.isEmpty() && (segment = this.segments.get(this.segments.size() - 1)).isErr() == bl && segment.getListener() == outputListener && this.hasColors(segment, color, color2)) {
            segment.end = n;
            return;
        }
        boolean bl4 = bl3 = color != null || color2 != null;
        segment = outputListener != null ? (bl3 ? new ColorListenerSegment(n, outputListener, bl2, color, color2) : new ListenerSegment(n, outputListener, bl2)) : (bl ? (bl3 ? new ColorErrSegment(n, color, color2) : new ErrSegment(n)) : (bl3 ? new ColorSegment(n, color, color2) : new Segment(n)));
        this.segments.add(segment);
    }

    private boolean hasColors(Segment segment, Color color, Color color2) {
        return this.hasForeground(segment, color) && this.hasBackground(segment, color2);
    }

    private boolean hasForeground(Segment segment, Color color) {
        return segment.getCustomColor() == color || color != null && color.equals(segment.getCustomColor());
    }

    private boolean hasBackground(Segment segment, Color color) {
        return segment.getCustomBackground() == color || color != null && color.equals(segment.getCustomBackground());
    }

    OutputListener getListenerAfter(int n, int[] nArray) {
        int n2 = 0;
        for (Segment segment : this.segments) {
            if (segment.getEnd() < n) continue;
            if (segment.getListener() != null) {
                if (nArray != null) {
                    nArray[0] = n2;
                    nArray[1] = segment.getEnd();
                }
                return segment.getListener();
            }
            n2 = segment.getEnd();
        }
        return null;
    }

    OutputListener getListenerBefore(int n, int[] nArray) {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            int n2;
            int n3 = n2 = i == 0 ? 0 : this.segments.get(i - 1).getEnd();
            if (n2 > n || this.segments.get(i).getListener() == null) continue;
            if (nArray != null) {
                nArray[0] = n2;
                nArray[1] = this.segments.get(i).getEnd();
            }
            return this.segments.get(i).getListener();
        }
        return null;
    }

    OutputListener getFirstListener(int[] nArray) {
        int n = 0;
        for (Segment segment : this.segments) {
            if (segment.getListener() != null) {
                if (nArray != null) {
                    nArray[0] = n;
                    nArray[1] = segment.getEnd();
                }
                return segment.getListener();
            }
            n = segment.getEnd();
        }
        return null;
    }

    OutputListener getLastListener(int[] nArray) {
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            Segment segment = this.segments.get(i);
            if (segment.getListener() == null) continue;
            if (nArray != null) {
                nArray[0] = i == 0 ? 0 : this.segments.get(i - 1).getEnd();
                nArray[1] = segment.getEnd();
            }
            return segment.getListener();
        }
        return null;
    }

    Collection<Segment> getLineSegments() {
        return this.segments;
    }

    Collection<OutputListener> getListeners() {
        ArrayList<OutputListener> arrayList = new ArrayList<OutputListener>();
        for (Segment segment : this.segments) {
            OutputListener outputListener = segment.getListener();
            if (outputListener == null) continue;
            arrayList.add(outputListener);
        }
        return arrayList;
    }

    private class ColorListenerSegment
    extends ListenerSegment {
        final Color color;
        final Color background;

        public ColorListenerSegment(int n, OutputListener outputListener, boolean bl, Color color, Color color2) {
            super(n, outputListener, bl);
            this.color = color == null ? super.getColor() : color;
            this.background = color2;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }

        @Override
        Color getCustomBackground() {
            return this.background;
        }
    }

    private class ListenerSegment
    extends Segment {
        final OutputListener listener;
        final boolean important;

        public ListenerSegment(int n, OutputListener outputListener, boolean bl) {
            super(n);
            this.listener = outputListener;
            this.important = bl;
        }

        @Override
        OutputListener getListener() {
            return this.listener;
        }

        @Override
        Color getColor() {
            return LineInfo.this.parent.getDefColor(this.important ? IOColors.OutputType.HYPERLINK_IMPORTANT : IOColors.OutputType.HYPERLINK);
        }
    }

    private class ColorErrSegment
    extends ErrSegment {
        final Color color;
        final Color background;

        public ColorErrSegment(int n, Color color, Color color2) {
            super(n);
            this.color = color == null ? super.getColor() : color;
            this.background = color2;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }

        @Override
        Color getCustomBackground() {
            return this.background;
        }
    }

    private class ErrSegment
    extends Segment {
        public ErrSegment(int n) {
            super(n);
        }

        @Override
        boolean isErr() {
            return true;
        }

        @Override
        Color getColor() {
            return LineInfo.this.parent.getDefColor(IOColors.OutputType.ERROR);
        }
    }

    private class ColorSegment
    extends Segment {
        final Color color;
        final Color background;

        public ColorSegment(int n, Color color, Color color2) {
            super(n);
            this.color = color == null ? super.getColor() : color;
            this.background = color2;
        }

        @Override
        Color getColor() {
            return this.color;
        }

        @Override
        Color getCustomColor() {
            return this.color;
        }

        @Override
        Color getCustomBackground() {
            return this.background;
        }
    }

    public class Segment {
        int end;

        public Segment(int n) {
            this.end = n;
        }

        int getEnd() {
            return this.end;
        }

        OutputListener getListener() {
            return null;
        }

        boolean isErr() {
            return false;
        }

        Color getColor() {
            return LineInfo.this.parent.getDefColor(IOColors.OutputType.OUTPUT);
        }

        Color getCustomColor() {
            return null;
        }

        Color getCustomBackground() {
            return null;
        }
    }
}

