/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.OutWriter;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class ErrWriter
extends OutputWriter {
    private OutWriter wrapped;
    private final NbWriter parent;
    boolean closed = true;

    ErrWriter(OutWriter outWriter, NbWriter nbWriter) {
        super((Writer)new OutWriter.DummyWriter());
        this.wrapped = outWriter;
        this.parent = nbWriter;
    }

    synchronized void setWrapped(OutWriter outWriter) {
        this.wrapped = outWriter;
        this.closed = true;
    }

    public void println(String string, OutputListener outputListener) throws IOException {
        this.println(string, outputListener, false);
    }

    public void println(String string, OutputListener outputListener, boolean bl) throws IOException {
        this.closed = false;
        this.wrapped.print(string, outputListener, bl, null, null, true, true);
    }

    public void reset() throws IOException {
        Logger.getAnonymousLogger().warning("Do not call reset() on the error io, only on the output IO.  Reset on the error io does nothing.");
        this.closed = false;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.parent.notifyErrClosed();
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public void flush() {
        this.wrapped.flush();
    }

    public boolean checkError() {
        return this.wrapped.checkError();
    }

    public void write(int n) {
        this.print(String.valueOf(n), false);
    }

    public void write(char[] cArray, int n, int n2) {
        this.print(new OutWriter.CharArrayWrapper(cArray, n, n2), false);
    }

    public void write(String string, int n, int n2) {
        this.print(string.substring(n, n + n2), false);
    }

    public void println(boolean bl) {
        this.print(bl ? "true" : "false", true);
    }

    public void println(int n) {
        this.print(String.valueOf(n), true);
    }

    public void println(char c) {
        this.print(String.valueOf(c), true);
    }

    public void println(long l) {
        this.print(String.valueOf(l), true);
    }

    public void println(float f) {
        this.print(String.valueOf(f), true);
    }

    public void println(double d) {
        this.print(String.valueOf(d), true);
    }

    public void println(char[] cArray) {
        this.print(new OutWriter.CharArrayWrapper(cArray), true);
    }

    public void println(String string) {
        this.print(string, true);
    }

    public void println(Object object) {
        this.print(String.valueOf(object), true);
    }

    public void print(char[] cArray) {
        this.print(new OutWriter.CharArrayWrapper(cArray), false);
    }

    public void print(Object object) {
        this.print(String.valueOf(object), false);
    }

    public void print(char c) {
        this.print(String.valueOf(c), false);
    }

    public void print(int n) {
        this.print(String.valueOf(n), false);
    }

    public void print(String string) {
        this.print(string, false);
    }

    public void print(boolean bl) {
        this.print(bl ? "true" : "false", false);
    }

    public void println() {
        this.closed = false;
        this.wrapped.println();
    }

    private void print(CharSequence charSequence, boolean bl) {
        this.closed = false;
        this.wrapped.print(charSequence, null, false, null, null, true, bl);
    }
}

