/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IEventHook;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataType;
import com.jrockit.mc.flightrecorder.internal.parser.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.parser.model.Transition;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptor;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Synthetics {
    public static final int HOTSPOT_PRODUCER_ID = 1;
    public static final int METADATA_EVENT_TYPE_INDEX = 0;
    public static final int CHECK_POINT_EVENT_TYPE_INDEX = 1;
    public static final int LOST_EVENT_TYPE_INDEX = 2;
    public static final int CONTENT_TYPE_POOL_NONE = 0;
    public static final int CONTENT_TYPE_MEMORY = 1;
    public static final int CONTENT_TYPE_EPOCHMILLIS = 2;
    public static final int CONTENT_TYPE_MILLIS = 3;
    public static final int CONTENT_TYPE_NANOS = 4;
    public static final int CONTENT_TYPE_TICKS = 5;
    public static final int CONTENT_TYPE_ADDRESS = 6;
    public static final int CONTENT_TYPE_THREADID = 7;
    public static final int CONTENT_TYPE_JAVATHREADID = 8;
    public static final int CONTENT_TYPE_STACKTRACEID = 9;
    public static final int CONTENT_TYPE_CLASSID = 10;
    public static final int CONTENT_TYPE_PERCENTAGE = 11;
    public static final int CONTENT_TYPE_VMTHREAD = 30;
    public static final int CONTENT_TYPE_METHOD = 32;
    static final String EVENT_THREAD_ID = "(thread)";
    static final String STACKTRACE_ID = "(stackTrace)";
    static final String CONTENT_TYPE_STRING_STACKTRACE = "stacktrace";
    public static final String THREAD_ALLOCATION_PATH = "java/statistics/thread_allocation";
    public static final String EXECUTION_SAMPLE_PATH = "vm/prof/execution_sample";
    public static final String GC_PATH = "vm/gc/garbage_collection";
    public static final String JAVA_THREAD_START_PATH = "java/thread_start";
    public static final String JAVA_THREAD_END_PATH = "java/thread_end";
    public static final String VM_LOCK_PROFILE_PATH = "vm/sync/lock_profile";
    public static final String JAVA_LCOK_PROFILE_PATH = "java/statistics/lock_profile";
    public static final String BUFFER_LOST_EVENT_PATH = "recordings/buffer_lost";
    public static final int HEAP_USAGE_EVENT_TYPE_ID = 3978;
    public static final int LIVE_SET_EVENT_TYPE_ID = 3979;
    public static final int INITIAL_SYSTEM_PROPERTY_EVENT_TYPE_ID = 3980;
    public static final int INITIAL_ENVIRONMENT_VARIABLE_EVENT_TYPE_ID = 3981;
    public static final int RECORDING_SETTING_EVENT_TYPE_ID = 3982;
    public static final int PROCESS_EVENT_TYPE_ID = 3983;
    public static final int RECORDING_EVENT_TYPE_ID = 3984;
    public static final String TRANSITION_TO = "transitionTo";
    public static final String TRANSITION_FROM = "transitionFrom";
    private static final Map<String, IEventHook[]> eventHooks = new ConcurrentHashMap<String, IEventHook[]>(1);
    private static final Map<String, IEventTypeDescriptorHook[]> eventTypeHooks = new ConcurrentHashMap<String, IEventTypeDescriptorHook[]>(1);

    static {
        Synthetics.setEventHooks(JAVA_THREAD_START_PATH, new IEventHook(){

            @Override
            public List<IEventHook.IEventThreadPair> handleEvent(IEvent event, FLRThread thread) {
                thread.setStartTimeStamp(Math.min(thread.getStartTimestamp(), event.getStartTimestamp()));
                return null;
            }
        });
        Synthetics.setEventHooks(JAVA_THREAD_END_PATH, new IEventHook(){

            @Override
            public List<IEventHook.IEventThreadPair> handleEvent(IEvent event, FLRThread thread) {
                thread.setEndTimeStamp(Math.max(thread.getEndTimestamp(), event.getEndTimestamp()));
                return null;
            }
        });
        Synthetics.setEventTypeHooks(EXECUTION_SAMPLE_PATH, new IEventTypeDescriptorHook(){

            @Override
            public EventTypeDescriptor modifyEventTypeDescriptor(EventTypeDescriptor etd) {
                ValueDescriptor[] values = etd.getDataStructure();
                int i = 0;
                while (i < values.length) {
                    String id = values[i].getIdentifier();
                    if (values[i].getContentType() == 9 && "stackTrace".equals(id)) {
                        values[i] = Synthetics.createStacktraceValueDescriptor();
                    } else if (values[i].getContentType() == 7 && "sampledThread".equals(id)) {
                        values[i] = Synthetics.createEventThreadValueDescriptor();
                    }
                    ++i;
                }
                return etd;
            }
        });
        Synthetics.setEventTypeHooks(THREAD_ALLOCATION_PATH, new IEventTypeDescriptorHook(){

            @Override
            public EventTypeDescriptor modifyEventTypeDescriptor(EventTypeDescriptor etd) {
                ValueDescriptor[] values = etd.getDataStructure();
                int i = 0;
                while (i < values.length) {
                    String id = values[i].getIdentifier();
                    if (values[i].getContentType() == 7 && "thread".equals(id)) {
                        values[i] = Synthetics.createEventThreadValueDescriptor();
                    }
                    ++i;
                }
                return etd;
            }
        });
    }

    public static EventTypeDescriptor modifyEventTypeDescriptor(EventTypeDescriptor etd) {
        IEventTypeDescriptorHook[] hooks = eventTypeHooks.get(etd.getPath());
        if (hooks != null) {
            IEventTypeDescriptorHook[] iEventTypeDescriptorHookArray = hooks;
            int n = hooks.length;
            int n2 = 0;
            while (n2 < n) {
                IEventTypeDescriptorHook hook = iEventTypeDescriptorHookArray[n2];
                etd = hook.modifyEventTypeDescriptor(etd);
                ++n2;
            }
        }
        return etd;
    }

    public static ValueDescriptor[] createTopDescriptors(EventTypeDescriptor etd, ValueDescriptor[] vd) {
        ArrayList<ValueDescriptor> topDescriptors = new ArrayList<ValueDescriptor>(2 + vd.length);
        if (etd.hasThread()) {
            topDescriptors.add(Synthetics.createEventThreadValueDescriptor());
        }
        if (etd.canHaveStacktrace()) {
            topDescriptors.add(Synthetics.createStacktraceValueDescriptor());
        }
        topDescriptors.addAll(Arrays.asList(vd));
        return topDescriptors.toArray(new ValueDescriptor[topDescriptors.size()]);
    }

    public static void setEventHooks(String eventPath, IEventHook ... hook) {
        eventHooks.put(eventPath, hook);
    }

    public static IEventHook[] getEventHooks(String eventPath) {
        return eventHooks.get(eventPath);
    }

    public static void setEventTypeHooks(String eventPath, IEventTypeDescriptorHook ... hook) {
        eventTypeHooks.put(eventPath, hook);
    }

    private static ValueDescriptor createStacktraceValueDescriptor() {
        return new ValueDescriptor(STACKTRACE_ID, "Stack Trace", "", Transition.None, DataType.LONG, CONTENT_TYPE_STRING_STACKTRACE, null, 9, null, -1);
    }

    private static ValueDescriptor createEventThreadValueDescriptor() {
        return new ValueDescriptor(EVENT_THREAD_ID, "Event Thread", "", Transition.None, DataType.U4, UnitLookup.THREAD.getIdentifier(), null, 7, null, -1);
    }

    public static String createContentTypeString(int contentType, DataType dt) {
        switch (contentType) {
            case 2: {
                return UnitLookup.TIMESTAMP.getIdentifier();
            }
            case 3: 
            case 4: 
            case 5: {
                return UnitLookup.TIMESPAN.getIdentifier();
            }
            case 6: {
                return UnitLookup.ADDRESS.getIdentifier();
            }
            case 7: 
            case 8: 
            case 30: {
                return UnitLookup.THREAD.getIdentifier();
            }
            case 10: {
                return UnitLookup.CLASS.getIdentifier();
            }
            case 11: {
                return UnitLookup.PERCENTAGE.getIdentifier();
            }
            case 1: {
                return UnitLookup.MEMORY.getIdentifier();
            }
            case 9: {
                return CONTENT_TYPE_STRING_STACKTRACE;
            }
            case 32: {
                return UnitLookup.METHOD.getIdentifier();
            }
        }
        switch (dt) {
            case BOOLEAN: {
                return UnitLookup.FLAG.getIdentifier();
            }
            case BYTE: 
            case U1: 
            case SHORT: 
            case U2: 
            case INTEGER: 
            case U4: 
            case LONG: 
            case U8: {
                return UnitLookup.COUNT.getIdentifier();
            }
            case UTF8: 
            case STRING: {
                return UnitLookup.PLAIN_TEXT.getIdentifier();
            }
        }
        return UnitLookup.UNKNOWN.getIdentifier();
    }

    public static int deduceRelationIndex(DataType dataType, int dataStructureIndex) {
        if (dataType.isPrimitive() && dataStructureIndex > 0) {
            return dataStructureIndex - 1;
        }
        return -1;
    }

    public static EventTypeDescriptor getBufferLostEventType() {
        ValueDescriptor[] vd = new ValueDescriptor[]{Synthetics.createEventThreadValueDescriptor(), new ValueDescriptor("memoryDropped", "Memory Dropped", "The amount of data that was dropped from the thread local buffer.", Transition.None, DataType.INTEGER, UnitLookup.MEMORY.getIdentifier(), null, -1, null, -1)};
        return new EventTypeDescriptor(2, "Lost Events", false, true, false, false, vd, "Event emitted when thread local buffers can't be written fast enough to disk.", BUFFER_LOST_EVENT_PATH);
    }

    public static interface IEventTypeDescriptorHook {
        public EventTypeDescriptor modifyEventTypeDescriptor(EventTypeDescriptor var1);
    }
}

