/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.jnl;

import com.sun.deploy.Environment;
import com.sun.deploy.association.AssociationDesc;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.security.CachedCertificatesHelper;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.GeneralUtil;
import com.sun.deploy.util.URLUtil;
import com.sun.deploy.xml.BadTokenException;
import com.sun.deploy.xml.XMLAttribute;
import com.sun.deploy.xml.XMLEncoding;
import com.sun.deploy.xml.XMLNode;
import com.sun.deploy.xml.XMLParser;
import com.sun.javaws.Globals;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.exceptions.BadFieldException;
import com.sun.javaws.exceptions.JNLParseException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.ApplicationDesc;
import com.sun.javaws.jnl.ExtDownloadDesc;
import com.sun.javaws.jnl.ExtensionDesc;
import com.sun.javaws.jnl.IconDesc;
import com.sun.javaws.jnl.InformationDesc;
import com.sun.javaws.jnl.InstallerDesc;
import com.sun.javaws.jnl.JARDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXAppDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.jnl.LibraryDesc;
import com.sun.javaws.jnl.PackageDesc;
import com.sun.javaws.jnl.PropertyDesc;
import com.sun.javaws.jnl.RContentDesc;
import com.sun.javaws.jnl.ResourcesDesc;
import com.sun.javaws.jnl.ShortcutDesc;
import com.sun.javaws.jnl.UpdateDesc;
import com.sun.javaws.jnl.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

public class XMLFormat {
    public static XMLNode parseBits(byte[] byArray) throws JNLParseException {
        return XMLFormat.parse(XMLFormat.decode(byArray));
    }

    private static String decode(byte[] byArray) throws JNLParseException {
        try {
            return XMLEncoding.decodeXML((byte[])byArray);
        }
        catch (Exception exception) {
            throw new JNLParseException(null, exception, "exception determining encoding of jnlp file", 0);
        }
    }

    private static XMLNode parse(String string) throws JNLParseException {
        try {
            return new XMLParser(string).parse();
        }
        catch (BadTokenException badTokenException) {
            throw new JNLParseException(string, (Exception)((Object)badTokenException), "wrong kind of token found", badTokenException.getLine());
        }
        catch (Exception exception) {
            throw new JNLParseException(string, exception, "exception parsing jnlp file", 0);
        }
    }

    public static LaunchDesc parse(byte[] byArray, URL uRL, URL uRL2, URL uRL3) throws IOException, BadFieldException, MissingFieldException, JNLParseException {
        URL uRL4;
        String string = XMLFormat.decode(byArray);
        XMLNode xMLNode = XMLFormat.parse(string);
        InformationDesc informationDesc = null;
        ResourcesDesc resourcesDesc = null;
        UpdateDesc updateDesc = null;
        ApplicationDesc applicationDesc = null;
        AppletDesc appletDesc = null;
        JavaFXAppDesc javaFXAppDesc = null;
        LibraryDesc libraryDesc = null;
        InstallerDesc installerDesc = null;
        String string2 = null;
        if (xMLNode == null || xMLNode.getName() == null) {
            throw new JNLParseException(string, null, null, 0);
        }
        if (xMLNode.getName().equals("player") || xMLNode.getName().equals("viewer")) {
            String string3 = XMLUtils.getAttribute(xMLNode, null, "tab");
            return LaunchDescFactory.buildInternalLaunchDesc(xMLNode, string3);
        }
        if (!xMLNode.getName().equals("jnlp")) {
            XMLFormat.throwNewException(string, new MissingFieldException(string, "<jnlp>"));
        }
        String string4 = XMLUtils.getAttribute(xMLNode, "", "spec", "1.0+");
        String string5 = XMLUtils.getAttribute(xMLNode, "", "version");
        URL uRL5 = URLUtil.asPathURL((URL)XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "codebase"));
        if (uRL5 == null && uRL != null) {
            uRL5 = uRL;
        }
        if ((uRL4 = XMLUtils.getAttributeURL(string, uRL5, xMLNode, "<applet-desc>", "documentbase")) == null) {
            uRL4 = XMLUtils.getAttributeURL(string, uRL5, xMLNode, "<applet-desc>", "documentBase");
        }
        if (uRL2 != null) {
            uRL4 = uRL2;
        }
        URL uRL6 = XMLUtils.getAttributeURL(string, uRL5, xMLNode, "", "href");
        int n = 0;
        CachedCertificatesHelper[] cachedCertificatesHelperArray = null;
        if (XMLUtils.isElementPath(xMLNode, "<security><all-permissions>")) {
            n = 1;
            cachedCertificatesHelperArray = XMLFormat.buildCachedCertificates(xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<security><j2ee-application-client-permissions>")) {
            n = 2;
            cachedCertificatesHelperArray = XMLFormat.buildCachedCertificates(xMLNode);
        }
        if (XMLUtils.isElementPath(xMLNode, "<javafx-desc>")) {
            javaFXAppDesc = XMLFormat.buildFXAppDesc(string, xMLNode, "<javafx-desc>");
        }
        int n2 = 0;
        if (XMLUtils.isElementPath(xMLNode, "<application-desc>")) {
            n2 = 1;
            applicationDesc = XMLFormat.buildApplicationDesc(string, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<component-desc>")) {
            n2 = 3;
            libraryDesc = XMLFormat.buildLibraryDesc(string, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<installer-desc>")) {
            if (!Cache.isCacheEnabled()) {
                XMLFormat.throwNewException(string, new BadFieldException(string, "<installer-desc>", ""));
            }
            n2 = 4;
            installerDesc = XMLFormat.buildInstallerDesc(string, uRL5, xMLNode);
        } else if (XMLUtils.isElementPath(xMLNode, "<applet-desc>")) {
            n2 = 2;
            appletDesc = XMLFormat.buildAppletDesc(string, uRL5, uRL4, xMLNode);
        } else if (javaFXAppDesc != null) {
            n2 = 6;
        } else {
            XMLFormat.throwNewException(string, new MissingFieldException(string, "<jnlp>(<application-desc>|<applet-desc>|<installer-desc>|<component-desc>)"));
        }
        updateDesc = XMLFormat.getUpdateDesc(xMLNode);
        informationDesc = XMLFormat.buildInformationDesc(string, uRL5, xMLNode);
        resourcesDesc = XMLFormat.buildResourcesDesc(string, uRL5, xMLNode, false);
        URL uRL7 = n2 == 3 ? uRL3 : uRL6;
        LaunchDesc launchDesc = new LaunchDesc(string4, uRL5, uRL7, string5, informationDesc, n, cachedCertificatesHelperArray, updateDesc, resourcesDesc, n2, applicationDesc, appletDesc, javaFXAppDesc, libraryDesc, installerDesc, string2, xMLNode);
        if (!launchDesc.isApplicationDescriptor() || !JnlpxArgs.shouldRemoveArgumentFile()) {
            launchDesc.setSourceURL(uRL3);
        }
        if (Trace.isEnabled((TraceLevel)TraceLevel.TEMP)) {
            Trace.println((String)("returning LaunchDesc from XMLFormat.parse():\n" + launchDesc), (TraceLevel)TraceLevel.TEMP);
        }
        return launchDesc;
    }

    private static void throwNewException(String string, Exception exception) throws JNLParseException, MissingFieldException, BadFieldException {
        XMLParser xMLParser = new XMLParser(string);
        BadTokenException badTokenException = null;
        try {
            xMLParser.parse();
            badTokenException = xMLParser.getSavedException();
        }
        catch (Exception exception2) {
            Trace.ignored((Throwable)exception2);
        }
        if (badTokenException != null) {
            Trace.println((String)("JNLP Parse Exception: " + (Object)((Object)badTokenException)), (TraceLevel)TraceLevel.TEMP);
            throw new JNLParseException(string, (Exception)((Object)badTokenException), "wrong kind of token found", badTokenException.getLine());
        }
        if (exception instanceof MissingFieldException) {
            throw (MissingFieldException)exception;
        }
        if (exception instanceof BadFieldException) {
            throw (BadFieldException)exception;
        }
    }

    private static InformationDesc combineInformationDesc(InformationDesc informationDesc, InformationDesc informationDesc2) {
        if (informationDesc == null) {
            return informationDesc2;
        }
        if (informationDesc2 == null) {
            return informationDesc;
        }
        String string = informationDesc.getTitle() != null ? informationDesc.getTitle() : informationDesc2.getTitle();
        String string2 = informationDesc.getVendor() != null ? informationDesc.getVendor() : informationDesc2.getVendor();
        URL uRL = informationDesc.getHome() != null ? informationDesc.getHome() : informationDesc2.getHome();
        String[] stringArray = new String[4];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = informationDesc.getDescription(i) != null ? informationDesc.getDescription(i) : informationDesc2.getDescription(i);
        }
        ArrayList<IconDesc> arrayList = new ArrayList<IconDesc>();
        if (informationDesc2.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc2.getIcons()));
        }
        if (informationDesc.getIcons() != null) {
            arrayList.addAll(Arrays.asList(informationDesc.getIcons()));
        }
        IconDesc[] iconDescArray = new IconDesc[arrayList.size()];
        iconDescArray = arrayList.toArray(iconDescArray);
        boolean bl = informationDesc.supportsOfflineOperation() || informationDesc2.supportsOfflineOperation();
        ShortcutDesc shortcutDesc = informationDesc.getShortcut() != null ? informationDesc.getShortcut() : informationDesc2.getShortcut();
        AssociationDesc[] associationDescArray = (AssociationDesc[])XMLFormat.addArrays(informationDesc.getAssociations(), informationDesc2.getAssociations());
        RContentDesc[] rContentDescArray = (RContentDesc[])XMLFormat.addArrays(informationDesc.getRelatedContent(), informationDesc2.getRelatedContent());
        return new InformationDesc(string, string2, uRL, stringArray, iconDescArray, shortcutDesc, rContentDescArray, associationDescArray, bl);
    }

    private static InformationDesc buildInformationDesc(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<information>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws BadFieldException, MissingFieldException {
                String[] stringArray = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "os", null));
                String[] stringArray2 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "arch", null));
                String[] stringArray3 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "platform", null));
                String[] stringArray4 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList((String[])stringArray, (String)Config.getOSFullName()) && GeneralUtil.prefixMatchStringList((String[])stringArray2, (String)Config.getOSArch()) && GeneralUtil.prefixMatchStringList((String[])stringArray3, (String)Config.getOSPlatform()) && XMLFormat.matchDefaultLocale(stringArray4)) {
                    String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                    String string2 = XMLUtils.getElementContents(xMLNode, "<vendor>");
                    URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<homepage>", "href");
                    String[] stringArray5 = new String[4];
                    stringArray5[0] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "", null);
                    stringArray5[2] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "one-line", null);
                    stringArray5[1] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "short", null);
                    stringArray5[3] = XMLUtils.getElementContentsWithAttribute(xMLNode, "<description>", "kind", "tooltip", null);
                    IconDesc[] iconDescArray = XMLFormat.getIconDescs(string, uRL, xMLNode);
                    ShortcutDesc shortcutDesc = XMLFormat.getShortcutDesc(xMLNode);
                    RContentDesc[] rContentDescArray = XMLFormat.getRContentDescs(string, uRL, xMLNode);
                    AssociationDesc[] associationDescArray = XMLFormat.getAssociationDesc(string, uRL, xMLNode);
                    arrayList.add(new InformationDesc(string3, string2, uRL2, stringArray5, iconDescArray, shortcutDesc, rContentDescArray, associationDescArray, XMLUtils.isElementPath(xMLNode, "<offline-allowed>")));
                }
            }
        });
        InformationDesc informationDesc = new InformationDesc(null, null, null, null, null, null, null, null, false);
        for (int i = 0; i < arrayList.size(); ++i) {
            InformationDesc informationDesc2 = (InformationDesc)arrayList.get(i);
            informationDesc = XMLFormat.combineInformationDesc(informationDesc2, informationDesc);
        }
        if (informationDesc.getTitle() == null) {
            throw new MissingFieldException(string, "<jnlp><information><title>");
        }
        if (informationDesc.getVendor() == null) {
            throw new MissingFieldException(string, "<jnlp><information><vendor>");
        }
        return informationDesc;
    }

    private static Object[] addArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2;
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            arrayList.add(objectArray[n++]);
        }
        n = 0;
        while (n < objectArray2.length) {
            arrayList.add(objectArray2[n++]);
        }
        return arrayList.toArray(objectArray);
    }

    public static boolean matchDefaultLocale(String[] stringArray) {
        return GeneralUtil.matchLocale((String[])stringArray, (Locale)Globals.getDefaultLocale());
    }

    static ResourcesDesc buildResourcesDesc(final String string, final URL uRL, XMLNode xMLNode, final boolean bl) throws MissingFieldException, BadFieldException {
        final ResourcesDesc resourcesDesc = new ResourcesDesc();
        XMLUtils.visitElements(xMLNode, "<resources>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String[] stringArray = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "os", null));
                String[] stringArray2 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "arch", null));
                String[] stringArray3 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "platform", null));
                String[] stringArray4 = GeneralUtil.getStringList((String)XMLUtils.getAttribute(xMLNode, "", "locale", null));
                if (GeneralUtil.prefixMatchStringList((String[])stringArray, (String)Config.getOSFullName()) && GeneralUtil.prefixMatchStringList((String[])stringArray2, (String)Config.getOSArch()) && GeneralUtil.prefixMatchStringList((String[])stringArray2, (String)Config.getOSArch()) && GeneralUtil.prefixMatchStringList((String[])stringArray3, (String)Config.getOSPlatform()) && XMLFormat.matchDefaultLocale(stringArray4)) {
                    XMLUtils.visitChildrenElements(xMLNode, new XMLUtils.ElementVisitor(){

                        public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                            XMLFormat.handleResourceElement(string, uRL, xMLNode, resourcesDesc, bl);
                        }
                    });
                }
            }
        });
        if (!resourcesDesc.isEmpty()) {
            boolean bl2 = resourcesDesc.isPack200Enabled();
            boolean bl3 = resourcesDesc.isVersionEnabled();
            if (bl2 || bl3) {
                JARDesc[] jARDescArray = resourcesDesc.getLocalJarDescs();
                for (int i = 0; i < jARDescArray.length; ++i) {
                    JARDesc jARDesc = jARDescArray[i];
                    if (bl2) {
                        jARDesc.setPack200Enabled();
                    }
                    if (!bl3) continue;
                    jARDesc.setVersionEnabled();
                }
            }
        }
        return resourcesDesc.isEmpty() ? null : resourcesDesc;
    }

    private static IconDesc[] getIconDescs(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<icon>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getAttribute(xMLNode, "", "kind", "");
                URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "version", null);
                int n = XMLUtils.getIntAttribute(string, xMLNode, "", "height", 0);
                int n2 = XMLUtils.getIntAttribute(string, xMLNode, "", "width", 0);
                int n3 = XMLUtils.getIntAttribute(string, xMLNode, "", "depth", 0);
                int n4 = 0;
                if (string3.equals("selected")) {
                    n4 = 1;
                } else if (string3.equals("disabled")) {
                    n4 = 2;
                } else if (string3.equals("rollover")) {
                    n4 = 3;
                } else if (string3.equals("splash")) {
                    n4 = 4;
                } else if (string3.equals("shortcut")) {
                    n4 = 5;
                }
                arrayList.add(new IconDesc(uRL2, string2, n, n2, n3, n4));
            }
        });
        return arrayList.toArray(new IconDesc[arrayList.size()]);
    }

    private static ShortcutDesc getShortcutDesc(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<shortcut>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string = XMLUtils.getAttribute(xMLNode, "", "online", "true");
                boolean bl = string.equalsIgnoreCase("true");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "install", "false");
                boolean bl2 = string2.equalsIgnoreCase("true");
                boolean bl3 = XMLUtils.isElementPath(xMLNode, "<desktop>");
                boolean bl4 = XMLUtils.isElementPath(xMLNode, "<menu>");
                String string3 = XMLUtils.getAttribute(xMLNode, "<menu>", "submenu");
                arrayList.add(new ShortcutDesc(bl, bl2, bl3, bl4, string3));
            }
        });
        if (arrayList.size() > 0) {
            return (ShortcutDesc)arrayList.get(0);
        }
        return null;
    }

    private static CachedCertificatesHelper[] buildCachedCertificates(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<security><details>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string;
                String string2 = XMLUtils.getAttribute(xMLNode, "", "signedjnlp");
                boolean bl = "true".equalsIgnoreCase(string2);
                String string3 = XMLUtils.getAttribute(xMLNode, "<certificate-path>", "timestamp");
                Date date = string3 == null ? null : new Date(Long.parseLong(string3));
                CachedCertificatesHelper cachedCertificatesHelper = CachedCertificatesHelper.create((Date)date, (String)(string = XMLUtils.getElementContents(xMLNode, "<certificate-path>")), (boolean)bl);
                if (cachedCertificatesHelper != null) {
                    arrayList.add(cachedCertificatesHelper);
                }
            }
        });
        if (arrayList.size() > 0) {
            return arrayList.toArray(new CachedCertificatesHelper[0]);
        }
        return null;
    }

    private static UpdateDesc getUpdateDesc(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<update>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string = XMLUtils.getAttribute(xMLNode, "", "check", "timeout");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "policy", "always");
                arrayList.add(new UpdateDesc(string, string2));
            }
        });
        if (arrayList.size() > 0) {
            return (UpdateDesc)arrayList.get(0);
        }
        return new UpdateDesc("timeout", "always");
    }

    private static AssociationDesc[] getAssociationDesc(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<association>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string4 = XMLUtils.getAttribute(xMLNode, "", "extensions");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "mime-type");
                String string3 = XMLUtils.getElementContents(xMLNode, "<description>");
                URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<icon>", "href");
                if (string4 == null && string2 == null) {
                    throw new MissingFieldException(string, "<association>(<extensions><mime-type>)");
                }
                if (string4 == null) {
                    throw new MissingFieldException(string, "<association><extensions>");
                }
                if (string2 == null) {
                    throw new MissingFieldException(string, "<association><mime-type>");
                }
                if ("gnome".equals(System.getProperty("sun.desktop"))) {
                    string4 = string4.toLowerCase();
                    string2 = string2.toLowerCase();
                }
                arrayList.add(new AssociationDesc(string4, string2, string3, uRL2));
            }
        });
        return arrayList.toArray(new AssociationDesc[arrayList.size()]);
    }

    private static RContentDesc[] getRContentDescs(final String string, final URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<related-content>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                URL uRL3 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
                String string3 = XMLUtils.getElementContents(xMLNode, "<title>");
                String string2 = XMLUtils.getElementContents(xMLNode, "<description>");
                URL uRL2 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "<icon>", "href");
                arrayList.add(new RContentDesc(uRL3, string3, string2, uRL2));
            }
        });
        return arrayList.toArray(new RContentDesc[arrayList.size()]);
    }

    private static void handleResourceElement(String string, URL uRL, XMLNode xMLNode, ResourcesDesc resourcesDesc, boolean bl) throws MissingFieldException, BadFieldException {
        String string2 = xMLNode.getName();
        if (string2.equals("jar") || string2.equals("nativelib")) {
            URL uRL2 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string3 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            String string4 = XMLUtils.getAttribute(xMLNode, "", "download");
            String string5 = XMLUtils.getAttribute(xMLNode, "", "main");
            String string6 = XMLUtils.getAttribute(xMLNode, "", "part");
            int n = XMLUtils.getIntAttribute(string, xMLNode, "", "size", 0);
            boolean bl2 = string2.equals("nativelib");
            if (!Cache.isCacheEnabled() && bl2) {
                throw new BadFieldException(string, "nativelib", uRL2.toString());
            }
            boolean bl3 = "lazy".equalsIgnoreCase(string4);
            boolean bl4 = "progress".equalsIgnoreCase(string4);
            boolean bl5 = "true".equalsIgnoreCase(string5);
            JARDesc jARDesc = null;
            if (Environment.isImportMode() && Environment.getImportModeCodebaseOverride() != null && uRL2.toString().endsWith("/")) {
                Object object;
                String string7 = XMLUtils.getAttribute(xMLNode, "", "href");
                File file = null;
                try {
                    object = new URI(Environment.getImportModeCodebaseOverride().toString().replace("\\", "/") + XMLUtils.getAttribute(xMLNode, "", "href"));
                    file = new File((URI)object);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Trace.ignoredException((Exception)uRISyntaxException);
                }
                if (file != null && file.isDirectory()) {
                    object = file.listFiles();
                    for (int i = 0; i < ((File[])object).length; ++i) {
                        try {
                            URL uRL3 = new URL(uRL2.toString() + object[i].getName());
                            jARDesc = new JARDesc(uRL3, string3, bl3, bl5, bl2, string6, n, resourcesDesc, bl4);
                            resourcesDesc.addResource(jARDesc);
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            Trace.ignoredException((Exception)malformedURLException);
                        }
                    }
                }
            } else {
                jARDesc = new JARDesc(uRL2, string3, bl3, bl5, bl2, string6, n, resourcesDesc, bl4);
                resourcesDesc.addResource(jARDesc);
            }
        } else if (string2.equals("property")) {
            String string8 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string9 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
            if (string8.equals("jnlp.versionEnabled") && string9.equalsIgnoreCase("true")) {
                resourcesDesc.setVersionEnabled();
            } else if (string8.equals("jnlp.packEnabled") && string9.equalsIgnoreCase("true")) {
                resourcesDesc.setPack200Enabled();
            } else if (string8.equals("jnlp.concurrentDownloads")) {
                if (string9 != null) {
                    int n = 0;
                    try {
                        n = Integer.parseInt(string9.trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    resourcesDesc.setConcurrentDownloads(n);
                }
            } else {
                resourcesDesc.addResource(new PropertyDesc(string8, string9));
            }
        } else if (string2.equals("package")) {
            String string10 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
            String string11 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "part");
            String string12 = XMLUtils.getAttribute(xMLNode, "", "recursive", "false");
            boolean bl6 = "true".equals(string12);
            resourcesDesc.addResource(new PackageDesc(string10, string11, bl6));
        } else if (string2.equals("extension")) {
            String string13 = XMLUtils.getAttribute(xMLNode, "", "name");
            URL uRL4 = XMLUtils.getRequiredURL(string, uRL, xMLNode, "", "href");
            String string14 = XMLUtils.getAttribute(xMLNode, "", "version", null);
            ExtDownloadDesc[] extDownloadDescArray = XMLFormat.getExtDownloadDescs(string, xMLNode);
            resourcesDesc.addResource(new ExtensionDesc(string13, uRL4, string14, extDownloadDescArray));
        } else if ((string2.equals("java") || string2.equals("j2se")) && !bl) {
            String string15 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "version");
            URL uRL5 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
            String string16 = XMLUtils.getAttribute(xMLNode, "", "initial-heap-size");
            String string17 = XMLUtils.getAttribute(xMLNode, "", "max-heap-size");
            String string18 = XMLUtils.getAttribute(xMLNode, "", "java-vm-args");
            long l = -1L;
            long l2 = -1L;
            l = GeneralUtil.heapValToLong((String)string16);
            l2 = GeneralUtil.heapValToLong((String)string17);
            ResourcesDesc resourcesDesc2 = XMLFormat.buildResourcesDesc(string, uRL, xMLNode, true);
            JREDesc jREDesc = new JREDesc(string15, l, l2, string18, uRL5, resourcesDesc2);
            resourcesDesc.addResource(jREDesc);
        } else if (string2.equals("javafx-runtime")) {
            String string19 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "version");
            URL uRL6 = XMLUtils.getAttributeURL(string, uRL, xMLNode, "", "href");
            resourcesDesc.addResource(new JavaFXRuntimeDesc(string19, uRL6));
        }
    }

    private static ExtDownloadDesc[] getExtDownloadDescs(final String string, XMLNode xMLNode) throws BadFieldException, MissingFieldException {
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<ext-download>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string4 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "ext-part");
                String string2 = XMLUtils.getAttribute(xMLNode, "", "part");
                String string3 = XMLUtils.getAttribute(xMLNode, "", "download", "eager");
                boolean bl = "lazy".equals(string3);
                arrayList.add(new ExtDownloadDesc(string4, string2, bl));
            }
        });
        ExtDownloadDesc[] extDownloadDescArray = new ExtDownloadDesc[arrayList.size()];
        return arrayList.toArray(extDownloadDescArray);
    }

    private static ApplicationDesc buildApplicationDesc(final String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<application-desc>", "main-class", false);
        String string3 = XMLUtils.getClassName(string, xMLNode, "<application-desc>", "progress-class", false);
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<application-desc><argument>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string2 = XMLUtils.getElementContents(xMLNode, "", null);
                if (string2 == null) {
                    throw new BadFieldException(string, XMLUtils.getPathString(xMLNode), "");
                }
                arrayList.add(string2);
            }
        });
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return new ApplicationDesc(string2, string3, stringArray);
    }

    private static JavaFXAppDesc buildFXAppDesc(final String string, XMLNode xMLNode, String string2) throws MissingFieldException, BadFieldException {
        String string3 = XMLUtils.getClassName(string, xMLNode, string2, "main-class", true);
        String string4 = XMLUtils.getClassName(string, xMLNode, string2, "preloader-class", false);
        final ArrayList arrayList = new ArrayList();
        XMLUtils.visitElements(xMLNode, "<javafx-desc><argument>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string2 = XMLUtils.getElementContents(xMLNode, "", null);
                if (string2 == null) {
                    throw new BadFieldException(string, XMLUtils.getPathString(xMLNode), "");
                }
                arrayList.add(string2);
            }
        });
        String[] stringArray = null;
        if (!arrayList.isEmpty()) {
            stringArray = new String[arrayList.size()];
            stringArray = arrayList.toArray(stringArray);
        }
        final Properties properties = new Properties();
        XMLUtils.visitElements(xMLNode, "<javafx-desc><param>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
                String string2 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
                properties.setProperty(string3, string2);
            }
        });
        return new JavaFXAppDesc(string3, string4, stringArray, properties);
    }

    private static LibraryDesc buildLibraryDesc(String string, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<component-desc>", "progress-class", false);
        return new LibraryDesc(string2);
    }

    private static InstallerDesc buildInstallerDesc(String string, URL uRL, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<installer-desc>", "main-class", false);
        return new InstallerDesc(string2);
    }

    private static AppletDesc buildAppletDesc(final String string, URL uRL, URL uRL2, XMLNode xMLNode) throws MissingFieldException, BadFieldException {
        String string2 = XMLUtils.getClassName(string, xMLNode, "<applet-desc>", "main-class", true);
        String string3 = XMLUtils.getClassName(string, xMLNode, "<applet-desc>", "progress-class", false);
        String string4 = XMLUtils.getRequiredAttribute(string, xMLNode, "<applet-desc>", "name");
        int n = XMLUtils.getRequiredIntAttribute(string, xMLNode, "<applet-desc>", "width");
        int n2 = XMLUtils.getRequiredIntAttribute(string, xMLNode, "<applet-desc>", "height");
        if (n <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>width", new Integer(n).toString());
        }
        if (n2 <= 0) {
            throw new BadFieldException(string, XMLUtils.getPathString(xMLNode) + "<applet-desc>height", new Integer(n2).toString());
        }
        final Properties properties = new Properties();
        XMLUtils.visitElements(xMLNode, "<applet-desc><param>", new XMLUtils.ElementVisitor(){

            public void visitElement(XMLNode xMLNode) throws MissingFieldException, BadFieldException {
                String string3 = XMLUtils.getRequiredAttribute(string, xMLNode, "", "name");
                String string2 = XMLUtils.getRequiredAttributeEmptyOK(string, xMLNode, "", "value");
                properties.setProperty(string3, string2);
            }
        });
        return new AppletDesc(string4, string2, uRL2, n, n2, properties, string3);
    }

    public static boolean isBlacklisted(XMLNode xMLNode) {
        if (xMLNode == null) {
            return false;
        }
        if (xMLNode.getName() != null) {
            if (xMLNode.getName().equals("java") || xMLNode.getName().equals("j2se")) {
                for (XMLAttribute xMLAttribute = xMLNode.getAttributes(); xMLAttribute != null; xMLAttribute = xMLAttribute.getNext()) {
                    String string;
                    if (!xMLAttribute.getName().equals("java-vm-args") || (string = xMLAttribute.getValue()) == null || string.indexOf("*") < 0) continue;
                    Trace.println((String)("Blacklisted - a = " + xMLAttribute), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
            } else if (xMLNode.getName().equals("property")) {
                for (XMLAttribute xMLAttribute = xMLNode.getAttributes(); xMLAttribute != null; xMLAttribute = xMLAttribute.getNext()) {
                    String string = xMLAttribute.getValue();
                    if (string == null || string.indexOf("*") < 0) continue;
                    Trace.println((String)("Blacklisted - a = " + xMLAttribute), (TraceLevel)TraceLevel.SECURITY);
                    return true;
                }
            }
        }
        if (XMLFormat.isBlacklisted(xMLNode.getNested())) {
            return true;
        }
        return XMLFormat.isBlacklisted(xMLNode.getNext());
    }
}

