/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.filtering;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ZipInspector {
    public static final int UNZIP_BUFFER_SIZE = 308224;
    public static final double COMPRESSION_RATIO = 2.0;
    public static final long AVERAGE_EVENT_SIZE_IN_BYTES = 75L;
    public static final long EVENT_COUNT_UNKNOWN_AFTER_INSPECTION = -1L;
    private final ZipFile m_zipFile;
    private final File m_file;

    public ZipInspector(File file) throws ZipException, IOException {
        this.m_file = file;
        this.m_zipFile = new ZipFile(file);
    }

    public ZipEntry getDataFile() {
        Enumeration<? extends ZipEntry> entries = this.m_zipFile.entries();
        if (entries.hasMoreElements()) {
            return entries.nextElement();
        }
        return null;
    }

    public ZipFile getZipFile() {
        return this.m_zipFile;
    }

    public long getLatencyEventCountApproximation() {
        ZipEntry entry = this.getDataFile();
        if (entry != null) {
            long size = entry.getSize();
            if (size == -1L && entry.getCompressedSize() != -1L) {
                size = (long)(2.0 * (double)entry.getCompressedSize());
            }
            if (size == -1L && this.m_file.length() != 0L) {
                size = (long)((double)this.m_file.length() * 2.0);
            }
            if (size != -1L) {
                return size / 75L;
            }
        }
        return -1L;
    }

    public void close() throws IOException {
        if (this.m_zipFile != null) {
            this.m_zipFile.close();
        }
    }
}

