/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.tracetree;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.flightrecorder.util.EqualsToolkit;
import java.util.Observable;

public final class FrameEqualityChecker
extends Observable {
    private boolean m_disregardOptimization;
    private boolean m_disregardClassloader;

    boolean isEqual(IMCFrame frameA, IMCFrame frameB) {
        if (frameA != null && frameB != null && this.hasSameMethod(frameA, frameB)) {
            return this.hasSameQualifiedClassName(frameA, frameB);
        }
        return frameA == frameB;
    }

    private boolean hasSameQualifiedClassName(IMCFrame frameA, IMCFrame frameB) {
        IMCMethod methodA = frameA.getMethod();
        IMCMethod methodB = frameB.getMethod();
        if (methodA != null && methodB != null && EqualsToolkit.nullSafeEquals((Object)methodA.getClassName(), (Object)methodB.getClassName())) {
            return frameA.getMethod().getPackageName().equals(frameB.getMethod().getPackageName());
        }
        return methodA == methodB;
    }

    private boolean hasSameMethod(IMCFrame frameA, IMCFrame frameB) {
        IMCMethod methodA = frameA.getMethod();
        IMCMethod methodB = frameB.getMethod();
        if (methodA != null && methodB != null && methodA.equals(methodB)) {
            return frameA.getMethod().getFormalDescriptor().equals(frameB.getMethod().getFormalDescriptor());
        }
        return methodA == methodB;
    }

    public void setDisregardOptimization(boolean disregardOptimization) {
        this.m_disregardOptimization = disregardOptimization;
        this.setChanged();
    }

    public void setDisregardClassloader(boolean disregardClassloader) {
        this.m_disregardClassloader = disregardClassloader;
        this.setChanged();
    }

    public boolean getDiregardClassloader() {
        return this.m_disregardOptimization;
    }

    public boolean getDiscardClassLoader() {
        return this.m_disregardClassloader;
    }
}

