/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.LocalDownloadSupport;
import org.netbeans.modules.autoupdate.ui.LocallyDownloadedTableModel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UnitDetails;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.UpdateUnitListener;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizard;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.UninstallUnitWizard;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class UnitTab
extends JPanel {
    static final String PROP_LAST_CHECK = "lastCheckTime";
    private PreferenceChangeListener preferenceChangeListener;
    private UnitTable table = null;
    private UnitDetails details = null;
    private UnitCategoryTableModel model = null;
    private DocumentListener dlForSearch;
    private FocusListener flForSearch;
    private String filter = "";
    private PluginManagerUI manager = null;
    private PopupActionSupport popupActionsSupport;
    private TabAction activateAction;
    private TabAction deactivateAction;
    private TabAction reloadAction;
    private RowTabAction moreAction;
    private RowTabAction lessAction;
    private RowTabAction removeLocallyDownloaded;
    private static Boolean isWaitingForExternal = false;
    private static final RequestProcessor SEARCH_PROCESSOR = new RequestProcessor("search-processor");
    private final RequestProcessor.Task searchTask = SEARCH_PROCESSOR.create(new Runnable(){

        @Override
        public void run() {
            if (UnitTab.this.filter != null) {
                int n = UnitTab.this.getSelectedRow();
                final Unit unit = n >= 0 ? UnitTab.this.getModel().getUnitAtRow(n) : null;
                final Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (unit != null) {
                            int n = UnitTab.this.findRow(unit.updateUnit.getCodeName());
                            UnitTab.this.restoreSelectedRow(n);
                        }
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                        UnitTab.this.refreshState();
                    }
                };
                UnitTab.this.model.setFilter(UnitTab.this.filter, runnable);
            }
        }
    });
    private static final RequestProcessor DOWNLOAD_SIZE_PROCESSOR = new RequestProcessor("download-size-processor", 1, true);
    private RequestProcessor.Task getDownloadSizeTask = null;
    private Collection<Unit> oldUnits = Collections.emptySet();
    private JButton bTabAction;
    private JButton bTabAction1;
    private JButton bTabAction2;
    private JCheckBox detailView;
    private JLabel lSearch;
    private JLabel lSelectionInfo;
    private JLabel lWarning;
    private JSplitPane spTab;
    private JTextField tfSearch;
    private JButton topButton;

    public UnitTab(UnitTable unitTable, UnitDetails unitDetails, PluginManagerUI pluginManagerUI) {
        this.table = unitTable;
        this.details = unitDetails;
        this.manager = pluginManagerUI;
        TableModel tableModel = unitTable.getModel();
        assert (tableModel instanceof UnitCategoryTableModel) : tableModel + " instanceof UnitCategoryTableModel.";
        this.model = (UnitCategoryTableModel)tableModel;
        unitTable.getSelectionModel().setSelectionMode(0);
        this.initComponents();
        this.lWarning.setVisible(false);
        this.spTab.setLeftComponent(new JScrollPane(unitTable));
        this.spTab.setRightComponent(new JScrollPane(unitDetails, 20, 30));
        this.initTab();
        this.listenOnSelection();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                super.componentShown(componentEvent);
                UnitTab.this.focusTable();
            }
        });
        this.addUpdateUnitListener(new UpdateUnitListener(){

            @Override
            public void updateUnitsChanged() {
                UnitTab.this.manager.updateUnitsChanged();
            }

            @Override
            public void buttonsChanged() {
                UnitTab.this.manager.buttonsChanged();
            }

            @Override
            public void filterChanged() {
                UnitTab.this.model.fireTableDataChanged();
                UnitTab.this.manager.decorateTabTitle(UnitTab.this.table);
                UnitTab.this.refreshState();
            }
        });
        unitTable.getInputMap().put(KeyStroke.getKeyStroke(121, 64), "org.netbeans.modules.autoupdate.ui.UnitTab.PopupActionSupport");
        unitTable.getActionMap().put("org.netbeans.modules.autoupdate.ui.UnitTab.PopupActionSupport", this.popupActionsSupport.popupOnF10);
    }

    void focusTable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnitTab.this.table.requestFocusInWindow();
            }
        });
    }

    UnitCategoryTableModel getModel() {
        return this.model;
    }

    UnitTable getTable() {
        return this.table;
    }

    public String getHelpId() {
        return UnitTab.class.getName() + '.' + (Object)((Object)this.model.getType());
    }

    void setWaitingState(boolean bl) {
        boolean bl2 = !bl;
        Component[] componentArray = this.getComponents();
        for (Component component : componentArray) {
            if (component == this.bTabAction || component == this.bTabAction1 || component == this.bTabAction2) {
                if (bl2) {
                    TabAction tabAction = (TabAction)((AbstractButton)component).getAction();
                    component.setEnabled(tabAction == null ? false : tabAction.isEnabled());
                    continue;
                }
                component.setEnabled(bl2);
                continue;
            }
            if (component == this.spTab) {
                this.spTab.getLeftComponent().setEnabled(bl2);
                this.spTab.getRightComponent().setEnabled(bl2);
                this.details.setEnabled(bl2);
                this.table.setEnabled(bl2);
                continue;
            }
            component.setEnabled(bl2);
        }
        if (this.reloadAction != null) {
            this.reloadAction.setEnabled(bl2);
        }
        Container container = this.getParent();
        JRootPane jRootPane = this.getRootPane();
        if (container != null) {
            container.setEnabled(bl2);
        }
        if (jRootPane != null) {
            if (bl2) {
                jRootPane.setCursor(null);
            } else {
                jRootPane.setCursor(Cursor.getPredefinedCursor(3));
            }
        }
        this.focusTable();
    }

    private void prepareTopButton(Action action) {
        if (action != null) {
            this.topButton.setToolTipText((String)action.getValue("ToolTipText"));
            this.topButton.setAction(action);
            this.topButton.setVisible(true);
        } else {
            this.topButton.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        if (this.dlForSearch == null) {
            this.tfSearch.getDocument().addDocumentListener(this.getDocumentListener());
        }
        if (this.flForSearch == null) {
            this.flForSearch = new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    UnitTab.this.tfSearch.selectAll();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    UnitTab.this.tfSearch.select(0, 0);
                }
            };
            this.tfSearch.addFocusListener(this.flForSearch);
        }
        RequestProcessor.Task task = PluginManagerUI.getRunningTask(new Runnable(){

            @Override
            public void run() {
                if (isWaitingForExternal.booleanValue()) {
                    UnitTab.this.reloadTask(false).schedule(10);
                    isWaitingForExternal = false;
                }
            }
        });
        UnitTab unitTab = this;
        synchronized (unitTab) {
            if (task != null && !task.isFinished() && !isWaitingForExternal.booleanValue()) {
                isWaitingForExternal = true;
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        if (isWaitingForExternal.booleanValue()) {
                            UnitTab.this.reloadTask(false).schedule(10);
                        }
                        isWaitingForExternal = false;
                    }
                });
            }
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.dlForSearch != null) {
            this.tfSearch.getDocument().removeDocumentListener(this.getDocumentListener());
        }
        this.dlForSearch = null;
        if (this.flForSearch != null) {
            this.tfSearch.removeFocusListener(this.flForSearch);
        }
        this.flForSearch = null;
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        if (this.preferenceChangeListener != null) {
            preferences.removePreferenceChangeListener(this.preferenceChangeListener);
            this.preferenceChangeListener = null;
        }
    }

    public void refreshState() {
        this.detailView.setVisible(this.model.supportsTwoViews());
        Collection<Unit> collection = this.model.getMarkedUnits();
        if (((Object)this.oldUnits).equals(collection)) {
            return;
        }
        this.oldUnits = collection;
        this.popupActionsSupport.tableDataChanged();
        if (collection.isEmpty()) {
            this.cleanSelectionInfo();
        } else {
            this.setSelectionInfo(null, collection.size());
        }
        this.getDefaultAction().tableDataChanged(collection);
        boolean bl = false;
        if (this.getDownloadSizeTask != null) {
            if (this.getDownloadSizeTask.getDelay() > 0) {
                this.getDownloadSizeTask.schedule(1000);
                bl = true;
            } else if (!this.getDownloadSizeTask.isFinished()) {
                this.getDownloadSizeTask.cancel();
            }
        }
        if (collection.size() > 0 && !bl) {
            this.getDownloadSizeTask = DOWNLOAD_SIZE_PROCESSOR.post(new Runnable(){

                @Override
                public void run() {
                    int n = UnitTab.this.model.getDownloadSize();
                    if (Thread.interrupted()) {
                        return;
                    }
                    if (UnitTab.this.model.getMarkedUnits().isEmpty()) {
                        UnitTab.this.cleanSelectionInfo();
                    } else {
                        UnitTab.this.setSelectionInfo(Utilities.getDownloadSizeAsString(n), UnitTab.this.model.getMarkedUnits().size());
                    }
                }
            }, 150);
        }
    }

    final void updateTab(final Map<String, Boolean> map) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                LocallyDownloadedTableModel locallyDownloadedTableModel = (LocallyDownloadedTableModel)UnitTab.this.model;
                List<UpdateUnit> list = Collections.emptyList();
                locallyDownloadedTableModel.setUnits(list);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UnitTab.this.fireUpdataUnitChange();
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                        UnitTab.this.refreshState();
                        UnitTab.this.setWaitingState(false);
                    }
                });
            }
        };
        this.setWaitingState(true);
        Utilities.startAsWorkerThread(runnable, 250);
    }

    private TabAction getDefaultAction() {
        return (TabAction)this.bTabAction.getAction();
    }

    private void initTab() {
        TabAction[] tabActionArray = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                ActivateCategoryAction activateCategoryAction = new ActivateCategoryAction();
                DeactivateCategoryAction deactivateCategoryAction = new DeactivateCategoryAction();
                this.activateAction = new ActivateAction();
                this.deactivateAction = new DeactivateAction();
                UninstallAction uninstallAction = new UninstallAction();
                tabActionArray = new TabAction[]{this.activateAction, this.deactivateAction, activateCategoryAction, deactivateCategoryAction, checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction(), uninstallAction};
                this.bTabAction1.setVisible(true);
                this.bTabAction2.setVisible(true);
                this.bTabAction.setAction(this.activateAction);
                this.bTabAction1.setAction(this.deactivateAction);
                this.bTabAction2.setAction(uninstallAction);
                this.prepareTopButton(null);
                this.table.setEnableRenderer(new EnableRenderer());
                this.initReloadTooltip();
                break;
            }
            case UPDATE: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                this.moreAction = new MoreAction();
                this.lessAction = new LessAction();
                tabActionArray = new TabAction[]{checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction(), this.moreAction, this.lessAction};
                this.bTabAction.setAction(new UpdateAction());
                this.bTabAction1.setVisible(false);
                this.bTabAction2.setVisible(false);
                this.reloadAction = new ReloadAction("UnitTab_ReloadActionUpdates");
                this.prepareTopButton(this.reloadAction);
                this.initReloadTooltip();
                break;
            }
            case AVAILABLE: {
                CheckCategoryAction checkCategoryAction = new CheckCategoryAction();
                UncheckCategoryAction uncheckCategoryAction = new UncheckCategoryAction();
                CheckAllAction checkAllAction = new CheckAllAction();
                UncheckAllAction uncheckAllAction = new UncheckAllAction();
                this.moreAction = new MoreAction();
                this.lessAction = new LessAction();
                tabActionArray = new TabAction[]{checkCategoryAction, uncheckCategoryAction, checkAllAction, uncheckAllAction, new CheckAction(), this.moreAction, this.lessAction};
                this.bTabAction.setAction(new AvailableAction());
                this.bTabAction1.setVisible(false);
                this.bTabAction2.setVisible(false);
                this.reloadAction = new ReloadAction("UnitTab_ReloadAction");
                this.prepareTopButton(this.reloadAction);
                this.table.setEnableRenderer(new SourceCategoryRenderer());
                this.initReloadTooltip();
                break;
            }
            case LOCAL: {
                this.removeLocallyDownloaded = new RemoveLocallyDownloadedAction();
                tabActionArray = new TabAction[]{this.removeLocallyDownloaded, new CheckAction()};
                this.bTabAction.setAction(new LocalUpdateAction());
                this.bTabAction1.setVisible(false);
                this.bTabAction2.setVisible(false);
                this.prepareTopButton(new AddLocallyDownloadedAction());
            }
        }
        this.model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                UnitTab.this.refreshState();
            }
        });
        this.popupActionsSupport = new PopupActionSupport(tabActionArray);
        this.table.addMouseListener(this.popupActionsSupport);
        this.getDefaultAction().setEnabled(this.model.getMarkedUnits().size() > 0);
    }

    private void cleanSelectionInfo() {
        this.lSelectionInfo.setText("");
        this.lWarning.setText("");
        this.lWarning.setIcon(null);
    }

    private void setSelectionInfo(String string, int n) {
        String string2;
        String string3 = null;
        switch (this.model.getType()) {
            case INSTALLED: {
                string3 = "UnitTab_OperationName_Text_INSTALLED";
                break;
            }
            case UPDATE: {
                string3 = "UnitTab_OperationName_Text_UPDATE";
                break;
            }
            case AVAILABLE: {
                string3 = "UnitTab_OperationName_Text_AVAILABLE";
                break;
            }
            case LOCAL: {
                string3 = "UnitTab_OperationName_Text_LOCAL";
            }
        }
        String string4 = string2 = n == 1 ? "UnitTab_lHowManySelected_Single_Text" : "UnitTab_lHowManySelected_Many_Text";
        if (UnitCategoryTableModel.Type.INSTALLED == this.model.getType() || UnitCategoryTableModel.Type.LOCAL == this.model.getType()) {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)string2, (Object)n));
        } else if (string == null) {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)string2, (Object)n));
        } else {
            this.lSelectionInfo.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lHowManySelected_TextFormatWithSize", (Object)NbBundle.getMessage(UnitTab.class, (String)string2, (Object)n), (Object)string));
        }
        if (this.model.needsRestart()) {
            ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/warning.gif", (boolean)false);
            this.lWarning.setIcon(imageIcon);
            this.lWarning.setText(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_lWarning_Text", (Object)NbBundle.getMessage(UnitTab.class, (String)string3)));
        }
    }

    private void showDetailsAtRow(int n) {
        this.showDetailsAtRow(n, null);
    }

    private void showDetailsAtRow(int n, Action action) {
        if (n == -1) {
            this.details.setUnit(null);
        } else {
            Unit unit;
            Unit unit2 = unit = this.model.isExpansionControlAtRow(n) ? null : this.model.getUnitAtRow(n);
            if (unit != null) {
                this.details.setUnit(unit, action);
            }
        }
    }

    private void listenOnSelection() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(final ListSelectionEvent listSelectionEvent) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.valueChanged(listSelectionEvent);
                        }
                    });
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    UnitTab.this.showDetailsAtRow(-1);
                    UnitTab.this.popupActionsSupport.rowChanged(-1);
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    UnitTab.this.popupActionsSupport.rowChanged(n);
                    RowTabAction rowTabAction = null;
                    if (!(UnitTab.this.activateAction != null && UnitTab.this.activateAction.isEnabled() || UnitTab.this.deactivateAction != null && UnitTab.this.deactivateAction.isEnabled() || UnitTab.this.removeLocallyDownloaded == null || !UnitTab.this.removeLocallyDownloaded.isEnabled())) {
                        rowTabAction = UnitTab.this.removeLocallyDownloaded;
                    }
                    UnitTab.this.showDetailsAtRow(n, rowTabAction);
                }
            }
        });
    }

    public void addUpdateUnitListener(UpdateUnitListener updateUnitListener) {
        this.model.addUpdateUnitListener(updateUnitListener);
    }

    public void removeUpdateUnitListener(UpdateUnitListener updateUnitListener) {
        this.model.removeUpdateUnitListener(updateUnitListener);
    }

    void fireUpdataUnitChange() {
        this.model.fireUpdataUnitChange();
    }

    DocumentListener getDocumentListener() {
        if (this.dlForSearch == null) {
            this.dlForSearch = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    UnitTab.this.filter = UnitTab.this.tfSearch.getText().trim();
                    UnitTab.this.searchTask.schedule(350);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            };
        }
        return this.dlForSearch;
    }

    private void initComponents() {
        this.lSelectionInfo = new JLabel();
        this.bTabAction = new JButton();
        this.lSearch = new JLabel();
        this.tfSearch = new JTextField();
        this.spTab = new JSplitPane();
        this.topButton = new JButton();
        this.lWarning = new JLabel();
        this.detailView = new JCheckBox();
        this.bTabAction1 = new JButton();
        this.bTabAction2 = new JButton();
        this.lSearch.setLabelFor(this.tfSearch);
        Mnemonics.setLocalizedText((JLabel)this.lSearch, (String)NbBundle.getMessage(UnitTab.class, (String)"lSearch1.text"));
        this.spTab.setBorder(null);
        this.spTab.setDividerLocation(Integer.parseInt(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Splitter_DefaultDividerLocation")));
        this.spTab.setResizeWeight(0.5);
        this.spTab.setOneTouchExpandable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.topButton, (String)"jButton1");
        this.detailViewInit();
        Mnemonics.setLocalizedText((AbstractButton)this.detailView, (String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab.detailView.text"));
        this.detailView.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                UnitTab.this.detailViewItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.topButton).addGap(18, 18, 18).addComponent(this.detailView).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 443, Short.MAX_VALUE).addComponent(this.lSearch).addGap(4, 4, 4).addComponent(this.tfSearch, -2, 114, -2)).addComponent(this.spTab, -1, 776, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.bTabAction).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTabAction1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTabAction2).addGap(8, 8, 8).addComponent(this.lSelectionInfo).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lWarning, -1, 542, Short.MAX_VALUE).addGap(99, 99, 99))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lSearch).addComponent(this.topButton).addComponent(this.detailView)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spTab, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.bTabAction).addComponent(this.lSelectionInfo, -1, -1, Short.MAX_VALUE).addComponent(this.lWarning).addComponent(this.bTabAction1).addComponent(this.bTabAction2)).addContainerGap()));
        groupLayout.linkSize(1, this.lSelectionInfo, this.lWarning);
        this.lSearch.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_Search"));
        this.topButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTab.class, (String)"ACN_Reload"));
        this.topButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"ACD_Reload"));
    }

    private void detailViewItemStateChanged(ItemEvent itemEvent) {
        if (this.model.supportsTwoViews()) {
            this.manager.setDetailView(this.detailView.isSelected());
            this.uncheckAll();
            this.manager.updateUnitsChanged();
            System.setProperty("plugin.manager.detail.view.selected", "" + this.detailView.isSelected());
        }
    }

    private void detailViewInit() {
        this.detailView.setVisible(this.model.supportsTwoViews());
        if (this.model.supportsTwoViews()) {
            this.detailView.setSelected(Boolean.getBoolean("plugin.manager.detail.view.selected"));
        }
    }

    private LocalDownloadSupport getLocalDownloadSupport() {
        return this.model instanceof LocallyDownloadedTableModel ? ((LocallyDownloadedTableModel)this.model).getLocalDownloadSupport() : null;
    }

    private RequestProcessor.Task reloadTask(final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadAction"));
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                JLabel jLabel = new JLabel(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_PrepareReloadAction"));
                UnitTab.this.manager.setProgressComponent(jLabel, jComponent);
                progressHandle.setInitialDelay(0);
                progressHandle.start();
                ((UnitTab)UnitTab.this).manager.initTask.waitFinished();
                UnitTab.this.setWaitingState(true);
                if (UnitTab.this.getDownloadSizeTask != null && !UnitTab.this.getDownloadSizeTask.isFinished()) {
                    if (UnitTab.this.getDownloadSizeTask.getDelay() > 0) {
                        UnitTab.this.getDownloadSizeTask.cancel();
                    } else {
                        UnitTab.this.getDownloadSizeTask.waitFinished();
                    }
                }
                final int n = UnitTab.this.getSelectedRow();
                final Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                if (UnitTab.this.model instanceof LocallyDownloadedTableModel) {
                    ((LocallyDownloadedTableModel)UnitTab.this.model).removeInstalledUnits();
                    ((LocallyDownloadedTableModel)UnitTab.this.model).setUnits(null);
                }
                UnitTab.this.manager.unsetProgressComponent(jLabel, jComponent);
                Utilities.presentRefreshProviders(UnitTab.this.manager, bl);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UnitTab.this.fireUpdataUnitChange();
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                        UnitTab.this.restoreSelectedRow(n);
                        UnitTab.this.refreshState();
                        UnitTab.this.setWaitingState(false);
                    }
                });
            }
        };
        return Utilities.startAsWorkerThread(runnable);
    }

    private void showPopup(Point point, Component component) {
        int n = this.table.rowAtPoint(point);
        if (n >= 0) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
            JPopupMenu jPopupMenu = this.popupActionsSupport.createPopup();
            if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0) {
                jPopupMenu.show(component, point.x, point.y);
            }
        }
    }

    private int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    private void restoreSelectedRow(int n) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i >= 0; --i) {
            if (i >= this.table.getRowCount() || i <= -1) continue;
            this.table.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    int findRow(String string) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Unit unit = this.model.getUnitAtRow(i);
            if (unit == null || !string.equals(unit.updateUnit.getCodeName())) continue;
            return i;
        }
        return -1;
    }

    private void initReloadTooltip() {
        Preferences preferences = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        long l = preferences.getLong(PROP_LAST_CHECK, 0L);
        if (l > 0L) {
            this.topButton.setToolTipText("<html>" + NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)("<b>" + new SimpleDateFormat().format(new Date(l)) + "</b>")) + "</html>");
        } else {
            String string = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime_Never");
            this.topButton.setToolTipText("<html>" + NbBundle.getMessage(UnitTab.class, (String)"UnitTab_ReloadTime", (Object)("<b>" + string + "</b>")) + "/<html>");
        }
        if (this.preferenceChangeListener == null) {
            this.preferenceChangeListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            UnitTab.this.initReloadTooltip();
                        }
                    });
                }
            };
            preferences.addPreferenceChangeListener(this.preferenceChangeListener);
        }
    }

    static String textForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(UnitTab.class, (String)string));
        return jButton.getText();
    }

    static int mnemonicForKey(String string) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(UnitTab.class, (String)string));
        return jButton.getMnemonic();
    }

    private void uncheckAll() {
        Collection<Unit> collection = this.model.getMarkedUnits();
        for (Unit unit : collection) {
            if (unit == null || !unit.isMarked() || !unit.canBeMarked()) continue;
            unit.setMarked(false);
        }
        this.model.fireTableDataChanged();
    }

    class SourceCategoryRenderer
    extends DefaultTableCellRenderer {
        SourceCategoryRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Image && (object2 = UnitTab.this.model.getUnitAtRow(n)) instanceof Unit.Available) {
                Unit.Available available = (Unit.Available)object2;
                jLabel.setIcon(ImageUtilities.image2Icon((Image)available.getSourceIcon()));
                jLabel.setText("");
                jLabel.setHorizontalAlignment(0);
            }
            object2 = jLabel;
            return object2;
        }
    }

    private class EnableRenderer
    extends DefaultTableCellRenderer {
        private EnableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Object object2;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Boolean) {
                object2 = UnitTab.this.model.getUnitAtRow(n);
                if (object2 != null && ((Unit)object2).getRelevantElement().getUpdateUnit().isPending()) {
                    jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/restart.png", (boolean)false));
                } else {
                    Boolean bl3 = (Boolean)object;
                    if (bl3.booleanValue()) {
                        jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/active.png", (boolean)false));
                    } else {
                        jLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/ui/resources/inactive.png", (boolean)false));
                    }
                }
                jLabel.setText("");
                jLabel.setHorizontalAlignment(0);
            }
            object2 = jLabel;
            return object2;
        }
    }

    private class RemoveLocallyDownloadedAction
    extends RowTabAction {
        public RemoveLocallyDownloadedAction() {
            super("UnitTab_RemoveLocallyDownloadedAction", null);
            String string = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_RemoveAction_LOCAL");
            this.putValue("ToolTipText", string);
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            return unit != null && UnitTab.this.model.getType().equals((Object)UnitCategoryTableModel.Type.LOCAL);
        }

        @Override
        public boolean isEnabled() {
            if (super.isEnabled()) {
                return UnitTab.this.table.getSelectedRow() > -1;
            }
            return false;
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            super.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
        }

        @Override
        public void performerImpl(final Unit unit) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                    try {
                        if (unit.isMarked()) {
                            unit.setMarked(false);
                        }
                        UnitTab.this.getLocalDownloadSupport().remove(unit.updateUnit);
                        UnitTab.this.getLocalDownloadSupport().getUpdateUnits();
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(map){
                            final /* synthetic */ Map val$state;
                            {
                                this.val$state = map;
                            }

                            @Override
                            public void run() {
                                UnitTab.this.fireUpdataUnitChange();
                                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), this.val$state, UnitTab.this.model.isMarkedAsDefault());
                                UnitTab.this.refreshState();
                                UnitTab.this.setWaitingState(false);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            };
            UnitTab.this.setWaitingState(true);
            Utilities.startAsWorkerThread(runnable, 250);
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName();
        }

        @Override
        protected boolean isVisible(Unit unit) {
            return false;
        }
    }

    private class AddLocallyDownloadedAction
    extends TabAction {
        public AddLocallyDownloadedAction() {
            super("UnitTab_bAddLocallyDownloads_Name", null);
            UnitTab.this.topButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_bAddLocallyDownloads_ACN"));
            UnitTab.this.topButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(UnitTab.class, (String)"UnitTab_bAddLocallyDownloads_ACD"));
            String string = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_AddAction_LOCAL");
            this.putValue("ToolTipText", string);
        }

        @Override
        public void performerImpl() {
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            if (UnitTab.this.getLocalDownloadSupport().chooseNbmFiles()) {
                UnitTab.this.updateTab(map);
            }
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            super.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
        }
    }

    private class ReloadAction
    extends TabAction {
        RequestProcessor.Task reloadTask;

        public ReloadAction(String string) {
            super(string, KeyStroke.getKeyStroke(82, 128), null);
            this.reloadTask = null;
            String string2 = NbBundle.getMessage(UnitTab.class, (String)"UnitTab_Tooltip_RefreshAction");
            this.putValue("ToolTipText", string2);
            this.setEnabled(false);
        }

        @Override
        public void performerImpl() {
            this.setEnabled(false);
            this.reloadTask = UnitTab.this.reloadTask(true);
        }

        @Override
        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            super.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
        }
    }

    private class LessAction
    extends RowTabAction {
        public LessAction() {
            super("UnitTab_LessAction", "Expand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit unit) {
            try {
                UnitTab.this.setWaitingState(true);
                Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                UnitTab.this.model.setExpanded(false);
                UnitTab.this.fireUpdataUnitChange();
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                UnitTab.this.focusTable();
            }
            finally {
                UnitTab.this.setWaitingState(false);
            }
        }

        @Override
        protected boolean isVisible(Unit unit) {
            return this.isEnabled(unit);
        }

        @Override
        protected boolean isVisible(int n) {
            return !UnitTab.this.model.isExpansionControlAtRow(n) && this.isEnabled(n);
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            return unit != null && UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isExpanded();
        }

        @Override
        protected boolean isEnabled(int n) {
            return UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isExpanded();
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class MoreAction
    extends RowTabAction {
        public MoreAction() {
            super("UnitTab_MoreAction", "Expand");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl(Unit unit) {
            try {
                UnitTab.this.setWaitingState(true);
                Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
                UnitTab.this.model.setExpanded(true);
                UnitTab.this.fireUpdataUnitChange();
                UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                UnitTab.this.focusTable();
            }
            finally {
                UnitTab.this.setWaitingState(false);
            }
        }

        @Override
        protected boolean isVisible(Unit unit) {
            return this.isEnabled(unit);
        }

        @Override
        protected boolean isVisible(int n) {
            return !UnitTab.this.model.isExpansionControlAtRow(n) && this.isEnabled(n);
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            return unit != null && UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isCollapsed();
        }

        @Override
        protected boolean isEnabled(int n) {
            return UnitTab.this.model.isExpansionControlPresent() && UnitTab.this.model.isCollapsed();
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class UncheckAllAction
    extends RowTabAction {
        public UncheckAllAction() {
            super("UnitTab_UncheckAllAction", "Uncheck");
        }

        @Override
        public void performerImpl(Unit unit) {
            int n = UnitTab.this.getSelectedRow();
            UnitTab.this.uncheckAll();
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            return true;
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class CheckAllAction
    extends RowTabAction {
        public CheckAllAction() {
            super("UnitTab_CheckAllAction", KeyStroke.getKeyStroke(65, 128), "Check");
        }

        @Override
        public void performerImpl(Unit unit) {
            int n = UnitTab.this.getSelectedRow();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                if (unit2 == null || unit2.isMarked() || !unit2.canBeMarked()) continue;
                unit2.setMarked(true);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            return true;
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class UncheckCategoryAction
    extends RowTabAction {
        public UncheckCategoryAction() {
            super("UnitTab_UncheckCategoryAction", "Uncheck");
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                if (unit2 == null || !string.equals(unit2.getCategoryName()) || !unit2.isMarked()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        public void performerImpl(Unit unit) {
            String string = unit.getCategoryName();
            int n = UnitTab.this.getSelectedRow();
            int n2 = UnitTab.this.model.getRowCount();
            for (int i = 0; i < n2; ++i) {
                unit = UnitTab.this.model.getUnitAtRow(i);
                if (unit == null || !string.equals(unit.getCategoryName()) || !unit.isMarked() || !unit.canBeMarked()) continue;
                unit.setMarked(false);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        @Override
        protected boolean isVisible(Unit unit) {
            if (unit.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return super.isVisible(unit);
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
        }
    }

    private class DeactivateCategoryAction
    extends RowTabAction {
        public DeactivateCategoryAction() {
            super("UnitTab_DeactivateCategoryAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                Unit.Installed installed;
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || !(installed = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                bl = Unit.Installed.isOperationAllowed(installed.updateUnit, installed.getRelevantElement(), Containers.forDisable());
            }
            return bl;
        }

        @Override
        protected String getContextName(Unit unit) {
            if (unit != null && unit instanceof Unit.Installed) {
                return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
            }
            return this.getActionName();
        }

        @Override
        public void performerImpl(Unit unit) {
            Unit.Installed installed = (Unit.Installed)unit;
            int n = UnitTab.this.getSelectedRow();
            String string = installed.getCategoryName();
            int n2 = UnitTab.this.model.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Unit.Installed installed2;
                Unit unit2 = UnitTab.this.model.getUnitAtRow(i);
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || !(installed2 = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                OperationContainer.OperationInfo operationInfo = Containers.forDisable().add(installed2.updateUnit, installed2.getRelevantElement());
            }
            if (Containers.forDisable().listAll().size() > 0) {
                UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
                uninstallUnitWizard.invokeWizard(false);
                Containers.forDisable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        @Override
        protected boolean isVisible(Unit unit) {
            if (unit.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return this.isEnabled();
        }
    }

    private class DeactivateAction
    extends TabAction {
        public DeactivateAction() {
            super("UnitTab_DeactivateAction", "EnableDisable");
        }

        @Override
        public void tableDataChanged(Collection<Unit> collection) {
            if (collection.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (Unit unit : collection) {
                if (!this.isEnabled(unit)) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            OperationContainer<OperationSupport> operationContainer = Containers.forDisable();
            for (Unit unit : UnitTab.this.model.getUnits()) {
                if (!unit.isMarked() || !this.isEnabled(unit)) continue;
                operationContainer.add(unit.updateUnit, unit.getRelevantElement());
            }
            UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
            boolean bl = false;
            try {
                bl = uninstallUnitWizard.invokeWizard(false);
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        protected boolean isEnabled(Unit unit) {
            Unit.Installed installed;
            boolean bl = false;
            if (unit != null && unit instanceof Unit.Installed && (installed = (Unit.Installed)unit).getRelevantElement().isEnabled()) {
                bl = Unit.Installed.isOperationAllowed(unit.updateUnit, unit.getRelevantElement(), Containers.forDisable());
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class ActivateCategoryAction
    extends RowTabAction {
        public ActivateCategoryAction() {
            super("UnitTab_ActivateCategoryAction", "EnableDisable");
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                Unit.Installed installed;
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || (installed = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                bl = Unit.Installed.isOperationAllowed(installed.updateUnit, installed.getRelevantElement(), Containers.forEnable());
            }
            return bl;
        }

        @Override
        protected String getContextName(Unit unit) {
            if (unit != null && unit instanceof Unit.Installed) {
                return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
            }
            return this.getActionName();
        }

        @Override
        public void performerImpl(Unit unit) {
            Unit.Installed installed = (Unit.Installed)unit;
            int n = UnitTab.this.getSelectedRow();
            String string = installed.getCategoryName();
            int n2 = UnitTab.this.model.getRowCount();
            for (int i = 0; i < n2; ++i) {
                Unit.Installed installed2;
                Unit unit2 = UnitTab.this.model.getUnitAtRow(i);
                if (unit2 == null || !(unit2 instanceof Unit.Installed) || !string.equals(unit2.getCategoryName()) || (installed2 = (Unit.Installed)unit2).getRelevantElement().isEnabled()) continue;
                OperationContainer.OperationInfo operationInfo = Containers.forEnable().add(installed2.updateUnit, installed2.getRelevantElement());
                assert (operationInfo != null);
            }
            if (Containers.forEnable().listAll().size() > 0) {
                UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
                uninstallUnitWizard.invokeWizard(true);
                Containers.forEnable().removeAll();
            }
            UnitTab.this.fireUpdataUnitChange();
            UnitTab.this.restoreSelectedRow(n);
            UnitTab.this.focusTable();
        }

        @Override
        protected boolean isVisible(Unit unit) {
            if (unit.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return this.isEnabled();
        }
    }

    private class ActivateAction
    extends TabAction {
        public ActivateAction() {
            super("UnitTab_ActivateAction", "EnableDisable");
        }

        @Override
        public void tableDataChanged(Collection<Unit> collection) {
            if (collection.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (Unit unit : collection) {
                if (!this.isEnabled(unit)) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            OperationContainer<OperationSupport> operationContainer = Containers.forEnable();
            for (Unit unit : UnitTab.this.model.getUnits()) {
                if (!unit.isMarked() || !this.isEnabled(unit)) continue;
                operationContainer.add(unit.updateUnit, unit.getRelevantElement());
            }
            UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
            boolean bl = false;
            try {
                bl = uninstallUnitWizard.invokeWizard(true);
            }
            finally {
                Containers.forEnable().removeAll();
                Containers.forDisable().removeAll();
                Containers.forUninstall().removeAll();
                if (bl) {
                    for (Unit unit : UnitTab.this.model.getMarkedUnits()) {
                        unit.setMarked(false);
                    }
                }
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        protected boolean isEnabled(Unit unit) {
            Unit.Installed installed;
            boolean bl = false;
            if (unit != null && unit instanceof Unit.Installed && !(installed = (Unit.Installed)unit).getRelevantElement().isEnabled()) {
                bl = Unit.Installed.isOperationAllowed(unit.updateUnit, unit.getRelevantElement(), Containers.forEnable());
            }
            return bl;
        }

        protected String getContextName(Unit unit) {
            return this.getActionName();
        }
    }

    private class CheckCategoryAction
    extends RowTabAction {
        protected CheckCategoryAction(String string, KeyStroke keyStroke, String string2) {
            super(string, keyStroke, string2);
        }

        public CheckCategoryAction() {
            super("UnitTab_CheckCategoryAction", "Check");
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            boolean bl = false;
            String string = unit.getCategoryName();
            List<Unit> list = UnitTab.this.model.getUnits();
            for (Unit unit2 : list) {
                if (unit2 == null || !string.equals(unit2.getCategoryName()) || unit2.isMarked() || !unit2.canBeMarked()) continue;
                bl = true;
                break;
            }
            return bl;
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName() + " \"" + unit.getCategoryName() + "\"";
        }

        @Override
        public void performerImpl(Unit unit) {
            String string = unit.getCategoryName();
            int n = UnitTab.this.model.getRowCount();
            int n2 = UnitTab.this.getSelectedRow();
            for (int i = 0; i < n; ++i) {
                unit = UnitTab.this.model.getUnitAtRow(i);
                if (unit == null || !string.equals(unit.getCategoryName()) || unit.isMarked() || !unit.canBeMarked()) continue;
                unit.setMarked(true);
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n2);
        }

        @Override
        protected boolean isVisible(Unit unit) {
            if (unit.getRelevantElement().getUpdateUnit().getType() == UpdateManager.TYPE.FEATURE) {
                return false;
            }
            return super.isVisible(unit);
        }
    }

    private class LocalUpdateAction
    extends TabAction {
        public LocalUpdateAction() {
            super("UnitTab_bTabAction_Name_LOCAL", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                bl = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.LOCAL_DOWNLOAD, UnitTab.this.manager);
            }
            finally {
                if (bl) {
                    UnitTab.this.reloadTask(false).schedule(10);
                } else {
                    UnitTab.this.fireUpdataUnitChange();
                    if (!bl) {
                        UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                    }
                    UnitTab.this.restoreSelectedRow(n);
                    UnitTab.this.refreshState();
                }
                UnitTab.this.focusTable();
            }
        }
    }

    private class AvailableAction
    extends TabAction {
        public AvailableAction() {
            super("UnitTab_bTabAction_Name_AVAILABLE", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                bl = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.INSTALL, UnitTab.this.manager);
            }
            finally {
                if (UnitTab.this.manager != null) {
                    UnitTab.this.fireUpdataUnitChange();
                }
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }
    }

    private class UpdateAction
    extends TabAction {
        public UpdateAction() {
            super("UnitTab_bTabAction_Name_UPDATE", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            try {
                bl = new InstallUnitWizard().invokeWizard(OperationWizardModel.OperationType.UPDATE, UnitTab.this.manager);
            }
            finally {
                if (UnitTab.this.manager != null && UnitTab.this.manager.isClosing()) {
                    return;
                }
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }
    }

    private class UninstallAction
    extends TabAction {
        public UninstallAction() {
            super("UnitTab_bTabAction_Name_INSTALLED", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performerImpl() {
            boolean bl = false;
            int n = UnitTab.this.getSelectedRow();
            Map<String, Boolean> map = UnitCategoryTableModel.captureState(UnitTab.this.model.getUnits());
            UninstallUnitWizard uninstallUnitWizard = new UninstallUnitWizard();
            try {
                bl = uninstallUnitWizard.invokeWizard();
            }
            finally {
                Containers.forUninstall().removeAll();
                Containers.forDisable().removeAll();
                Containers.forEnable().removeAll();
                UnitTab.this.fireUpdataUnitChange();
                if (!bl) {
                    UnitCategoryTableModel.restoreState(UnitTab.this.model.getUnits(), map, UnitTab.this.model.isMarkedAsDefault());
                }
                UnitTab.this.restoreSelectedRow(n);
                UnitTab.this.refreshState();
                UnitTab.this.focusTable();
            }
        }

        @Override
        public void tableDataChanged(Collection<Unit> collection) {
            if (collection.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            for (Unit unit : collection) {
                Unit.Installed installed;
                if (!(unit instanceof Unit.Installed) || !(installed = (Unit.Installed)unit).isUninstallAllowed()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }
    }

    private class CheckAction
    extends RowTabAction {
        public CheckAction() {
            super("UnitTab_CheckAction", KeyStroke.getKeyStroke(32, 0), null);
        }

        @Override
        public void performerImpl(Unit unit) {
            int n = UnitTab.this.getSelectedRow();
            if (UnitTab.this.model.isExpansionControlAtRow(n)) {
                if (UnitTab.this.moreAction != null && UnitTab.this.moreAction.isEnabled()) {
                    UnitTab.this.moreAction.performAction();
                } else if (UnitTab.this.lessAction != null && UnitTab.this.lessAction.isEnabled()) {
                    UnitTab.this.lessAction.performAction();
                }
            } else if (unit != null && unit.canBeMarked()) {
                unit.setMarked(!unit.isMarked());
            }
            UnitTab.this.model.fireTableDataChanged();
            UnitTab.this.restoreSelectedRow(n);
        }

        @Override
        protected boolean isEnabled(Unit unit) {
            return unit != null && unit.canBeMarked();
        }

        @Override
        protected boolean isEnabled(int n) {
            return UnitTab.this.model.isExpansionControlAtRow(n);
        }

        @Override
        protected String getContextName(Unit unit) {
            return this.getActionName();
        }

        @Override
        protected boolean isVisible(Unit unit) {
            return false;
        }

        @Override
        protected boolean isVisible(int n) {
            return false;
        }
    }

    private abstract class RowTabAction
    extends TabAction {
        private Unit u;
        private int row;

        public RowTabAction(String string, String string2) {
            super(string, string2);
        }

        public RowTabAction(String string, KeyStroke keyStroke, String string2) {
            super(string, keyStroke, string2);
        }

        public void unitChanged(int n, Unit unit) {
            this.u = unit;
            this.row = n;
            this.unitChanged();
        }

        public final boolean isVisible() {
            return this.u != null ? this.isVisible(this.u) : this.isVisible(this.row);
        }

        private void unitChanged() {
            if (this.u != null) {
                this.setEnabled(this.isEnabled(this.u));
                this.setContextName(this.getContextName(this.u));
            } else {
                this.setEnabled(this.isEnabled(this.row));
                this.setContextName(this.getContextName(this.row));
            }
        }

        @Override
        public void tableDataChanged() {
            this.unitChanged();
        }

        @Override
        public void tableDataChanged(Collection<Unit> collection) {
            this.unitChanged();
        }

        @Override
        public final void performerImpl() {
            this.performerImpl(this.u);
        }

        protected boolean isVisible(Unit unit) {
            return unit != null;
        }

        protected boolean isVisible(int n) {
            return false;
        }

        public abstract void performerImpl(Unit var1);

        protected abstract boolean isEnabled(Unit var1);

        protected boolean isEnabled(int n) {
            return false;
        }

        protected abstract String getContextName(Unit var1);

        protected String getContextName(int n) {
            return this.getActionName();
        }
    }

    private abstract class TabAction
    extends AbstractAction {
        private String name;
        private String actionCategory;

        public TabAction(String string, KeyStroke keyStroke, String string2) {
            super(UnitTab.textForKey(string));
            this.actionCategory = string2;
            if (keyStroke != null) {
                this.putValue("AcceleratorKey", keyStroke);
            }
            this.putValue("MnemonicKey", UnitTab.mnemonicForKey(string));
            this.name = (String)this.getValue("Name");
            this.putIntoActionMap(UnitTab.this.table);
        }

        public TabAction(String string, String string2) {
            this(string, null, string2);
        }

        protected String getActionName() {
            return this.name;
        }

        public String getActionCategory() {
            return this.getActionCategoryImpl();
        }

        protected String getActionCategoryImpl() {
            return this.actionCategory;
        }

        protected void setContextName(String string) {
            this.putValue("Name", string);
        }

        @Override
        public void setEnabled(boolean bl) {
            if (this.isEnabled() != bl) {
                if (bl) {
                    RequestProcessor.Task task = PluginManagerUI.getRunningTask(new Runnable(){

                        @Override
                        public void run() {
                            TabAction.this.setEnabled(true);
                        }
                    });
                    if (task != null && !task.isFinished()) {
                        task.addTaskListener(new TaskListener(){

                            public void taskFinished(Task task) {
                                TabAction.this.setEnabled(true);
                            }
                        });
                    } else {
                        super.setEnabled(true);
                    }
                } else {
                    super.setEnabled(false);
                }
            }
        }

        private void putIntoActionMap(JComponent jComponent) {
            KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
            Object object = this.getValue("Name");
            if (keyStroke == null) {
                keyStroke = KeyStroke.getKeyStroke((Integer)this.getValue("MnemonicKey"), 512);
            }
            if (keyStroke != null && object != null) {
                jComponent.getInputMap(0).put(keyStroke, object);
                jComponent.getActionMap().put(object, this);
            }
        }

        public final void performAction() {
            if (this.isEnabled()) {
                this.actionPerformed(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            this.performerImpl();
        }

        public void tableDataChanged() {
            this.tableDataChanged(UnitTab.this.model.getMarkedUnits());
        }

        public void tableDataChanged(Collection<Unit> collection) {
            this.setEnabled(collection.size() > 0);
        }

        public abstract void performerImpl();
    }

    class PopupActionSupport
    extends MouseAdapter
    implements Runnable {
        private final TabAction[] actions;
        public final Action popupOnF10 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnitTab.this.popupActionsSupport.run();
            }

            @Override
            public boolean isEnabled() {
                return UnitTab.this.table.isFocusOwner();
            }
        };

        PopupActionSupport(TabAction[] tabActionArray) {
            this.actions = tabActionArray;
        }

        void rowChanged(int n) {
            Unit unit = null;
            if (n > -1) {
                unit = UnitTab.this.model.getUnitAtRow(n);
            }
            for (TabAction tabAction : this.actions) {
                if (!(tabAction instanceof RowTabAction)) continue;
                RowTabAction rowTabAction = (RowTabAction)tabAction;
                rowTabAction.unitChanged(n, unit);
            }
        }

        void tableDataChanged() {
            Collection<Unit> collection = UnitTab.this.model.getMarkedUnits();
            for (TabAction tabAction : this.actions) {
                tabAction.tableDataChanged(collection);
            }
        }

        private JPopupMenu createPopup() {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.removeAll();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (TabAction tabActionArray : this.actions) {
                String string = tabActionArray.getActionCategory();
                if (!hashSet.add(string)) continue;
                arrayList.add(string);
            }
            for (String string : arrayList) {
                int n = jPopupMenu.getSubElements().length > 0 ? 1 : 0;
                for (TabAction tabAction : this.actions) {
                    String string2 = tabAction.getActionCategory();
                    if ((string == null || !string.equals(string2)) && (string != null || string2 != null)) continue;
                    if (tabAction instanceof RowTabAction) {
                        RowTabAction rowTabAction = (RowTabAction)tabAction;
                        if (!rowTabAction.isVisible()) continue;
                        if (n != 0) {
                            n = 0;
                            jPopupMenu.addSeparator();
                        }
                        jPopupMenu.add(new JMenuItem(tabAction));
                        continue;
                    }
                    if (n != 0) {
                        n = 0;
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(new JMenuItem(tabAction));
                }
            }
            return jPopupMenu;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (!this.maybeShowPopup(mouseEvent)) {
                int n = UnitTab.this.table.rowAtPoint(mouseEvent.getPoint());
                if (UnitTab.this.model.isExpansionControlAtRow(n)) {
                    UnitTab.this.moreAction.unitChanged(n, null);
                    UnitTab.this.lessAction.unitChanged(n, null);
                    if (UnitTab.this.moreAction.isEnabled()) {
                        UnitTab.this.moreAction.performAction();
                    } else if (UnitTab.this.lessAction.isEnabled()) {
                        UnitTab.this.lessAction.performAction();
                    }
                }
            }
        }

        private boolean maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                UnitTab.this.focusTable();
                UnitTab.this.showPopup(mouseEvent.getPoint(), mouseEvent.getComponent());
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            Point point = this.getPositionForPopup();
            if (point != null) {
                UnitTab.this.showPopup(point, UnitTab.this.table);
            }
        }

        private Point getPositionForPopup() {
            int n = UnitTab.this.table.getSelectedRow();
            int n2 = UnitTab.this.table.getSelectedColumn();
            if (n < 0 || n2 < 0) {
                return null;
            }
            Rectangle rectangle = UnitTab.this.table.getCellRect(n, n2, false);
            if (rectangle == null) {
                return null;
            }
            return SwingUtilities.convertPoint(UnitTab.this.table, rectangle.x, rectangle.y, UnitTab.this.table);
        }
    }
}

