/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.autoupdate.ui.Bundle;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class ProblemPanel
extends JPanel {
    private String problem;
    private JButton[] buttons = null;
    private boolean isWarning = false;
    private OperationException ex;
    JCheckBox cbShowAgain;
    JScrollPane jScrollPane1;
    JScrollPane jScrollPane2;
    JTextPane taTitle;
    JTextPane tpMessage;

    public ProblemPanel(OperationException operationException, boolean bl, JButton ... jButtonArray) {
        this(operationException, null, null, bl, jButtonArray);
    }

    public ProblemPanel(OperationException operationException, UpdateElement updateElement, boolean bl, JButton ... jButtonArray) {
        this(operationException, updateElement, null, bl, jButtonArray);
    }

    public ProblemPanel(String string, JButton ... jButtonArray) {
        this(null, null, string, true, jButtonArray);
    }

    private ProblemPanel(OperationException operationException, UpdateElement updateElement, String string, boolean bl, JButton ... jButtonArray) {
        this.ex = operationException;
        this.buttons = jButtonArray;
        this.isWarning = bl;
        if (operationException == null) {
            this.initProxyProblem(string);
        } else {
            switch (operationException.getErrorType()) {
                case PROXY: {
                    this.initProxyProblem(string);
                    break;
                }
                case WRITE_PERMISSION: {
                    this.initWriteProblem(updateElement, string);
                    break;
                }
                case INSTALL: {
                    this.initInstallProblem(operationException);
                    break;
                }
                default: {
                    assert (false) : "Unknown type " + operationException;
                    break;
                }
            }
        }
        for (JButton jButton : jButtonArray) {
            jButton.getAccessibleContext().setAccessibleDescription(jButton.getText());
        }
    }

    private void initProxyProblem(String string) {
        if (this.ex != null) {
            string = this.ex.getLocalizedMessage();
        }
        this.problem = string == null ? Bundle.proxy_taTitle_Text() : string;
        this.initComponents();
        this.cbShowAgain.setVisible(false);
        this.taTitle.setText(this.problem);
        this.taTitle.setToolTipText(this.problem);
        if (this.isWarning) {
            if (this.buttons.length == 2) {
                this.tpMessage.setText(Bundle.proxy_taMessage_WarningTextWithReload());
            } else {
                this.tpMessage.setText(Bundle.proxy_taMessage_WarningText());
            }
        } else {
            this.tpMessage.setText(Bundle.proxy_taMessage_ErrorText());
        }
    }

    private void initWriteProblem(UpdateElement updateElement, String string) {
        this.problem = string == null ? Bundle.write_taTitle_Text(updateElement.getDisplayName()) : string;
        this.initComponents();
        this.cbShowAgain.setVisible(false);
        this.taTitle.setText(this.problem);
        this.taTitle.setToolTipText(this.problem);
        this.tpMessage.setText(Bundle.write_taMessage_WarningText());
    }

    private void initInstallProblem(OperationException operationException) {
        this.problem = Bundle.install_taTitle_Text();
        this.initComponents();
        this.cbShowAgain.setVisible(false);
        this.taTitle.setText(this.problem);
        this.taTitle.setToolTipText(this.problem);
        this.tpMessage.setText(Bundle.install_taMessage_ErrorText(operationException.getLocalizedMessage()));
    }

    private void initComponents() {
        this.cbShowAgain = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.tpMessage = new JTextPane();
        this.jScrollPane2 = new JScrollPane();
        this.taTitle = new JTextPane();
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowAgain, (String)NbBundle.getMessage(ProblemPanel.class, (String)"ProblemPanel.cbShowAgain.text"));
        this.cbShowAgain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProblemPanel.this.cbShowAgainActionPerformed(actionEvent);
            }
        });
        this.tpMessage.setEditable(false);
        this.tpMessage.setContentType("text/html");
        this.tpMessage.setOpaque(false);
        this.tpMessage.setPreferredSize(new Dimension(400, 100));
        this.jScrollPane1.setViewportView(this.tpMessage);
        this.taTitle.setEditable(false);
        this.taTitle.setContentType("text/html");
        this.taTitle.setOpaque(false);
        this.taTitle.setPreferredSize(new Dimension(200, 100));
        this.jScrollPane2.setViewportView(this.taTitle);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowAgain, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 425, Short.MAX_VALUE).addComponent(this.jScrollPane2));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 106, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 169, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowAgain)));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProblemPanel.class, (String)"NetworkProblemPanel_ACD"));
    }

    private void cbShowAgainActionPerformed(ActionEvent actionEvent) {
        ProblemPanel.getPreferences().putBoolean(Utilities.PLUGIN_MANAGER_DONT_CARE_WRITE_PERMISSION, this.cbShowAgain.isSelected());
    }

    public Object showNetworkProblemDialog() {
        DialogDescriptor dialogDescriptor = this.getNetworkProblemDescriptor();
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        return dialogDescriptor.getValue();
    }

    public Object showWriteProblemDialog() {
        DialogDescriptor dialogDescriptor = this.getWriteProblemDescriptor();
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        return dialogDescriptor.getValue();
    }

    private DialogDescriptor getNetworkProblemDescriptor() {
        Object[] objectArray = this.buttons == null || this.buttons.length == 0 ? new Object[]{DialogDescriptor.OK_OPTION} : this.buttons;
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(ProblemPanel.class, (String)"CTL_ShowProxyOptions"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, this.isWarning ? NbBundle.getMessage(ProblemPanel.class, (String)"CTL_Warning") : NbBundle.getMessage(ProblemPanel.class, (String)"CTL_Error"), true, objectArray, null, 0, null, null);
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProblemPanel.class, (String)"ACSD_ShowProxyOptions"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsDisplayer.getDefault().open("General");
            }
        });
        dialogDescriptor.setMessageType(this.isWarning ? 2 : 0);
        if (this.isWarning) {
            dialogDescriptor.setAdditionalOptions(new Object[]{jButton});
        }
        dialogDescriptor.setClosingOptions(objectArray);
        return dialogDescriptor;
    }

    private DialogDescriptor getWriteProblemDescriptor() {
        Object[] objectArray = this.buttons == null || this.buttons.length == 0 ? new Object[]{DialogDescriptor.OK_OPTION} : this.buttons;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, this.isWarning ? NbBundle.getMessage(ProblemPanel.class, (String)"CTL_Warning") : Bundle.CTL_WriteError(), true, objectArray, null, 0, null, null);
        dialogDescriptor.setMessageType(this.isWarning ? 2 : 0);
        dialogDescriptor.setClosingOptions(null);
        return dialogDescriptor;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }
}

