/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.components;

import com.jrockit.mc.common.persistence.ISettingFetcher;
import com.jrockit.mc.common.persistence.LocalizedString;
import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.ComponentsPlugin;
import com.jrockit.mc.components.ui.components.ComponentTypeDescriptor;
import com.jrockit.mc.components.ui.components.ComponentTypeRegistry;
import java.util.Random;
import java.util.logging.Level;

public final class ComponentDescriptor {
    private static final String NAME = "name";
    private static final String TYPE_IDENTIFIER = "typeIdentifier";
    private static final String IDENTIFIER = "identifier";
    private static final String DESCRIPTION = "description";
    private static final String COMPONENTS_SETTINGS = "settings";
    private static final String GUID = "guid";
    private final Setting m_setting = new Setting("componentDescriptor");
    private static final Random s_randomNumberGenerator;

    static {
        PersistenceToolkit.registerFetcher(ComponentDescriptor.class, (ISettingFetcher)new ISettingFetcher<ComponentDescriptor>(){

            public Setting getSetting(ComponentDescriptor serviceDescriptor) {
                return serviceDescriptor.m_setting;
            }
        });
        s_randomNumberGenerator = new Random();
    }

    public ComponentDescriptor() {
        this.setGUID(this.createIdentifier());
    }

    String createIdentifier() {
        return String.valueOf(ComponentDescriptor.createRandom16BitHex()) + '-' + ComponentDescriptor.createRandom16BitHex();
    }

    private static String createRandom16BitHex() {
        return String.format("%04X", s_randomNumberGenerator.nextInt(65536)).toUpperCase();
    }

    public String getName() {
        return ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).getText();
    }

    public void setName(String name) {
        ((LocalizedString)this.m_setting.getChildObject(NAME, LocalizedString.class)).setText(name);
    }

    public String getIdentifier() {
        return (String)this.m_setting.getChildObject(IDENTIFIER, String.class);
    }

    void setGUID(String name) {
        this.m_setting.setChildObject(GUID, (Object)name);
    }

    public String getGUID() {
        return (String)this.m_setting.getChildObject(GUID, String.class);
    }

    public String getTypeIdentifier() {
        return (String)this.m_setting.getChildObject(TYPE_IDENTIFIER, String.class);
    }

    public void setTypeIdentifier(String typeIdentifier) {
        this.m_setting.setChildObject(TYPE_IDENTIFIER, (Object)typeIdentifier);
    }

    public Setting getSetting() {
        return this.m_setting;
    }

    public Setting getComponentSettings() {
        return this.m_setting.getChild(COMPONENTS_SETTINGS);
    }

    public String getDescription() {
        return ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).getText();
    }

    public void setDescription(String description) {
        ((LocalizedString)this.m_setting.getChildObject(DESCRIPTION, LocalizedString.class)).setText(description);
    }

    public Object createComponent() {
        ComponentTypeRegistry ctr = ComponentsPlugin.getDefault().getComponentTypeRegistry();
        ComponentTypeDescriptor std = ctr.getComponentTypeDescriptor(this.getTypeIdentifier());
        if (std == null) {
            ComponentsPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not find component type with id " + this.getTypeIdentifier());
            return null;
        }
        return ctr.createComponent(std);
    }

    public static ComponentDescriptor createNew(String componentTypeIdentifier) {
        ComponentTypeDescriptor ctd = ComponentsPlugin.getDefault().getComponentTypeRegistry().getComponentTypeDescriptor(componentTypeIdentifier);
        return ComponentDescriptor.createNew(ctd);
    }

    public static ComponentDescriptor createNew(ComponentTypeDescriptor std) {
        ComponentDescriptor descriptor = new ComponentDescriptor();
        descriptor.setTypeIdentifier(std.getId());
        descriptor.setName(std.getName());
        return descriptor;
    }
}

