/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLWriter;
import org.netbeans.lib.profiler.ui.UIUtils;

public class HTMLTextArea
extends JEditorPane
implements HyperlinkListener,
MouseListener {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.components.Bundle");
    private static final String CUT_STRING = messages.getString("HTMLTextArea_CutString");
    private static final String COPY_STRING = messages.getString("HTMLTextArea_CopyString");
    private static final String PASTE_STRING = messages.getString("HTMLTextArea_PasteString");
    private static final String DELETE_STRING = messages.getString("HTMLTextArea_DeleteString");
    private static final String SELECT_ALL_STRING = messages.getString("HTMLTextArea_SelectAllString");
    private ActionListener popupListener;
    private JMenuItem itemCopy;
    private JMenuItem itemCut;
    private JMenuItem itemDelete;
    private JMenuItem itemPaste;
    private JMenuItem itemSelectAll;
    private JPopupMenu popupMenu;
    private boolean showPopup = true;
    private String pendingText;
    private String currentText;
    private boolean forceSetText;

    public HTMLTextArea() {
        this.setEditorKit(new HTMLEditorKit());
        this.setEditable(false);
        this.setOpaque(true);
        this.setAutoscrolls(true);
        this.addHyperlinkListener(this);
        this.setTransferHandler(new HTMLTextAreaTransferHandler());
        this.setFont(UIManager.getFont("Label.font"));
        this.setBackground(UIUtils.getProfilerResultsBackground());
        this.addMouseListener(this);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && HTMLTextArea.this.isShowing() && HTMLTextArea.this.pendingText != null) {
                    HTMLTextArea.this.setText(HTMLTextArea.this.pendingText);
                }
            }
        });
    }

    public HTMLTextArea(String string) {
        this();
        this.setText(string);
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        if (color2 != null && color2.equals(color)) {
            return;
        }
        super.setForeground(color);
        this.forceSetText = true;
        this.setText(this.getText());
    }

    public void setShowPopup(boolean bl) {
        this.showPopup = bl;
    }

    public boolean getShowPopup() {
        return this.showPopup;
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            return;
        }
        if (!this.isShowing() && !this.forceSetText) {
            this.pendingText = string;
        } else {
            if (!this.forceSetText && string.equals(this.currentText)) {
                return;
            }
            this.currentText = string;
            this.pendingText = null;
            Font font = this.getFont();
            Color color = this.getForeground();
            string = string.replaceAll("\\n\\r|\\r\\n|\\n|\\r", "<br>");
            string = string.replace("<code>", "<code style=\"font-size: " + font.getSize() + "pt;\">");
            String string2 = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
            String string3 = "<html><body text=\"" + string2 + "\" style=\"font-size: " + font.getSize() + "pt; font-family: " + font.getName() + ";\">" + string + "</body></html>";
            this.setDocument(this.getEditorKit().createDefaultDocument());
            super.setText(string3);
        }
        this.forceSetText = false;
    }

    @Override
    public String getText() {
        return this.pendingText != null ? this.pendingText : this.currentText;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.pendingText != null) {
            this.forceSetText = true;
            this.setText(this.pendingText);
        }
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.pendingText != null) {
            this.forceSetText = true;
            this.setText(this.pendingText);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.pendingText != null) {
            this.forceSetText = true;
            this.setText(this.pendingText);
        }
        return super.getMaximumSize();
    }

    public void deleteSelection() {
        try {
            this.getDocument().remove(this.getSelectionStart(), this.getSelectionEnd() - this.getSelectionStart());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.showURL(hyperlinkEvent.getURL());
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ENTERED) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.EXITED) {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu;
        if (mouseEvent.getModifiers() == 4 && this.isEnabled() && this.isFocusable() && this.showPopup && (jPopupMenu = this.getPopupMenu()) != null) {
            this.updatePopupMenu();
            if (!this.hasFocus()) {
                this.requestFocus();
            }
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void paste() {
        try {
            this.replaceSelection(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor).toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.popupListener = this.createPopupListener();
        this.itemCut = new JMenuItem(CUT_STRING);
        this.itemCopy = new JMenuItem(COPY_STRING);
        this.itemPaste = new JMenuItem(PASTE_STRING);
        this.itemDelete = new JMenuItem(DELETE_STRING);
        this.itemSelectAll = new JMenuItem(SELECT_ALL_STRING);
        this.itemCut.addActionListener(this.popupListener);
        this.itemCopy.addActionListener(this.popupListener);
        this.itemPaste.addActionListener(this.popupListener);
        this.itemDelete.addActionListener(this.popupListener);
        this.itemSelectAll.addActionListener(this.popupListener);
        jPopupMenu.add(this.itemCut);
        jPopupMenu.add(this.itemCopy);
        jPopupMenu.add(this.itemPaste);
        jPopupMenu.add(this.itemDelete);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.itemSelectAll);
        return jPopupMenu;
    }

    protected void showURL(URL uRL) {
    }

    protected void updatePopupMenu() {
        this.itemCut.setEnabled(this.isEditable() && this.getSelectedText() != null);
        this.itemCopy.setEnabled(this.getSelectedText() != null);
        try {
            Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            this.itemPaste.setEnabled(this.isEditable() && transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor));
        }
        catch (Exception exception) {
            this.itemPaste.setEnabled(false);
        }
        if (this.isEditable()) {
            this.itemDelete.setVisible(true);
            this.itemDelete.setEnabled(this.getSelectedText() != null);
        } else {
            this.itemDelete.setVisible(false);
        }
    }

    private ActionListener createPopupListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == HTMLTextArea.this.itemCut) {
                    HTMLTextArea.this.cut();
                } else if (actionEvent.getSource() == HTMLTextArea.this.itemCopy) {
                    HTMLTextArea.this.copy();
                } else if (actionEvent.getSource() == HTMLTextArea.this.itemPaste) {
                    HTMLTextArea.this.paste();
                } else if (actionEvent.getSource() == HTMLTextArea.this.itemDelete) {
                    HTMLTextArea.this.deleteSelection();
                } else if (actionEvent.getSource() == HTMLTextArea.this.itemSelectAll) {
                    HTMLTextArea.this.selectAll();
                }
            }
        };
    }

    private static class NcrToUnicode {
        private static Map entities;

        private NcrToUnicode() {
        }

        public static String decode(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                n = string.indexOf(38, i);
                if (n == -1) {
                    stringBuilder.append(string.substring(i, string.length()));
                    break;
                }
                stringBuilder.append(string.substring(i, n));
                i = string.indexOf(59, n);
                if (i == -1) {
                    stringBuilder.append(string.substring(n, string.length()));
                    break;
                }
                String string2 = string.substring(n + 1, i);
                if (string2.charAt(0) == '#') {
                    if (string2.equals("#160")) {
                        stringBuilder.append((String)NcrToUnicode.getEntities().get("nbsp"));
                        continue;
                    }
                    string2 = string2.substring(1);
                    try {
                        int n2 = 10;
                        if (string2.trim().charAt(0) == 'x') {
                            n2 = 16;
                            string2 = string2.substring(1, string2.length());
                        }
                        stringBuilder.append((char)Integer.parseInt(string2, n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuilder.append('?');
                    }
                    continue;
                }
                string2 = (String)NcrToUnicode.getEntities().get(string2);
                if (string2 != null) {
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append('?');
            }
            return stringBuilder.toString();
        }

        private static synchronized Map getEntities() {
            if (entities == null) {
                entities = new Hashtable();
                entities.put("quot", "\"");
                entities.put("amp", "&");
                entities.put("lt", "<");
                entities.put("gt", ">");
                entities.put("nbsp", " ");
                entities.put("iexcl", "\u00a1");
                entities.put("cent", "\u00a2");
                entities.put("pound", "\u00a3");
                entities.put("curren", "\u00a4");
                entities.put("yen", "\u00a5");
                entities.put("brvbar", "\u00a6");
                entities.put("sect", "\u00a7");
                entities.put("uml", "\u00a8");
                entities.put("copy", "\u00a9");
                entities.put("ordf", "\u00aa");
                entities.put("laquo", "\u00ab");
                entities.put("not", "\u00ac");
                entities.put("shy", "\u00ad");
                entities.put("reg", "\u00ae");
                entities.put("macr", "\u00af");
                entities.put("deg", "\u00b0");
                entities.put("plusmn", "\u00b1");
                entities.put("sup2", "\u00b2");
                entities.put("sup3", "\u00b3");
                entities.put("acute", "\u00b4");
                entities.put("micro", "\u00b5");
                entities.put("para", "\u00b6");
                entities.put("middot", "\u00b7");
                entities.put("cedil", "\u00b8");
                entities.put("sup1", "\u00b9");
                entities.put("ordm", "\u00ba");
                entities.put("raquo", "\u00bb");
                entities.put("frac14", "\u00bc");
                entities.put("frac12", "\u00bd");
                entities.put("frac34", "\u00be");
                entities.put("iquest", "\u00bf");
                entities.put("Agrave", "\u00c0");
                entities.put("Aacute", "\u00c1");
                entities.put("Acirc", "\u00c2");
                entities.put("Atilde", "\u00c3");
                entities.put("Auml", "\u00c4");
                entities.put("Aring", "\u00c5");
                entities.put("AElig", "\u00c6");
                entities.put("Ccedil", "\u00c7");
                entities.put("Egrave", "\u00c8");
                entities.put("Eacute", "\u00c9");
                entities.put("Ecirc", "\u00ca");
                entities.put("Euml", "\u00cb");
                entities.put("Igrave", "\u00cc");
                entities.put("Iacute", "\u00cd");
                entities.put("Icirc", "\u00ce");
                entities.put("Iuml", "\u00cf");
                entities.put("ETH", "\u00d0");
                entities.put("Ntilde", "\u00d1");
                entities.put("Ograve", "\u00d2");
                entities.put("Oacute", "\u00d3");
                entities.put("Ocirc", "\u00d4");
                entities.put("Otilde", "\u00d5");
                entities.put("Ouml", "\u00d6");
                entities.put("times", "\u00d7");
                entities.put("Oslash", "\u00d8");
                entities.put("Ugrave", "\u00d9");
                entities.put("Uacute", "\u00da");
                entities.put("Ucirc", "\u00db");
                entities.put("Uuml", "\u00dc");
                entities.put("Yacute", "\u00dd");
                entities.put("THORN", "\u00de");
                entities.put("szlig", "\u00df");
                entities.put("agrave", "\u00e0");
                entities.put("aacute", "\u00e1");
                entities.put("acirc", "\u00e2");
                entities.put("atilde", "\u00e3");
                entities.put("auml", "\u00e4");
                entities.put("aring", "\u00e5");
                entities.put("aelig", "\u00e6");
                entities.put("ccedil", "\u00e7");
                entities.put("egrave", "\u00e8");
                entities.put("eacute", "\u00e9");
                entities.put("ecirc", "\u00ea");
                entities.put("euml", "\u00eb");
                entities.put("igrave", "\u00ec");
                entities.put("iacute", "\u00ed");
                entities.put("icirc", "\u00ee");
                entities.put("iuml", "\u00ef");
                entities.put("eth", "\u00f0");
                entities.put("ntilde", "\u00f1");
                entities.put("ograve", "\u00f2");
                entities.put("oacute", "\u00f3");
                entities.put("ocirc", "\u00f4");
                entities.put("otilde", "\u00f5");
                entities.put("ouml", "\u00f6");
                entities.put("divide", "\u00f7");
                entities.put("oslash", "\u00f8");
                entities.put("ugrave", "\u00f9");
                entities.put("uacute", "\u00fa");
                entities.put("ucirc", "\u00fb");
                entities.put("uuml", "\u00fc");
                entities.put("yacute", "\u00fd");
                entities.put("thorn", "\u00fe");
                entities.put("yuml", "\u00ff");
            }
            return entities;
        }
    }

    private class HTMLTextAreaTransferHandler
    extends TransferHandler {
        private HTMLTextAreaTransferHandler() {
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
            try {
                int n2 = HTMLTextArea.this.getSelectionStart();
                int n3 = HTMLTextArea.this.getSelectionEnd() - n2;
                StringWriter stringWriter = new StringWriter();
                try {
                    new ExtendedHTMLWriter((Writer)stringWriter, (HTMLDocument)HTMLTextArea.this.getDocument(), n2, n3).write();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String string = NcrToUnicode.decode(stringWriter.toString());
                clipboard.setContents(new StringSelection(string), null);
                if (n == 2) {
                    HTMLTextArea.this.getDocument().remove(n2, n3);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class ExtendedHTMLWriter
    extends HTMLWriter {
        public ExtendedHTMLWriter(Writer writer, HTMLDocument hTMLDocument, int n, int n2) {
            super(writer, hTMLDocument, n, n2);
            this.setLineLength(Integer.MAX_VALUE);
        }

        protected boolean isSupportedBreakFlowTag(AttributeSet attributeSet) {
            Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.HTML || tag == HTML.Tag.HEAD || tag == HTML.Tag.BODY || tag == HTML.Tag.HR) {
                    return false;
                }
                return tag.breaksFlow();
            }
            return false;
        }

        @Override
        protected void emptyTag(Element element) throws BadLocationException, IOException {
            if (this.isSupportedBreakFlowTag(element.getAttributes())) {
                this.writeLineSeparator();
            }
            if (this.matchNameAttribute(element.getAttributes(), HTML.Tag.CONTENT)) {
                this.text(element);
            }
        }

        @Override
        protected void endTag(Element element) throws IOException {
            if (this.isSupportedBreakFlowTag(element.getAttributes())) {
                this.writeLineSeparator();
            }
        }

        @Override
        protected void startTag(Element element) throws IOException, BadLocationException {
        }
    }
}

