/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sampler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.sampler.InternalSampler;
import org.netbeans.modules.sampler.SamplesOutputStream;

public abstract class Sampler {
    private static final int SAMPLER_RATE = 10;
    private static final double MAX_AVERAGE = 30.0;
    private static final double MAX_STDDEVIATION = 40.0;
    private static final int MAX_SAMPLING_TIME = 300;
    private static final int MIN_SAMPLES = 50;
    private static final int MAX_SAMPLES = 30000;
    private final String name;
    private Timer timer;
    private ByteArrayOutputStream out;
    private SamplesOutputStream samplesStream;
    private long startTime;
    private long nanoTimeCorrection;
    private long samples;
    private long laststamp;
    private double max;
    private double min = 9.223372036854776E18;
    private double sum;
    private double devSquaresSum;
    private volatile boolean stopped;
    private volatile boolean running;

    @CheckForNull
    public static Sampler createSampler(@NonNull String string) {
        return InternalSampler.createInternalSampler(string);
    }

    @CheckForNull
    public static Sampler createManualSampler(@NonNull String string) {
        if (SamplesOutputStream.isSupported()) {
            return new InternalSampler(string);
        }
        return null;
    }

    Sampler(String string) {
        this.name = string;
    }

    abstract ThreadMXBean getThreadMXBean();

    abstract void saveSnapshot(byte[] var1) throws IOException;

    abstract void printStackTrace(Throwable var1);

    abstract void openProgress(int var1);

    abstract void closeProgress();

    abstract void progress(int var1);

    private void updateStats(long l) {
        if (this.laststamp != 0L) {
            double d = (double)(l - this.laststamp) / 1000000.0;
            ++this.samples;
            this.sum += d;
            this.devSquaresSum += (d - 10.0) * (d - 10.0);
            if (d > this.max) {
                this.max = d;
            } else if (d < this.min) {
                this.min = d;
            }
        }
        this.laststamp = l;
    }

    public final synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("sampling is already running");
        }
        if (this.stopped) {
            throw new IllegalStateException("it is not possible to restart sampling");
        }
        this.running = true;
        final ThreadMXBean threadMXBean = this.getThreadMXBean();
        this.out = new ByteArrayOutputStream(65536);
        try {
            this.samplesStream = new SamplesOutputStream(this.out, this, 30000);
        }
        catch (IOException iOException) {
            this.printStackTrace(iOException);
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.nanoTimeCorrection = this.startTime * 1000000L - System.nanoTime();
        this.timer = new Timer("sampler-" + this.name);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Sampler sampler = Sampler.this;
                synchronized (sampler) {
                    if (Sampler.this.stopped) {
                        return;
                    }
                    try {
                        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(false, false);
                        long l = System.nanoTime() + Sampler.this.nanoTimeCorrection;
                        Sampler.this.samplesStream.writeSample(threadInfoArray, l, Thread.currentThread().getId());
                        Sampler.this.updateStats(l);
                    }
                    catch (Throwable throwable) {
                        Sampler.this.printStackTrace(throwable);
                    }
                }
            }
        }, 10L, 10L);
    }

    public final void cancel() {
        this.stopSampling(true, null);
    }

    public final void stopAndWriteTo(@NonNull DataOutputStream dataOutputStream) {
        this.stopSampling(false, dataOutputStream);
    }

    public final void stop() {
        this.stopSampling(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopSampling(boolean bl, DataOutputStream dataOutputStream) {
        try {
            boolean bl2;
            if (!this.running) {
                throw new IllegalStateException("sampling was not started");
            }
            if (this.stopped) {
                throw new IllegalStateException("sampling is not running");
            }
            this.stopped = true;
            this.timer.cancel();
            if (bl || this.samples < 1L) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException("sampling cannot be stopped from EDT");
            }
            double d = this.sum / (double)this.samples;
            double d2 = Math.sqrt(this.devSquaresSum / (double)this.samples);
            boolean bl3 = bl2 = dataOutputStream != null;
            if (bl2) {
                Object[] objectArray = new Object[]{this.startTime, "Samples", this.samples, "Average", d, "Minimum", this.min, "Maximum", this.max, "Std. deviation", d2};
                Logger.getLogger("org.netbeans.ui.performance").log(Level.CONFIG, "Snapshot statistics", objectArray);
                if (d > 30.0 || d2 > 40.0 || this.samples < 50L) {
                    return;
                }
            }
            this.samplesStream.close();
            this.samplesStream = null;
            if (bl2) {
                dataOutputStream.write(this.out.toByteArray());
                dataOutputStream.close();
                return;
            }
            this.saveSnapshot(this.out.toByteArray());
        }
        catch (IOException iOException) {
            this.printStackTrace(iOException);
        }
        finally {
            this.out = null;
            this.samplesStream = null;
        }
    }
}

