/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import org.netbeans.core.NbLifeExit;
import org.netbeans.core.startup.ModuleSystem;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public final class NbLifecycleManager
extends LifecycleManager {
    static final Logger LOG = Logger.getLogger(NbLifecycleManager.class.getName());
    private static CountDownLatch onExit;
    private volatile JDialog dialog;
    private volatile boolean isExitOnEventQueue;

    public void saveAll() {
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>();
        NotifyDescriptor.Message message = DataObject.getRegistry().getModified();
        if (((DataObject[])message).length == 0) {
            return;
        }
        for (DataObject dataObject : message) {
            try {
                SaveCookie saveCookie = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                if (saveCookie == null) continue;
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbLifecycleManager.class, (String)"CTL_FMT_SavingMessage", (Object)dataObject.getName()));
                saveCookie.save();
            }
            catch (IOException iOException) {
                Logger.getLogger(NbLifecycleManager.class.getName()).log(Level.WARNING, null, iOException);
                arrayList.add(dataObject);
            }
        }
        for (DataObject dataObject : arrayList) {
            NotifyDescriptor.Message message2 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(NbLifecycleManager.class, (String)"CTL_Cannot_save", (Object)dataObject.getPrimaryFile().getName()));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message2);
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(NbLifecycleManager.class, (String)"MSG_AllSaved"));
    }

    public void exit() {
        this.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean blockForExit(CountDownLatch[] countDownLatchArray) {
        Class<NbLifecycleManager> clazz = NbLifecycleManager.class;
        synchronized (NbLifecycleManager.class) {
            if (onExit != null) {
                countDownLatchArray[0] = onExit;
                LOG.log(Level.FINE, "blockForExit, already counting down {0}", onExit);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            countDownLatchArray[0] = onExit = new CountDownLatch(1){

                @Override
                public void countDown() {
                    super.countDown();
                    JDialog jDialog = NbLifecycleManager.this.dialog;
                    LOG.log(Level.FINE, "countDown for {0}, hiding {1}", new Object[]{this, jDialog});
                    if (jDialog != null) {
                        jDialog.setVisible(false);
                    }
                }
            };
            LOG.log(Level.FINE, "blockForExit, new {0}", onExit);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void finishExitState(CountDownLatch[] var1_1, boolean var2_2) {
        NbLifecycleManager.LOG.log(Level.FINE, "finishExitState {0} clean: {1}", new Object[]{Thread.currentThread(), var2_2});
        if (EventQueue.isDispatchThread()) {
            var3_3 = this.isExitOnEventQueue;
            if (!var3_3) {
                this.isExitOnEventQueue = true;
                try {
                    NbLifecycleManager.LOG.log(Level.FINE, "waiting in EDT: {0} own: {1}", new Object[]{NbLifecycleManager.onExit, var1_1[0]});
                    if (var1_1[0].await(5L, TimeUnit.SECONDS)) {
                        NbLifecycleManager.LOG.fine("wait is over, return");
                        return;
                    }
                }
                catch (InterruptedException var4_7) {
                    NbLifecycleManager.LOG.log(Level.FINE, null, var4_7);
                }
            }
            var4_8 = new JDialog((Frame)null, true);
            var4_8.setUndecorated(true);
            var4_8.setLocation(544300, 544300);
            var4_8.setSize(0, 0);
            try {
                this.dialog = var4_8;
                NbLifecycleManager.LOG.log(Level.FINE, "Showing dialog: {0}", var4_8);
                var4_8.setVisible(true);
            }
            finally {
                NbLifecycleManager.LOG.log(Level.FINE, "Disposing dialog: {0}", this.dialog);
                this.dialog = null;
                this.isExitOnEventQueue = var3_3;
            }
        }
        NbLifecycleManager.LOG.log(Level.FINE, "About to block on {0}", var1_1[0]);
        try {
            var1_1[0].await();
            ** if (!var2_2) goto lbl-1000
        }
        catch (InterruptedException var3_5) {
            try {
                NbLifecycleManager.LOG.log(Level.FINE, null, var3_5);
                ** if (!var2_2) goto lbl-1000
            }
            catch (Throwable var8_10) {
                if (var2_2 == false) throw var8_10;
                NbLifecycleManager.LOG.log(Level.FINE, "Cleaning {0} own {1}", new Object[]{NbLifecycleManager.onExit, var1_1[0]});
                var9_11 = NbLifecycleManager.class;
                // MONITORENTER : org.netbeans.core.NbLifecycleManager.class
                if (!NbLifecycleManager.$assertionsDisabled && var1_1[0] != NbLifecycleManager.onExit) {
                    throw new AssertionError();
                }
                NbLifecycleManager.onExit = null;
                // MONITOREXIT : var9_11
                throw var8_10;
            }
lbl-1000:
            // 1 sources

            {
                NbLifecycleManager.LOG.log(Level.FINE, "Cleaning {0} own {1}", new Object[]{NbLifecycleManager.onExit, var1_1[0]});
                var3_6 = NbLifecycleManager.class;
                // MONITORENTER : org.netbeans.core.NbLifecycleManager.class
                if (!NbLifecycleManager.$assertionsDisabled && var1_1[0] != NbLifecycleManager.onExit) {
                    throw new AssertionError();
                }
                NbLifecycleManager.onExit = null;
                // MONITOREXIT : var3_6
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            NbLifecycleManager.LOG.log(Level.FINE, "Cleaning {0} own {1}", new Object[]{NbLifecycleManager.onExit, var1_1[0]});
            var3_4 = NbLifecycleManager.class;
            // MONITORENTER : org.netbeans.core.NbLifecycleManager.class
            if (!NbLifecycleManager.$assertionsDisabled && var1_1[0] != NbLifecycleManager.onExit) {
                throw new AssertionError();
            }
            NbLifecycleManager.onExit = null;
            // MONITOREXIT : var3_4
        }
lbl-1000:
        // 2 sources

        {
        }
        NbLifecycleManager.LOG.fine("End of finishExitState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int n) {
        LOG.log(Level.FINE, "Initiating exit with status {0}", n);
        if (EventQueue.isDispatchThread()) {
            if (this.isExitOnEventQueue) {
                LOG.log(Level.FINE, "Already in process of exiting {0}, return", this.isExitOnEventQueue);
                return;
            }
            this.isExitOnEventQueue = true;
        }
        try {
            CountDownLatch[] countDownLatchArray = new CountDownLatch[]{null};
            if (this.blockForExit(countDownLatchArray)) {
                this.finishExitState(countDownLatchArray, false);
                return;
            }
            NbLifeExit nbLifeExit = new NbLifeExit(0, n, countDownLatchArray[0]);
            Mutex.EVENT.readAccess((Runnable)nbLifeExit);
            this.finishExitState(countDownLatchArray, true);
        }
        finally {
            if (EventQueue.isDispatchThread()) {
                this.isExitOnEventQueue = false;
            }
        }
    }

    public static boolean isExiting() {
        return onExit != null;
    }

    public void markForRestart() throws UnsupportedOperationException {
        ModuleSystem.markForRestart();
    }
}

