/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.Component;
import java.beans.PropertyEditorSupport;
import org.openide.explorer.propertysheet.editors.EnhancedPropertyEditor;
import org.openide.nodes.PropertyEditorRegistration;

@PropertyEditorRegistration(targetType={Character.class})
public class CharEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor {
    @Override
    public String getAsText() {
        char c = ((Character)this.getValue()).charValue();
        StringBuffer stringBuffer = new StringBuffer(6);
        switch (c) {
            case '\b': {
                stringBuffer.append("\\b");
                break;
            }
            case '\t': {
                stringBuffer.append("\\t");
                break;
            }
            case '\n': {
                stringBuffer.append("\\n");
                break;
            }
            case '\f': {
                stringBuffer.append("\\f");
                break;
            }
            case '\r': {
                stringBuffer.append("\\r");
                break;
            }
            case '\\': {
                stringBuffer.append("\\\\");
                break;
            }
            default: {
                if (c >= ' ' && c <= '\u007f') {
                    stringBuffer.append(c);
                    break;
                }
                stringBuffer.append("\\u");
                String string = Integer.toHexString(c);
                for (int i = 0; i < 4 - string.length(); ++i) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string.length() < 1) {
            return;
        }
        int n = 0;
        if (string.charAt(0) == '\\') {
            int n2 = string.length() >= 2 ? (int)string.charAt(1) : 92;
            switch (n2) {
                case 98: {
                    n = 8;
                    break;
                }
                case 116: {
                    n = 9;
                    break;
                }
                case 110: {
                    n = 10;
                    break;
                }
                case 102: {
                    n = 12;
                    break;
                }
                case 114: {
                    n = 13;
                    break;
                }
                case 92: {
                    n = 92;
                    break;
                }
                case 117: {
                    String string2 = string.substring(2, string.length());
                    if (string2.length() > 4) {
                        return;
                    }
                    try {
                        int n3 = Integer.parseInt(string2, 16);
                        n = (char)n3;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                }
                default: {
                    return;
                }
            }
        } else {
            n = string.charAt(0);
        }
        this.setValue(Character.valueOf((char)n));
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException {
        String string;
        if (object instanceof Character) {
            super.setValue(object);
            return;
        }
        if (object instanceof String && (string = (String)object).length() >= 1) {
            super.setValue(Character.valueOf(string.charAt(0)));
            return;
        }
        if (object == null) {
            super.setValue(Character.valueOf('\u0000'));
            return;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getJavaInitializationString() {
        if (((Character)this.getValue()).charValue() == '\'') {
            return "'\\''";
        }
        return "'" + this.getAsText() + "'";
    }

    public Component getInPlaceCustomEditor() {
        return null;
    }

    public boolean hasInPlaceCustomEditor() {
        return false;
    }

    public boolean supportsEditingTaggedValues() {
        return true;
    }
}

