/*
 * Decompiled with CFR 0.152.
 */
package weather.util;

import com.smartechz.tools.mygeoloc.Geobytes;
import de.mbenning.weather.wunderground.api.domain.DataSet;
import de.mbenning.weather.wunderground.api.domain.WeatherStation;
import de.mbenning.weather.wunderground.impl.services.HttpDataReaderService;
import de.mbenning.weather.wunderground.impl.services.WeatherStationService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

public class WeatherGrabber {
    private String city;
    private String country;
    private final HttpDataReaderService reader = new HttpDataReaderService();
    private DataSet dataset;
    private static final int TIMEOUT = 10000;

    public WeatherGrabber() {
        this.setLocalLocation();
    }

    public WeatherGrabber(String country, String city) {
        this.setLocation(country, city);
    }

    private void setLocalLocation() {
        try {
            this.country = Geobytes.get("Country");
            this.city = Geobytes.get("City");
        }
        catch (Exception e) {
            throw new RuntimeException("Can not detect current location, check your internet connection");
        }
        this.setLocation(this.country, this.city);
    }

    private void setLocation(String country, String city) {
        if (country.toLowerCase().equals("UK")) {
            country = "United Kingdom";
        }
        this.country = country;
        this.city = city;
        new Thread(new Runnable(){

            @Override
            public void run() {
                WeatherGrabber.this.fetchData();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchData() {
        this.reader.setWeatherStation(this.getWeatherStation(this.country, this.city));
        DataSet t = this.reader.getCurrentData();
        WeatherGrabber weatherGrabber = this;
        synchronized (weatherGrabber) {
            this.dataset = t;
            this.notify();
        }
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private WeatherStation getWeatherStation(String country, String city) {
        List stations = new WeatherStationService().findAllWeatherStationsByCountry(WeatherGrabber.encode(country));
        for (WeatherStation weatherStation : stations) {
            if (weatherStation.getCity() == null || !weatherStation.getCity().toLowerCase().contains(city.toLowerCase())) continue;
            return weatherStation;
        }
        throw new RuntimeException("Can not find weather information for " + city + ", " + country + ". Please check spelling or try another location");
    }

    public synchronized DataSet getDataset() {
        if (this.dataset == null) {
            try {
                this.wait(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.dataset == null) {
            throw new RuntimeException("Can not find weather information for " + this.city + ", " + this.country + ". Operation timed out.");
        }
        return this.dataset;
    }

    public String getCity() {
        return this.city;
    }

    public String getCountry() {
        return this.country;
    }
}

