/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.BaseFileObj;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FolderObj;
import org.netbeans.modules.masterfs.watcher.Watcher;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.Exceptions;

final class FileObjectKeeper
implements FileChangeListener {
    private static final Logger LOG = Logger.getLogger(FileObjectKeeper.class.getName());
    private static final Object TIME_STAMP_LOCK = new Object();
    private Set<FolderObj> kept;
    private Collection<FileChangeListener> listeners;
    private final FolderObj root;
    private long timeStamp;

    public FileObjectKeeper(FolderObj folderObj) {
        this.root = folderObj;
    }

    public synchronized void addRecursiveListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArraySet<FileChangeListener>();
        }
        LOG.log(Level.FINEST, "addRecursiveListener for {0} isEmpty: {1}", new Object[]{this.root, this.listeners.isEmpty()});
        if (this.listeners.isEmpty()) {
            Callable callable = null;
            boolean bl = fileChangeListener.getClass().getName().equals("org.openide.filesystems.DeepListener");
            if (fileChangeListener instanceof Callable && bl) {
                callable = (Callable)fileChangeListener;
            }
            FileFilter fileFilter = null;
            if (fileChangeListener instanceof FileFilter && bl) {
                fileFilter = (FileFilter)fileChangeListener;
            }
            this.listenToAll(callable, fileFilter);
        }
        this.listeners.add(fileChangeListener);
    }

    public synchronized void removeRecursiveListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(fileChangeListener);
        LOG.log(Level.FINEST, "removeRecursiveListener for {0} isEmpty: {1}", new Object[]{this.root, this.listeners.isEmpty()});
        if (this.listeners.isEmpty()) {
            this.listenNoMore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> init(long l, FileObjectFactory fileObjectFactory, boolean bl) {
        boolean bl2;
        Object object = TIME_STAMP_LOCK;
        synchronized (object) {
            boolean bl3 = bl2 = this.timeStamp < -1L;
            if (this.timeStamp > 0L) {
                this.timeStamp = -this.timeStamp;
            }
            if (this.timeStamp == 0L) {
                this.timeStamp = -2L;
            }
        }
        object = Watcher.wrap(this.root.getFileName().getFile(), this.root);
        LinkedList<File> linkedList = new LinkedList<File>();
        long l2 = this.root.getProvidedExtensions().refreshRecursively((File)object, l, linkedList);
        try {
            for (File file : linkedList) {
                if (file.isDirectory()) continue;
                long l3 = file.lastModified();
                LOG.log(Level.FINE, "  check {0} for {1}", new Object[]{l3, file});
                if (l3 > l2) {
                    l2 = l3;
                }
                if (l3 <= l || fileObjectFactory == null || bl2) continue;
                BaseFileObj baseFileObj = fileObjectFactory.getCachedOnly(file);
                if (baseFileObj == null) {
                    BaseFileObj baseFileObj2 = fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.GetChildern);
                    if (baseFileObj2 != null) {
                        LOG.log(Level.FINE, "External change detected {0}", (Object)baseFileObj2);
                        if (baseFileObj2.isData()) {
                            baseFileObj2.fireFileDataCreatedEvent(bl);
                            continue;
                        }
                        baseFileObj2.fireFileFolderCreatedEvent(bl);
                        continue;
                    }
                    LOG.log(Level.FINE, "Cannot get valid FileObject. File probably removed: {0}", file);
                    continue;
                }
                LOG.log(Level.FINE, "Do classical refresh for {0}", (Object)baseFileObj);
                baseFileObj.refresh(bl, true);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            Exceptions.attachMessage((Throwable)stackOverflowError, (String)("FileObjectKeeper.init for " + (Object)((Object)this.root) + " timeStamp: " + this.timeStamp + " recursive: " + bl2));
            throw stackOverflowError;
        }
        Object object2 = TIME_STAMP_LOCK;
        synchronized (object2) {
            if (!bl2) {
                this.timeStamp = l2;
            }
        }
        LOG.log(Level.FINE, "Testing {0}, time {1}", new Object[]{object, this.timeStamp});
        return linkedList;
    }

    private void listenTo(FileObject fileObject, boolean bl, Collection<? super File> collection) {
        if (bl) {
            fileObject.addFileChangeListener((FileChangeListener)this);
            if (fileObject instanceof FolderObj) {
                FolderObj folderObj = (FolderObj)fileObject;
                folderObj.getKeeper(collection);
                folderObj.getChildren();
                assert (Thread.holdsLock(this));
                Set<FolderObj> set = this.kept;
                if (set != null) {
                    set.add(folderObj);
                }
            }
            LOG.log(Level.FINER, "Listening to {0}", fileObject);
        } else {
            fileObject.removeFileChangeListener((FileChangeListener)this);
            LOG.log(Level.FINER, "Ignoring {0}", fileObject);
        }
    }

    private void listenToAll(Callable<?> callable, FileFilter fileFilter) {
        assert (Thread.holdsLock(this));
        assert (this.kept == null) : "Already listening to " + this.kept + " now requested for " + (Object)((Object)this.root);
        this.kept = new HashSet<FolderObj>();
        LinkedList linkedList = new LinkedList();
        this.listenTo(this.root, true, linkedList);
        FileObjectFactory fileObjectFactory = null;
        while (true) {
            File file = (File)linkedList.poll();
            LOG.log(Level.FINEST, "listenToAll, processing {0}", file);
            if (file == null || FileObjectKeeper.isCyclicSymlink(file)) break;
            if (fileObjectFactory == null) {
                fileObjectFactory = FileObjectFactory.getInstance(file);
            }
            BaseFileObj baseFileObj = fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.Others);
            LOG.log(Level.FINEST, "listenToAll, check {0} for stop {1}", new Object[]{baseFileObj, callable});
            if (!(baseFileObj instanceof FolderObj)) continue;
            FolderObj folderObj = (FolderObj)baseFileObj;
            if (fileFilter != null && !fileFilter.accept(folderObj.getFileName().getFile())) continue;
            Boolean bl = null;
            if (callable != null) {
                try {
                    bl = (Boolean)callable.call();
                }
                catch (Exception exception) {
                    bl = Boolean.TRUE;
                }
            }
            if (Boolean.TRUE.equals(bl)) {
                LOG.log(Level.INFO, "addRecursiveListener to {0} interrupted", (Object)this.root);
                return;
            }
            this.listenTo(folderObj, true, linkedList);
        }
    }

    private void listenNoMore() {
        assert (Thread.holdsLock(this));
        this.listenTo(this.root, false, null);
        Set<FolderObj> set = this.kept;
        if (set != null) {
            for (FolderObj folderObj : set) {
                this.listenTo(folderObj, false, null);
            }
            this.kept = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileFolderCreated(FileEvent fileEvent) {
        Object object;
        Collection<FileChangeListener> collection = this.listeners;
        FileObject fileObject = fileEvent.getFile();
        if (fileObject instanceof FolderObj) {
            object = (FolderObj)fileObject;
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                File file;
                FileChangeListener fileChangeListener = new LinkedList();
                this.listenTo((FileObject)object, true, (Collection<? super File>)fileChangeListener);
                FileObjectFactory fileObjectFactory = null;
                while ((file = (File)fileChangeListener.poll()) != null) {
                    BaseFileObj baseFileObj;
                    if (fileObjectFactory == null) {
                        fileObjectFactory = FileObjectFactory.getInstance(file);
                    }
                    if (!((baseFileObj = fileObjectFactory.getValidFileObject(file, FileObjectFactory.Caller.Others)) instanceof FolderObj)) continue;
                    this.listenTo((FolderObj)baseFileObj, true, (Collection<? super File>)fileChangeListener);
                }
            }
        }
        object = this;
        synchronized (object) {
            assert (Thread.holdsLock(this));
            if (collection == null || this.kept == null) {
                return;
            }
            for (FileChangeListener fileChangeListener : collection) {
                fileChangeListener.fileFolderCreated(fileEvent);
            }
        }
    }

    public void fileDataCreated(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileDataCreated(fileEvent);
        }
    }

    public void fileChanged(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileChanged(fileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileDeleted(FileEvent fileEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        FileObject fileObject = fileEvent.getFile();
        if (fileObject.isFolder() && fileEvent.getSource() == fileObject && fileObject != this.root) {
            return;
        }
        if (fileObject instanceof FolderObj) {
            FolderObj folderObj = (FolderObj)fileObject;
            FileObjectKeeper fileObjectKeeper = this;
            synchronized (fileObjectKeeper) {
                assert (Thread.holdsLock(this));
                if (this.kept != null) {
                    this.kept.remove((Object)folderObj);
                }
                this.listenTo(folderObj, false, null);
            }
        }
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileDeleted(fileEvent);
        }
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        FileObject fileObject = fileRenameEvent.getFile();
        if (fileObject.isFolder() && fileRenameEvent.getSource() == fileObject && fileObject != this.root) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileRenamed(fileRenameEvent);
        }
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        Collection<FileChangeListener> collection = this.listeners;
        if (collection == null) {
            return;
        }
        for (FileChangeListener fileChangeListener : collection) {
            fileChangeListener.fileAttributeChanged(fileAttributeEvent);
        }
    }

    long childrenLastModified() {
        return this.timeStamp == -2L ? 0L : Math.abs(this.timeStamp);
    }

    synchronized boolean isOn() {
        assert (Thread.holdsLock(this));
        if (this.kept != null) {
            return true;
        }
        FolderObj folderObj = this.root.getExistingParent();
        return folderObj != null && folderObj.hasRecursiveListener();
    }

    private static boolean isCyclicSymlink(File file) {
        File file2 = file.getParentFile();
        while (file2 != null) {
            if (file2.getName().equals(file.getName())) {
                try {
                    if (file.getCanonicalFile().equals(file2.getCanonicalFile())) {
                        return true;
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, "Can't convert to cannonical files {0} and {1}", new Object[]{file, file2});
                    LOG.log(Level.FINE, null, iOException);
                }
            }
            file2 = file2.getParentFile();
        }
        return false;
    }
}

