/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.sections;

import com.jrockit.mc.ui.misc.MCBook;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;

public class PageBookBlock {
    private static final String SECTION_IDENTIFIER_KEY = "SectionIdentifierKey";
    private final MCBook m_pageBook;
    private final IManagedForm m_form;

    public PageBookBlock(IManagedForm form, Composite parent) {
        this.m_pageBook = new MCBook(parent, 0);
        this.m_form = form;
    }

    public void showPart(String sectionIdentifier) {
        this.m_pageBook.showPageWithData(sectionIdentifier, SECTION_IDENTIFIER_KEY);
    }

    public Composite getControl() {
        return this.m_pageBook;
    }

    public void addPart(SectionPart part, String sectionIdentifier) {
        part.getSection().setData(SECTION_IDENTIFIER_KEY, (Object)sectionIdentifier);
        this.m_form.addPart((IFormPart)part);
        if (this.m_pageBook.getChildren().length == 1) {
            this.showPart(sectionIdentifier);
        }
    }

    public void removePart(SectionPart part) {
        this.m_form.removePart((IFormPart)part);
        this.m_pageBook.hidePage((Control)part.getSection());
    }

    public Action createSwitchAction(String sectionIdentifier, String actionName, String toolTipText, ImageDescriptor image) {
        return new SwitchSectionPartAction(sectionIdentifier, actionName, toolTipText, image);
    }

    private class SwitchSectionPartAction
    extends Action {
        private final String m_sectionIdentifier;

        public SwitchSectionPartAction(String sectionIdentifier, String text, String toolTipText, ImageDescriptor image) {
            super(text, 1);
            this.m_sectionIdentifier = sectionIdentifier;
            this.setImageDescriptor(image);
            this.setToolTipText(toolTipText);
            this.setId("switch.section");
        }

        public void run() {
            PageBookBlock.this.showPart(this.m_sectionIdentifier);
        }
    }
}

