/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.internal.FormatToolkit;
import com.jrockit.mc.ui.model.fields.MemoizedField;
import com.jrockit.mc.ui.model.fields.Messages;
import org.eclipse.osgi.util.NLS;

public class MethodField
extends MemoizedField {
    public static final String PROPERTY_RETURN_VALUE_VISIBLE = "return_value_visible";
    public static final String PROPERTY_RETURN_VALUE_PACKAGE_VISIBLE = "return_value_package_visible";
    public static final String PROPERTY_ARGUMENT_VISIBLE = "parameter_visible";
    public static final String PROPERTY_ARGUMENT_PACKAGE_VISIBLE = "parameter_package_visible";
    public static final String PROPERTY_CLASS_VISIBLE = "class_visible";
    public static final String PROPERTY_CLASS_PACKAGE_VISIBLE = "class_package_visible";
    public static final boolean DEFAULT_RETURN_VALUE_VISIBLE = false;
    public static final boolean DEFAULT_RETURN_VALUE_PACKAGE_VISIBLE = false;
    public static final boolean DEFAULT_ARGUMENT_VISIBLE = true;
    public static final boolean DEFAULT_ARGUMENT_PACKAGE_VISIBLE = false;
    public static final boolean DEFAULT_CLASS_VISIBLE = true;
    public static final boolean DEFAULT_CLASS_PACKAGE_VISIBLE = true;

    public MethodField(int id) {
        super(id);
        this.setReturnValueVisible(false);
        this.setReturnValuePackageVisible(false);
        this.setArgumentVisible(true);
        this.setArgumentPackageVisible(false);
        this.setClassVisible(true);
        this.setClassPackageVisible(true);
    }

    @Override
    public String formatForClipboard(Object object) {
        return this.formatObject(object);
    }

    public final void setReturnValueVisible(boolean visible) {
        this.setBoolean(PROPERTY_RETURN_VALUE_VISIBLE, visible);
    }

    public final void setReturnValuePackageVisible(boolean visible) {
        this.setBoolean(PROPERTY_RETURN_VALUE_PACKAGE_VISIBLE, visible);
    }

    public final void setArgumentVisible(boolean visible) {
        this.setBoolean(PROPERTY_ARGUMENT_VISIBLE, visible);
    }

    public final void setArgumentPackageVisible(boolean visible) {
        this.setBoolean(PROPERTY_ARGUMENT_PACKAGE_VISIBLE, visible);
    }

    public final void setClassVisible(boolean visible) {
        this.setBoolean(PROPERTY_CLASS_VISIBLE, visible);
    }

    public final void setClassPackageVisible(boolean visible) {
        this.setBoolean(PROPERTY_CLASS_PACKAGE_VISIBLE, visible);
    }

    public final boolean isReturnValueVisible() {
        return this.getBoolean(PROPERTY_RETURN_VALUE_VISIBLE, false);
    }

    public final boolean isReturnValuePackageVisible() {
        return this.getBoolean(PROPERTY_RETURN_VALUE_PACKAGE_VISIBLE, false);
    }

    public final boolean isArgumentVisible() {
        return this.getBoolean(PROPERTY_ARGUMENT_VISIBLE, true);
    }

    public boolean isArgumentPackageVisible() {
        return this.getBoolean(PROPERTY_ARGUMENT_PACKAGE_VISIBLE, false);
    }

    public final boolean isClassVisible() {
        return this.getBoolean(PROPERTY_CLASS_VISIBLE, true);
    }

    public boolean isClassPackageVisible() {
        return this.getBoolean(PROPERTY_CLASS_PACKAGE_VISIBLE, true);
    }

    @Override
    public int compare(Object a, Object b, boolean order) {
        if (a instanceof IMCMethod && b instanceof IMCMethod) {
            return super.compare(this.formatObject(a), this.formatObject(b), order);
        }
        return super.compare(a, b, order);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.flushCache();
        super.setBoolean(key, value);
    }

    @Override
    public String formatMemoized(Object object) {
        if (object instanceof IMCMethod) {
            IMCMethod method = (IMCMethod)object;
            String result = method.getHumanReadable(this.isReturnValueVisible(), this.isReturnValuePackageVisible(), this.isClassVisible(), this.isClassPackageVisible(), this.isArgumentVisible(), this.isArgumentPackageVisible());
            if (result == null) {
                String methodName = method.getMethodName();
                if (methodName != null) {
                    String className = method.getClassName();
                    String packageName = method.getPackageName();
                    if (packageName != null && className != null) {
                        return String.valueOf(packageName) + "." + className + "." + methodName;
                    }
                }
                return methodName;
            }
            return result;
        }
        if (object instanceof IMCFrame) {
            return this.formatMemoized(((IMCFrame)object).getMethod());
        }
        return null;
    }

    @Override
    public String getTooltip(Object object) {
        if (object instanceof IMCMethod) {
            IMCMethod method = (IMCMethod)object;
            String result = method.getHumanReadable(true, true, true, true, true, true);
            if (result == null) {
                result = FormatToolkit.getHumanReadable((IMCMethod)method, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            if (Boolean.TRUE.equals(method.getIsNative())) {
                return NLS.bind((String)Messages.MethodField_TOOLTIP_NATIVE_MSG, (Object)result);
            }
            String file = method.getFileName();
            if (file != null) {
                Integer line = method.getLineNumber();
                if (line != null) {
                    return NLS.bind((String)Messages.MethodField_TOOLTIP_FILE_WITH_LINE_MSG, (Object[])new Object[]{result, file, line});
                }
                return NLS.bind((String)Messages.MethodField_TOOLTIP_FILE_NO_LINE_MSG, (Object)result, (Object)file);
            }
            return result;
        }
        if (object instanceof IMCFrame) {
            return this.getTooltip(((IMCFrame)object).getMethod());
        }
        return null;
    }
}

