/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.model.fields;

import com.jrockit.mc.common.parsing.Token;
import com.jrockit.mc.common.parsing.Tokenizer;
import com.jrockit.mc.ui.model.fields.NumberField;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;

public class IdentifierField
extends NumberField {
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    static {
        NUMBER_FORMAT.setMaximumFractionDigits(0);
        NUMBER_FORMAT.setMinimumFractionDigits(0);
        NUMBER_FORMAT.setGroupingUsed(false);
    }

    public IdentifierField(int id) {
        super(id);
    }

    @Override
    public String formatObject(Object object) {
        if (object instanceof Number) {
            return IdentifierField.formatNumber((Number)object);
        }
        return super.formatObject(object);
    }

    @Override
    public String formatForClipboard(Object object) {
        if (object instanceof Number) {
            return IdentifierField.removeNonBreakingSpace(IdentifierField.formatNumber((Number)object));
        }
        return super.formatObject(object);
    }

    public static String formatNumber(Number number) {
        if (IdentifierField.isValid(number)) {
            return NUMBER_FORMAT.format(number);
        }
        return IdentifierField.defaultFormat(null);
    }

    @Override
    public Object parse(Tokenizer tokenizer) throws ParseException {
        Token token = tokenizer.peek();
        if (token != null) {
            ParsePosition p = new ParsePosition(token.start);
            Number n = NUMBER_FORMAT.parse(IdentifierField.replaceWithBreakingSpace(tokenizer.getText()), p);
            if (p.getIndex() != token.start) {
                tokenizer.setCharacterPosition(p.getIndex());
                return n.longValue();
            }
            throw new ParseException("Numeric value " + token.text + " could not be read.", token.start);
        }
        return null;
    }
}

