/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.idesupport;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.idesupport.IDESupportToolkit;
import com.jrockit.mc.ui.UIPlugin;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class BasicFile
implements MCFile {
    private final IPath path;

    public BasicFile(IPath path) {
        this.path = path;
    }

    public boolean exists() {
        return this.toFile().exists();
    }

    public IPath create(IProgressMonitor pm) throws IOException {
        File f = this.toFile();
        if (!f.exists()) {
            if (!f.mkdirs()) {
                throw new IOException(String.format("Could not create the directory for %s", f.toString()));
            }
            if (!f.createNewFile()) {
                UIPlugin.getDefault().getLogger().log(Level.WARNING, String.format("Reusing file %s", f.toString()));
            }
        }
        return this.path;
    }

    public IPath writeStreamToUnique(InputStream stream, IProgressMonitor pm) throws IOException {
        IPath actual = this.getUniquePath();
        BasicFile.transfer(actual, stream, pm);
        return actual;
    }

    public IPath getUniquePath() throws IOException {
        File file = this.path.toFile();
        if (file.exists()) {
            IPath noExtension = this.path.removeFileExtension();
            File parent = file.getParentFile();
            String prefix = noExtension.lastSegment();
            assert (prefix != null);
            if (prefix.length() < 3) {
                prefix = "new_" + prefix;
            }
            file = parent != null ? BasicFile.createTempFileWithTimestamp(prefix, BasicFile.getSafeFileExtensionWithDot(this.path.getFileExtension()), parent) : BasicFile.createTempFileWithTimestamp(prefix, BasicFile.getSafeFileExtensionWithDot(this.path.getFileExtension()));
        }
        Path actual = new Path(file.getAbsolutePath());
        return actual;
    }

    public static void transfer(IPath filePath, InputStream in, IProgressMonitor monitor) throws IOException {
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(filePath.toFile());
            byte[] buf = new byte[0x100000];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
                monitor.worked(len);
            }
        }
        finally {
            IOToolkit.closeSilently((Closeable)in);
            IOToolkit.closeSilently((Closeable)out);
        }
    }

    public void appendStream(InputStream stream, IProgressMonitor pm) throws IOException {
        File f = this.toFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(f, true));
        try {
            out.write(IDESupportToolkit.createString((InputStream)stream));
        }
        finally {
            IOToolkit.closeSilently((Closeable)out);
        }
    }

    public File toFile() {
        File f = this.getPath().toFile();
        if (!f.isAbsolute()) {
            f = BasicFile.makeAbsolute(f);
        }
        return f;
    }

    public IPath getPath() {
        return this.path;
    }

    public File toUniqueFile() throws IOException {
        File f = this.getUniquePath().toFile();
        if (!f.isAbsolute()) {
            f = BasicFile.makeAbsolute(f);
        }
        return f;
    }

    public String getFileExtension() {
        return this.getPath().getFileExtension();
    }

    public String toString() {
        return this.path.toOSString();
    }

    public boolean delete(IProgressMonitor pn) throws IOException {
        return this.toFile().delete();
    }

    public void writeStream(InputStream stream, IProgressMonitor monitor) throws IOException {
        File file = this.toFile();
        if (file.exists() && !file.delete()) {
            UIPlugin.getDefault().getLogger().severe(String.format("Could not overwrite target file %s", file.toString()));
        }
        Path actual = new Path(file.getAbsolutePath());
        BasicFile.transfer((IPath)actual, stream, monitor);
    }

    public static File createTempFileWithTimestamp(String prefix, String suffix, File parent) throws IOException {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd_HH_mm_ss");
        String fileName = String.valueOf(prefix) + sf.format(System.currentTimeMillis()) + suffix;
        File file = new File(parent, fileName);
        if (!file.exists()) {
            return file;
        }
        return File.createTempFile(prefix, suffix);
    }

    private static File createTempDirectory() throws IOException {
        File file = File.createTempFile("dummy", "dummy").getParentFile();
        if (!file.delete()) {
            throw new IOException("Can not delete files in the temporary directory!");
        }
        return file;
    }

    private static File makeAbsolute(File f) {
        Location instanceLoc = Platform.getInstanceLocation();
        String file = instanceLoc.getURL().getFile();
        return new File(String.valueOf(file) + f.getPath() + File.separatorChar);
    }

    private static File createTempFileWithTimestamp(String prefix, String suffix) throws IOException {
        return BasicFile.createTempFileWithTimestamp(prefix, suffix, BasicFile.createTempDirectory());
    }

    public static String getSafeFileExtensionWithDot(String fileExtension) {
        if (fileExtension == null) {
            return "";
        }
        return "." + fileExtension;
    }

    public InputStream readStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.toFile()));
    }
}

