/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FieldBaseRenderer;
import com.jrockit.mc.ui.model.fields.CaptionField;
import com.jrockit.mc.ui.model.fields.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FieldRenderer
extends FieldBaseRenderer
implements DisposeListener {
    private final FormToolkit m_toolkit;
    private final Composite m_container;
    private final Map<Field, Text> m_textFieldMap = new HashMap<Field, Text>();
    private final ScrolledForm m_client;
    private final Menu m_menu;
    private final Font m_bold;
    private final Field PADDING = new CaptionField(0);

    public FieldRenderer(Composite parent, FormToolkit formToolkit, Menu menu) {
        this.PADDING.setName("");
        this.m_menu = menu;
        this.m_toolkit = formToolkit;
        this.m_client = this.m_toolkit.createScrolledForm(parent);
        this.m_container = this.m_client.getForm().getBody();
        this.m_bold = UIPlugin.getDefault().getFontColorToolkit().getStandardBoldFont();
        this.m_container.addDisposeListener((DisposeListener)this);
        this.m_toolkit.paintBordersFor(this.m_container);
    }

    public void render(Field[] fields) {
        this.m_textFieldMap.clear();
        int columnCount = FieldRenderer.getColumnCount(fields);
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = columnCount;
        this.m_container.setLayout((Layout)layout);
        this.renderFields(fields);
        this.m_toolkit.paintBordersFor(this.m_container);
    }

    public void updateFields(Object[] data, Object input) {
        this.m_container.setRedraw(false);
        if (data != null) {
            for (Field element : this.m_textFieldMap.keySet()) {
                Field field = element;
                Text textWidget = this.m_textFieldMap.get(field);
                if (textWidget == null) continue;
                field.setInput(input);
                Object object = data[field.INDEX];
                String formattedText = object == null ? Field.defaultFormat(null) : field.formatObject(object);
                this.setToolTip(field, textWidget, object);
                textWidget.setText(formattedText);
            }
        }
        this.m_container.layout(true, true);
        this.m_container.setRedraw(true);
        this.m_client.reflow(false);
    }

    public void dispose() {
        this.m_textFieldMap.clear();
    }

    public Composite getClient() {
        return this.m_client;
    }

    private void setToolTip(Field field, Text textWdiget, Object object) {
        String toolTip = field.getTooltip(object);
        if (toolTip == null) {
            textWdiget.setToolTipText(field.getDescription());
        } else {
            textWdiget.setToolTipText(String.valueOf(field.getDescription()) + ' ' + toolTip);
        }
    }

    @Override
    protected void renderLabel(Field field) {
        this.renderLabelWithStyle(field, false);
    }

    private void renderLabelWithStyle(Field field, boolean bold) {
        Label label = this.m_toolkit.createLabel(this.m_container, field.getName(), 0);
        label.setData("name", (Object)(String.valueOf(field.IDENTIFIER) + ".label"));
        if (bold && this.m_bold != null) {
            label.setFont(this.m_bold);
        }
        TableWrapData tableWrapData = new TableWrapData(128, 32);
        label.setLayoutData((Object)tableWrapData);
        if (this.m_menu != null) {
            label.setMenu(this.m_menu);
        }
    }

    @Override
    protected void renderText(Field field) {
        int style = 10;
        if (field.useLineWrap()) {
            style |= 0x40;
        }
        Text text = this.m_toolkit.createText(this.m_container, "", style);
        text.setData("name", (Object)(String.valueOf(field.IDENTIFIER) + ".text"));
        text.setToolTipText(field.getDescription());
        text.setLayoutData((Object)new TableWrapData(256, 256));
        text.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.hookClearSelectionListener(text);
        this.m_textFieldMap.put(field, text);
    }

    private void hookClearSelectionListener(final Text text) {
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                text.clearSelection();
            }
        });
    }

    @Override
    protected void renderCaption(Field field) {
        this.renderLabelWithStyle(field, true);
    }

    public void widgetDisposed(DisposeEvent e) {
        this.dispose();
    }

    @Override
    protected void endRow(int padCount) {
        int n = 0;
        while (n < padCount) {
            this.renderLabel(this.PADDING);
            ++n;
        }
    }
}

