/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.misc.IRefreshable;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.widgets.Display;

public class RefreshController {
    private final Vector<IRefreshable> m_refreshables;
    private final Display m_display;
    private static final int UPDATE_INTERVAL = 50;
    private final AtomicBoolean m_keepAlive = new AtomicBoolean();

    public RefreshController(Display display) {
        this.m_refreshables = new Vector();
        this.m_display = display;
    }

    public void add(IRefreshable refeshable) {
        this.m_refreshables.add(refeshable);
    }

    public void remove(IRefreshable refeshable) {
        this.m_refreshables.remove(refeshable);
    }

    public void stop() {
        this.m_keepAlive.set(false);
    }

    public void start() {
        if (!this.m_keepAlive.getAndSet(true)) {
            this.scheduleUpdate();
        }
    }

    private void scheduleUpdate() {
        this.m_display.timerExec(50, new Runnable(){

            @Override
            public void run() {
                if (RefreshController.this.m_keepAlive.get()) {
                    RefreshController.this.update();
                    RefreshController.this.scheduleUpdate();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        IRefreshable[] refreshables;
        Vector<IRefreshable> vector = this.m_refreshables;
        synchronized (vector) {
            refreshables = this.m_refreshables.toArray(new IRefreshable[this.m_refreshables.size()]);
        }
        IRefreshable[] iRefreshableArray = refreshables;
        int n = refreshables.length;
        int n2 = 0;
        while (n2 < n) {
            IRefreshable refreshable = iRefreshableArray[n2];
            refreshable.refresh();
            ++n2;
        }
    }

    public void clear() {
        this.m_refreshables.clear();
    }
}

