/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.common.unit.ContentType;
import com.jrockit.mc.common.unit.IQuantity;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.ColorToolkit;
import com.jrockit.mc.ui.misc.ColorConstants;
import com.jrockit.mc.ui.misc.MCColor;
import java.awt.Color;
import org.eclipse.ui.IMemento;

public class DialConfiguration {
    private static final String KEY_USE_WATERMARK = "useWatermark";
    private static final String KEY_GRADIENT_VALUE_TYPE = "gradientValueType";
    private static final String KEY_GRADIENT_BEGIN_VALUE = "gradientBeginValue";
    private static final String KEY_GRADIENT_END_VALUE = "gradientEndValue";
    private static final String KEY_GRADIENT_BEGIN_COLOR = "gradientBeginColor";
    private static final String KEY_GRADIENT_END_COLOR = "gradientEndColor";
    private static final String KEY_WATERMARK_COLOR = "watermarkColor";
    private static final String KEY_TITLE = "title";
    private MCColor m_gradientBeginColor = ColorConstants.DIAL_NO_GRADIENT_COLOR.create();
    private MCColor m_gradientEndColor = ColorConstants.DIAL_NO_GRADIENT_COLOR.create();
    private MCColor m_waterMarkColor = ColorConstants.DIAL_WATERMARK_COLOR.create();
    private IQuantity m_gradientBeginValue;
    private IQuantity m_gradientEndValue;
    private String m_title = "";
    private boolean m_useWatermark = true;

    public DialConfiguration(String title) {
        this.m_title = title;
    }

    public String getTitle() {
        return this.m_title;
    }

    public MCColor getWatermarkColor() {
        return this.m_waterMarkColor;
    }

    public MCColor getGradientBeginColor() {
        return this.m_gradientBeginColor;
    }

    public void setGradientBeginColor(MCColor color) {
        this.m_gradientBeginColor = color;
    }

    public void setGradientEndColor(MCColor color) {
        this.m_gradientEndColor = color;
    }

    public IQuantity getGradientBeginValue() {
        return this.m_gradientBeginValue;
    }

    public IQuantity getGradientEndValue() {
        return this.m_gradientEndValue;
    }

    public MCColor getGradientEndColor() {
        return this.m_gradientEndColor;
    }

    public void setTitle(String text) {
        this.m_title = text;
    }

    public boolean getUseWatermark() {
        return this.m_useWatermark;
    }

    public void setUseWatermark(boolean useWatermark) {
        this.m_useWatermark = useWatermark;
    }

    public void setGradientBeginValue(IQuantity beginValue) {
        this.m_gradientBeginValue = beginValue;
    }

    public void setGradientEndValue(IQuantity endValue) {
        this.m_gradientEndValue = endValue;
    }

    public void setWatermarkColor(MCColor color) {
        this.m_waterMarkColor = color;
    }

    public void saveState(IMemento state) {
        state.putString(KEY_TITLE, this.m_title);
        state.putBoolean(KEY_USE_WATERMARK, this.m_useWatermark);
        if (this.m_gradientBeginValue != null && this.m_gradientEndValue != null && this.m_gradientEndValue.getUnit().getContentType().equals(this.m_gradientBeginValue.getUnit().getContentType())) {
            state.putString(KEY_GRADIENT_VALUE_TYPE, this.m_gradientBeginValue.getUnit().getContentType().getIdentifier());
            state.putString(KEY_GRADIENT_BEGIN_VALUE, this.m_gradientBeginValue.persistableString());
            state.putString(KEY_GRADIENT_END_VALUE, this.m_gradientEndValue.persistableString());
        }
        state.putString(KEY_GRADIENT_BEGIN_COLOR, ColorToolkit.encode((Color)this.m_gradientBeginColor.getAWTColor()));
        state.putString(KEY_GRADIENT_END_COLOR, ColorToolkit.encode((Color)this.m_gradientEndColor.getAWTColor()));
        state.putString(KEY_WATERMARK_COLOR, ColorToolkit.encode((Color)this.m_waterMarkColor.getAWTColor()));
    }

    public void restoreState(IMemento state) {
        String watermarkColor;
        String endColor;
        String beginColor;
        Boolean useWatermark;
        String title = state.getString(KEY_TITLE);
        if (title != null) {
            this.setTitle(title);
        }
        if ((useWatermark = state.getBoolean(KEY_USE_WATERMARK)) != null) {
            this.setUseWatermark(useWatermark);
        }
        try {
            ContentType contentType;
            String type = state.getString(KEY_GRADIENT_VALUE_TYPE);
            String begin = state.getString(KEY_GRADIENT_BEGIN_VALUE);
            String end = state.getString(KEY_GRADIENT_END_VALUE);
            if (type != null && begin != null && end != null && (contentType = UnitLookup.getContentType((String)type)) instanceof KindOfQuantity) {
                this.setGradientBeginValue(((KindOfQuantity)contentType).parsePersisted(begin));
                this.setGradientEndValue(((KindOfQuantity)contentType).parsePersisted(end));
            }
        }
        catch (QuantityConversionException type) {
            // empty catch block
        }
        if ((beginColor = state.getString(KEY_GRADIENT_BEGIN_COLOR)) != null) {
            this.setGradientBeginColor(new MCColor(ColorToolkit.decode((String)beginColor)));
        }
        if ((endColor = state.getString(KEY_GRADIENT_END_COLOR)) != null) {
            this.setGradientEndColor(new MCColor(ColorToolkit.decode((String)endColor)));
        }
        if ((watermarkColor = state.getString(KEY_WATERMARK_COLOR)) != null) {
            this.setWatermarkColor(new MCColor(ColorToolkit.decode((String)watermarkColor)));
        }
    }
}

