/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.tabs.memory.MemoryPoolInformation;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.ui.polling.PollManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.jface.util.IPropertyChangeListener;

public class MemoryPoolModel {
    private final PollManager m_pollManager = new PollManager(1000, "console.ui.profiling.update.interval.");
    private final IConnectionHandle m_connectionHandle;
    private volatile MemoryPoolInformation[] m_pools;
    private ArrayList<ObjectName> poolNames;

    public MemoryPoolModel(IConnectionHandle connectionHandle) {
        ConsolePlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.m_pollManager);
        this.m_connectionHandle = connectionHandle;
        this.findPools();
    }

    public MemoryPoolInformation[] getAllPools() {
        return this.m_pools;
    }

    public PollManager getPollManager() {
        return this.m_pollManager;
    }

    public boolean isConnected() {
        return this.m_connectionHandle.isConnected();
    }

    public void update() {
        IMBeanHelperService h = (IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        if (this.poolNames != null) {
            MemoryPoolInformation[] pools = new MemoryPoolInformation[this.poolNames.size()];
            try {
                int i = 0;
                while (i < pools.length) {
                    pools[i] = new MemoryPoolInformation();
                    pools[i].setPoolName(h.getAttribute(new MRI(MRI.Type.ATTRIBUTE, this.poolNames.get(i), "Name")).getValue().toString());
                    pools[i].setPoolType(h.getAttribute(new MRI(MRI.Type.ATTRIBUTE, this.poolNames.get(i), "Type")).getValue().toString());
                    CompositeData cd = (CompositeData)h.getAttribute(new MRI(MRI.Type.ATTRIBUTE, this.poolNames.get(i), "Usage")).getValue();
                    long used = (Long)cd.get("used");
                    long max = (Long)cd.get("max");
                    pools[i].setCurUsed(used);
                    pools[i].setCurMax(max);
                    pools[i].setCurUsage(max == -1L ? (double)max : (double)used / (double)max);
                    cd = (CompositeData)h.getAttribute(new MRI(MRI.Type.ATTRIBUTE, this.poolNames.get(i), "PeakUsage")).getValue();
                    used = (Long)cd.get("used");
                    max = (Long)cd.get("max");
                    pools[i].setPeakUsed(used);
                    pools[i].setPeakMax(max);
                    ++i;
                }
                this.m_pools = pools;
            }
            catch (Exception e) {
                this.m_pools = null;
            }
        }
    }

    private void findPools() {
        IMBeanHelperService h = (IMBeanHelperService)this.m_connectionHandle.getServiceOrDummy(IMBeanHelperService.class);
        this.poolNames = new ArrayList();
        try {
            for (Map.Entry entry : h.getMBeanInfos().entrySet()) {
                ObjectName o = (ObjectName)entry.getKey();
                if (!o.getDomain().equals("java.lang") || !o.getKeyProperty("type").equals("MemoryPool")) continue;
                this.poolNames.add(o);
            }
        }
        catch (IOException e1) {
            this.poolNames.clear();
        }
    }
}

