/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.tabs.memory;

import com.jrockit.mc.console.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProviderService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;

public class GarbageCollectionMBeanMetaDataProviderService
implements IMRIMetaDataProviderService {
    private static final String PROPERTY_TYPE = "type";
    private static final String GC_MBEAN_DOMAIN = "java.lang";
    private static final String GC_MBEAN_TYPE = "GarbageCollector";
    private static final Map<String, String> DISPLAY_NAMES = new HashMap<String, String>();
    private static final Map<String, String> UNIT_STRINGS = new HashMap<String, String>();
    private static final Map<String, String> COLORS = new HashMap<String, String>();

    static {
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("CollectionTime", Messages.GcTable_COLLECTION_TIME_TEXT, "ms", "#800000");
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("CollectionCount", Messages.GcTable_COLLECTION_COUNT_TEXT, null, "#f00000");
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("LastGcInfo/startTime", Messages.GcTable_LAST_STARTED_TEXT, "ms", "#008000");
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("LastGcInfo/endTime", Messages.GcTable_LAST_ENDED_TEXT, "ms", "#00f000");
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("LastGcInfo/duration", Messages.GcTable_LAST_DURATION_TEXT, "ms", "#000080");
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("LastGcInfo/id", Messages.GcTable_LAST_ID_TEXT, null, "#0000f0");
        GarbageCollectionMBeanMetaDataProviderService.storeMetaData("LastGcInfo/GcThreadCount", Messages.GcTable_LAST_THREADCOUNT_TEXT, null, "#123456");
    }

    private static boolean isGarbageCollectorMBean(ObjectName o) {
        return o.getDomain().equals(GC_MBEAN_DOMAIN) && GC_MBEAN_TYPE.equals(o.getKeyProperty(PROPERTY_TYPE));
    }

    private static void storeMetaData(String dataPath, String displayName, String unitString, String color) {
        DISPLAY_NAMES.put(dataPath, displayName);
        UNIT_STRINGS.put(dataPath, unitString);
        COLORS.put(dataPath, color);
    }

    private static String lookupMetaData(MRI mri, String dataKey) {
        if ("DisplayName".equals(dataKey)) {
            return DISPLAY_NAMES.get(mri.getDataPath());
        }
        if ("color".equals(dataKey)) {
            return COLORS.get(mri.getDataPath());
        }
        if ("UnitString".equals(dataKey)) {
            return UNIT_STRINGS.get(mri.getDataPath());
        }
        return null;
    }

    public Object getMetaData(IMRIMetaDataService metaDataService, MRI mri, String dataKey) {
        if (GarbageCollectionMBeanMetaDataProviderService.isGarbageCollectorMBean(mri.getObjectName())) {
            return GarbageCollectionMBeanMetaDataProviderService.lookupMetaData(mri, dataKey);
        }
        return null;
    }
}

