/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.tab;

import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.tab.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.attributes.MRIAttribute;
import com.jrockit.mc.rjmx.ui.attributes.MRIAttributeInspector;
import com.jrockit.mc.rjmx.ui.internal.SectionPartManager;
import com.jrockit.mc.ui.misc.ErrorDialog;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MBeanAttributeSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private MRIAttributeInspector m_client;

    public MBeanAttributeSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection str;
        if (part instanceof MBeanTreeSectionPart && !selection.isEmpty() && (str = (IStructuredSelection)selection).getFirstElement() instanceof ObjectName) {
            try {
                ArrayList<Object> attributes = new ArrayList<Object>();
                ObjectName bean = (ObjectName)str.getFirstElement();
                MBeanInfo info = ((IMBeanHelperService)this.getConnection().getServiceOrThrow(IMBeanHelperService.class)).getMBeanInfo(bean);
                MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
                int n = mBeanAttributeInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MBeanAttributeInfo attribute = mBeanAttributeInfoArray[n2];
                    if (attribute.getName() == null) {
                        attributes.add(new MRIAttributeInspector.ErroneousAttribute(Messages.MBeanAttributeSectionPart_ATTRIBUTE_NAME_MISSING));
                    } else {
                        attributes.add(MRIAttribute.create((IConnectionHandle)this.getConnection(), (MRI)new MRI(MRI.Type.ATTRIBUTE, bean, attribute.getName())));
                    }
                    ++n2;
                }
                this.m_client.setInput(attributes);
            }
            catch (ConnectionClosedException attributes) {
            }
            catch (Exception e) {
                MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to load attributes", e);
                String error = Messages.MBeanAttributeSectionPart_FAILED_TO_LOAD_ATTRIBUTES;
                ErrorDialog.showException((Shell)this.getSection().getShell(), (String)error, (String)error, (Throwable)e);
            }
        }
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)MBeanBrowserPlugin.getDefault().getMCDialogSettings(), (String)"mbean_attribute_inspector");
        this.m_client = new MRIAttributeInspector((SectionPartManager)this.getConsoleEditor().getSectionPartManagers().get(0), section, settings, this.getConnection(), false);
        return this.m_client.getControl();
    }

    private IConnectionHandle getConnection() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }

    private ConsoleEditor getConsoleEditor() {
        return (ConsoleEditor)((IFormPage)this.getManagedForm().getContainer()).getEditor();
    }

    protected void initializeSection(Section section) {
    }
}

