/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.metadata;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.metadata.ConstructorContentProvider;
import com.jrockit.mc.console.ui.mbeanbrowser.metadata.Messages;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import com.jrockit.mc.ui.sections.MCSectionPart;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanParameterInfo;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

final class ConstructorSectionPart
extends MCClientSectionPart {
    private TreeColumnComposite tree;

    public ConstructorSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, MCSectionPart.getAccessibilityDescriptionStyle(), sectionIdentifier);
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) throws Exception {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)MBeanBrowserPlugin.getDefault().getMCDialogSettings(), (String)"constructorSectionPart");
        this.tree = new TreeColumnComposite(section, 0, settings);
        Column itemColumn = new Column(Messages.ConstructorSectionPart_ITEM_NAME_TEXT, Messages.ConstructorSectionPart_ITEM_DESCRIPTION_TEXT, "Item", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanConstructorInfo) {
                    return ((MBeanConstructorInfo)element).getName();
                }
                if (element instanceof MBeanParameterInfo) {
                    MBeanParameterInfo parameter = (MBeanParameterInfo)element;
                    return String.valueOf(TypeHandling.simplifyType((String)parameter.getType())) + ' ' + parameter.getName();
                }
                return super.getText(element);
            }
        });
        Column descColumn = new Column(Messages.ConstructorSectionPart_DESCRIPTION_NAME_TEXT, Messages.ConstructorSectionPart_DESCRIPTION_DESCRIPTION_TEXT, "Description", new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MBeanFeatureInfo) {
                    return ((MBeanFeatureInfo)element).getDescription();
                }
                return super.getText(element);
            }
        });
        this.tree.addColumns(new IColumn[]{itemColumn, descColumn});
        this.tree.getViewer().setContentProvider((IContentProvider)new ConstructorContentProvider());
        this.tree.getViewer().setAutoExpandLevel(-1);
        return this.tree;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.ConstructorSectionPart_CONSTRUCTORS_TITLE_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void setMBeanInfo(MBeanInfo mbeanInfo) {
        this.tree.getViewer().setInput((Object)mbeanInfo);
    }
}

