/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.dialog;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.attach.dialog.Bundle;
import org.netbeans.modules.profiler.attach.spi.AttachStepsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class AttachDialog
extends AttachWizard {
    private AttachStepsProvider currentProvider;
    private Panel panel;
    private static final String ATTACH_WIZARD_HELPCTX = "AttachDialog.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("AttachDialog.HelpCtx");

    @Override
    public AttachSettings configure(AttachSettings attachSettings) {
        AttachSettings attachSettings2;
        if (attachSettings == null) {
            attachSettings = new AttachSettings();
        }
        if (attachSettings.getTargetType().isEmpty()) {
            attachSettings.setDirect(false);
            attachSettings.setDynamic16(true);
            attachSettings.setRemote(false);
        }
        attachSettings.setTargetType(Bundle.AttachDialog_JavaApplication());
        attachSettings.setServerType(Bundle.AttachDialog_JavaApplication());
        if (attachSettings.isRemote()) {
            attachSettings.setHostOS(null);
        }
        this.panel = new Panel();
        this.panel.setup(attachSettings);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, Bundle.AttachDialog_Caption());
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        AttachSettings attachSettings3 = attachSettings2 = dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION ? this.panel.getSettings() : null;
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        this.currentProvider = null;
        this.panel = null;
        return attachSettings2;
    }

    private String steps(AttachSettings attachSettings) {
        Collection collection = Lookup.getDefault().lookupAll(AttachStepsProvider.class);
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        for (AttachStepsProvider attachStepsProvider : collection) {
            String string = attachStepsProvider.getSteps(attachSettings);
            if (string == null) continue;
            this.currentProvider = attachStepsProvider;
            this.currentProvider.addChangeListener(this.panel);
            return string;
        }
        this.currentProvider = null;
        return Bundle.AttachDialog_NoSteps();
    }

    private class Panel
    extends JPanel
    implements HelpCtx.Provider,
    ChangeListener {
        private JRadioButton local;
        private JRadioButton remote;
        private JRadioButton dynamic;
        private JRadioButton direct;
        private JTextField hostname;
        private JComboBox os;
        private HTMLTextArea steps;
        private AttachSettings as;
        private boolean updatingUI = false;

        Panel() {
            this.initComponents();
        }

        void setup(AttachSettings attachSettings) {
            this.as = attachSettings;
            this.updatingUI = true;
            this.local.setSelected(!attachSettings.isRemote());
            this.remote.setSelected(attachSettings.isRemote());
            this.dynamic.setSelected(!attachSettings.isDirect());
            this.direct.setSelected(attachSettings.isDirect());
            if (attachSettings.isRemote()) {
                this.hostname.setText(attachSettings.getHost());
                this.os.setSelectedItem(attachSettings.getHostOS());
            } else {
                this.hostname.setText("");
                this.os.setSelectedIndex(0);
            }
            this.updatingUI = false;
            this.updateSteps();
        }

        AttachSettings getSettings() {
            this.as.setRemote(this.remote.isSelected());
            if (this.as.isRemote()) {
                this.as.setDirect(true);
                this.as.setDynamic16(false);
                this.as.setHost(this.hostname.getText().trim());
                this.as.setHostOS(this.os.getSelectedItem().toString());
            } else {
                this.as.setDirect(this.direct.isSelected());
                this.as.setDynamic16(this.dynamic.isSelected());
                this.as.setHostOS(IntegrationUtils.getLocalPlatform((int)-1));
            }
            return this.as;
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            final JPanel jPanel = new JPanel(new CardLayout());
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            JPanel jPanel3 = new JPanel(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            ButtonGroup buttonGroup2 = new ButtonGroup();
            JPanel jPanel4 = new JPanel(new GridBagLayout());
            jPanel4.setBorder(new TitledBorder(Bundle.AttachDialog_Target()));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 0, 0);
            this.local = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    super.fireItemStateChanged(itemEvent);
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                    cardLayout.show(jPanel, "LOCAL");
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.local, (String)Bundle.AttachDialog_Local());
            buttonGroup.add(this.local);
            jPanel4.add((Component)this.local, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 30, 0, 10);
            JLabel jLabel = new JLabel(Bundle.AttachDialog_LocalHint());
            jLabel.setEnabled(false);
            jPanel4.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 10, 0);
            this.remote = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    super.fireItemStateChanged(itemEvent);
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    CardLayout cardLayout = (CardLayout)jPanel.getLayout();
                    cardLayout.show(jPanel, "REMOTE");
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.remote, (String)Bundle.AttachDialog_Remote());
            buttonGroup.add(this.remote);
            jPanel4.add((Component)this.remote, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 30, 10, 10);
            JLabel jLabel2 = new JLabel(Bundle.AttachDialog_RemoteHint());
            jLabel2.setEnabled(false);
            jPanel4.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)jPanel4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 0, 0);
            this.dynamic = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    super.fireItemStateChanged(itemEvent);
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.dynamic, (String)Bundle.AttachDialog_Dynamic());
            buttonGroup2.add(this.dynamic);
            jPanel2.add((Component)this.dynamic, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 30, 0, 10);
            JLabel jLabel3 = new JLabel(Bundle.AttachDialog_DynamicHint());
            jLabel3.setEnabled(false);
            jPanel2.add((Component)jLabel3, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 10, 0);
            this.direct = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    super.fireItemStateChanged(itemEvent);
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.direct, (String)Bundle.AttachDialog_Direct());
            buttonGroup2.add(this.direct);
            jPanel2.add((Component)this.direct, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 30, 10, 10);
            JLabel jLabel4 = new JLabel(Bundle.AttachDialog_DirectHint());
            jLabel4.setEnabled(false);
            jPanel2.add((Component)jLabel4, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 0, 0);
            JLabel jLabel5 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel5, (String)Bundle.AttachDialog_Hostname());
            jPanel3.add((Component)jLabel5, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 0, 10);
            this.hostname = new JTextField();
            jLabel5.setLabelFor(this.hostname);
            jPanel3.add((Component)this.hostname, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 10, 0);
            JLabel jLabel6 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel6, (String)Bundle.AttachDialog_OsJvm());
            jPanel3.add((Component)jLabel6, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(6, 10, 10, 10);
            this.os = new JComboBox(new Object[]{IntegrationUtils.PLATFORM_WINDOWS_OS, IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS, IntegrationUtils.PLATFORM_WINDOWS_CVM, IntegrationUtils.PLATFORM_LINUX_OS, IntegrationUtils.PLATFORM_LINUX_AMD64_OS, IntegrationUtils.PLATFORM_LINUX_ARM_OS, IntegrationUtils.PLATFORM_LINUX_CVM, IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS, IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS, IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS, IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS, IntegrationUtils.PLATFORM_MAC_OS}){

                @Override
                protected void fireItemStateChanged(ItemEvent itemEvent) {
                    super.fireItemStateChanged(itemEvent);
                    if (itemEvent.getStateChange() != 1) {
                        return;
                    }
                    Panel.this.updateSteps();
                }
            };
            jLabel6.setLabelFor(this.os);
            jPanel3.add((Component)this.os, gridBagConstraints);
            jPanel.setBorder(new TitledBorder(Bundle.AttachDialog_Connection()));
            jPanel.add((Component)jPanel2, "LOCAL");
            jPanel.add((Component)jPanel3, "REMOTE");
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 10, 0, 10);
            this.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(10, 12, 0, 12);
            JLabel jLabel7 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel7, (String)Bundle.AttachDialog_Steps());
            jLabel7.setIcon(Icons.getIcon((String)"GeneralIcons.Info"));
            this.add((Component)jLabel7, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(2, 12, 0, 12);
            this.steps = new HTMLTextArea(){

                protected void showURL(URL uRL) {
                    if (AttachDialog.this.currentProvider != null) {
                        final String string = uRL.toString();
                        final AttachSettings attachSettings = new AttachSettings();
                        Panel.this.getSettings().copyInto(attachSettings);
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                AttachDialog.this.currentProvider.handleAction(string, attachSettings);
                            }
                        });
                    }
                }
            };
            jLabel7.setLabelFor((Component)this.steps);
            this.steps.setEditable(false);
            this.steps.setPreferredSize(new Dimension(505, 130));
            JScrollPane jScrollPane = new JScrollPane((Component)this.steps);
            this.add((Component)jScrollPane, gridBagConstraints);
        }

        private void updateSteps() {
            if (this.updatingUI) {
                return;
            }
            this.steps.setText(AttachDialog.this.steps(this.getSettings()));
            this.steps.setCaretPosition(0);
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Panel.this.updateSteps();
                }
            });
        }
    }
}

