/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.progress;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.modules.progress.spi.RunOffEDTProvider;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class ProgressUtils {
    private static final RunOffEDTProvider PROVIDER = ProgressUtils.getProvider();
    private static final int DISPLAY_DIALOG_MS = 9450;
    private static final int DISPLAY_WAIT_CURSOR_MS = 50;

    private ProgressUtils() {
    }

    private static RunOffEDTProvider getProvider() {
        RunOffEDTProvider runOffEDTProvider = (RunOffEDTProvider)Lookup.getDefault().lookup(RunOffEDTProvider.class);
        return runOffEDTProvider != null ? runOffEDTProvider : new Trivial();
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl) {
        PROVIDER.runOffEventDispatchThread(runnable, string, atomicBoolean, bl, 50, 9450);
    }

    public static void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
        PROVIDER.runOffEventDispatchThread(runnable, string, atomicBoolean, bl, n, n2);
    }

    public static void showProgressDialogAndRun(Runnable runnable, ProgressHandle progressHandle, boolean bl) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress) {
            RunOffEDTProvider.Progress progress = (RunOffEDTProvider.Progress)PROVIDER;
            progress.showProgressDialogAndRun(runnable, progressHandle, bl);
        } else {
            PROVIDER.runOffEventDispatchThread(runnable, progressHandle.getDisplayName(), new AtomicBoolean(false), false, 0, 0);
        }
    }

    public static void runOffEventThreadWithProgressDialog(Runnable runnable, String string, ProgressHandle progressHandle, boolean bl, int n, int n2) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress2) {
            RunOffEDTProvider.Progress2 progress2 = (RunOffEDTProvider.Progress2)PROVIDER;
            progress2.runOffEventThreadWithProgressDialog(runnable, string, progressHandle, bl, n, n2);
        } else {
            PROVIDER.runOffEventDispatchThread(runnable, progressHandle.getDisplayName(), new AtomicBoolean(false), true, 50, 9450);
        }
    }

    public static void runOffEventThreadWithCustomDialogContent(Runnable runnable, String string, JPanel jPanel, int n, int n2) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress2) {
            RunOffEDTProvider.Progress2 progress2 = (RunOffEDTProvider.Progress2)PROVIDER;
            progress2.runOffEventThreadWithCustomDialogContent(runnable, string, jPanel, n, n2);
        } else {
            PROVIDER.runOffEventDispatchThread(runnable, string, new AtomicBoolean(false), true, 50, 9450);
        }
    }

    public static <T> T showProgressDialogAndRun(final ProgressRunnable<T> progressRunnable, final String string, boolean bl) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress) {
            RunOffEDTProvider.Progress progress = (RunOffEDTProvider.Progress)PROVIDER;
            return progress.showProgressDialogAndRun(progressRunnable, string, bl);
        }
        final AtomicReference atomicReference = new AtomicReference();
        PROVIDER.runOffEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle(string);
                progressHandle.start();
                progressHandle.switchToIndeterminate();
                try {
                    atomicReference.set(progressRunnable.run(progressHandle));
                }
                finally {
                    progressHandle.finish();
                }
            }
        }, string, new AtomicBoolean(false), true, 0, 0);
        return (T)atomicReference.get();
    }

    public static void showProgressDialogAndRun(Runnable runnable, String string) {
        ProgressUtils.showProgressDialogAndRun(new RunnableWrapper(runnable), string, false);
    }

    public static <T> Future<T> showProgressDialogAndRunLater(final ProgressRunnable<T> progressRunnable, final ProgressHandle progressHandle, boolean bl) {
        if (PROVIDER instanceof RunOffEDTProvider.Progress) {
            RunOffEDTProvider.Progress progress = (RunOffEDTProvider.Progress)PROVIDER;
            return progress.showProgressDialogAndRunLater(progressRunnable, progressHandle, bl);
        }
        FutureTask futureTask = new FutureTask(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return progressRunnable.run(progressHandle);
            }
        });
        PROVIDER.runOffEventDispatchThread(futureTask, progressHandle.getDisplayName(), new AtomicBoolean(false), true, 0, 0);
        return futureTask;
    }

    private static class Trivial
    implements RunOffEDTProvider {
        private static final RequestProcessor WORKER = new RequestProcessor(ProgressUtils.class.getName());

        private Trivial() {
        }

        @Override
        public void runOffEventDispatchThread(Runnable runnable, String string, AtomicBoolean atomicBoolean, boolean bl, int n, int n2) {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.Task task = WORKER.post(runnable);
                task.waitFinished();
            } else {
                runnable.run();
            }
        }
    }

    private static final class RunnableWrapper
    implements ProgressRunnable<Void> {
        private final Runnable toRun;

        RunnableWrapper(Runnable runnable) {
            this.toRun = runnable;
        }

        @Override
        public Void run(ProgressHandle progressHandle) {
            this.toRun.run();
            return null;
        }
    }
}

