/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.slides;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.view.ui.slides.CommandManager;
import org.netbeans.core.windows.view.ui.slides.SlideBarController;
import org.netbeans.core.windows.view.ui.slides.SlideGestureRecognizer;
import org.netbeans.core.windows.view.ui.slides.TabbedSlideAdapter;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.swing.tabcontrol.SlideBarDataModel;
import org.netbeans.swing.tabcontrol.SlidingButton;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.event.ComplexListDataEvent;
import org.netbeans.swing.tabcontrol.event.ComplexListDataListener;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.BusyTabsSupport;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.netbeans.swing.tabcontrol.plaf.TabControlButtonFactory;
import org.openide.windows.TopComponent;

public final class SlideBar
extends JPanel
implements ComplexListDataListener,
SlideBarController,
Tabbed.Accessor,
ChangeListener,
ActionListener {
    public static final String COMMAND_SLIDE_IN = "slideIn";
    public static final String COMMAND_SLIDE_OUT = "slideOut";
    public static final String COMMAND_SLIDE_RESIZE = "slideResize";
    public static final String COMMAND_POPUP_REQUEST = "popup";
    public static final String COMMAND_DISABLE_AUTO_HIDE = "disableAutoHide";
    public static final String COMMAND_MAXIMIZE = "slideMaximize";
    private static final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private final TabbedSlideAdapter tabbed;
    private final SlideBarDataModel dataModel;
    private final SingleSelectionModel selModel;
    private SlideGestureRecognizer gestureRecognizer;
    private List<SlidingButton> buttons;
    private CommandManager commandMgr;
    private boolean active = false;
    private final TabDisplayer dummyDisplayer = new TabDisplayer();
    private final int separatorOrientation;
    private int row = 0;
    private int col = 0;

    public SlideBar(TabbedSlideAdapter tabbedSlideAdapter, SlideBarDataModel slideBarDataModel, SingleSelectionModel singleSelectionModel) {
        super(new GridBagLayout());
        this.tabbed = tabbedSlideAdapter;
        this.dataModel = slideBarDataModel;
        this.selModel = singleSelectionModel;
        this.commandMgr = new CommandManager(this);
        this.gestureRecognizer = new SlideGestureRecognizer(this, this.commandMgr.getResizer());
        this.buttons = new ArrayList<SlidingButton>(5);
        this.separatorOrientation = tabbedSlideAdapter.isHorizontal() ? 1 : 0;
        this.dummyDisplayer.addActionListener((ActionListener)this);
        this.syncWithModel();
        slideBarDataModel.addComplexListDataListener((ComplexListDataListener)this);
        singleSelectionModel.addChangeListener(this);
        if (isAqua) {
            Color color = UIManager.getColor("NbSplitPane.background");
            if (null == color) {
                color = this.getBackground().darker();
            }
            if (slideBarDataModel.getOrientation() == 3) {
                this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, color));
            } else if (slideBarDataModel.getOrientation() == 4) {
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color));
            } else if (slideBarDataModel.getOrientation() == 2) {
                this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, color));
            } else if (slideBarDataModel.getOrientation() == 1) {
                this.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, color));
            }
        }
        if (UIManager.getBoolean("NbMainWindow.showCustomBackground")) {
            this.setOpaque(false);
        }
    }

    public SlideBarDataModel getModel() {
        return this.dataModel;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selModel;
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.syncWithModel();
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.syncWithModel();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.syncWithModel();
    }

    public void indicesAdded(ComplexListDataEvent complexListDataEvent) {
        this.syncWithModel();
    }

    public void indicesChanged(ComplexListDataEvent complexListDataEvent) {
        this.syncWithModel();
    }

    public void indicesRemoved(ComplexListDataEvent complexListDataEvent) {
        this.syncWithModel();
    }

    public int tabForCoordinate(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        int n3 = 0;
        Iterator<SlidingButton> iterator = this.buttons.iterator();
        while (iterator.hasNext()) {
            ((Component)iterator.next()).getBounds(rectangle);
            if (rectangle.contains(n, n2)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    int nextTabForCoordinate(int n, int n2) {
        Rectangle rectangle = new Rectangle();
        int n3 = 0;
        for (Component component : this.buttons) {
            component.getBounds(rectangle);
            if (this.tabbed.isHorizontal()) {
                if (rectangle.x + rectangle.width / 2 < n) {
                    ++n3;
                    continue;
                }
            } else if (rectangle.y + rectangle.height / 2 < n2) {
                ++n3;
                continue;
            }
            return n3;
        }
        return n3;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.selModel.getSelectedIndex();
        this.tabbed.postSelectionEvent();
        if (this.isDisplayable() && this.isVisible()) {
            if (n != -1) {
                this.commandMgr.slideIn(n);
            } else {
                this.commandMgr.slideOut(true, true);
            }
        }
    }

    @Override
    public void userToggledAutoHide(int n, boolean bl) {
        this.commandMgr.slideIntoDesktop(n, true);
    }

    @Override
    public void userToggledTransparency(int n) {
        if (n != this.getSelectionModel().getSelectedIndex()) {
            this.getSelectionModel().setSelectedIndex(n);
        }
        this.commandMgr.toggleTransparency(n);
    }

    @Override
    public void userTriggeredPopup(MouseEvent mouseEvent, Component component) {
        int n = this.getButtonIndex(component);
        this.commandMgr.showPopup(mouseEvent, n);
    }

    private SlidingButton buttonFor(TopComponent topComponent) {
        TabData tabData;
        int n = 0;
        Iterator iterator = this.dataModel.getTabs().iterator();
        while (iterator.hasNext() && (tabData = (TabData)iterator.next()).getComponent() != topComponent) {
            if (!iterator.hasNext()) {
                n = -1;
                continue;
            }
            ++n;
        }
        if (n >= 0 && n < this.dataModel.size()) {
            return this.getButton(n);
        }
        return null;
    }

    public void setBlinking(TopComponent topComponent, boolean bl) {
        SlidingButton slidingButton = this.buttonFor(topComponent);
        if (slidingButton != null) {
            slidingButton.setBlinking(bl);
        }
    }

    @Override
    public void userClickedSlidingButton(Component component) {
        int n = this.getButtonIndex(component);
        SlidingButton slidingButton = this.buttons.get(n);
        slidingButton.setBlinking(false);
        if (n != this.selModel.getSelectedIndex() || !this.isActive()) {
            TopComponent topComponent = (TopComponent)this.dataModel.getTab(n).getComponent();
            if (topComponent != null) {
                topComponent.requestActive();
            }
            slidingButton.setSelected(true);
        } else {
            this.selModel.setSelectedIndex(-1);
        }
    }

    @Override
    public boolean userTriggeredAutoSlideIn(Component component) {
        int n = this.getButtonIndex(component);
        if (n < 0) {
            return false;
        }
        SlidingButton slidingButton = this.buttons.get(n);
        slidingButton.setBlinking(false);
        TopComponent topComponent = (TopComponent)this.dataModel.getTab(n).getComponent();
        if (topComponent == null) {
            return false;
        }
        topComponent.requestVisible();
        return true;
    }

    @Override
    public void userTriggeredAutoSlideOut() {
        this.selModel.setSelectedIndex(-1);
    }

    public Rectangle getTabBounds(int n) {
        SlidingButton slidingButton = this.getButton(n);
        if (slidingButton == null) {
            return null;
        }
        Insets insets = this.getInsets();
        Point point = new Point(insets.left, insets.top);
        if (this.tabbed.isHorizontal()) {
            if (n < this.dataModel.size()) {
                point.x = this.getButton((int)n).getLocation().x;
            }
        } else if (n < this.dataModel.size()) {
            point.y = this.getButton((int)n).getLocation().y;
        }
        return new Rectangle(point, slidingButton.getPreferredSize());
    }

    public Tabbed getTabbed() {
        return this.tabbed;
    }

    public WinsysInfoForTabbedContainer createWinsysInfo() {
        return new SlidedWinsysInfoForTabbedContainer();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TabActionEvent tabActionEvent;
        if (actionEvent instanceof TabActionEvent && "restoreGroup".equals((tabActionEvent = (TabActionEvent)actionEvent).getActionCommand())) {
            String string = tabActionEvent.getGroupName();
            WindowManagerImpl windowManagerImpl = WindowManagerImpl.getInstance();
            ModeImpl modeImpl = (ModeImpl)windowManagerImpl.findMode(string);
            if (null != modeImpl) {
                windowManagerImpl.userRestoredMode(this.tabbed.getSlidingMode(), modeImpl);
            }
        }
    }

    private GridBagConstraints createConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = this.row++;
        gridBagConstraints.gridy = this.col++;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        if (!this.tabbed.isHorizontal()) {
            // empty if block
        }
        return gridBagConstraints;
    }

    private void addSeparator() {
        int n = UIManager.getInt("NbSlideBar.GroupSeparator.Size");
        if (n > 0) {
            this.addStrut(n);
        } else {
            JSeparator jSeparator = new JSeparator(this.separatorOrientation);
            int n2 = UIManager.getInt("NbSlideBar.GroupSeparator.Gap.Before");
            if (n2 == 0) {
                n2 = 15;
            }
            this.addStrut(n2);
            GridBagConstraints gridBagConstraints = this.createConstraints();
            gridBagConstraints.insets = new Insets(1, 1, 1, 1);
            gridBagConstraints.fill = this.separatorOrientation == 1 ? 3 : 2;
            this.add((Component)jSeparator, gridBagConstraints);
            n2 = UIManager.getInt("NbSlideBar.GroupSeparator.Gap.After");
            if (n2 == 0) {
                n2 = 5;
            }
            this.addStrut(n2);
        }
    }

    private void addRestoreButton(String string) {
        if (null == string) {
            return;
        }
        TabControlButton tabControlButton = TabControlButtonFactory.createRestoreGroupButton((TabDisplayer)this.dummyDisplayer, (String)string);
        this.add((Component)tabControlButton, this.createConstraints());
        tabControlButton.putClientProperty((Object)"NbSlideBar.RestoreButton.Orientation", (Object)this.getModel().getOrientation());
        int n = UIManager.getInt("NbSlideBar.RestoreButton.Gap");
        if (n == 0) {
            n = 10;
        }
        this.addStrut(n);
    }

    private void addButton(SlidingButton slidingButton) {
        Object object = isAqua ? new AquaButtonPanel((JToggleButton)slidingButton) : slidingButton;
        this.add((Component)object, this.createConstraints());
        int n = UIManager.getInt("NbSlideBar.SlideButton.Gap");
        if (n > 0) {
            this.addStrut(n);
        }
    }

    void makeBusy(TopComponent topComponent, boolean bl) {
        Component component;
        BusyTabsSupport.getDefault().makeTabBusy((Tabbed)this.tabbed, 0, bl);
        if (!bl && null != (component = this.getSlidedComp())) {
            component.repaint();
        }
        this.syncWithModel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        BusyTabsSupport.getDefault().install(this.getTabbed(), (TabDataModel)this.dataModel);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        BusyTabsSupport.getDefault().uninstall(this.getTabbed(), (TabDataModel)this.dataModel);
    }

    boolean isHorizontal() {
        return this.tabbed.isHorizontal();
    }

    Component getSlidedComp() {
        return this.commandMgr.getSlidedComp();
    }

    void setActive(boolean bl) {
        this.active = bl;
        this.commandMgr.setActive(bl);
    }

    boolean isActive() {
        return this.active;
    }

    boolean isHoveringAllowed() {
        return !this.isActive() || !this.commandMgr.isCompSlided();
    }

    int getButtonIndex(Component component) {
        return this.buttons.indexOf(component);
    }

    SlidingButton getButton(int n) {
        return this.buttons.get(n);
    }

    boolean containsComp(Component component) {
        List list = this.getModel().getTabs();
        TabData tabData2 = null;
        for (TabData tabData2 : list) {
            if (!component.equals(tabData2.getComponent())) continue;
            return true;
        }
        return false;
    }

    private void addStrut(int n) {
        JLabel jLabel = new JLabel();
        Dimension dimension = new Dimension(n, n);
        jLabel.setMinimumSize(dimension);
        jLabel.setPreferredSize(dimension);
        jLabel.setMaximumSize(dimension);
        GridBagConstraints gridBagConstraints = this.createConstraints();
        gridBagConstraints.fill = 0;
        this.add((Component)jLabel, gridBagConstraints);
    }

    private void syncWithModel() {
        SlidingButton slidingButton2;
        assert (SwingUtilities.isEventDispatchThread());
        HashSet<TabData> hashSet = null;
        for (SlidingButton slidingButton2 : this.buttons) {
            if (slidingButton2.isBlinking()) {
                if (hashSet == null) {
                    hashSet = new HashSet<TabData>();
                }
                hashSet.add(slidingButton2.getData());
            }
            this.gestureRecognizer.detachButton((AbstractButton)slidingButton2);
        }
        this.removeAll();
        this.buttons.clear();
        List list = this.dataModel.getTabs();
        slidingButton2 = null;
        String string = null;
        boolean bl = true;
        this.row = 0;
        this.col = 0;
        Object object = list.iterator();
        while (object.hasNext()) {
            TopComponent topComponent;
            TabData tabData = (TabData)object.next();
            slidingButton2 = new SlidingButton(tabData, this.dataModel.getOrientation());
            if (hashSet != null && hashSet.contains(tabData)) {
                slidingButton2.setBlinking(true);
            }
            if (this.tabbed.isBusy(topComponent = (TopComponent)tabData.getComponent())) {
                slidingButton2.setIcon(BusyTabsSupport.getDefault().getBusyIcon(false));
            }
            String string2 = this.getRestoreModeNameForTab(tabData);
            this.gestureRecognizer.attachButton((AbstractButton)slidingButton2);
            this.buttons.add(slidingButton2);
            if (Switches.isModeSlidingEnabled()) {
                if (isAqua && bl) {
                    this.addStrut(4);
                }
                if (null == string || !string.equals(string2)) {
                    if (!bl) {
                        this.addSeparator();
                    }
                    this.addRestoreButton(string2);
                    string = string2;
                    bl = false;
                }
                this.addButton(slidingButton2);
                continue;
            }
            this.addButton(slidingButton2);
        }
        object = this.createConstraints();
        if (this.tabbed.isHorizontal()) {
            ((GridBagConstraints)object).weightx = 1.0;
        } else {
            ((GridBagConstraints)object).weighty = 1.0;
        }
        ((GridBagConstraints)object).fill = 0;
        this.add((Component)new JLabel(), object);
        this.commandMgr.syncWithModel();
        if (!UIManager.getBoolean("NbMainWindow.showCustomBackground")) {
            this.setOpaque(!this.buttons.isEmpty());
        }
        this.revalidate();
        this.repaint();
    }

    private String getRestoreModeNameForTab(TabData tabData) {
        ModeImpl modeImpl;
        WindowManagerImpl windowManagerImpl;
        String string;
        Component component = tabData.getComponent();
        if (component instanceof TopComponent && null != (string = (windowManagerImpl = WindowManagerImpl.getInstance()).findTopComponentID((TopComponent)component)) && null != (modeImpl = windowManagerImpl.getPreviousModeForTopComponent(string, this.tabbed.getSlidingMode()))) {
            return modeImpl.getName();
        }
        return null;
    }

    boolean isSlidedTabTransparent() {
        boolean bl = false;
        if (null != this.getSlidedComp()) {
            bl = ((TabbedContainer)this.getSlidedComp()).isTransparent();
        }
        return bl;
    }

    private static final class VerticalBorder
    implements Border {
        private VerticalBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIManager.getColor("NbBrushedMetal.darkShadow"));
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.setColor(UIManager.getColor("NbBrushedMetal.lightShadow"));
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 3, 1, 3);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static final class BottomBorder
    implements Border {
        private BottomBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(UIManager.getColor("NbBrushedMetal.darkShadow"));
            graphics.drawLine(n, n2, n, n2 + n4);
            graphics.setColor(UIManager.getColor("NbBrushedMetal.lightShadow"));
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(3, 1, 3, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class AquaButtonPanel
    extends JPanel {
        private final JToggleButton slidingButton;
        private final Border pressedBorder;

        public AquaButtonPanel(JToggleButton jToggleButton) {
            super(new GridBagLayout());
            this.slidingButton = jToggleButton;
            this.pressedBorder = SlideBar.this.tabbed.isHorizontal() ? new BottomBorder() : new VerticalBorder();
            this.add((Component)jToggleButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
            jToggleButton.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    AquaButtonPanel.this.repaint();
                }
            });
        }

        private boolean isPressed() {
            if (null == this.slidingButton) {
                return false;
            }
            ButtonModel buttonModel = this.slidingButton.getModel();
            return buttonModel.isArmed() || buttonModel.isPressed() || buttonModel.isSelected();
        }

        private boolean isRollover() {
            if (null == this.slidingButton) {
                return false;
            }
            ButtonModel buttonModel = this.slidingButton.getModel();
            return buttonModel.isRollover();
        }

        @Override
        public boolean isOpaque() {
            return this.isPressed() || this.isRollover();
        }

        @Override
        public Color getBackground() {
            if (this.isRollover()) {
                return UIManager.getColor("NbSlideBar.rollover");
            }
            if (this.isPressed()) {
                return UIManager.getColor("NbSplitPane.background");
            }
            return super.getBackground();
        }

        @Override
        public Border getBorder() {
            if (this.isPressed()) {
                return this.pressedBorder;
            }
            return BorderFactory.createEmptyBorder();
        }

        @Override
        public Dimension getPreferredSize() {
            return null == this.slidingButton ? super.getPreferredSize() : this.slidingButton.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return null == this.slidingButton ? super.getMinimumSize() : this.slidingButton.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return null == this.slidingButton ? super.getMaximumSize() : this.slidingButton.getMaximumSize();
        }
    }

    private class SlidedWinsysInfoForTabbedContainer
    extends WinsysInfoForTabbedContainer {
        private SlidedWinsysInfoForTabbedContainer() {
        }

        public Object getOrientation(Component component) {
            if (WindowManagerImpl.getInstance().getEditorAreaState() != 0) {
                return TabDisplayer.ORIENTATION_INVISIBLE;
            }
            return TabDisplayer.ORIENTATION_CENTER;
        }

        public boolean inMaximizedMode(Component component) {
            return TabbedAdapter.isInMaximizedMode(component);
        }

        public boolean isTopComponentSlidingEnabled() {
            return Switches.isTopComponentSlidingEnabled();
        }

        public boolean isTopComponentClosingEnabled() {
            return Switches.isViewTopComponentClosingEnabled();
        }

        public boolean isTopComponentMaximizationEnabled() {
            return Switches.isTopComponentMaximizationEnabled();
        }

        public boolean isTopComponentClosingEnabled(TopComponent topComponent) {
            return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.closing_disabled"));
        }

        public boolean isTopComponentMaximizationEnabled(TopComponent topComponent) {
            return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.maximization_disabled"));
        }

        public boolean isTopComponentSlidingEnabled(TopComponent topComponent) {
            return !Boolean.TRUE.equals(topComponent.getClientProperty((Object)"netbeans.winsys.tc.sliding_disabled"));
        }

        public boolean isModeSlidingEnabled() {
            return Switches.isModeSlidingEnabled();
        }

        public boolean isSlidedOutContainer() {
            return true;
        }

        public boolean isTopComponentBusy(TopComponent topComponent) {
            return WindowManagerImpl.getInstance().isTopComponentBusy(topComponent);
        }
    }
}

