/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.export;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.netbeans.api.visual.export.SceneExporter;
import org.netbeans.api.visual.export.WidgetPolygonalCoordinates;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class Scene2Image {
    private final File file;
    private final Scene scene;
    private Set selectedObjects;
    private int imageHeight;
    private int imageWidth;
    private double scale;

    public Scene2Image(Scene scene, File file) {
        this.scene = scene;
        this.file = file;
    }

    public ArrayList<WidgetPolygonalCoordinates> getSceneImageMapCoordinates(int n) {
        ArrayList<WidgetPolygonalCoordinates> arrayList = new ArrayList<WidgetPolygonalCoordinates>();
        List<Widget> list = this.scene.getChildren();
        boolean bl = false;
        for (Widget widget : list) {
            if (bl) break;
            List<Widget> list2 = widget.getChildren();
            if (this.selectedObjects != null) {
                ObjectScene objectScene = (ObjectScene)this.scene;
                list2.clear();
                for (Polygon polygon : this.selectedObjects) {
                    list2.add(objectScene.findWidget(polygon));
                }
                bl = true;
            }
            for (Widget widget2 : list2) {
                int n2;
                List<Point> list3;
                Polygon polygon;
                polygon = new Polygon();
                if (widget2 instanceof ConnectionWidget) {
                    int n3;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    Point point;
                    int n8;
                    list3 = ((ConnectionWidget)widget2).getControlPoints();
                    int n9 = list3.size();
                    if (n9 == 0) continue;
                    Point point2 = (Point)list3.get(0);
                    Point point3 = (Point)list3.get(list3.size() - 1);
                    Point point4 = point2;
                    n2 = 1;
                    int n10 = 1;
                    for (n8 = 0; n8 < n9; ++n8) {
                        point = null;
                        if (n8 + 1 < n9) {
                            point = (Point)list3.get(n8 + 1);
                            n2 = point4.y - point.y;
                            n10 = point4.x - point.x;
                        }
                        n7 = point4.x;
                        n6 = point4.y;
                        n5 = 0;
                        n4 = 0;
                        if (n2 == 0) {
                            n4 = n;
                        } else if (n10 == 0) {
                            n5 = n;
                        } else {
                            n3 = n2 * n10 / Math.abs(n2 * n10);
                            n5 = n3 * n;
                            n4 = n;
                        }
                        polygon.addPoint((int)((double)n7 * this.scale + (double)n5), (int)((double)n6 * this.scale + (double)n4));
                        point4 = point;
                    }
                    point4 = point3;
                    for (n8 = n9 - 1; n8 >= 0; --n8) {
                        point = null;
                        if (n8 - 1 >= 0) {
                            point = (Point)list3.get(n8 - 1);
                            n2 = point4.y - point.y;
                            n10 = point4.x - point.x;
                        }
                        n7 = point4.x;
                        n6 = point4.y;
                        n5 = 0;
                        n4 = 0;
                        if (n2 == 0) {
                            n4 = -n;
                        } else if (n10 == 0) {
                            n5 = -n;
                        } else {
                            n3 = n2 * n10 / Math.abs(n2 * n10);
                            n5 = n3 * n;
                            n4 = -n;
                        }
                        polygon.addPoint((int)((double)n7 * this.scale + (double)n5), (int)((double)n6 * this.scale + (double)n4));
                        point4 = point;
                    }
                } else {
                    list3 = widget2.getLocation();
                    Rectangle rectangle = widget2.getPreferredBounds();
                    int n11 = (int)((double)rectangle.width * this.scale);
                    int n12 = (int)((double)rectangle.height * this.scale);
                    int n13 = (int)((double)((Point)((Object)list3)).x * this.scale);
                    n2 = (int)((double)((Point)((Object)list3)).y * this.scale);
                    polygon.addPoint(n13 - 1, n2 - 1);
                    polygon.addPoint(n13 + n11 + 1, n2 - 1);
                    polygon.addPoint(n13 + n11 + 1, n2 + n12 + 1);
                    polygon.addPoint(n13 - 1, n2 + n12 + 1);
                }
                arrayList.add(new WidgetPolygonalCoordinates(widget2, polygon));
            }
        }
        return arrayList;
    }

    public BufferedImage createImage(SceneExporter.ImageType imageType, SceneExporter.ZoomType zoomType, boolean bl, boolean bl2, int n, int n2, int n3, boolean bl3) throws IOException {
        Object object;
        Object object4;
        double d = this.scene.getZoomFactor();
        Rectangle rectangle = this.scene.getPreferredBounds();
        Rectangle rectangle2 = this.scene.getView() != null ? this.scene.getView().getVisibleRect() : rectangle;
        ArrayList<Widget> arrayList = new ArrayList<Widget>();
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        Set<?> set = null;
        if (bl2 && this.scene instanceof ObjectScene) {
            object4 = (ObjectScene)this.scene;
            HashSet iterator2 = new HashSet();
            iterator2.addAll(((ObjectScene)object4).getObjects());
            set = ((ObjectScene)object4).getSelectedObjects();
            iterator2.removeAll(set);
            for (Object object2 : iterator2) {
                object = ((ObjectScene)object4).findWidget(object2);
                if (object == null || !((Widget)object).isVisible()) continue;
                ((Widget)object).setVisible(false);
                arrayList.add((Widget)object);
            }
        }
        if (bl) {
            n4 = rectangle2.width;
            n5 = rectangle2.height;
        } else {
            switch (zoomType) {
                case CUSTOM_SIZE: {
                    n4 = n2;
                    n5 = n3;
                    d = Math.min((double)n2 / (double)rectangle.width, (double)n3 / (double)rectangle.height);
                    break;
                }
                case FIT_IN_WINDOW: {
                    d = Math.min((double)rectangle2.width / (double)rectangle.width, (double)rectangle2.height / (double)rectangle.height);
                    n4 = (int)((double)rectangle.width * d);
                    n5 = (int)((double)rectangle.height * d);
                    break;
                }
                case CURRENT_ZOOM_LEVEL: {
                    n4 = (int)((double)rectangle.width * this.scene.getZoomFactor());
                    n5 = (int)((double)rectangle.height * this.scene.getZoomFactor());
                    break;
                }
                case ACTUAL_SIZE: {
                    n4 = rectangle.width;
                    n5 = rectangle.height;
                    d = 1.0;
                }
            }
        }
        if (bl3) {
            this.selectedObjects = set;
            this.imageHeight = n5;
            this.imageWidth = n4;
            this.scale = d;
        }
        BufferedImage bufferedImage = new BufferedImage(n4, n5, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(0, 0);
        graphics2D.scale(d, d);
        this.scene.paint(graphics2D);
        for (Widget widget : arrayList) {
            widget.setVisible(true);
        }
        if (this.file != null) {
            object4 = new FileImageOutputStream(this.file);
            if (imageType == SceneExporter.ImageType.JPG) {
                Object object2;
                Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
                ImageWriter imageWriter = iterator.next();
                object2 = imageWriter.getDefaultWriteParam();
                ((ImageWriteParam)object2).setCompressionMode(2);
                if (n > 100) {
                    n = 100;
                }
                if (n < 0) {
                    n = 0;
                }
                ((ImageWriteParam)object2).setCompressionQuality(n / 100);
                imageWriter.setOutput(object4);
                object = new IIOImage(bufferedImage, null, null);
                imageWriter.write(null, (IIOImage)object, (ImageWriteParam)object2);
                imageWriter.dispose();
            } else {
                ImageIO.write((RenderedImage)bufferedImage, "" + (Object)((Object)imageType), (ImageOutputStream)object4);
            }
            try {
                ((FileImageOutputStream)object4).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bufferedImage;
    }
}

