/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.search.provider.SearchInfo;

public abstract class SearchScopeDefinition {
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);

    @NonNull
    public abstract String getTypeId();

    @NonNull
    public abstract String getDisplayName();

    @CheckForNull
    public String getAdditionalInfo() {
        return null;
    }

    public abstract boolean isApplicable();

    public final synchronized void addChangeListener(@NonNull ChangeListener changeListener) {
        if (!this.changeListeners.contains(changeListener)) {
            this.changeListeners.add(changeListener);
        }
    }

    public final synchronized void removeChangeListener(@NonNull ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected final void notifyListeners() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.changeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @NonNull
    public abstract SearchInfo getSearchInfo();

    public String toString() {
        return this.getDisplayName();
    }

    public abstract int getPriority();

    public abstract void clean();

    public void selected() {
    }
}

