/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.IssuesPanel;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class BasicReplaceResultsPanel
extends BasicAbstractResultsPanel {
    private static final RequestProcessor RP = new RequestProcessor(BasicReplaceResultsPanel.class.getName());
    private final RequestProcessor.Task SAVE_TASK = RP.create((Runnable)new SaveTask());
    private JButton replaceButton;
    private JSplitPane splitPane;

    public BasicReplaceResultsPanel(ResultModel resultModel, BasicComposition basicComposition, Node node) {
        super(resultModel, basicComposition, true, new ResultsOutlineSupport(true, true, resultModel, basicComposition, node));
        this.init();
    }

    private void init() {
        JPanel jPanel = new JPanel();
        this.replaceButton = new JButton();
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicReplaceResultsPanel.this.replace();
            }
        });
        this.setButtonText();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(3, 2, 1));
        jPanel2.add(this.replaceButton);
        this.replaceButton.setMaximumSize(this.replaceButton.getPreferredSize());
        jPanel.add((Component)this.resultsOutlineSupport.getOutlineView());
        jPanel.add(jPanel2);
        this.splitPane = new JSplitPane();
        this.splitPane.setLeftComponent(jPanel);
        this.splitPane.setRightComponent(new ContextView(this.resultModel, this.getExplorerManager()));
        this.initSplitDividerLocationHandling();
        this.getContentPanel().add(this.splitPane);
        this.initResultModelListener();
        this.replaceButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TEXT_BUTTON_REPLACE"));
    }

    private void replace() {
        ReplaceTask replaceTask = new ReplaceTask(this.resultModel.getMatchingObjects(), this);
        this.resultsOutlineSupport.clean();
        this.replaceButton.setEnabled(false);
        Manager.getInstance().scheduleReplaceTask(replaceTask);
    }

    private void initResultModelListener() {
        this.resultModel.addPropertyChangeListener(new ModelListener());
    }

    private void initSplitDividerLocationHandling() {
        this.splitPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("dividerLocation")) {
                    BasicReplaceResultsPanel.this.SAVE_TASK.schedule(1000);
                }
            }
        });
        int n = FindDialogMemory.getDefault().getReplaceResultsDivider();
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
        }
    }

    private void setButtonText() {
        int n = this.resultModel.getSelectedMatchesCount();
        this.replaceButton.setText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE", (Object)n));
        this.replaceButton.setEnabled(n > 0);
    }

    public void displayIssuesToUser(ReplaceTask replaceTask, final String string, final String[] stringArray, final boolean bl) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                IssuesPanel issuesPanel = new IssuesPanel(string, stringArray);
                if (BasicAbstractResultsPanel.isMacLaf) {
                    issuesPanel.setBackground(BasicAbstractResultsPanel.macBackground);
                }
                BasicReplaceResultsPanel.this.displayIssues(issuesPanel);
                if (!ResultView.getInstance().isOpened()) {
                    ResultView.getInstance().open();
                }
                if (bl) {
                    ResultView.getInstance().requestAttention(true);
                }
            }
        });
    }

    public void displayIssues(IssuesPanel issuesPanel) {
        if (issuesPanel != null) {
            this.showRefreshButton();
            this.removeButtons(this.btnNext, this.btnPrev, this.btnFlatView, this.btnTreeView, this.btnExpand, this.showDetailsButton);
            JPanel jPanel = this.getContentPanel();
            jPanel.removeAll();
            jPanel.add(issuesPanel);
            this.validate();
            this.repaint();
        }
    }

    private void removeButtons(AbstractButton ... abstractButtonArray) {
        for (AbstractButton abstractButton : abstractButtonArray) {
            if (abstractButton == null) continue;
            Container container = abstractButton.getParent();
            container.remove(abstractButton);
        }
    }

    public void rescan() {
        BasicComposition basicComposition = new BasicComposition(this.composition.getSearchInfo(), this.composition.getMatcher(), this.composition.getBasicSearchCriteria(), this.composition.getScopeDisplayName());
        Manager.getInstance().scheduleSearchTask(basicComposition, true);
    }

    public void showFinishedInfo() {
        final AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/search/res/info.png");
        abstractNode.setDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_INFO_REPLACE_FINISHED", (Object)this.resultModel.getSelectedMatchesCount()));
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                BasicReplaceResultsPanel.this.getOutlineView().getOutline().setRootVisible(true);
                BasicReplaceResultsPanel.this.getExplorerManager().setRootContext((Node)abstractNode);
                BasicReplaceResultsPanel.this.getOutlineView().validate();
                BasicReplaceResultsPanel.this.getOutlineView().repaint();
                BasicReplaceResultsPanel.this.btnNext.setEnabled(false);
                BasicReplaceResultsPanel.this.btnPrev.setEnabled(false);
                BasicReplaceResultsPanel.this.btnTreeView.setEnabled(false);
                BasicReplaceResultsPanel.this.btnFlatView.setEnabled(false);
                BasicReplaceResultsPanel.this.btnExpand.setEnabled(false);
            }
        });
    }

    private class SaveTask
    implements Runnable {
        private SaveTask() {
        }

        @Override
        public void run() {
            if (BasicReplaceResultsPanel.this.splitPane != null) {
                FindDialogMemory.getDefault().setReplaceResultsDivider(BasicReplaceResultsPanel.this.splitPane.getDividerLocation());
            }
        }
    }

    private class ModelListener
    implements PropertyChangeListener {
        private ModelListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("valid")) {
                BasicReplaceResultsPanel.this.replaceButton.setText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE_INVALID"));
                BasicReplaceResultsPanel.this.replaceButton.setEnabled(false);
            } else if (propertyChangeEvent.getPropertyName().equals("selection") && BasicReplaceResultsPanel.this.resultModel.isValid()) {
                BasicReplaceResultsPanel.this.setButtonText();
            }
        }
    }
}

