/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.LinkedList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.netbeans.api.search.SearchControl;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchProvider;
import org.netbeans.swing.outline.Outline;
import org.openide.awt.ToolbarWithOverflow;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public abstract class AbstractSearchResultsPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    private static final String REFRESH_ICON = "org/netbeans/modules/search/res/refresh.png";
    private static final String STOP_ICON = "org/netbeans/modules/search/res/stop.png";
    private static final String NEXT_ICON = "org/netbeans/modules/search/res/next.png";
    private static final String PREV_ICON = "org/netbeans/modules/search/res/prev.png";
    private static final String EXPAND_ICON = "org/netbeans/modules/search/res/expandTree.png";
    private static final String COLLAPSE_ICON = "org/netbeans/modules/search/res/collapseTree.png";
    private ExplorerManager explorerManager;
    private SearchComposition<?> searchComposition;
    protected JButton btnStopRefresh = new JButton();
    protected JButton btnPrev = new JButton();
    protected JButton btnNext = new JButton();
    protected JToggleButton btnExpand = new JToggleButton();
    private final SearchProvider.Presenter searchProviderPresenter;
    private Lookup lookup;
    private volatile boolean btnStopRefreshInRefreshMode = false;
    private JPanel contentPanel;
    private JPanel jPanel1;
    private JToolBar toolBar;

    public AbstractSearchResultsPanel(SearchComposition<?> searchComposition, SearchProvider.Presenter presenter) {
        this.searchComposition = searchComposition;
        this.searchProviderPresenter = presenter;
        this.initComponents();
        this.explorerManager = new ExplorerManager();
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)ResultView.getInstance().getActionMap());
        this.initActions();
        this.initToolbar();
        this.initSelectionListeners();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.toolBar = new ToolbarWithOverflow();
        this.contentPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.toolBar.setRollover(true);
        this.toolBar.setPreferredSize(null);
        this.toolBar.setRequestFocusEnabled(false);
        this.add((Component)this.toolBar, "West");
        this.contentPanel.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 2));
        this.add((Component)this.contentPanel, "Center");
    }

    public final ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    private void initToolbar() {
        this.toolBar.setRollover(true);
        this.initStopRefreshButton();
        this.toolBar.add(this.btnStopRefresh);
        this.initPrevButton();
        this.toolBar.add(this.btnPrev);
        this.initNextButton();
        this.toolBar.add(this.btnNext);
        this.initExpandButton();
        this.toolBar.add(this.btnExpand);
        this.toolBar.setMinimumSize(new Dimension((int)this.toolBar.getMinimumSize().getWidth(), (int)this.btnStopRefresh.getMinimumSize().getHeight()));
    }

    private void initStopRefreshButton() throws MissingResourceException {
        this.sizeButton(this.btnStopRefresh);
        this.btnStopRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AbstractSearchResultsPanel.this.btnStopRefreshInRefreshMode) {
                    AbstractSearchResultsPanel.this.modifyCriteria();
                } else {
                    AbstractSearchResultsPanel.this.getSearchComposition().terminate();
                }
            }
        });
        this.btnStopRefresh.setToolTipText(UiUtils.getText("TEXT_BUTTON_STOP"));
        this.btnStopRefresh.setIcon(ImageUtilities.loadImageIcon((String)STOP_ICON, (boolean)true));
        this.btnStopRefresh.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TEXT_BUTTON_STOP"));
    }

    private void initExpandButton() {
        this.sizeButton(this.btnExpand);
        this.btnExpand.setIcon(ImageUtilities.loadImageIcon((String)EXPAND_ICON, (boolean)true));
        this.btnExpand.setSelectedIcon(ImageUtilities.loadImageIcon((String)COLLAPSE_ICON, (boolean)true));
        this.btnExpand.setToolTipText(UiUtils.getText("TEXT_BUTTON_EXPAND"));
        this.btnExpand.setEnabled(false);
        this.btnExpand.setSelected(false);
    }

    private void initNextButton() {
        this.sizeButton(this.btnNext);
        this.btnNext.setIcon(ImageUtilities.loadImageIcon((String)NEXT_ICON, (boolean)true));
        this.btnNext.setToolTipText(UiUtils.getText("TEXT_BUTTON_NEXT_MATCH"));
        this.btnNext.setEnabled(false);
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSearchResultsPanel.this.shift(1);
            }
        });
    }

    private void initPrevButton() {
        this.sizeButton(this.btnPrev);
        this.btnPrev.setIcon(ImageUtilities.loadImageIcon((String)PREV_ICON, (boolean)true));
        this.btnPrev.setToolTipText(UiUtils.getText("TEXT_BUTTON_PREV_MATCH"));
        this.btnPrev.setEnabled(false);
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractSearchResultsPanel.this.shift(-1);
            }
        });
    }

    protected void sizeButton(AbstractButton abstractButton) {
        Dimension dimension = new Dimension(24, 24);
        abstractButton.setMinimumSize(dimension);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setPreferredSize(dimension);
    }

    protected JPanel getContentPanel() {
        return this.contentPanel;
    }

    protected SearchComposition<?> getSearchComposition() {
        return this.searchComposition;
    }

    public void searchStarted() {
    }

    public void searchFinished() {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                AbstractSearchResultsPanel.this.showRefreshButton();
            }
        });
    }

    protected void showRefreshButton() {
        this.btnStopRefresh.setToolTipText(UiUtils.getText("TEXT_BUTTON_CUSTOMIZE"));
        this.btnStopRefresh.setIcon(ImageUtilities.loadImageIcon((String)REFRESH_ICON, (boolean)true));
        this.btnStopRefresh.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnStopRefreshInRefreshMode = true;
    }

    protected void modifyCriteria() {
        if (this.searchProviderPresenter != null) {
            if (this.searchProviderPresenter.isReplacing()) {
                SearchControl.openReplaceDialog(this.searchProviderPresenter);
            } else {
                SearchControl.openFindDialog(this.searchProviderPresenter);
            }
        }
    }

    protected void addButton(AbstractButton abstractButton) {
        this.toolBar.add(abstractButton);
    }

    protected void toggleExpand(Node node, boolean bl) {
        if (bl) {
            this.getOutlineView().expandNode(node);
        }
        for (Node node2 : node.getChildren().getNodes()) {
            this.toggleExpand(node2, bl);
        }
        if (!bl) {
            this.getOutlineView().collapseNode(node);
        }
    }

    protected abstract OutlineView getOutlineView();

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("jumpNext", new PrevNextAction(1));
        actionMap.put("jumpPrev", new PrevNextAction(-1));
    }

    private void initSelectionListeners() {
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractSearchResultsPanel.this.updateShiftButtons();
                        }
                    });
                }
            }
        });
    }

    protected void updateShiftButtons() {
        if (this.btnPrev.isVisible() && this.btnNext.isVisible()) {
            this.btnPrev.setEnabled(this.findShiftNode(-1, this.getOutlineView(), false) != null);
            this.btnNext.setEnabled(this.findShiftNode(1, this.getOutlineView(), false) != null);
        }
    }

    private void shift(int n) {
        Node node = this.findShiftNode(n, this.getOutlineView(), true);
        if (node != null) {
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
                this.onDetailShift(node);
            }
            catch (PropertyVetoException propertyVetoException) {
                Exceptions.printStackTrace((Throwable)propertyVetoException);
            }
        }
    }

    protected void afterMatchingNodeAdded() {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                if (AbstractSearchResultsPanel.this.btnNext.isVisible() && !AbstractSearchResultsPanel.this.btnNext.isEnabled()) {
                    AbstractSearchResultsPanel.this.updateShiftButtons();
                }
            }
        });
    }

    protected void onDetailShift(Node node) {
    }

    private Node findShiftNode(int n, OutlineView outlineView, boolean bl) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        Node node = null;
        if (nodeArray == null || nodeArray.length == 0) {
            node = this.getExplorerManager().getRootContext();
        } else if (nodeArray.length == 1) {
            node = nodeArray[0];
        }
        return node == null ? null : this.findDetailNode(node, n, outlineView, bl);
    }

    Node findDetailNode(Node node, int n, OutlineView outlineView, boolean bl) {
        return this.findUp(node, n, this.isDetailNode(node) || n < 0 ? n : 0, outlineView, bl);
    }

    Node findUp(Node node, int n, int n2, OutlineView outlineView, boolean bl) {
        if (node == null) {
            return null;
        }
        Node node2 = node.getParentNode();
        Node[] nodeArray = node2 == null ? new Node[]{node} : AbstractSearchResultsPanel.getChildren(node2, outlineView, bl);
        int n3 = AbstractSearchResultsPanel.findChildIndex(node, nodeArray);
        if (n3 + n2 < 0 || n3 + n2 >= nodeArray.length) {
            return this.findUp(node2, n, n, outlineView, bl);
        }
        int n4 = n3 + n2;
        if (n4 >= 0 && n4 < nodeArray.length) {
            Node node3 = this.findDown(nodeArray[n4], nodeArray, n4, n, outlineView, bl);
            return node3;
        }
        return this.findUp(node2, n, n2, outlineView, bl);
    }

    private Node findDown(Node node, Node[] nodeArray, int n, int n2, OutlineView outlineView, boolean bl) {
        int n3;
        Node[] nodeArray2 = AbstractSearchResultsPanel.getChildren(node, outlineView, bl);
        int n4 = n3 = n2 > 0 ? 0 : nodeArray2.length - 1;
        while (n3 >= 0 && n3 < nodeArray2.length) {
            Node node2 = this.findDown(nodeArray2[n3], nodeArray2, n3, n2, outlineView, bl);
            if (node2 != null) {
                return node2;
            }
            n3 += n2;
        }
        for (n3 = n; n3 >= 0 && n3 < nodeArray.length; n3 += n2) {
            if (!this.isDetailNode(nodeArray[n3])) continue;
            return nodeArray[n3];
        }
        return null;
    }

    protected abstract boolean isDetailNode(Node var1);

    private static int findChildIndex(Node node, Node[] nodeArray) {
        int n = -1;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] != node) continue;
            n = i;
            break;
        }
        return n;
    }

    private static Node[] getChildren(Node node, OutlineView outlineView, boolean bl) {
        if (outlineView != null) {
            if (!outlineView.isExpanded(node)) {
                if (bl) {
                    outlineView.expandNode(node);
                } else {
                    return node.getChildren().getNodes(true);
                }
            }
            return AbstractSearchResultsPanel.getChildrenInDisplayedOrder(node, outlineView);
        }
        return node.getChildren().getNodes(true);
    }

    private static Node[] getChildrenInDisplayedOrder(Node node, OutlineView outlineView) {
        Outline outline = outlineView.getOutline();
        Node[] nodeArray = node.getChildren().getNodes(true);
        int n = outlineView.getOutline().getRowCount();
        int n2 = AbstractSearchResultsPanel.findRowIndexInOutline(node, outline, n);
        if (n2 == -1) {
            return nodeArray;
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        for (int i = n2 + 1; i < n; ++i) {
            int n3 = outline.convertRowIndexToModel(i);
            if (n3 == -1) continue;
            Object object = outline.getModel().getValueAt(n3, 0);
            Node node2 = Visualizer.findNode((Object)object);
            if (node2.getParentNode() == node) {
                linkedList.add(node2);
                continue;
            }
            if (linkedList.size() == nodeArray.length) break;
        }
        return linkedList.toArray(new Node[linkedList.size()]);
    }

    private static int findRowIndexInOutline(Node node, Outline outline, int n) {
        int n2 = Math.max(outline.getSelectedRow(), 0);
        int n3 = 0;
        while (n2 + n3 < n || n2 - n3 >= 0) {
            int n4 = n2 + n3 + 1;
            int n5 = n2 - n3;
            if (n4 < n && AbstractSearchResultsPanel.testNodeInRow(outline, node, n4)) {
                return n4;
            }
            if (n5 >= 0 && AbstractSearchResultsPanel.testNodeInRow(outline, node, n5)) {
                return n5;
            }
            ++n3;
        }
        return -1;
    }

    private static boolean testNodeInRow(Outline outline, Node node, int n) {
        Object object;
        Node node2;
        int n2 = outline.convertRowIndexToModel(n);
        return n2 != -1 && (node2 = Visualizer.findNode((Object)(object = outline.getModel().getValueAt(n2, 0)))) == node;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private final class PrevNextAction
    extends AbstractAction {
        private int direction;

        public PrevNextAction(int n) {
            this.direction = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractSearchResultsPanel.this.shift(this.direction);
        }
    }

    private static class RootNodeChildren
    extends Children.Keys<Node> {
        private Node[] standard;
        private Node[] withInfo;
        private boolean infoNodeShown = false;

        public RootNodeChildren(Node node, Node node2) {
            this.standard = new Node[]{node};
            this.withInfo = new Node[]{node, node2};
            this.setKeys(this.standard);
        }

        private synchronized void showInfoNode() {
            if (!this.infoNodeShown) {
                this.setKeys(this.withInfo);
                this.infoNodeShown = true;
            }
        }

        protected Node[] createNodes(Node node) {
            return new Node[]{node};
        }
    }

    static class RootNode
    extends AbstractNode {
        Node resultsNode;
        Node infoNode;

        public RootNode(Node node, Node node2) {
            this(node, node2, new RootNodeChildren(node, node2));
        }

        private RootNode(Node node, Node node2, RootNodeChildren rootNodeChildren) {
            super((Children)rootNodeChildren);
            this.infoNode = node2;
            this.resultsNode = node;
            if (node2 != null) {
                this.setInfoNodeListener(rootNodeChildren);
            }
        }

        private void setInfoNodeListener(final RootNodeChildren rootNodeChildren) {
            assert (this.infoNode != null);
            this.infoNode.getChildren().getNodes(true);
            this.infoNode.addNodeListener((NodeListener)new NodeAdapter(){
                private boolean added = false;

                public synchronized void childrenAdded(NodeMemberEvent nodeMemberEvent) {
                    if (!this.added) {
                        rootNodeChildren.showInfoNode();
                        RootNode.this.infoNode.removeNodeListener((NodeListener)this);
                        this.added = true;
                    }
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    super.propertyChange(propertyChangeEvent);
                }

                public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
                    super.childrenReordered(nodeReorderEvent);
                }
            });
        }
    }
}

