/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import javax.swing.JComponent;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.BasicReplaceResultsPanel;
import org.netbeans.modules.search.ui.BasicSearchResultsPanel;
import org.netbeans.spi.search.provider.SearchResultsDisplayer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class ResultDisplayer
extends SearchResultsDisplayer<MatchingObject.Def> {
    private ResultModel resultModel;
    private BasicSearchCriteria criteria;
    private BasicComposition composition;
    private BasicAbstractResultsPanel resultPanel;
    private Node infoNode;

    public ResultDisplayer(BasicSearchCriteria basicSearchCriteria, BasicComposition basicComposition) {
        this.criteria = basicSearchCriteria;
        this.resultModel = new ResultModel(basicSearchCriteria, basicSearchCriteria.getReplaceString());
        this.composition = basicComposition;
    }

    @Override
    public synchronized JComponent getVisualComponent() {
        if (this.resultPanel != null) {
            return this.resultPanel;
        }
        this.resultPanel = this.criteria.isSearchAndReplace() ? new BasicReplaceResultsPanel(this.resultModel, this.composition, this.infoNode) : new BasicSearchResultsPanel(this.resultModel, this.composition, this.criteria.isFullText(), this.infoNode);
        this.resultPanel.setToolTipText(this.composition.getScopeDisplayName() + ": " + this.getTitle());
        return this.resultPanel;
    }

    @Override
    public void addMatchingObject(MatchingObject.Def def) {
        if (this.resultModel.objectFound(def.getFileObject(), def.getCharset(), def.getTextDetails())) {
            this.resultPanel.update();
            this.resultPanel.addMatchingObject(this.resultModel.getMatchingObjects().get(this.resultModel.size() - 1));
        }
        if (this.resultModel.wasLimitReached()) {
            this.composition.terminate();
        }
    }

    ResultModel getResultModel() {
        return this.resultModel;
    }

    @Override
    public String getTitle() {
        if (this.criteria.getTextPattern() == null) {
            if (this.criteria.getFileNamePattern() == null) {
                return NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_RESULTS_FOR_FILE_PATTERN");
            }
            return this.criteria.getFileNamePatternExpr();
        }
        return this.criteria.getTextPatternExpr();
    }

    @Override
    public void searchStarted() {
        this.resultModel.setStartTime();
        this.resultPanel.searchStarted();
    }

    @Override
    public void searchFinished() {
        this.resultPanel.searchFinished();
    }

    @Override
    public void setInfoNode(Node node) {
        this.infoNode = node;
    }

    @Override
    public void closed() {
        this.resultPanel.closed();
    }
}

