/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.search.RegexpUtil;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.ui.ComponentController;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ListComboBoxModel;
import org.netbeans.modules.search.ui.PatternChangeListener;
import org.netbeans.modules.search.ui.TextFieldFocusListener;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.util.Exceptions;

public final class FileNameController
extends ComponentController<JComboBox> {
    private FileNamePatternWatcher fileNamePatternWatcher;
    private JTextComponent fileNamePatternEditor;
    private boolean regexp = false;
    private boolean ignoreFileNamePatternChanges;
    private boolean patternValid;
    private Color defaultColor;

    FileNameController(JComboBox jComboBox) {
        super(jComboBox);
        this.init();
    }

    private void init() {
        Component component = ((JComboBox)this.component).getEditor().getEditorComponent();
        this.fileNamePatternEditor = (JTextComponent)component;
        this.fileNamePatternWatcher = new FileNamePatternWatcher(this.fileNamePatternEditor);
        this.fileNamePatternEditor.addFocusListener(this.fileNamePatternWatcher);
        this.fileNamePatternEditor.addHierarchyListener(this.fileNamePatternWatcher);
        this.fileNamePatternEditor.getDocument().addDocumentListener(new FileNameChangeListener());
        this.defaultColor = ((JComboBox)this.component).getForeground();
        ((JComboBox)this.component).setEditable(true);
        List<String> list = FindDialogMemory.getDefault().getFileNamePatterns();
        if (!list.isEmpty()) {
            ((JComboBox)this.component).setModel(new ListComboBoxModel(list, true));
        }
    }

    public String getFileNamePattern() {
        if (this.isAllFilesInfoDisplayed()) {
            return "";
        }
        return this.fileNamePatternEditor.getText();
    }

    public void setFileNamePattern(String string) {
        ((JComboBox)this.component).setSelectedItem(string);
    }

    public boolean isRegularExpression() {
        return this.regexp;
    }

    public boolean isAllFilesInfoDisplayed() {
        return this.fileNamePatternWatcher.infoDisplayed;
    }

    public void setRegularExpression(boolean bl) {
        this.regexp = bl;
        this.setFileNamePatternToolTip();
        this.patternChanged();
    }

    public void displayAllFilesInfo() {
        this.fileNamePatternWatcher.displayInfo();
    }

    public void hideAllFilesInfo() {
        this.fileNamePatternWatcher.hideInfo();
    }

    private void setFileNamePatternToolTip() {
        String string = this.regexp ? null : UiUtils.getText("BasicSearchForm.cboxFileNamePattern.tooltip");
        ((JComboBox)this.component).setToolTipText(string);
    }

    private void patternChanged() {
        if (!this.ignoreFileNamePatternChanges) {
            this.updateFileNamePatternColor();
            this.fireChange();
        }
    }

    private void updateFileNamePatternColor() {
        boolean bl = this.patternValid;
        String string = this.getFileNamePattern();
        if (string == null || string.isEmpty()) {
            this.patternValid = true;
        } else {
            try {
                Pattern pattern = RegexpUtil.makeFileNamePattern(SearchScopeOptions.create(this.getFileNamePattern(), this.regexp));
                this.patternValid = pattern != null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.patternValid = false;
            }
        }
        if (this.patternValid != bl && !this.isAllFilesInfoDisplayed()) {
            this.fileNamePatternEditor.setForeground(this.patternValid ? this.defaultColor : UiUtils.getErrorTextColor());
        }
    }

    private final class FileNameChangeListener
    extends PatternChangeListener {
        private FileNameChangeListener() {
        }

        @Override
        public void handleComboBoxChange(String string) {
            FileNameController.this.patternChanged();
        }
    }

    private final class FileNamePatternWatcher
    extends TextFieldFocusListener
    implements HierarchyListener {
        private final JTextComponent txtComp;
        private final Document doc;
        private Color foregroundColor;
        private String infoText;
        private boolean infoDisplayed;
        private final Logger watcherLogger = Logger.getLogger(this.getClass().getName());

        private FileNamePatternWatcher(JTextComponent jTextComponent) {
            this.txtComp = jTextComponent;
            this.doc = jTextComponent.getDocument();
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if (hierarchyEvent.getComponent() != this.txtComp || (hierarchyEvent.getChangeFlags() & 2L) == 0L || !this.txtComp.isDisplayable()) {
                return;
            }
            this.watcherLogger.finer("componentShown()");
            if (this.foregroundColor == null) {
                this.foregroundColor = this.txtComp.getForeground();
            }
            if (this.doc.getLength() == 0 && !this.txtComp.isFocusOwner()) {
                this.displayInfo();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.infoDisplayed) {
                this.hideInfo();
            }
            super.focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            super.focusLost(focusEvent);
            if (this.isEmptyText()) {
                this.displayInfo();
            }
        }

        private boolean isEmptyText() {
            String string;
            int n = this.doc.getLength();
            if (n == 0) {
                return true;
            }
            try {
                string = this.doc.getText(0, n);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
                string = null;
            }
            return string != null && string.trim().length() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void displayInfo() {
            assert (this.isEmptyText() && !this.txtComp.isFocusOwner());
            this.watcherLogger.finer("displayInfo()");
            try {
                this.txtComp.setForeground(this.txtComp.getDisabledTextColor());
                FileNameController.this.ignoreFileNamePatternChanges = true;
                this.doc.remove(0, this.doc.getLength());
                this.doc.insertString(0, this.getInfoText(), null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                FileNameController.this.ignoreFileNamePatternChanges = false;
                this.infoDisplayed = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hideInfo() {
            this.watcherLogger.finer("hideInfo()");
            this.txtComp.setEnabled(true);
            try {
                FileNameController.this.ignoreFileNamePatternChanges = true;
                if (this.doc.getText(0, this.doc.getLength()).equals(this.getInfoText())) {
                    this.doc.remove(0, this.doc.getLength());
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            finally {
                FileNameController.this.ignoreFileNamePatternChanges = false;
                this.txtComp.setForeground(this.foregroundColor);
                this.infoDisplayed = false;
            }
        }

        private String getInfoText() {
            if (this.infoText == null) {
                this.infoText = UiUtils.getText("BasicSearchForm.cboxFileNamePattern.allFiles");
            }
            return this.infoText;
        }
    }
}

