/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterAbortException;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.awt.UndoRedo;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupportRedirector;
import org.openide.text.EditorSupportLineSet;
import org.openide.text.EnhancedChangeEvent;
import org.openide.text.FilterDocument;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.text.PrintPreferences;
import org.openide.text.UndoRedoManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public abstract class CloneableEditorSupport
extends CloneableOpenSupport {
    private static final RequestProcessor RP = new RequestProcessor("org.openide.text Document Processing");
    public static final String EDITOR_MODE = "editor";
    public static final UndoableEdit BEGIN_COMMIT_GROUP = UndoRedoManager.BEGIN_COMMIT_GROUP;
    public static final UndoableEdit END_COMMIT_GROUP = UndoRedoManager.END_COMMIT_GROUP;
    public static final UndoableEdit MARK_COMMIT_GROUP = UndoRedoManager.MARK_COMMIT_GROUP;
    private static final String PROP_PANE = "CloneableEditorSupport.Pane";
    private static final int DOCUMENT_NO = 0;
    private static final int DOCUMENT_LOADING = 1;
    private static final int DOCUMENT_READY = 2;
    private static final int DOCUMENT_RELOADING = 3;
    private static final ThreadLocal<Boolean> LOCAL_LOAD_TASK = new ThreadLocal();
    private static final ThreadLocal<Boolean> LOCAL_CLOSE_DOCUMENT = new ThreadLocal();
    private static final Logger ERR = Logger.getLogger("org.openide.text.CloneableEditorSupport");
    private boolean inUserQuestionExceptionHandler;
    private Task prepareTask;
    private EditorKit kit;
    private StrongRef doc;
    private final Object LOCK_STRONG_REF = new Object();
    private boolean isStrongSet = false;
    private int counterGetDocument = 0;
    private int counterOpenDocument = 0;
    private int counterPrepareDocument = 0;
    private int counterOpenAtImpl = 0;
    private String mimeType;
    private Listener listener;
    private UndoRedo.Manager undoRedo;
    private Line.Set lineSet;
    private boolean printing;
    private final Object LOCK_PRINTING = new Object();
    private PositionRef.Manager positionManager;
    private Set<ChangeListener> listeners;
    private transient Reference<Pane> lastSelected;
    private long lastSaveTime;
    private boolean reloadDialogOpened;
    private PropertyChangeSupport propertyChangeSupport;
    private Lookup lookup;
    private boolean alreadyModified;
    private boolean documentReloading;
    private volatile int documentStatus = 0;
    private Throwable prepareDocumentRuntimeException;
    private Map<Line, Reference<Line>> lineSetWHM;
    private boolean annotationsLoaded;
    private DocFilter docFilter;
    private final Object LOCK_NOTIFY_MODIFIED = new Object();
    private static final Set<Class> warnedClasses = new WeakSet();
    private boolean reloadDocumentFireDocumentChangeClose = false;
    private boolean reloadDocumentFireDocumentChangeOpen = false;
    private static Reference<CloneableTopComponent> lastReusable = new WeakReference<Object>(null);

    public CloneableEditorSupport(Env env) {
        this(env, Lookup.EMPTY);
    }

    public CloneableEditorSupport(Env env, Lookup lookup) {
        super((CloneableOpenSupport.Env)env);
        Parameters.notNull((CharSequence)"l", (Object)lookup);
        this.lookup = lookup;
    }

    protected abstract String messageSave();

    protected abstract String messageName();

    protected String messageHtmlName() {
        return null;
    }

    protected String documentID() {
        return this.messageName();
    }

    protected abstract String messageToolTip();

    protected String messageLine(Line line) {
        return NbBundle.getMessage(Line.class, (String)"FMT_CESLineDisplayName", (Object)this.messageName(), (Object)(line.getLineNumber() + 1));
    }

    final Env cesEnv() {
        return (Env)this.env;
    }

    final EditorKit cesKit() {
        return this.kit;
    }

    protected final synchronized UndoRedo.Manager getUndoRedo() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getUndoRedo();
        }
        if (this.undoRedo == null) {
            UndoRedo.Manager manager;
            this.undoRedo = manager = this.createUndoRedoManager();
        }
        return this.undoRedo;
    }

    final synchronized PositionRef.Manager getPositionManager() {
        if (this.positionManager == null) {
            this.positionManager = new PositionRef.Manager(this);
        }
        return this.positionManager;
    }

    void ensureAnnotationsLoaded() {
        if (!this.annotationsLoaded) {
            this.annotationsLoaded = true;
            Line.Set set = this.getLineSet();
            for (AnnotationProvider annotationProvider : Lookup.getDefault().lookupAll(AnnotationProvider.class)) {
                annotationProvider.annotate(set, this.lookup);
            }
        }
    }

    private void askUserAndDoOpen(UserQuestionException userQuestionException, Callable<Void> callable) {
        while (userQuestionException != null) {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
            confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                try {
                    userQuestionException.confirmed();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return;
                }
            } else {
                return;
            }
            userQuestionException = null;
            try {
                callable.call();
            }
            catch (UserQuestionException userQuestionException2) {
                userQuestionException = userQuestionException2;
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
            }
            catch (Exception exception) {
                ERR.log(Level.SEVERE, null, exception);
            }
        }
    }

    protected boolean asynchronousOpen() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        if (warnedClasses.add(clazz)) {
            ERR.warning(clazz.getName() + " should override asynchronousOpen()." + " See http://bits.netbeans.org/dev/javadoc/org-openide-text/apichanges.html#CloneableEditorSupport.asynchronousOpen");
        }
        return false;
    }

    public void open() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.open();
            return;
        }
        if (this.getListener().loadExc instanceof UserQuestionException) {
            this.getListener().loadExc = null;
            this.documentStatus = 0;
        }
        if (this.asynchronousOpen()) {
            super.open();
        } else {
            try {
                StyledDocument styledDocument = this.openDocument();
                super.open();
            }
            catch (UserQuestionException userQuestionException) {
                class Query
                implements Runnable,
                Callable<Void> {
                    Query() {
                    }

                    @Override
                    public void run() {
                        CloneableEditorSupport.this.askUserAndDoOpen(userQuestionException, this);
                    }

                    @Override
                    public Void call() throws IOException {
                        CloneableEditorSupport.this.getListener().loadExc = null;
                        CloneableEditorSupport.this.documentStatus = 0;
                        StyledDocument styledDocument = CloneableEditorSupport.this.openDocument();
                        CloneableEditorSupport.super.open();
                        return null;
                    }
                }
                Query query = new Query();
                Mutex.EVENT.readAccess((Runnable)query);
            }
            catch (IOException iOException) {
                ERR.log(Level.INFO, null, iOException);
            }
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }
        return this.propertyChangeSupport;
    }

    private boolean canReleaseDoc() {
        return this.counterGetDocument == 0 && this.counterOpenDocument == 0 && this.counterPrepareDocument == 0 && this.counterOpenAtImpl == 0;
    }

    void checkReleaseDoc() {
        if (this.isStrongSet && this.canReleaseDoc()) {
            this.isStrongSet = false;
            this.setStrong(false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task prepareDocument() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.prepareDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            final StyledDocument styledDocument = this.getDoc();
            if (styledDocument == null && this.documentStatus != 0) {
                this.closeDocument();
            }
            switch (this.documentStatus) {
                case 0: {
                    Task task;
                    this.documentStatus = 1;
                    ++this.counterPrepareDocument;
                    this.prepareTask = task = this.prepareDocument(false);
                    task.addTaskListener(new TaskListener(){

                        public void taskFinished(Task task) {
                            CloneableEditorSupport.this.counterPrepareDocument--;
                            CloneableEditorSupport.this.checkReleaseDoc();
                            task.removeTaskListener((TaskListener)this);
                        }
                    });
                    return task;
                }
                case 2: {
                    assert (styledDocument != null);
                    Task task = new Task(new Runnable(){
                        private final StyledDocument d;
                        {
                            this.d = styledDocument;
                        }

                        @Override
                        public void run() {
                        }
                    });
                    task.run();
                    return task;
                }
            }
            if (this.prepareTask == null) {
                throw new IllegalStateException();
            }
            return this.prepareTask;
        }
    }

    private Task prepareDocument(boolean bl) {
        assert (Thread.holdsLock(this.getLock()));
        if (this.prepareTask != null) {
            return this.prepareTask;
        }
        boolean bl2 = true;
        Task task = null;
        try {
            this.env.removePropertyChangeListener((PropertyChangeListener)this.getListener());
            this.env.addPropertyChangeListener((PropertyChangeListener)this.getListener());
            this.kit = this.createEditorKit();
            final StyledDocument[] styledDocumentArray = new StyledDocument[]{this.getDoc()};
            if (styledDocumentArray[0] == null) {
                styledDocumentArray[0] = this.createStyledDocument(this.kit);
                this.setDoc(styledDocumentArray[0], true);
                this.isStrongSet = true;
            } else {
                this.setDoc(styledDocumentArray[0], true);
                this.isStrongSet = true;
            }
            task = this.prepareTask = RP.create(new Runnable(){
                private boolean runningInAtomicLock;
                private boolean fireEvent;
                private StyledDocument d;
                {
                    this.d = CloneableEditorSupport.this.getDoc();
                }

                @Override
                public void run() {
                    this.doRun();
                    styledDocumentArray[0] = null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void doRun() {
                    if (!this.runningInAtomicLock) {
                        this.runningInAtomicLock = true;
                        NbDocument.runAtomic(styledDocumentArray[0], this);
                        if (this.fireEvent) {
                            CloneableEditorSupport.this.fireDocumentChange(this.d, false);
                        }
                        return;
                    }
                    Object object = CloneableEditorSupport.this.getLock();
                    synchronized (object) {
                        if (CloneableEditorSupport.this.documentStatus == 0) {
                            CloneableEditorSupport.this.prepareTask = null;
                            return;
                        }
                        if (CloneableEditorSupport.this.getDoc() != styledDocumentArray[0]) {
                            CloneableEditorSupport.this.prepareTask = null;
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                        int n = 0;
                        try {
                            CloneableEditorSupport.this.getListener().run();
                            CloneableEditorSupport.this.documentStatus = 2;
                            this.fireEvent = true;
                            n = 2;
                            Object object2 = CloneableEditorSupport.this.getUndoRedo();
                            if (object2 instanceof UndoRedoManager) {
                                ((UndoRedoManager)((Object)object2)).markSavepoint();
                            }
                            CloneableEditorSupport.this.getDoc().addUndoableEditListener((UndoableEditListener)object2);
                        }
                        catch (DelegateIOExc delegateIOExc) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = delegateIOExc;
                        }
                        catch (RuntimeException runtimeException) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = runtimeException;
                            Exceptions.printStackTrace((Throwable)runtimeException);
                            throw runtimeException;
                        }
                        catch (Error error) {
                            CloneableEditorSupport.this.prepareDocumentRuntimeException = error;
                            Exceptions.printStackTrace((Throwable)error);
                            throw error;
                        }
                        finally {
                            Object object3 = CloneableEditorSupport.this.getLock();
                            synchronized (object3) {
                                CloneableEditorSupport.this.documentStatus = n;
                                CloneableEditorSupport.this.getLock().notifyAll();
                                CloneableEditorSupport.this.prepareTask = null;
                            }
                        }
                    }
                }
            });
            ((RequestProcessor.Task)task).schedule(0);
            if (RP.isRequestProcessorThread()) {
                task.waitFinished();
            }
            bl2 = false;
        }
        catch (RuntimeException runtimeException) {
            this.prepareDocumentRuntimeException = runtimeException;
            throw runtimeException;
        }
        catch (Error error) {
            this.prepareDocumentRuntimeException = error;
            throw error;
        }
        finally {
            if (bl2) {
                this.documentStatus = 0;
                this.getLock().notifyAll();
            }
        }
        assert (task != null) : "CloneableEditorSupport.prepareDocument must return non null value";
        return task;
    }

    final void addRemoveDocListener(Document document, boolean bl) {
        if (document == null) {
            return;
        }
        if (Boolean.TRUE.equals(document.getProperty("supportsModificationListener"))) {
            if (bl) {
                document.putProperty("modificationListener", this.getListener());
            } else {
                document.putProperty("modificationListener", null);
            }
        }
        if (bl) {
            if (document instanceof AbstractDocument) {
                AbstractDocument abstractDocument = (AbstractDocument)document;
                DocumentFilter documentFilter = abstractDocument.getDocumentFilter();
                this.docFilter = new DocFilter(documentFilter);
                abstractDocument.setDocumentFilter(this.docFilter);
            } else {
                DocumentFilter documentFilter = (DocumentFilter)document.getProperty(DocumentFilter.class);
                this.docFilter = new DocFilter(documentFilter);
                document.putProperty(DocumentFilter.class, this.docFilter);
            }
            document.addDocumentListener(this.getListener());
        } else {
            if (this.docFilter != null) {
                if (document instanceof AbstractDocument) {
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.setDocumentFilter(this.docFilter.origFilter);
                } else {
                    document.putProperty(DocumentFilter.class, this.docFilter.origFilter);
                }
                this.docFilter = null;
            }
            document.removeDocumentListener(this.getListener());
        }
    }

    private void clearDocument() {
        NbDocument.runAtomic(this.getDoc(), new Runnable(){

            @Override
            public void run() {
                try {
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), false);
                    CloneableEditorSupport.this.getDoc().remove(0, CloneableEditorSupport.this.getDoc().getLength());
                    CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), true);
                }
                catch (BadLocationException badLocationException) {
                    ERR.log(Level.INFO, null, badLocationException);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public StyledDocument openDocument() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.openDocument();
        }
        Object object = this.getLock();
        synchronized (object) {
            boolean bl = false;
            try {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = this.getDoc();
                if (styledDocument2 == null && this.documentStatus != 0) {
                    this.closeDocument();
                }
                if (this.documentStatus == 2 || this.documentStatus == 1 || this.documentStatus == 3) {
                    ++this.counterOpenDocument;
                    bl = true;
                    this.setStrong(true, true);
                }
                try {
                    ++this.counterOpenDocument;
                    styledDocument = styledDocument2 = this.openDocumentCheckIOE();
                    --this.counterOpenDocument;
                }
                catch (Throwable throwable) {
                    --this.counterOpenDocument;
                    throw throwable;
                }
                return styledDocument;
            }
            finally {
                if (bl) {
                    --this.counterOpenDocument;
                }
                this.checkReleaseDoc();
            }
        }
    }

    private StyledDocument openDocumentCheckIOE() throws IOException {
        StyledDocument styledDocument = this.openDocumentImpl();
        IOException iOException = this.getListener().checkLoadException();
        if (iOException != null) {
            throw iOException;
        }
        return styledDocument;
    }

    private StyledDocument openDocumentImpl() throws IOException, InterruptedIOException {
        switch (this.documentStatus) {
            case 0: {
                this.documentStatus = 1;
                this.prepareDocument(false);
                return this.openDocumentImpl();
            }
            case 2: 
            case 3: {
                StyledDocument styledDocument = this.getDoc();
                assert (styledDocument != null) : "no document although status is " + this.documentStatus + "; doc=" + this.doc;
                return styledDocument;
            }
        }
        try {
            this.getLock().wait();
        }
        catch (InterruptedException interruptedException) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(interruptedException);
        }
        if (this.prepareDocumentRuntimeException != null) {
            if (this.prepareDocumentRuntimeException instanceof DelegateIOExc) {
                Exception exception = new Exception(this.prepareDocumentRuntimeException);
                ERR.log(Level.INFO, "Outer callstack", exception);
                throw (IOException)this.prepareDocumentRuntimeException.getCause();
            }
            if (this.prepareDocumentRuntimeException instanceof Error) {
                throw (Error)this.prepareDocumentRuntimeException;
            }
            throw (RuntimeException)this.prepareDocumentRuntimeException;
        }
        return this.openDocumentImpl();
    }

    Throwable getPrepareDocumentRuntimeException() {
        return this.prepareDocumentRuntimeException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public StyledDocument getDocument() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getDocument();
        }
        if (this.documentStatus == 0 || this.documentStatus == 1) {
            return null;
        }
        Object object = this.getLock();
        synchronized (object) {
            StyledDocument styledDocument = this.getDoc();
            if (styledDocument == null && this.documentStatus != 0) {
                this.closeDocument();
            }
            switch (this.documentStatus) {
                case 0: {
                    return null;
                }
                case 1: {
                    return null;
                }
            }
            if (LOCAL_LOAD_TASK.get() != null) {
                return this.getDoc();
            }
            try {
                StyledDocument styledDocument2;
                ++this.counterGetDocument;
                this.setStrong(true, true);
                try {
                    styledDocument2 = styledDocument = this.openDocumentCheckIOE();
                }
                catch (IOException iOException) {
                    StyledDocument styledDocument3 = null;
                    --this.counterGetDocument;
                    this.checkReleaseDoc();
                    return styledDocument3;
                }
                return styledDocument2;
            }
            finally {
                --this.counterGetDocument;
                this.checkReleaseDoc();
            }
        }
    }

    public boolean isModified() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isModified();
        }
        return this.cesEnv().isModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        Object object;
        long l;
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        final boolean bl = ERR.isLoggable(Level.FINE);
        if (bl) {
            ERR.fine(this.documentID() + ": saveDocument() started.");
        }
        if (cloneableEditorSupport != null) {
            if (bl) {
                ERR.fine("  redirect to " + cloneableEditorSupport.documentID());
            }
            cloneableEditorSupport.saveDocument();
            return;
        }
        if (!this.cesEnv().isModified()) {
            if (bl) {
                ERR.fine(this.documentID() + "  No save performed because cesEnv().isModified() == false");
            }
            return;
        }
        final StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            if (bl) {
                ERR.fine(this.documentID() + "  No save performed because getDocument() == null");
            }
            return;
        }
        long l2 = this.lastSaveTime;
        if (l2 != -1L && (l = this.cesEnv().getTime().getTime()) > l2) {
            if (bl) {
                ERR.fine(this.documentID() + ":  externalMod=" + l + " > prevLST=" + l2 + " => throw new UserQuestionException()");
            }
            throw new UserQuestionException(this.mimeType){

                public String getLocalizedMessage() {
                    return NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change_write", (Object)styledDocument.getProperty("title"));
                }

                public void confirmed() throws IOException {
                    CloneableEditorSupport.this.setLastSaveTime(l);
                    CloneableEditorSupport.this.saveDocument();
                }
            };
        }
        class MemoryOutputStream
        extends ByteArrayOutputStream {
            public MemoryOutputStream(int n) {
                super(n);
            }

            @Override
            public void writeTo(OutputStream outputStream) throws IOException {
                outputStream.write(this.buf, 0, this.count);
            }
        }
        final MemoryOutputStream[] memoryOutputStreamArray = new MemoryOutputStream[1];
        final IOException[] iOExceptionArray = new IOException[1];
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){
            {
            }

            @Override
            public void run() {
                try {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    if (manager instanceof UndoRedoManager) {
                        UndoRedoManager undoRedoManager = (UndoRedoManager)manager;
                        if (blArray[0]) {
                            undoRedoManager.endOnSaveTasks();
                        }
                        undoRedoManager.markSavepoint();
                    }
                    int n = styledDocument.getLength() * 11 / 10;
                    memoryOutputStreamArray[0] = new MemoryOutputStream(n);
                    CloneableEditorSupport.this.saveFromKitToStream(styledDocument, CloneableEditorSupport.this.kit, memoryOutputStreamArray[0]);
                    CloneableEditorSupport.this.updateLineSet(true);
                    if (bl) {
                        ERR.fine(CloneableEditorSupport.this.documentID() + ": Saved " + memoryOutputStreamArray[0].size() + " bytes to memory output stream.");
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                catch (IOException iOException) {
                    iOExceptionArray[0] = iOException;
                }
            }
        };
        Runnable runnable2 = (Runnable)styledDocument.getProperty("beforeSaveRunnable");
        if (runnable2 != null) {
            object = new Runnable(){

                @Override
                public void run() {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    if (manager instanceof UndoRedoManager) {
                        ((UndoRedoManager)CloneableEditorSupport.this.undoRedo).startOnSaveTasks();
                        blArray[0] = true;
                    }
                }
            };
            styledDocument.putProperty("beforeSaveStart", object);
            styledDocument.putProperty("beforeSaveEnd", runnable);
            runnable2.run();
            if (memoryOutputStreamArray[0] == null) {
                styledDocument.render(runnable);
            }
        } else {
            styledDocument.render(runnable);
        }
        if (iOExceptionArray[0] != null) {
            if (bl) {
                ERR.log(Level.FINE, this.documentID() + ": Save broken due to IOException", iOExceptionArray[0]);
            }
            throw iOExceptionArray[0];
        }
        object = null;
        long l3 = this.lastSaveTime;
        try {
            this.setLastSaveTime(-1L);
            object = this.cesEnv().outputStream();
            memoryOutputStreamArray[0].writeTo((OutputStream)object);
            ((OutputStream)object).close();
            object = null;
            styledDocument.render(new Runnable(){

                @Override
                public void run() {
                    UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                    boolean bl = false;
                    if (manager instanceof UndoRedoManager) {
                        if (((UndoRedoManager)manager).isAtSavepoint()) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                    if (bl) {
                        CloneableEditorSupport.this.callNotifyUnmodified();
                    }
                }
            });
            if (bl) {
                ERR.fine(this.documentID() + ": Save to file OK, oldSaveTime: " + l3 + ", " + new Date(l3));
            }
            this.setLastSaveTime(this.cesEnv().getTime().getTime());
        }
        finally {
            if (this.lastSaveTime == -1L) {
                if (bl) {
                    ERR.fine(this.documentID() + ": Save failed (lastSaveTime == -1) restoring old save time.");
                }
                this.setLastSaveTime(l3);
                this.callNotifyModified();
            }
            if (object != null) {
                ((OutputStream)object).close();
            }
        }
    }

    public JEditorPane[] getOpenedPanes() {
        assert (SwingUtilities.isEventDispatchThread()) : "CloneableEditorSupport.getOpenedPanes() must be called from AWT thread only";
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getOpenedPanes();
        }
        LinkedList<JEditorPane> linkedList = new LinkedList<JEditorPane>();
        Enumeration enumeration = this.allEditors.getComponents();
        Pane pane = this.getLastSelected();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane2 = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane2 == null && cloneableTopComponent instanceof Pane) {
                pane2 = (Pane)cloneableTopComponent;
            }
            if (pane2 != null) {
                JEditorPane jEditorPane = pane2.getEditorPane();
                if (jEditorPane == null) continue;
                if (pane == pane2 || pane != null && pane instanceof Component && pane2 instanceof Container && ((Container)((Object)pane2)).isAncestorOf((Component)((Object)pane))) {
                    linkedList.addFirst(jEditorPane);
                    continue;
                }
                linkedList.add(jEditorPane);
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return linkedList.isEmpty() ? null : linkedList.toArray(new JEditorPane[linkedList.size()]);
    }

    JEditorPane getRecentPane() {
        assert (SwingUtilities.isEventDispatchThread()) : "CloneableEditorSupport.getRecentPane must be called from AWT thread only";
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getRecentPane();
        }
        Enumeration enumeration = this.allEditors.getComponents();
        Pane pane = this.getLastSelected();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane2 = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane2 == null && cloneableTopComponent instanceof Pane) {
                pane2 = (Pane)cloneableTopComponent;
            }
            if (pane2 != null) {
                JEditorPane jEditorPane = null;
                if (pane == pane2 || pane != null && pane instanceof Component && pane2 instanceof Container && ((Container)((Object)pane2)).isAncestorOf((Component)((Object)pane))) {
                    if (pane2 instanceof CloneableEditor && ((CloneableEditor)pane2).isEditorPaneReady()) {
                        jEditorPane = pane2.getEditorPane();
                    }
                    if (pane instanceof CloneableEditor) {
                        if (((CloneableEditor)pane).isEditorPaneReady()) {
                            jEditorPane = pane2.getEditorPane();
                        }
                    } else {
                        jEditorPane = pane2.getEditorPane();
                    }
                }
                if (jEditorPane == null) continue;
                return jEditorPane;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    final Pane getLastSelected() {
        Reference<Pane> reference = this.lastSelected;
        return reference == null ? null : reference.get();
    }

    final void setLastSelected(Pane pane) {
        this.lastSelected = new WeakReference<Pane>(pane);
    }

    public Line.Set getLineSet() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getLineSet();
        }
        return this.updateLineSet(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Map<Line, Reference<Line>> findWeakHashMap() {
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.lineSetWHM != null) {
                return this.lineSetWHM;
            }
            this.lineSetWHM = new WeakHashMap<Line, Reference<Line>>();
            return this.lineSetWHM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.print();
            return;
        }
        Object object = this.LOCK_PRINTING;
        synchronized (object) {
            if (this.printing) {
                return;
            }
            this.printing = true;
        }
        try {
            object = PrinterJob.getPrinterJob();
            Object object2 = NbDocument.findPageable(this.openDocument());
            if (object2 instanceof Pageable) {
                ((PrinterJob)object).setPageable((Pageable)object2);
            } else {
                PageFormat pageFormat = PrintPreferences.getPageFormat((PrinterJob)object);
                ((PrinterJob)object).setPrintable((Printable)object2, pageFormat);
            }
            if (((PrinterJob)object).printDialog()) {
                ((PrinterJob)object).print();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            CloneableEditorSupport.notifyProblem(fileNotFoundException, "CTL_Bad_File");
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (PrinterAbortException printerAbortException) {
            CloneableEditorSupport.notifyProblem(printerAbortException, "CTL_Printer_Abort");
        }
        catch (PrinterException printerException) {
            CloneableEditorSupport.notifyProblem(printerException, "EXC_Printer_Problem");
        }
        finally {
            Object object3 = this.LOCK_PRINTING;
            synchronized (object3) {
                this.printing = false;
            }
        }
    }

    private static void notifyProblem(Exception exception, String string) {
        String string2 = NbBundle.getMessage(CloneableEditorSupport.class, (String)string, (Object)exception.getLocalizedMessage());
        Exceptions.attachLocalizedMessage((Throwable)exception, (String)string2);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Exception((Throwable)exception));
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        this.prepareDocument();
        Pane pane = this.createPane();
        pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
        return pane.getComponent();
    }

    protected Pane createPane() {
        CloneableEditor cloneableEditor = this.createCloneableEditor();
        this.initializeCloneableEditor(cloneableEditor);
        return cloneableEditor;
    }

    protected Component wrapEditorComponent(Component component) {
        return component;
    }

    protected boolean canClose() {
        if (this.cesEnv().isModified()) {
            class SafeAWTAccess
            implements Runnable {
                boolean running;
                boolean finished;
                int ret;

                SafeAWTAccess() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    SafeAWTAccess safeAWTAccess = this;
                    synchronized (safeAWTAccess) {
                        this.running = true;
                        this.notifyAll();
                    }
                    try {
                        this.ret = CloneableEditorSupport.this.canCloseImpl();
                    }
                    finally {
                        safeAWTAccess = this;
                        synchronized (safeAWTAccess) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }
                }

                public synchronized void waitForResult() throws InterruptedException {
                    if (!this.running) {
                        this.wait(10000L);
                    }
                    if (!this.running) {
                        throw new InterruptedException("Waiting 10s for AWT and nothing! Exiting to prevent deadlock");
                    }
                    while (!this.finished) {
                        this.wait();
                    }
                }
            }
            SafeAWTAccess safeAWTAccess = new SafeAWTAccess();
            if (SwingUtilities.isEventDispatchThread()) {
                safeAWTAccess.run();
            } else {
                SwingUtilities.invokeLater(safeAWTAccess);
                try {
                    safeAWTAccess.waitForResult();
                }
                catch (InterruptedException interruptedException) {
                    ERR.log(Level.INFO, null, interruptedException);
                    return false;
                }
            }
            if (safeAWTAccess.ret == 0) {
                return false;
            }
            if (safeAWTAccess.ret == 1) {
                try {
                    this.saveDocument();
                }
                catch (UserCancelException userCancelException) {
                    return false;
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                    return false;
                }
            }
        }
        return true;
    }

    private int canCloseImpl() {
        String string = this.messageSave();
        ResourceBundle resourceBundle = NbBundle.getBundle(CloneableEditorSupport.class);
        JButton jButton = new JButton(resourceBundle.getString("CTL_Save"));
        jButton.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Save"));
        jButton.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Save"));
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Discard"));
        jButton2.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSN_CTL_Discard"));
        jButton2.setMnemonic(resourceBundle.getString("CTL_Discard_Mnemonic").charAt(0));
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, resourceBundle.getString("LBL_SaveFile_Title"), 1, 3, new Object[]{jButton, jButton2, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
        Object object = DialogDisplayer.getDefault().notify(notifyDescriptor);
        if (NotifyDescriptor.CANCEL_OPTION.equals(object) || NotifyDescriptor.CLOSED_OPTION.equals(object)) {
            return 0;
        }
        if (jButton.equals(object)) {
            return 1;
        }
        return -1;
    }

    public boolean isDocumentLoaded() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isDocumentLoaded();
        }
        return this.documentStatus != 0;
    }

    boolean isDocumentReady() {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.isDocumentReady();
        }
        return this.documentStatus == 2;
    }

    public void setMIMEType(String string) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this, true);
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.setMIMEType(string);
            return;
        }
        this.mimeType = string;
    }

    @Deprecated
    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<ChangeListener>(8);
        }
        this.listeners.add(changeListener);
    }

    @Deprecated
    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.listeners != null) {
            this.listeners.remove(changeListener);
        }
    }

    public final PositionRef createPositionRef(int n, Position.Bias bias) {
        return new PositionRef(this.getPositionManager(), n, bias);
    }

    protected CloneableEditor createCloneableEditor() {
        return new CloneableEditor(this);
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new UndoRedoManager(this);
    }

    public InputStream getInputStream() throws IOException {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.getInputStream();
        }
        StyledDocument styledDocument = this.getDocument();
        if (styledDocument == null) {
            return this.cesEnv().inputStream();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveFromKitToStream(styledDocument, this.kit, byteArrayOutputStream);
        }
        catch (BadLocationException badLocationException) {
            ERR.log(Level.INFO, null, badLocationException);
            throw (IllegalStateException)new IllegalStateException(badLocationException.getMessage()).initCause(badLocationException);
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        editorKit.write(outputStream, (Document)styledDocument, 0, styledDocument.getLength());
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        editorKit.read(inputStream, (Document)styledDocument, 0);
    }

    protected Task reloadDocument() {
        ERR.fine("reloadDocument in " + Thread.currentThread());
        if (this.getDoc() != null) {
            final JEditorPane[] jEditorPaneArray = this.getOpenedPanes();
            NbDocument.runAtomic(this.getDoc(), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int[] nArray;
                    CloneableEditorSupport.this.getDoc().removeUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                    if (jEditorPaneArray != null) {
                        nArray = new int[jEditorPaneArray.length];
                        for (int i = 0; i < jEditorPaneArray.length; ++i) {
                            nArray[i] = jEditorPaneArray[i].getCaretPosition();
                        }
                    } else {
                        nArray = new int[]{};
                    }
                    CloneableEditorSupport.this.documentStatus = 3;
                    CloneableEditorSupport.this.prepareDocumentRuntimeException = null;
                    class Query
                    implements Runnable,
                    Callable<Void> {
                        int targetStatus = 0;
                        UserQuestionException e;

                        Query() {
                        }

                        @Override
                        public void run() {
                            CloneableEditorSupport.this.askUserAndDoOpen(this.e, this);
                        }

                        @Override
                        public Void call() {
                            CloneableEditorSupport.this.getPositionManager().documentClosed();
                            CloneableEditorSupport.this.updateLineSet(true);
                            CloneableEditorSupport.this.reloadDocumentFireDocumentChangeClose = true;
                            ERR.fine("clearDocument");
                            CloneableEditorSupport.this.clearDocument();
                            CloneableEditorSupport.this.getListener().run();
                            CloneableEditorSupport.this.documentStatus = 2;
                            CloneableEditorSupport.this.reloadDocumentFireDocumentChangeOpen = true;
                            this.targetStatus = 2;
                            return null;
                        }
                    }
                    Query query = new Query();
                    try {
                        query.call();
                    }
                    catch (RuntimeException runtimeException) {
                        if (runtimeException.getCause() instanceof UserQuestionException) {
                            query.e = (UserQuestionException)runtimeException.getCause();
                            Mutex.EVENT.readAccess((Runnable)query);
                            return;
                        }
                        if (runtimeException.getCause() instanceof IOException) {
                            IOException iOException = (IOException)runtimeException.getCause();
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getLocalizedMessage(), 0));
                            return;
                        }
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = runtimeException;
                        throw runtimeException;
                    }
                    catch (Error error) {
                        CloneableEditorSupport.this.prepareDocumentRuntimeException = error;
                        throw error;
                    }
                    finally {
                        Object object = CloneableEditorSupport.this.getLock();
                        synchronized (object) {
                            if (query.targetStatus == 0) {
                                CloneableEditorSupport.this.setDoc(null, false);
                            }
                            CloneableEditorSupport.this.documentStatus = query.targetStatus;
                            CloneableEditorSupport.this.getLock().notifyAll();
                        }
                    }
                    ERR.fine("post-reload task posting to AWT");
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (CloneableEditorSupport.this.getDoc() == null) {
                                return;
                            }
                            if (jEditorPaneArray != null) {
                                for (int i = 0; i < jEditorPaneArray.length; ++i) {
                                    int n = jEditorPaneArray[i].getDocument().getLength();
                                    if (nArray[i] > n) {
                                        nArray[i] = n;
                                    }
                                    jEditorPaneArray[i].setCaretPosition(nArray[i]);
                                }
                            }
                        }
                    };
                    Runnable runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            StyledDocument styledDocument = CloneableEditorSupport.this.getDoc();
                            if (styledDocument == null) {
                                return;
                            }
                            ERR.fine("task-discardAllEdits");
                            UndoRedo.Manager manager = CloneableEditorSupport.this.getUndoRedo();
                            manager.discardAllEdits();
                            if (manager instanceof UndoRedoManager) {
                                ((UndoRedoManager)manager).markSavepoint();
                            }
                            ERR.fine("task-check already modified");
                            if (CloneableEditorSupport.this.isAlreadyModified()) {
                                ERR.fine("task-callNotifyUnmodified");
                                CloneableEditorSupport.this.callNotifyUnmodified();
                            }
                            CloneableEditorSupport.this.updateLineSet(true);
                            ERR.fine("task-addUndoableEditListener");
                            styledDocument.addUndoableEditListener((UndoableEditListener)CloneableEditorSupport.this.getUndoRedo());
                        }
                    };
                    if (CloneableEditorSupport.this.getDoc() != null) {
                        ERR.fine("Posting the AWT runnable: " + runnable2);
                        runnable.run();
                        SwingUtilities.invokeLater(runnable2);
                        ERR.fine("Posted in " + Thread.currentThread());
                    }
                }
            });
        }
        return this.prepareDocument();
    }

    public static EditorKit getEditorKit(String string) {
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)string));
        EditorKit editorKit = (EditorKit)lookup.lookup(EditorKit.class);
        if (editorKit == null) {
            lookup = MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/plain"));
            editorKit = (EditorKit)lookup.lookup(EditorKit.class);
        }
        return editorKit != null ? (EditorKit)editorKit.clone() : new PlainEditorKit();
    }

    protected EditorKit createEditorKit() {
        if (this.kit != null) {
            return this.kit;
        }
        if (this.mimeType != null) {
            this.kit = CloneableEditorSupport.getEditorKit(this.mimeType);
        } else {
            String string = this.cesEnv().getMimeType();
            this.kit = CloneableEditorSupport.getEditorKit(string);
        }
        return this.kit;
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = CloneableEditorSupport.createNetBeansDocument(editorKit.createDefaultDocument());
        styledDocument.putProperty("mimeType", this.mimeType != null ? this.mimeType : this.cesEnv().getMimeType());
        return styledDocument;
    }

    protected void notifyUnmodified() {
        this.env.unmarkModified();
        if (!Boolean.TRUE.equals(LOCAL_CLOSE_DOCUMENT.get())) {
            this.updateTitles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean callNotifyModified() {
        Object object = this.LOCK_NOTIFY_MODIFIED;
        synchronized (object) {
            if (!this.isAlreadyModified() && !this.documentReloading) {
                this.setAlreadyModified(true);
                if (!this.notifyModified()) {
                    this.setAlreadyModified(false);
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void callNotifyUnmodified() {
        Object object = this.LOCK_NOTIFY_MODIFIED;
        synchronized (object) {
            this.setAlreadyModified(false);
            this.notifyUnmodified();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean bl = true;
        try {
            this.env.markModified();
        }
        catch (UserQuestionException userQuestionException) {
            CloneableEditorSupport cloneableEditorSupport = this;
            synchronized (cloneableEditorSupport) {
                if (!this.inUserQuestionExceptionHandler) {
                    this.inUserQuestionExceptionHandler = true;
                    RP.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0);
                            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                            if (NotifyDescriptor.OK_OPTION.equals(object)) {
                                try {
                                    userQuestionException.confirmed();
                                }
                                catch (IOException iOException) {
                                    Exceptions.printStackTrace((Throwable)iOException);
                                }
                            }
                            CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupport.this;
                            synchronized (cloneableEditorSupport) {
                                CloneableEditorSupport.this.inUserQuestionExceptionHandler = false;
                            }
                        }
                    });
                }
            }
            bl = false;
            ERR.log(Level.FINE, "Could not lock document", userQuestionException);
        }
        catch (IOException iOException) {
            ERR.log(Level.FINE, "Could not lock document", iOException);
            String string = null;
            string = iOException.getMessage() != iOException.getLocalizedMessage() ? iOException.getLocalizedMessage() : Exceptions.findLocalizedMessage((Throwable)iOException);
            if (string != null) {
                StatusDisplayer.getDefault().setStatusText(string);
            }
            bl = false;
        }
        if (!bl) {
            Toolkit.getDefaultToolkit().beep();
            ERR.log(Level.FINE, "notifyModified returns false");
            return false;
        }
        lastReusable.clear();
        this.updateTitles();
        if (ERR.isLoggable(Level.FINE)) {
            ERR.log(Level.FINE, "notifyModified returns true; env.isModified()=" + this.env.isModified());
        }
        return true;
    }

    protected void notifyClosed() {
        this.closeDocument();
    }

    final StyledDocument getDocumentHack() {
        return this.getDoc();
    }

    final Lookup getLookup() {
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set updateLineSet(boolean bl) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.lineSet != null && !bl) {
                return this.lineSet;
            }
            Line.Set set = this.lineSet;
            this.lineSet = this.getDoc() == null || this.documentStatus == 3 ? new EditorSupportLineSet.Closed(this) : new EditorSupportLineSet(this, this.getDoc());
            return this.lineSet;
        }
    }

    /*
     * Exception decompiling
     */
    private void loadDocument(EditorKit var1_1, StyledDocument var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean close(boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.close(bl);
        }
        if (!super.close(bl)) {
            return false;
        }
        this.notifyClosed();
        return true;
    }

    /*
     * Exception decompiling
     */
    private void closeDocument() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCloseDocument() {
        boolean bl = false;
        this.cesEnv().removePropertyChangeListener(this.getListener());
        try {
            LOCAL_CLOSE_DOCUMENT.set(Boolean.TRUE);
            this.callNotifyUnmodified();
        }
        finally {
            LOCAL_CLOSE_DOCUMENT.set(Boolean.FALSE);
        }
        StyledDocument styledDocument = this.getDoc();
        if (styledDocument != null) {
            styledDocument.removeUndoableEditListener((UndoableEditListener)this.getUndoRedo());
            this.addRemoveDocListener(styledDocument, false);
        }
        if (this.positionManager != null) {
            this.positionManager.documentClosed();
        }
        this.documentStatus = 0;
        bl = true;
        this.setDoc(null, false);
        this.kit = null;
        this.getUndoRedo().discardAllEdits();
        this.updateLineSet(true);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReload(boolean bl) {
        StyledDocument styledDocument;
        Object object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            styledDocument = this.getDoc();
        }
        if (!bl && !this.reloadDialogOpened) {
            object = NbBundle.getMessage(CloneableEditorSupport.class, (String)"FMT_External_change", (Object)styledDocument.getProperty("title"));
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation(object, 0);
            this.reloadDialogOpened = true;
            try {
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (NotifyDescriptor.YES_OPTION.equals(object2)) {
                    bl = true;
                }
            }
            finally {
                this.reloadDialogOpened = false;
            }
        }
        object = this.getLock();
        synchronized (object) {
            if (this.documentStatus != 2) {
                return;
            }
            if (bl) {
                this.reloadDocument();
            }
        }
        if (this.reloadDocumentFireDocumentChangeClose) {
            this.reloadDocumentFireDocumentChangeClose = false;
            this.fireDocumentChange(this.getDoc(), true);
        }
        if (this.reloadDocumentFireDocumentChangeOpen) {
            this.reloadDocumentFireDocumentChangeOpen = false;
            this.fireDocumentChange(this.getDoc(), false);
        }
    }

    private static StyledDocument createNetBeansDocument(Document document) {
        if (document instanceof StyledDocument) {
            return (StyledDocument)document;
        }
        return new FilterDocument(document);
    }

    private final void fireDocumentChange(StyledDocument styledDocument, boolean bl) {
        this.fireStateChangeEvent(styledDocument, bl);
        this.firePropertyChange("document", bl ? styledDocument : null, bl ? null : styledDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fireStateChangeEvent(StyledDocument styledDocument, boolean bl) {
        if (this.listeners == null) return;
        EnhancedChangeEvent enhancedChangeEvent = new EnhancedChangeEvent(this, styledDocument, bl);
        ChangeListener[] changeListenerArray = this;
        synchronized (this) {
            ChangeListener[] changeListenerArray2 = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (ChangeListener changeListener : changeListenerArray2) {
                changeListener.stateChanged(enhancedChangeEvent);
            }
            return;
        }
    }

    protected void updateTitles() {
        Enumeration enumeration = this.allEditors.getComponents();
        while (enumeration.hasMoreElements()) {
            CloneableTopComponent cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane == null && cloneableTopComponent instanceof Pane) {
                pane = (Pane)cloneableTopComponent;
            }
            if (pane != null) {
                pane.updateName();
                continue;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
    }

    private static void replaceTc(TopComponent topComponent, TopComponent topComponent2) {
        int n = topComponent.getTabPosition();
        topComponent.close();
        topComponent2.openAtTabPosition(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pane openPane(boolean bl) {
        String string;
        Pane pane = null;
        boolean bl2 = false;
        Object object = this.getLock();
        synchronized (object) {
            pane = this.getAnyEditor();
            if (pane == null) {
                string = this.messageOpening();
                if (string != null) {
                    StatusDisplayer.getDefault().setStatusText(string);
                }
                this.prepareDocument();
                pane = this.createPane();
                pane.getComponent().putClientProperty((Object)PROP_PANE, (Object)pane);
                pane.getComponent().setReference(this.allEditors);
                bl2 = true;
            }
        }
        object = pane.getComponent();
        if (bl && bl2) {
            string = lastReusable.get();
            if (string != null) {
                CloneableEditorSupport.replaceTc((TopComponent)string, (TopComponent)object);
            } else {
                object.open();
            }
            lastReusable = new WeakReference<Object>(object);
        } else {
            object.open();
        }
        if (bl2) {
            string = this.messageOpened();
            if (string == null) {
                string = "";
            }
            StatusDisplayer.getDefault().setStatusText(string);
        }
        return pane;
    }

    Pane getAnyEditor() {
        CloneableTopComponent cloneableTopComponent = this.allEditors.getArbitraryComponent();
        if (cloneableTopComponent == null) {
            return null;
        }
        Pane pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
        if (pane != null) {
            return pane;
        }
        if (cloneableTopComponent instanceof Pane) {
            return (Pane)cloneableTopComponent;
        }
        Enumeration enumeration = this.allEditors.getComponents();
        if (enumeration.hasMoreElements()) {
            cloneableTopComponent = (CloneableTopComponent)enumeration.nextElement();
            pane = (Pane)cloneableTopComponent.getClientProperty((Object)PROP_PANE);
            if (pane != null) {
                return pane;
            }
            if (cloneableTopComponent instanceof Pane) {
                return (Pane)cloneableTopComponent;
            }
            throw new IllegalStateException("No reference to Pane. Please file a bug against openide/text");
        }
        return null;
    }

    @Deprecated
    final Pane openReuse(PositionRef positionRef, int n, int n2) {
        if (n2 == 5) {
            lastReusable.clear();
        }
        return this.openAtImpl(positionRef, n, true);
    }

    final Pane openReuse(PositionRef positionRef, int n, Line.ShowOpenType showOpenType) {
        if (showOpenType == Line.ShowOpenType.REUSE_NEW) {
            lastReusable.clear();
        }
        return this.openAtImpl(positionRef, n, true);
    }

    protected final Pane openAt(PositionRef positionRef, int n) {
        return this.openAtImpl(positionRef, n, false);
    }

    private final Pane openAtImpl(final PositionRef positionRef, final int n, boolean bl) {
        CloneableEditorSupport cloneableEditorSupport = CloneableEditorSupportRedirector.findRedirect(this);
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.openAtImpl(positionRef, n, bl);
        }
        ++this.counterOpenAtImpl;
        final Pane pane = this.openPane(bl);
        Task task = this.prepareDocument();
        pane.ensureVisible();
        class Selector
        implements TaskListener,
        Runnable {
            private boolean documentLocked = false;
            private int counterRun = 0;

            Selector() {
            }

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(this);
                task.removeTaskListener((TaskListener)this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block17: {
                    ++this.counterRun;
                    try {
                        JEditorPane jEditorPane = pane.getEditorPane();
                        if (jEditorPane == null) {
                            return;
                        }
                        StyledDocument styledDocument = CloneableEditorSupport.this.getDocument();
                        if (styledDocument == null) {
                            return;
                        }
                        if (!this.documentLocked) {
                            this.documentLocked = true;
                            styledDocument.render(this);
                            break block17;
                        }
                        Caret caret = jEditorPane.getCaret();
                        if (caret == null) {
                            return;
                        }
                        Document document = jEditorPane.getDocument();
                        if (document instanceof StyledDocument && document != styledDocument) {
                            if (ERR.isLoggable(Level.FINE)) {
                                ERR.fine("paneDoc=" + document + "\n !=\ndoc=" + styledDocument);
                            }
                            styledDocument = (StyledDocument)document;
                        }
                        Element element = NbDocument.findLineRootElement(styledDocument);
                        int n2 = (element = element.getElement(element.getElementIndex(positionRef.getOffset()))).getStartOffset() + Math.max(0, n);
                        if (n2 > element.getEndOffset()) {
                            n2 = Math.max(element.getStartOffset(), element.getEndOffset() - 1);
                        }
                        caret.setDot(n2);
                        try {
                            Rectangle rectangle = jEditorPane.modelToView(n2);
                            if (rectangle != null) {
                                rectangle.height *= 5;
                                jEditorPane.scrollRectToVisible(rectangle);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            ERR.log(Level.WARNING, "Can't scroll to text: pos.getOffset=" + positionRef.getOffset() + ", column=" + n + ", offset=" + n2 + ", doc.getLength=" + styledDocument.getLength(), badLocationException);
                        }
                    }
                    finally {
                        --this.counterRun;
                        if (this.counterRun == 0) {
                            CloneableEditorSupport.this.counterOpenAtImpl--;
                            CloneableEditorSupport.this.checkReleaseDoc();
                        }
                    }
                }
            }
        }
        task.addTaskListener((TaskListener)new Selector());
        return pane;
    }

    final Object getLock() {
        return this.allEditors;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    void howToReproduceDeadlock40766(boolean bl) {
    }

    final void setLastSaveTime(long l) {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine(this.documentID() + ": Setting new lastSaveTime to " + l + ", " + new Date(l));
        }
        this.lastSaveTime = l;
    }

    final boolean isAlreadyModified() {
        return this.alreadyModified;
    }

    final void setAlreadyModified(boolean bl) {
        if (ERR.isLoggable(Level.FINE)) {
            ERR.fine(this.documentID() + ": setAlreadyModified from " + this.isAlreadyModified() + " to " + bl);
            ERR.log(Level.FINEST, null, new Exception("Setting to modified: " + bl));
        }
        this.alreadyModified = bl;
        this.setStrong(bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledDocument getDoc() {
        Object object = this.LOCK_STRONG_REF;
        synchronized (object) {
            StrongRef strongRef = this.doc;
            return strongRef != null ? strongRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDoc(StyledDocument styledDocument, boolean bl) {
        Object object = this.LOCK_STRONG_REF;
        synchronized (object) {
            if (styledDocument == null) {
                this.doc = null;
                return;
            }
            this.doc = new StrongRef(styledDocument, bl);
            Logger.getLogger("TIMER").log(Level.FINE, "TextDocument", styledDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStrong(boolean bl, boolean bl2) {
        Object object = this.LOCK_STRONG_REF;
        synchronized (object) {
            if (this.doc != null) {
                if (bl) {
                    this.doc.setStrong(true);
                    if (bl2) {
                        this.isStrongSet = true;
                    }
                } else if (!this.isAlreadyModified()) {
                    this.doc.setStrong(false);
                }
            }
        }
    }

    private final class DocFilter
    extends DocumentFilter {
        final DocumentFilter origFilter;

        DocFilter(DocumentFilter documentFilter) {
            this.origFilter = documentFilter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = this.checkModificationAllowed(n);
            boolean bl2 = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.insertString(filterBypass, n, string, attributeSet);
                } else {
                    super.insertString(filterBypass, n, string, attributeSet);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && !bl) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
            boolean bl = this.checkModificationAllowed(n);
            boolean bl2 = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.remove(filterBypass, n, n2);
                } else {
                    super.remove(filterBypass, n, n2);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && !bl) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            boolean bl = this.checkModificationAllowed(n);
            boolean bl2 = false;
            try {
                if (this.origFilter != null) {
                    this.origFilter.replace(filterBypass, n, n2, string, attributeSet);
                } else {
                    super.replace(filterBypass, n, n2, string, attributeSet);
                }
                bl2 = true;
            }
            finally {
                if (!bl2 && !bl) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        private boolean checkModificationAllowed(int n) throws BadLocationException {
            boolean bl = CloneableEditorSupport.this.isAlreadyModified();
            if (!CloneableEditorSupport.this.callNotifyModified()) {
                this.modificationNotAllowed(n);
            }
            return bl;
        }

        private void modificationNotAllowed(int n) throws BadLocationException {
            throw new BadLocationException("Modification not allowed", n);
        }
    }

    static final class DelegateIOExc
    extends IllegalStateException {
        public DelegateIOExc(IOException iOException) {
            super(iOException.getMessage());
            this.initCause(iOException);
        }
    }

    private final class Listener
    implements PropertyChangeListener,
    DocumentListener,
    Runnable,
    VetoableChangeListener {
        private IOException loadExc;
        private boolean revertModifiedFlag;

        Listener() {
        }

        public IOException checkLoadException() {
            IOException iOException = this.loadExc;
            return iOException;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            CloneableEditorSupport.this.callNotifyModified();
            this.revertModifiedFlag = false;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                    boolean bl = CloneableEditorSupport.this.isAlreadyModified();
                    if (!CloneableEditorSupport.this.callNotifyModified()) {
                        throw new PropertyVetoException("Not allowed", propertyChangeEvent);
                    }
                    this.revertModifiedFlag = !bl;
                } else if (this.revertModifiedFlag) {
                    CloneableEditorSupport.this.callNotifyUnmodified();
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("expectedTime".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.lastSaveTime = ((Date)propertyChangeEvent.getNewValue()).getTime();
            }
            if ("time".equals(propertyChangeEvent.getPropertyName())) {
                final Date date = (Date)propertyChangeEvent.getNewValue();
                ERR.fine(CloneableEditorSupport.this.documentID() + ": PROP_TIME new value: " + date + ", " + (date != null ? date.getTime() : -1L));
                ERR.fine("       lastSaveTime: " + new Date(CloneableEditorSupport.this.lastSaveTime) + ", " + CloneableEditorSupport.this.lastSaveTime);
                boolean bl = CloneableEditorSupport.this.lastSaveTime != -1L && (date == null || date.getTime() > CloneableEditorSupport.this.lastSaveTime || date.getTime() + 10000L < CloneableEditorSupport.this.lastSaveTime);
                ERR.fine("             reload: " + bl);
                if (bl) {
                    SwingUtilities.invokeLater(new Runnable(){
                        private boolean inRunAtomic;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (!this.inRunAtomic) {
                                this.inRunAtomic = true;
                                StyledDocument styledDocument = CloneableEditorSupport.this.getDoc();
                                if (styledDocument == null) {
                                    return;
                                }
                                CloneableEditorSupport.this.documentReloading = true;
                                try {
                                    NbDocument.runAtomic(styledDocument, this);
                                }
                                finally {
                                    CloneableEditorSupport.this.documentReloading = false;
                                }
                                return;
                            }
                            boolean bl = date == null || !CloneableEditorSupport.this.isModified();
                            ERR.fine(CloneableEditorSupport.this.documentID() + ": checkReload noAsk: " + bl);
                            CloneableEditorSupport.this.checkReload(bl);
                        }
                    });
                    ERR.fine(CloneableEditorSupport.this.documentID() + ": reload task posted");
                }
            }
            if ("modified".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.firePropertyChange("modified", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
            if ("DataEditorSupport.read-only.changing".equals(propertyChangeEvent.getPropertyName())) {
                CloneableEditorSupport.this.updateTitles();
            }
        }

        @Override
        public void run() {
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), false);
            try {
                this.loadExc = null;
                LOCAL_LOAD_TASK.set(true);
                CloneableEditorSupport.this.loadDocument(CloneableEditorSupport.this.kit, CloneableEditorSupport.this.getDoc());
            }
            catch (IOException iOException) {
                this.loadExc = iOException;
                throw new DelegateIOExc(iOException);
            }
            finally {
                LOCAL_LOAD_TASK.set(null);
            }
            CloneableEditorSupport.this.getPositionManager().documentOpened(CloneableEditorSupport.this.doc);
            CloneableEditorSupport.this.updateLineSet(true);
            CloneableEditorSupport.this.setLastSaveTime(CloneableEditorSupport.this.cesEnv().getTime().getTime());
            CloneableEditorSupport.this.addRemoveDocListener(CloneableEditorSupport.this.getDoc(), true);
        }
    }

    private static final class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        static final long serialVersionUID = -5788777967029507963L;

        PlainEditorKit() {
        }

        @Override
        public Object clone() {
            return new PlainEditorKit();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this;
        }

        @Override
        public View create(Element element) {
            return new WrappedPlainView(element);
        }

        @Override
        public void install(JEditorPane jEditorPane) {
            super.install(jEditorPane);
            jEditorPane.setFont(new Font("Monospaced", 0, jEditorPane.getFont().getSize() + 1));
        }
    }

    public static interface Pane {
        public JEditorPane getEditorPane();

        public CloneableTopComponent getComponent();

        public void updateName();

        public void ensureVisible();
    }

    public static interface Env
    extends CloneableOpenSupport.Env {
        public static final String PROP_TIME = "time";

        public InputStream inputStream() throws IOException;

        public OutputStream outputStream() throws IOException;

        public Date getTime();

        public String getMimeType();
    }

    private final class StrongRef
    extends WeakReference<StyledDocument>
    implements Runnable {
        private StyledDocument doc;

        public StrongRef(StyledDocument styledDocument, boolean bl) {
            super(styledDocument, Utilities.activeReferenceQueue());
            if (bl) {
                this.doc = styledDocument;
            }
        }

        @Override
        public StyledDocument get() {
            return this.doc != null ? this.doc : (StyledDocument)super.get();
        }

        @Override
        public void run() {
            if (this != CloneableEditorSupport.this.doc) {
                return;
            }
            CloneableEditorSupport.this.closeDocument();
        }

        private void setStrong(boolean bl) {
            this.doc = bl ? (StyledDocument)super.get() : null;
        }

        public String toString() {
            return "StrongRef@" + Integer.toHexString(System.identityHashCode(this)) + "[doc=" + this.doc + ",super.get=" + super.get() + "]";
        }
    }
}

