/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openide.text.Installer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.QuietEditorPane;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CloneableEditor
extends CloneableTopComponent
implements CloneableEditorSupport.Pane {
    private static final String HELP_ID = "editing.editorwindow";
    static final long serialVersionUID = -185739563792410059L;
    private static final RequestProcessor RP = new RequestProcessor("org.openide.text Editor Initialization");
    private static final RequestProcessor RPPostprocessing = new RequestProcessor("org.openide.text Document Postprocessing");
    protected JEditorPane pane;
    private CloneableEditorSupport support;
    private boolean initialized;
    private boolean initVisualFinished;
    private static boolean waitingOnInitVisual;
    private static boolean isModalDialog;
    private boolean isDocLoadingCanceled = false;
    private boolean isComponentOpened = false;
    private int cursorPosition = -1;
    private final boolean[] CLOSE_LAST_LOCK = new boolean[1];
    private static List<AWTQuery> tbdList;
    private static List<AWTQuery> finishedList;
    private Component customComponent;
    private JToolBar customToolbar;
    private DoInitialize doInitialize;
    private static final Logger LOG;
    static final Logger TIMER;

    public CloneableEditor() {
        this(null);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport) {
        this(cloneableEditorSupport, false);
    }

    public CloneableEditor(CloneableEditorSupport cloneableEditorSupport, boolean bl) {
        this.support = cloneableEditorSupport;
        this.updateName();
        this._setCloseOperation();
        this.setMinimumSize(new Dimension(10, 10));
        if (bl) {
            this.associateLookup(cloneableEditorSupport.getLookup());
        }
    }

    private void _setCloseOperation() {
        this.setCloseOperation(0);
    }

    protected CloneableEditorSupport cloneableEditorSupport() {
        return this.support;
    }

    public int getPersistenceType() {
        return 1;
    }

    public HelpCtx getHelpCtx() {
        HelpCtx helpCtx;
        EditorKit editorKit = this.support.cesKit();
        HelpCtx helpCtx2 = helpCtx = editorKit == null ? null : HelpCtx.findHelp((Object)editorKit);
        if (helpCtx != null) {
            return helpCtx;
        }
        return new HelpCtx(HELP_ID);
    }

    public boolean canClose() {
        boolean bl = super.canClose();
        return bl;
    }

    protected void componentShowing() {
        super.componentShowing();
        this.initialize();
    }

    private void initialize() {
        if (this.initialized || this.discard()) {
            return;
        }
        QuietEditorPane quietEditorPane = new QuietEditorPane();
        quietEditorPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CloneableEditor.class, (String)"ACS_CloneableEditor_QuietEditorPane", (Object)this.getName()));
        quietEditorPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneableEditor.class, (String)"ACSD_CloneableEditor_QuietEditorPane", (Object)this.getAccessibleContext().getAccessibleDescription()));
        quietEditorPane.putClientProperty("usedByCloneableEditor", true);
        this.pane = quietEditorPane;
        this.initialized = true;
        this.isComponentOpened = true;
        this.doInitialize = new DoInitialize(quietEditorPane);
    }

    final boolean newInitialize() {
        if (Boolean.getBoolean("org.openide.text.CloneableEditor.oldInitialize")) {
            return false;
        }
        return !Boolean.TRUE.equals(this.getClientProperty("oldInitialize"));
    }

    protected final void initializeBySupport() {
        this.cloneableEditorSupport().initializeCloneableEditor(this);
    }

    private void releasePane() {
        if (this.pane != null) {
            this.pane.putClientProperty("usedByCloneableEditor", false);
        }
        this.pane = null;
    }

    protected CloneableTopComponent createClonedObject() {
        return this.support.createCloneableTopComponent();
    }

    protected void componentOpened() {
        super.componentOpened();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
            StyledDocument styledDocument = cloneableEditorSupport.getDocument();
            if (styledDocument != null) {
                String string = (String)styledDocument.getProperty("mimeType");
                Installer.add(string);
            }
        }
    }

    protected void componentClosed() {
        if (this.pane != null) {
            this.pane.setEditorKit(null);
        }
        this.customComponent = null;
        this.customToolbar = null;
        this.releasePane();
        this.initialized = false;
        this.initVisualFinished = false;
        this.isComponentOpened = false;
        super.componentClosed();
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
        }
        if (cloneableEditorSupport.getAnyEditor() == null) {
            cloneableEditorSupport.close(false);
        }
    }

    protected boolean closeLast() {
        return this.closeLast(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean closeLast(boolean bl) {
        if (bl && !this.support.canClose()) {
            return false;
        }
        boolean[] blArray = this.CLOSE_LAST_LOCK;
        synchronized (this.CLOSE_LAST_LOCK) {
            if (this.CLOSE_LAST_LOCK[0]) {
                this.CLOSE_LAST_LOCK[0] = false;
            } else {
                this.support.notifyClosed();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.support.getLastSelected() == this) {
                this.support.setLastSelected(null);
            }
            return true;
        }
    }

    public UndoRedo getUndoRedo() {
        return this.support.getUndoRedo();
    }

    public Action[] getActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(super.getActions()));
        arrayList.add(null);
        arrayList.addAll(Utilities.actionsForPath((String)"Editors/TabActions"));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    @Deprecated
    public void requestFocus() {
        super.requestFocus();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                this.customComponent.requestFocus();
            } else {
                this.pane.requestFocus();
            }
        }
    }

    @Deprecated
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        if (this.pane != null) {
            if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
                return this.customComponent.requestFocusInWindow();
            }
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    @Deprecated
    public boolean requestDefaultFocus() {
        if (this.customComponent != null && !SwingUtilities.isDescendingFrom(this.pane, this.customComponent)) {
            return this.customComponent.requestFocusInWindow();
        }
        if (this.pane != null) {
            return this.pane.requestFocusInWindow();
        }
        return false;
    }

    public Dimension getPreferredSize() {
        Rectangle rectangle = WindowManager.getDefault().getCurrentWorkspace().getBounds();
        return new Dimension(rectangle.width / 2, rectangle.height / 2);
    }

    public void open() {
        boolean bl = this.getClientProperty("TopComponentAllowDockAnywhere") == null;
        super.open();
        if (bl) {
            this.putClientProperty("TopComponentAllowDockAnywhere", null);
        }
    }

    private Action getAction(String string) {
        if (string == null) {
            return null;
        }
        EditorKit editorKit = this.support.cesKit();
        if (editorKit == null) {
            return null;
        }
        Action[] actionArray = editorKit.getActions();
        for (int i = 0; i < actionArray.length; ++i) {
            if (!string.equals(actionArray[i].getValue("Name"))) continue;
            return actionArray[i];
        }
        return null;
    }

    protected void componentActivated() {
        this.support.setLastSelected(this);
    }

    @Override
    public void updateName() {
        final CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            Mutex.EVENT.writeAccess(new Runnable(){

                @Override
                public void run() {
                    String string = cloneableEditorSupport.messageHtmlName();
                    CloneableEditor.this.setHtmlDisplayName(string);
                    string = cloneableEditorSupport.messageName();
                    CloneableEditor.this.setDisplayName(string);
                    CloneableEditor.this.setName(string);
                    CloneableEditor.this.setToolTipText(cloneableEditorSupport.messageToolTip());
                }
            });
        }
    }

    protected String preferredID() {
        CloneableEditorSupport cloneableEditorSupport = this.cloneableEditorSupport();
        if (cloneableEditorSupport != null) {
            return cloneableEditorSupport.documentID();
        }
        return "";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.support != null ? this.support.cesEnv() : null);
        int n = 0;
        JEditorPane jEditorPane = this.pane;
        if (jEditorPane != null) {
            Caret caret = jEditorPane.getCaret();
            if (caret != null) {
                n = caret.getDot();
            } else if (jEditorPane instanceof QuietEditorPane) {
                int n2 = ((QuietEditorPane)jEditorPane).getLastPosition();
                if (n2 == -1) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Pane=" + jEditorPane + "was not initialized yet!"));
                } else {
                    n = n2;
                }
            } else {
                StyledDocument styledDocument;
                StyledDocument styledDocument2 = styledDocument = this.support != null ? this.support.getDocument() : null;
                if (styledDocument != null) {
                    Logger.getLogger(CloneableEditor.class.getName()).log(Level.WARNING, null, new IllegalStateException("Caret is null in editor pane=" + jEditorPane + "\nsupport=" + (Object)((Object)this.support) + "\ndoc=" + styledDocument));
                }
            }
        }
        objectOutput.writeObject(new Integer(n));
        objectOutput.writeBoolean(this.getLookup() == this.support.getLookup());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        boolean bl;
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof CloneableOpenSupport.Env) {
            CloneableOpenSupport.Env env = (CloneableOpenSupport.Env)object;
            CloneableOpenSupport cloneableOpenSupport = env.findCloneableOpenSupport();
            this.support = (CloneableEditorSupport)cloneableOpenSupport;
        }
        int n = (Integer)objectInput.readObject();
        if (!this.discard()) {
            this.cursorPosition = n;
        }
        this.updateName();
        this.isComponentOpened = true;
        if (objectInput.available() > 0 && (bl = objectInput.readBoolean()) && this.support != null) {
            this.associateLookup(this.support.getLookup());
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.discard()) {
            throw new NotSerializableException("Serializing component is invalid: " + this);
        }
        return super.writeReplace();
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.discard()) {
            throw new InvalidObjectException("Deserialized component is invalid: " + this);
        }
        this.initializeBySupport();
        return this;
    }

    private boolean discard() {
        return this.support == null || !this.support.cesEnv().isValid();
    }

    @Override
    public CloneableTopComponent getComponent() {
        return this;
    }

    boolean isEditorPaneReady() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.initVisualFinished;
    }

    boolean isEditorPaneReadyTest() {
        return this.initVisualFinished;
    }

    @Override
    public JEditorPane getEditorPane() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.isDocLoadingCanceled || !this.isComponentOpened) {
            return null;
        }
        if (isModalDialog) {
            LOG.log(Level.WARNING, "AWT is blocked by modal dialog. Return null from CloneableEditor.getEditorPane. Please report this to IZ.");
            LOG.log(Level.WARNING, "support:" + ((Object)((Object)this.support)).getClass().getName());
            Exception exception = new Exception();
            StringWriter stringWriter = new StringWriter(500);
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            LOG.log(Level.WARNING, stringWriter.toString());
            return null;
        }
        this.initialize();
        DoInitialize doInitialize = this.doInitialize;
        if (doInitialize != null && !Thread.holdsLock(this.support.getLock())) {
            waitingOnInitVisual = true;
            doInitialize.initVisual();
            waitingOnInitVisual = false;
        }
        return this.pane;
    }

    @Override
    public void ensureVisible() {
        this.open();
        this.requestVisible();
    }

    static /* synthetic */ boolean access$800() {
        return waitingOnInitVisual;
    }

    static /* synthetic */ Action access$1200(CloneableEditor cloneableEditor, String string) {
        return cloneableEditor.getAction(string);
    }

    static {
        tbdList = Collections.synchronizedList(new ArrayList());
        finishedList = Collections.synchronizedList(new ArrayList());
        LOG = Logger.getLogger("org.openide.text.CloneableEditor");
        TIMER = Logger.getLogger("TIMER");
    }

    class DoInitialize
    implements Runnable,
    ActionListener {
        private final QuietEditorPane tmp;
        private Document doc;
        private RequestProcessor.Task task;
        private int phase;
        private EditorKit kit;
        private JComponent tmpComp;
        private boolean initialized = false;
        private boolean isInInitVisual = false;
        private boolean confirmed = false;

        public DoInitialize(QuietEditorPane quietEditorPane) {
            this.tmp = quietEditorPane;
            this.tmpComp = this.initLoading();
            new Timer(1000, this).start();
            if (CloneableEditor.this.newInitialize()) {
                this.task = RP.create((Runnable)this);
                this.task.setPriority(3);
                this.task.schedule(0);
            } else {
                this.run();
            }
        }

        private JComponent initLoading() {
            CloneableEditor.this.setLayout(new BorderLayout());
            JLabel jLabel = new JLabel(NbBundle.getMessage(CloneableEditor.class, (String)"LBL_EditorLoading"));
            jLabel.setOpaque(true);
            jLabel.setHorizontalAlignment(0);
            jLabel.setBorder(new EmptyBorder(new Insets(11, 11, 11, 11)));
            jLabel.setVisible(false);
            CloneableEditor.this.add(jLabel, "Center");
            return jLabel;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.tmpComp.setVisible(true);
            Timer timer = (Timer)actionEvent.getSource();
            timer.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = System.currentTimeMillis();
            int n = this.phase;
            switch (this.phase++) {
                case 0: {
                    boolean[] blArray = CloneableEditor.this.CLOSE_LAST_LOCK;
                    synchronized (blArray) {
                        ((CloneableEditor)CloneableEditor.this).CLOSE_LAST_LOCK[0] = true;
                    }
                    this.phase = this.initNonVisual(this.phase);
                    blArray = CloneableEditor.this.CLOSE_LAST_LOCK;
                    synchronized (blArray) {
                        if (!CloneableEditor.this.CLOSE_LAST_LOCK[0]) {
                            CloneableEditor.this.support.notifyClosed();
                            this.phase = Integer.MAX_VALUE;
                        }
                        ((CloneableEditor)CloneableEditor.this).CLOSE_LAST_LOCK[0] = false;
                    }
                    if (this.phase == Integer.MAX_VALUE) break;
                    if (CloneableEditor.this.newInitialize()) {
                        WindowManager.getDefault().invokeWhenUIReady((Runnable)this);
                        break;
                    }
                }
                case 1: {
                    if (CloneableEditor.this.pane != this.tmp) {
                        this.phase = Integer.MAX_VALUE;
                        break;
                    }
                    if (CloneableEditor.this.support.getDocument() == null || CloneableEditor.this.support.cesKit() == null) {
                        this.phase = Integer.MAX_VALUE;
                        break;
                    }
                    this.initVisual();
                    if (CloneableEditor.this.newInitialize()) {
                        this.task.schedule(1000);
                        break;
                    }
                }
                case 2: {
                    this.initRest();
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong phase: " + this.phase + " for " + (Object)((Object)CloneableEditor.this.support));
                }
            }
            if (this.phase >= 3) {
                CloneableEditor.this.doInitialize = null;
            }
            long l2 = System.currentTimeMillis() - l;
            if (TIMER.isLoggable(Level.FINE)) {
                Object object;
                String string = SwingUtilities.isEventDispatchThread() ? "AWT" : "RP";
                Document document = this.doc;
                Object object2 = object = document == null ? null : document.getProperty("stream");
                if (object == null) {
                    object = CloneableEditor.this.support.messageName();
                }
                TIMER.log(Level.FINE, "Open Editor, phase " + n + ", " + string + " [ms]", new Object[]{object, l2});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        private int initNonVisual(int var1_1) {
            block42: {
                if (CloneableEditor.access$500().isLoggable(Level.FINE)) {
                    CloneableEditor.access$500().log(Level.FINE, "DoInitialize.initNonVisual Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.access$300(CloneableEditor.this))) + "]" + " Name:" + CloneableEditor.this.getName());
                }
                var2_2 = CloneableEditor.access$300(CloneableEditor.this).prepareDocument();
                if (!DoInitialize.$assertionsDisabled && var2_2 == null) {
                    throw new AssertionError((Object)"Failed to get prepareTask");
                }
                var2_2.waitFinished();
                var3_3 = CloneableEditor.access$300(CloneableEditor.this).getPrepareDocumentRuntimeException();
                if (var3_3 == null) {
                    CloneableEditor.access$602(CloneableEditor.this, false);
                }
                if (!CloneableEditor.access$300(CloneableEditor.this).asynchronousOpen()) ** GOTO lbl77
                if (!(var3_3 instanceof CloneableEditorSupport.DelegateIOExc)) break block42;
                if (!(var3_3.getCause() instanceof UserQuestionException)) ** GOTO lbl74
                if (CloneableEditor.access$800()) {
                    var4_4 = (UserQuestionException)var3_3.getCause();
                    var5_5 = new AWTQuery((UserQuestionException)var4_4);
                    CloneableEditor.access$900().add(var5_5);
                    var6_9 = this;
                    synchronized (var6_9) {
                        this.notifyAll();
                        try {
                            while (CloneableEditor.access$1000().isEmpty() || !CloneableEditor.access$1000().remove(var5_5)) {
                                this.wait();
                            }
                        }
                        catch (InterruptedException var7_11) {
                            Exceptions.printStackTrace((Throwable)var7_11);
                        }
                    }
                    if (AWTQuery.access$1100((AWTQuery)var5_5)) {
                        this.confirmed = true;
                        try {
                            var4_4.confirmed();
                        }
                        catch (IOException var6_10) {
                            Exceptions.printStackTrace((Throwable)var6_10);
                        }
                    }
                } else {
                    var4_4 = new 1Query();
                    try {
                        SwingUtilities.invokeLater((Runnable)var4_4);
                        if (var4_4.awaitAWT()) {
                            var4_4.waitRest();
                        } else {
                            this.confirmed = true;
                        }
                        var5_5 = var4_4;
                        synchronized (var5_5) {
                            var4_4.finished = true;
                        }
                    }
                    catch (InterruptedException var5_6) {
                        Exceptions.printStackTrace((Throwable)var5_6);
                    }
                }
                if (this.confirmed) {
                    CloneableEditor.access$602(CloneableEditor.this, false);
                    var4_4 = (UserQuestionException)var3_3.getCause();
                    try {
                        var4_4.confirmed();
                    }
                    catch (IOException var5_7) {
                        Exceptions.printStackTrace((Throwable)var5_7);
                    }
                    var2_2 = CloneableEditor.access$300(CloneableEditor.this).prepareDocument();
                    if (!DoInitialize.$assertionsDisabled && var2_2 == null) {
                        throw new AssertionError((Object)"Failed to get prepareTask");
                    }
                    var2_2.waitFinished();
                } else {
                    this.cancelLoadingAndCloseEditor();
                    return 0x7FFFFFFF;
lbl74:
                    // 1 sources

                    Exceptions.printStackTrace((Throwable)var3_3.getCause());
                    this.cancelLoadingAndCloseEditor();
                    return 0x7FFFFFFF;
lbl77:
                    // 1 sources

                    if (var3_3 instanceof CloneableEditorSupport.DelegateIOExc) {
                        if (var3_3.getCause() instanceof UserQuestionException) {
                            var4_4 = (UserQuestionException)var3_3.getCause();
                            try {
                                var4_4.confirmed();
                            }
                            catch (IOException var5_8) {
                                // empty catch block
                            }
                            var2_2 = CloneableEditor.access$300(CloneableEditor.this).prepareDocument();
                            if (!DoInitialize.$assertionsDisabled && var2_2 == null) {
                                throw new AssertionError((Object)"Failed to get prepareTask");
                            }
                            var2_2.waitFinished();
                        } else {
                            Exceptions.printStackTrace((Throwable)var3_3.getCause());
                            this.cancelLoadingAndCloseEditor();
                            return 0x7FFFFFFF;
                        }
                    }
                }
            }
            var4_4 = CloneableEditor.this.getActionMap();
            var5_5 = this.tmp.getActionMap();
            var4_4.setParent((ActionMap)var5_5);
            var5_5.put("cut-to-clipboard", CloneableEditor.access$1200(CloneableEditor.this, "cut-to-clipboard"));
            var5_5.put("copy-to-clipboard", CloneableEditor.access$1200(CloneableEditor.this, "copy-to-clipboard"));
            var5_5.put("delete", CloneableEditor.access$1200(CloneableEditor.this, "delete-next"));
            var5_5.put("paste-from-clipboard", CloneableEditor.access$1200(CloneableEditor.this, "paste-from-clipboard"));
            var6_9 = CloneableEditor.access$300(CloneableEditor.this).cesKit();
            if (CloneableEditor.this.newInitialize() && var6_9 instanceof Callable) {
                try {
                    ((Callable)var6_9).call();
                }
                catch (Exception var7_12) {
                    Exceptions.printStackTrace((Throwable)var7_12);
                }
            }
            var7_13 = this;
            synchronized (var7_13) {
                this.doc = CloneableEditor.access$300(CloneableEditor.this).getDocument();
                if (this.doc == null && CloneableEditor.access$500().isLoggable(Level.FINE)) {
                    CloneableEditor.access$500().log(Level.FINE, "DoInitialize.initNonVisual CANNOT set kit because doc is null! Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.access$300(CloneableEditor.this))) + "]" + " Name:" + CloneableEditor.this.getName() + " kit:" + this.kit);
                }
                this.kit = var6_9;
                this.initialized = true;
                if (CloneableEditor.access$500().isLoggable(Level.FINE)) {
                    CloneableEditor.access$500().log(Level.FINE, "DoInitialize.initNonVisual doc and kit are set Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.access$300(CloneableEditor.this))) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + this.doc + " kit:" + this.kit);
                    CloneableEditor.access$500().log(Level.FINE, "DoInitialize.initNonVisual Call notifyAll Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " [" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " Name:" + CloneableEditor.this.getName());
                }
                if (this.doc == null) {
                    var1_1 = 0x7FFFFFFF;
                }
                this.notifyAll();
            }
            return var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelLoadingAndCloseEditor() {
            CloneableEditor.this.isDocLoadingCanceled = true;
            DoInitialize doInitialize = this;
            synchronized (doInitialize) {
                this.notifyAll();
            }
            CloneableEditor.this.isComponentOpened = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object object = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)((Object)CloneableEditor.this));
                    if (null == object) {
                        object = CloneableEditor.this;
                    }
                    object.close();
                }
            });
        }

        private void initCustomEditor() {
            if (this.doc instanceof NbDocument.CustomEditor) {
                NbDocument.CustomEditor customEditor = (NbDocument.CustomEditor)this.doc;
                CloneableEditor.this.customComponent = customEditor.createEditor(this.tmp);
                if (CloneableEditor.this.customComponent == null) {
                    throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomEditor may not" + " return null component");
                }
            }
        }

        private void initDecoration() {
            if (this.doc instanceof NbDocument.CustomToolbar) {
                NbDocument.CustomToolbar customToolbar = (NbDocument.CustomToolbar)this.doc;
                CloneableEditor.this.customToolbar = customToolbar.createToolbar(this.tmp);
                if (CloneableEditor.this.customToolbar == null) {
                    throw new IllegalStateException("Document:" + this.doc + " implementing NbDocument.CustomToolbar may not" + " return null toolbar");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean initDocument() {
            EditorKit editorKit;
            Document document;
            DoInitialize doInitialize = this;
            synchronized (doInitialize) {
                while (true) {
                    if (!tbdList.isEmpty()) {
                        while (!tbdList.isEmpty()) {
                            AWTQuery aWTQuery = (AWTQuery)tbdList.remove(0);
                            aWTQuery.run();
                            finishedList.add(aWTQuery);
                        }
                        this.notifyAll();
                    }
                    document = this.doc;
                    editorKit = this.kit;
                    if (this.initialized) {
                        // MONITOREXIT @DISABLED, blocks:[2, 4, 11] lbl15 : MonitorExitStatement: MONITOREXIT : var3_1
                        if (document == null) return false;
                        break;
                    }
                    if (CloneableEditor.this.isDocLoadingCanceled) {
                        CloneableEditor.this.releasePane();
                        return false;
                    }
                    try {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "DoInitialize.initDocument Starting wait Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + document + " kit:" + editorKit);
                        }
                        this.wait();
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "DoInitialize.initDocument Wait finished Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName() + " doc:" + document + " kit:" + editorKit);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
            }
            if (this.tmp.getDocument() == document) return false;
            this.tmp.setEditorKit(editorKit);
            this.tmp.setWorking(1);
            this.tmp.setDocument(document);
            return true;
        }

        final void initVisual() {
            Object object;
            if (CloneableEditor.this.isDocLoadingCanceled) {
                return;
            }
            if (this.isInInitVisual) {
                return;
            }
            this.isInInitVisual = true;
            if (!this.initDocument()) {
                this.isInInitVisual = false;
                return;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "DoInitialize.initVisual Enter Time:" + System.currentTimeMillis() + " Thread:" + Thread.currentThread().getName() + " ce:[" + Integer.toHexString(System.identityHashCode(CloneableEditor.this)) + "]" + " this:[" + Integer.toHexString(System.identityHashCode(this)) + "]" + " support:[" + Integer.toHexString(System.identityHashCode((Object)CloneableEditor.this.support)) + "]" + " Name:" + CloneableEditor.this.getName());
            }
            this.initCustomEditor();
            if (CloneableEditor.this.customComponent != null) {
                CloneableEditor.this.add(CloneableEditor.this.support.wrapEditorComponent(CloneableEditor.this.customComponent), "Center");
            } else {
                object = new JScrollPane(this.tmp);
                this.tmp.setBorder(null);
                CloneableEditor.this.add(CloneableEditor.this.support.wrapEditorComponent((Component)object), "Center");
            }
            this.initDecoration();
            if (CloneableEditor.this.customToolbar != null) {
                object = (Border)UIManager.get("Nb.Editor.Toolbar.border");
                CloneableEditor.this.customToolbar.setBorder((Border)object);
                CloneableEditor.this.add(CloneableEditor.this.customToolbar, "North");
            }
            CloneableEditor.this.remove(this.tmpComp);
            this.tmp.setWorking(3);
            if (CloneableEditor.this.cursorPosition != -1 && (object = this.tmp.getCaret()) != null) {
                object.setDot(CloneableEditor.this.cursorPosition);
            }
            object = CloneableEditor.this.getActionMap().getParent();
            CloneableEditor.this.getActionMap().setParent(null);
            CloneableEditor.this.getActionMap().setParent((ActionMap)object);
            if (this.shouldRequestFocus(this.tmp)) {
                LOG.log(Level.FINE, "requestFocusInWindow {0}", this.tmp);
                CloneableEditor.this.requestFocusInWindow();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CloneableEditor.this.revalidate();
                }
            });
            this.isInInitVisual = false;
            CloneableEditor.this.initVisualFinished = true;
            CloneableEditorSupport cloneableEditorSupport = CloneableEditor.this.cloneableEditorSupport();
            if (cloneableEditorSupport != null) {
                cloneableEditorSupport.firePropertyChange("openedPanes", null, null);
            }
        }

        private boolean shouldRequestFocus(Component component) {
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            while (component != null) {
                if (component == topComponent) {
                    return true;
                }
                component = component.getParent();
            }
            return false;
        }

        private void initRest() {
            RPPostprocessing.post(new Runnable(){

                @Override
                public void run() {
                    CloneableEditor.this.support.ensureAnnotationsLoaded();
                }
            });
        }
    }

    class AWTQuery
    implements Runnable {
        private UserQuestionException ex;
        private boolean isConfirmed;

        public AWTQuery(UserQuestionException userQuestionException) {
            this.ex = userQuestionException;
        }

        public boolean confirmed() {
            return this.isConfirmed;
        }

        @Override
        public void run() {
            NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)this.ex.getLocalizedMessage(), 0);
            confirmation.setOptions(new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION});
            isModalDialog = true;
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
            isModalDialog = false;
            this.isConfirmed = NotifyDescriptor.OK_OPTION.equals(object);
        }

        static /* synthetic */ boolean access$1100(AWTQuery aWTQuery) {
            return aWTQuery.isConfirmed;
        }
    }
}

