/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JComponent;
import javax.swing.JFrame;

public final class ChartRenderingToolkit {
    private static final double LOG10FACT = 1.0 / Math.log(10.0);
    private static final double LOG2FACT = 1.0 / Math.log(2.0);
    private static final Stroke BOUNDARY_STROKE;

    static {
        float[] dash = new float[]{3.0f, 8.0f};
        BOUNDARY_STROKE = new BasicStroke(0.5f, 0, 0, 1.0f, dash, 0.0f);
    }

    private ChartRenderingToolkit() {
    }

    public static void markBoundary(Graphics2D ctx, int x, int y, int width, int height, Color c) {
        Color oldColor = ctx.getColor();
        Stroke oldStroke = ctx.getStroke();
        ctx.setColor(c);
        ctx.setStroke(BOUNDARY_STROKE);
        ctx.drawRect(x, y, width, height);
        ctx.setColor(oldColor);
        ctx.setStroke(oldStroke);
    }

    public static void paintCross(Graphics2D ctx, int x, int y, int size, Color c) {
        Color oldColor = ctx.getColor();
        Stroke oldStroke = ctx.getStroke();
        ctx.setColor(c);
        ctx.drawLine(x - size, y - size, x + size, y + size);
        ctx.drawLine(x - size, y + size, x + size, y - size);
        ctx.setColor(oldColor);
        ctx.setStroke(oldStroke);
    }

    public static double log10(double n) {
        return Math.log(n) * LOG10FACT;
    }

    public static double log2(double n) {
        return Math.log(n) * LOG2FACT;
    }

    public static void testComponent(JComponent panel, int width, int height) {
        JFrame frame = new JFrame("Testing " + panel.getName());
        frame.setContentPane(panel);
        frame.setSize(width, height);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    public static double fastFloor(double f) {
        if (f < 0.0) {
            return (long)f - 1L;
        }
        return (long)f;
    }
}

