/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.builders;

import bluej.doclet.doclets.internal.toolkit.AnnotationTypeWriter;
import bluej.doclet.doclets.internal.toolkit.ClassWriter;
import bluej.doclet.doclets.internal.toolkit.Configuration;
import bluej.doclet.doclets.internal.toolkit.MemberSummaryWriter;
import bluej.doclet.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import bluej.doclet.doclets.internal.toolkit.util.DocFinder;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import bluej.doclet.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MemberSummaryBuilder
extends AbstractMemberBuilder {
    public static final String NAME = "MemberSummary";
    private VisibleMemberMap[] visibleMemberMaps;
    private MemberSummaryWriter[] memberSummaryWriters;
    private ClassDoc classDoc;

    private MemberSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MemberSummaryBuilder getInstance(ClassWriter classWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(configuration);
        builder.classDoc = classWriter.getClassDoc();
        builder.init(classWriter);
        return builder;
    }

    public static MemberSummaryBuilder getInstance(AnnotationTypeWriter annotationTypeWriter, Configuration configuration) throws Exception {
        MemberSummaryBuilder builder = new MemberSummaryBuilder(configuration);
        builder.classDoc = annotationTypeWriter.getAnnotationTypeDoc();
        builder.init(annotationTypeWriter);
        return builder;
    }

    private void init(Object writer) throws Exception {
        int i;
        this.visibleMemberMaps = new VisibleMemberMap[7];
        for (i = 0; i < 7; ++i) {
            this.visibleMemberMaps[i] = new VisibleMemberMap(this.classDoc, i, this.configuration.nodeprecated);
        }
        this.memberSummaryWriters = new MemberSummaryWriter[7];
        for (i = 0; i < 7; ++i) {
            this.memberSummaryWriters[i] = this.classDoc.isAnnotationType() ? (this.visibleMemberMaps[i].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((AnnotationTypeWriter)writer, i)) : (this.visibleMemberMaps[i].noVisibleMembers() ? null : this.configuration.getWriterFactory().getMemberSummaryWriter((ClassWriter)writer, i));
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    public VisibleMemberMap getVisibleMemberMap(int type) {
        return this.visibleMemberMaps[type];
    }

    public MemberSummaryWriter getMemberSummaryWriter(int type) {
        return this.memberSummaryWriters[type];
    }

    public List members(int type) {
        return this.visibleMemberMaps[type].getLeafClassMembers(this.configuration);
    }

    @Override
    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    @Override
    public boolean hasMembersToDocument() {
        if (this.classDoc instanceof AnnotationTypeDoc) {
            return ((AnnotationTypeDoc)this.classDoc).elements().length > 0;
        }
        for (int i = 0; i < 7; ++i) {
            VisibleMemberMap members = this.visibleMemberMaps[i];
            if (members.noVisibleMembers()) continue;
            return true;
        }
        return false;
    }

    public void buildEnumConstantsSummary() {
        this.buildSummary(this.memberSummaryWriters[1], this.visibleMemberMaps[1]);
    }

    public void buildAnnotationTypeOptionalMemberSummary() {
        this.buildSummary(this.memberSummaryWriters[5], this.visibleMemberMaps[5]);
    }

    public void buildAnnotationTypeRequiredMemberSummary() {
        this.buildSummary(this.memberSummaryWriters[6], this.visibleMemberMaps[6]);
    }

    public void buildFieldsSummary() {
        this.buildSummary(this.memberSummaryWriters[2], this.visibleMemberMaps[2]);
    }

    public void buildFieldsInheritedSummary() {
        this.buildInheritedSummary(this.memberSummaryWriters[2], this.visibleMemberMaps[2]);
    }

    public void buildNestedClassesSummary() {
        this.buildSummary(this.memberSummaryWriters[0], this.visibleMemberMaps[0]);
    }

    public void buildNestedClassesInheritedSummary() {
        this.buildInheritedSummary(this.memberSummaryWriters[0], this.visibleMemberMaps[0]);
    }

    public void buildMethodsSummary() {
        this.buildSummary(this.memberSummaryWriters[4], this.visibleMemberMaps[4]);
    }

    public void buildMethodsInheritedSummary() {
        this.buildInheritedSummary(this.memberSummaryWriters[4], this.visibleMemberMaps[4]);
    }

    public void buildConstructorsSummary() {
        this.buildSummary(this.memberSummaryWriters[3], this.visibleMemberMaps[3]);
    }

    private void buildSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap) {
        ArrayList members = new ArrayList(visibleMemberMap.getLeafClassMembers(this.configuration));
        if (members.size() > 0) {
            Collections.sort(members);
            writer.writeMemberSummaryHeader(this.classDoc);
            for (int i = 0; i < members.size(); ++i) {
                ProgramElementDoc member = (ProgramElementDoc)members.get(i);
                Tag[] firstSentenceTags = member.firstSentenceTags();
                if (member instanceof MethodDoc && firstSentenceTags.length == 0) {
                    DocFinder.Output inheritedDoc = DocFinder.search(new DocFinder.Input((MethodDoc)member));
                    if (inheritedDoc.holder != null && inheritedDoc.holder.firstSentenceTags().length > 0) {
                        firstSentenceTags = inheritedDoc.holder.firstSentenceTags();
                    }
                }
                writer.writeMemberSummary(this.classDoc, member, firstSentenceTags, i == 0, i == members.size() - 1);
            }
            writer.writeMemberSummaryFooter(this.classDoc);
        }
    }

    private void buildInheritedSummary(MemberSummaryWriter writer, VisibleMemberMap visibleMemberMap) {
        for (ClassDoc inhclass : visibleMemberMap.getVisibleClassesList()) {
            List inhmembers;
            if (!inhclass.isPublic() && !Util.isLinkable(inhclass, this.configuration) || inhclass == this.classDoc || (inhmembers = visibleMemberMap.getMembersFor(inhclass)).size() <= 0) continue;
            Collections.sort(inhmembers);
            writer.writeInheritedMemberSummaryHeader(inhclass);
            for (int j = 0; j < inhmembers.size(); ++j) {
                writer.writeInheritedMemberSummary(inhclass.isPackagePrivate() && !Util.isLinkable(inhclass, this.configuration) ? this.classDoc : inhclass, (ProgramElementDoc)inhmembers.get(j), j == 0, j == inhmembers.size() - 1);
            }
            writer.writeInheritedMemberSummaryFooter(inhclass);
        }
    }
}

