/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.builders;

import bluej.doclet.doclets.internal.toolkit.Configuration;
import bluej.doclet.doclets.internal.toolkit.ConstantsSummaryWriter;
import bluej.doclet.doclets.internal.toolkit.builders.AbstractBuilder;
import bluej.doclet.doclets.internal.toolkit.builders.LayoutParser;
import bluej.doclet.doclets.internal.toolkit.util.VisibleMemberMap;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ConstantsSummaryBuilder
extends AbstractBuilder {
    public static final String ROOT = "ConstantSummary";
    public static final int MAX_CONSTANT_VALUE_INDEX_LENGTH = 2;
    protected ConstantsSummaryWriter writer;
    protected Set classDocsWithConstFields;
    protected Set printedPackageHeaders;
    private PackageDoc currentPackage;
    private ClassDoc currentClass;

    private ConstantsSummaryBuilder(Configuration configuration) {
        super(configuration);
    }

    public static ConstantsSummaryBuilder getInstance(Configuration configuration, ConstantsSummaryWriter writer) {
        ConstantsSummaryBuilder builder = new ConstantsSummaryBuilder(configuration);
        builder.writer = writer;
        builder.classDocsWithConstFields = new HashSet();
        return builder;
    }

    @Override
    public void invokeMethod(String methodName, Class[] paramClasses, Object[] params) throws Exception {
        Method method = this.getClass().getMethod(methodName, paramClasses);
        method.invoke((Object)this, params);
    }

    @Override
    public void build() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.build(LayoutParser.getInstance(this.configuration).parseXML(ROOT));
    }

    @Override
    public String getName() {
        return ROOT;
    }

    public void buildConstantSummary(List elements) throws Exception {
        this.build(elements);
        this.writer.close();
    }

    public void buildHeader() {
        this.writer.writeHeader();
    }

    public void buildFooter() {
        this.writer.writeFooter();
    }

    public void buildContents() {
        this.writer.writeContentsHeader();
        PackageDoc[] packages = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        for (int i = 0; i < packages.length; ++i) {
            if (!this.hasConstantField(packages[i]) || this.hasPrintedPackageIndex(packages[i].name())) continue;
            this.writer.writeLinkToPackageContent(packages[i], this.parsePackageName(packages[i].name()), this.printedPackageHeaders);
        }
        this.writer.writeContentsFooter();
    }

    public void buildConstantSummaries(List elements) {
        PackageDoc[] packages = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        for (int i = 0; i < packages.length; ++i) {
            if (!this.hasConstantField(packages[i])) continue;
            this.currentPackage = packages[i];
            this.build(elements);
        }
    }

    public void buildPackageConstantSummary(List elements) {
        this.build(elements);
    }

    public void buildClassConstantSummary(List elements) {
        Object[] classes = this.currentPackage.name().length() > 0 ? this.currentPackage.allClasses() : this.configuration.classDocCatalog.allClasses("&lt;Unnamed&gt;");
        Arrays.sort(classes);
        for (int i = 0; i < classes.length; ++i) {
            if (!this.classDocsWithConstFields.contains(classes[i]) || !classes[i].isIncluded()) continue;
            this.currentClass = classes[i];
            this.build(elements);
        }
    }

    public void buildPackageHeader() {
        String parsedPackageName = this.parsePackageName(this.currentPackage.name());
        if (!this.printedPackageHeaders.contains(parsedPackageName)) {
            this.writer.writePackageName(this.currentPackage, this.parsePackageName(this.currentPackage.name()));
            this.printedPackageHeaders.add(parsedPackageName);
        }
    }

    public void buildClassHeader() {
        this.writer.writeConstantMembersHeader(this.currentClass);
    }

    public void buildConstantMembers() {
        new ConstantFieldBuilder(this.currentClass).buildMembersSummary();
    }

    public void buildClassFooter() {
        this.writer.writeConstantMembersFooter(this.currentClass);
    }

    private boolean hasConstantField(PackageDoc pkg) {
        ClassDoc[] classes = pkg.name().length() > 0 ? pkg.allClasses() : this.configuration.classDocCatalog.allClasses("&lt;Unnamed&gt;");
        boolean found = false;
        for (int j = 0; j < classes.length; ++j) {
            if (!classes[j].isIncluded() || !this.hasConstantField(classes[j])) continue;
            found = true;
        }
        return found;
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        VisibleMemberMap visibleMemberMapFields = new VisibleMemberMap(classDoc, 2, this.configuration.nodeprecated);
        List fields = visibleMemberMapFields.getLeafClassMembers(this.configuration);
        for (FieldDoc field : fields) {
            if (field.constantValueExpression() == null) continue;
            this.classDocsWithConstFields.add(classDoc);
            return true;
        }
        return false;
    }

    private boolean hasPrintedPackageIndex(String pkgname) {
        String[] list = this.printedPackageHeaders.toArray(new String[0]);
        for (int i = 0; i < list.length; ++i) {
            if (!pkgname.startsWith(list[i])) continue;
            return true;
        }
        return false;
    }

    private String parsePackageName(String pkgname) {
        int index = -1;
        for (int j = 0; j < 2; ++j) {
            index = pkgname.indexOf(".", index + 1);
        }
        if (index != -1) {
            pkgname = pkgname.substring(0, index);
        }
        return pkgname;
    }

    private class ConstantFieldBuilder {
        protected VisibleMemberMap visibleMemberMapFields = null;
        protected VisibleMemberMap visibleMemberMapEnumConst = null;
        protected ClassDoc classdoc;

        public ConstantFieldBuilder(ClassDoc classdoc) {
            this.classdoc = classdoc;
            this.visibleMemberMapFields = new VisibleMemberMap(classdoc, 2, ConstantsSummaryBuilder.this.configuration.nodeprecated);
            this.visibleMemberMapEnumConst = new VisibleMemberMap(classdoc, 1, ConstantsSummaryBuilder.this.configuration.nodeprecated);
        }

        protected void buildMembersSummary() {
            ArrayList members = new ArrayList(this.members());
            if (members.size() > 0) {
                Collections.sort(members);
                ConstantsSummaryBuilder.this.writer.writeConstantMembers(this.classdoc, members);
            }
        }

        protected List members() {
            List l = this.visibleMemberMapFields.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration);
            l.addAll(this.visibleMemberMapEnumConst.getLeafClassMembers(ConstantsSummaryBuilder.this.configuration));
            if (l == null) {
                return null;
            }
            Iterator iter = l.iterator();
            LinkedList<FieldDoc> inclList = new LinkedList<FieldDoc>();
            while (iter.hasNext()) {
                FieldDoc member = (FieldDoc)iter.next();
                if (member.constantValue() == null) continue;
                inclList.add(member);
            }
            return inclList;
        }
    }
}

