/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.ModuleFactory;
import org.netbeans.ProxyClassPackages;
import org.netbeans.ProxyClassParents;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;

public class ProxyClassLoader
extends ClassLoader {
    private static final Logger LOGGER = Logger.getLogger(ProxyClassLoader.class.getName());
    private static final boolean LOG_LOADING;
    private static final ClassLoader TOP_CL;
    private final Map<String, Package> packages = new HashMap<String, Package>();
    volatile ProxyClassParents parents;
    private static final Set<String> arbitraryLoadWarnings;
    private static Map<String, Boolean> sclPackages;

    public ProxyClassLoader(ClassLoader[] classLoaderArray, boolean bl) {
        super(TOP_CL);
        this.parents = ProxyClassParents.coalesceParents(this, classLoaderArray, TOP_CL, bl);
    }

    protected final void addCoveredPackages(Iterable<String> iterable) {
        ProxyClassPackages.addCoveredPackages(this, iterable);
    }

    public void append(ClassLoader[] classLoaderArray) throws IllegalArgumentException {
        if (classLoaderArray == null) {
            throw new IllegalArgumentException("null parents array");
        }
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader != null) continue;
            throw new IllegalArgumentException("null parent: " + Arrays.asList(classLoaderArray));
        }
        ClassLoader[] classLoaderArray2 = null;
        ModuleFactory moduleFactory = (ModuleFactory)Lookup.getDefault().lookup(ModuleFactory.class);
        this.parents = moduleFactory != null && moduleFactory.removeBaseClassLoader() ? ProxyClassParents.coalesceParents(this, classLoaderArray, ClassLoader.getSystemClassLoader(), this.parents.isTransitive()) : this.parents.append(this, classLoaderArray);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        if (LOG_LOADING && !string.startsWith("java.")) {
            LOGGER.log(Level.FINEST, "{0} initiated loading of {1}", new Object[]{this, string});
        }
        Class clazz = null;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            throw new ClassNotFoundException("Will not load classes from default package (" + string + ")");
        }
        String string2 = n >= 0 ? string.substring(0, n) : "";
        String string3 = string2.replace('.', '/') + "/";
        Set<ProxyClassLoader> set = ProxyClassPackages.findCoveredPkg(string2);
        Boolean bl2 = ProxyClassLoader.isSystemPackage(string2);
        if ((bl2 == null || bl2.booleanValue()) && this.shouldDelegateResource(string3, null)) {
            try {
                clazz = this.parents.systemCL().loadClass(string);
                if (bl2 == null) {
                    ProxyClassLoader.registerSystemPackage(string2, true);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (set != null) {
            if (set.size() == 1) {
                ProxyClassLoader proxyClassLoader = set.iterator().next();
                if ((proxyClassLoader == this || this.parents.contains(proxyClassLoader) && this.shouldDelegateResource(string3, proxyClassLoader)) && (clazz = super.selfLoadClass(string2, string)) != null) {
                    ProxyClassLoader.registerSystemPackage(string2, false);
                }
            } else {
                for (ProxyClassLoader proxyClassLoader : this.parents.loaders()) {
                    Class clazz2;
                    if (!set.contains(proxyClassLoader) || !this.shouldDelegateResource(string3, proxyClassLoader) || (clazz2 = proxyClassLoader.selfLoadClass(string2, string)) == null) continue;
                    if (clazz == null) {
                        clazz = clazz2;
                        continue;
                    }
                    if (clazz == clazz2) continue;
                    String string4 = "Will not load class " + string + " arbitrarily from one of " + clazz.getClassLoader() + " and " + proxyClassLoader + " starting from " + this + "; see http://wiki.netbeans.org/DevFaqModuleCCE";
                    ClassNotFoundException classNotFoundException = new ClassNotFoundException(string4);
                    if (arbitraryLoadWarnings.add(string4)) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, null, classNotFoundException);
                        } else {
                            LOGGER.warning(string4);
                        }
                    }
                    throw classNotFoundException;
                }
                if (clazz == null && set.contains(this)) {
                    clazz = this.selfLoadClass(string2, string);
                }
                if (clazz != null) {
                    ProxyClassLoader.registerSystemPackage(string2, false);
                }
            }
        }
        if (clazz == null && this.shouldDelegateResource(string3, null)) {
            try {
                clazz = this.parents.systemCL().loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ClassNotFoundException(this.diagnosticCNFEMessage(classNotFoundException.getMessage(), set), classNotFoundException);
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(this.diagnosticCNFEMessage(string, set));
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private String diagnosticCNFEMessage(String string, Set<ProxyClassLoader> set) {
        int n = this.parents.size();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(" starting from ").append(this).append(" with possible defining loaders ").append(set).append(" and declared parents ");
        Iterator<ProxyClassLoader> iterator = this.parents.loaders().iterator();
        for (int i = 0; i < 10 && iterator.hasNext(); ++i) {
            stringBuilder.append(i == 0 ? "[" : ", ");
            stringBuilder.append(iterator.next());
        }
        if (iterator.hasNext()) {
            stringBuilder.append(", ...").append(n - 10).append(" more");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private synchronized Class selfLoadClass(String string, String string2) {
        Class clazz = this.findLoadedClass(string2);
        if (clazz == null) {
            try {
                clazz = this.doLoadClass(string, string2);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw (NoClassDefFoundError)new NoClassDefFoundError(noClassDefFoundError.getMessage() + " while loading " + string2 + "; see http://wiki.netbeans.org/DevFaqTroubleshootClassNotFound").initCause(noClassDefFoundError);
            }
            if (LOG_LOADING && !string2.startsWith("java.")) {
                LOGGER.log(Level.FINEST, "{0} loaded {1}", new Object[]{this, string2});
            }
        }
        return clazz;
    }

    protected Class doLoadClass(String string, String string2) {
        return null;
    }

    private String stripInitialSlash(String string) {
        if (string.startsWith("/")) {
            LOGGER.log(Level.WARNING, "Should not use initial '/' in calls to ClassLoader.getResource(s): {0}", string);
            return string.substring(1);
        }
        return string;
    }

    @Override
    public final URL getResource(String string) {
        return this.getResourceImpl(string);
    }

    URL getResourceImpl(String string) {
        Object object;
        Set<ProxyClassLoader> set;
        String string2;
        String string3;
        URL uRL = null;
        int n = (string = this.stripInitialSlash(string)).lastIndexOf(47);
        if (n >= 0) {
            string2 = string3 = string.substring(0, n).replace('/', '.');
        } else {
            string3 = "";
            string2 = "default/" + string;
        }
        String string4 = string.substring(0, n + 1);
        Boolean bl = ProxyClassLoader.isSystemPackage(string3);
        if ((bl == null || bl.booleanValue()) && this.shouldDelegateResource(string4, null) && (set = this.parents.systemCL().getResource(string)) != null) {
            if (bl == null) {
                ProxyClassLoader.registerSystemPackage(string3, true);
            }
            return set;
        }
        set = ProxyClassPackages.findCoveredPkg(string2);
        if (string3.length() == 0 && (object = ProxyClassPackages.findCoveredPkg(string3)) != null) {
            if (set != null) {
                set = new HashSet<ProxyClassLoader>(set);
                set.addAll((Collection<ProxyClassLoader>)object);
            } else {
                set = object;
            }
        }
        if (set == null) {
            if (this.shouldDelegateResource(string4, null)) {
                uRL = this.parents.systemCL().getResource(string);
            }
        } else if (set.size() == 1) {
            object = (ProxyClassLoader)set.iterator().next();
            if (object == this || this.parents.contains((ProxyClassLoader)object) && this.shouldDelegateResource(string4, (ClassLoader)object)) {
                uRL = ((ProxyClassLoader)object).findResource(string);
            }
        } else {
            ProxyClassLoader proxyClassLoader;
            object = this.parents.loaders().iterator();
            while (!(!object.hasNext() || set.contains(proxyClassLoader = object.next()) && this.shouldDelegateResource(string4, proxyClassLoader) && (uRL = proxyClassLoader.findResource(string)) != null)) {
            }
            if (uRL == null && set.contains(this)) {
                uRL = this.findResource(string);
            }
        }
        if (uRL == null && this.shouldDelegateResource(string4, null)) {
            uRL = this.parents.systemCL().getResource(string);
        }
        return uRL;
    }

    @Override
    public URL findResource(String string) {
        return super.findResource(string);
    }

    @Override
    public final Enumeration<URL> getResources(String string) throws IOException {
        return this.getResourcesImpl(string);
    }

    synchronized Enumeration<URL> getResourcesImpl(String string) throws IOException {
        Object object;
        String string2;
        string = this.stripInitialSlash(string);
        int n = string.lastIndexOf(47);
        String string3 = string.substring(0, n + 1);
        String string4 = null;
        if (n >= 0) {
            string2 = string.startsWith("META-INF/") ? string.substring(8) : string.substring(0, n).replace('/', '.');
        } else {
            string2 = "default/" + string;
            string4 = "";
        }
        ArrayList<Enumeration<URL>> arrayList = new ArrayList<Enumeration<URL>>();
        if (this.shouldDelegateResource(string3, null)) {
            arrayList.add(this.parents.systemCL().getResources(string));
        }
        HashSet hashSet = ProxyClassPackages.findCoveredPkg(string2);
        if (string4 != null && (object = ProxyClassPackages.findCoveredPkg(string4)) != null) {
            if (hashSet != null) {
                hashSet = new HashSet(hashSet);
                hashSet.addAll(object);
            } else {
                hashSet = object;
            }
        }
        if (hashSet != null) {
            for (ProxyClassLoader proxyClassLoader : this.parents.loaders()) {
                if (!hashSet.contains(proxyClassLoader) || !this.shouldDelegateResource(string3, proxyClassLoader)) continue;
                arrayList.add(proxyClassLoader.findResources(string));
            }
            if (hashSet.contains(this)) {
                arrayList.add(this.findResources(string));
            }
        }
        return Enumerations.concat(Collections.enumeration(arrayList));
    }

    @Override
    public Enumeration<URL> findResources(String string) throws IOException {
        return super.findResources(string);
    }

    @Override
    protected Package getPackage(String string) {
        return this.getPackageFast(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackageFast(String string, boolean bl) {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            ProxyClassLoader proxyClassLoader;
            Package package_ = this.packages.get(string);
            if (package_ != null) {
                return package_;
            }
            if (!bl) {
                return null;
            }
            Iterator<ProxyClassLoader> iterator = this.parents.loaders().iterator();
            while (iterator.hasNext() && (package_ = (proxyClassLoader = iterator.next()).getPackageFast(string, false)) == null) {
            }
            if (package_ == null) {
                package_ = super.getPackage(string);
            }
            if (package_ != null) {
                this.packages.put(string, package_);
            }
            return package_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            Package package_ = super.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
            this.packages.put(string, package_);
            return package_;
        }
    }

    @Override
    protected synchronized Package[] getPackages() {
        return this.getPackages(new HashSet<ClassLoader>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Package[] getPackages(Set<ClassLoader> set) {
        HashMap<String, Package> hashMap = new HashMap<String, Package>();
        this.addPackages(hashMap, super.getPackages());
        for (ProxyClassLoader proxyClassLoader : this.parents.loaders()) {
            if (!(proxyClassLoader instanceof ProxyClassLoader) || !set.add(proxyClassLoader)) continue;
            this.addPackages(hashMap, proxyClassLoader.getPackages(set));
        }
        Map<String, Package> map = this.packages;
        synchronized (map) {
            hashMap.keySet().removeAll(this.packages.keySet());
            this.packages.putAll(hashMap);
            return this.packages.values().toArray(new Package[this.packages.size()]);
        }
    }

    private void addPackages(Map<String, Package> map, Package[] packageArray) {
        for (int i = 0; i < packageArray.length; ++i) {
            map.put(packageArray[i].getName(), packageArray[i]);
        }
    }

    protected final void setSystemClassLoader(ClassLoader classLoader) {
        this.parents = this.parents.changeSystemClassLoader(classLoader);
    }

    protected boolean shouldDelegateResource(String string, ClassLoader classLoader) {
        return true;
    }

    public void destroy() {
        ProxyClassPackages.removeCoveredPakcages(this);
    }

    final ClassLoader firstParent() {
        Iterator<ProxyClassLoader> iterator = this.parents.loaders().iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    private static Boolean isSystemPackage(String string) {
        return sclPackages.get(string);
    }

    private static void registerSystemPackage(String string, boolean bl) {
        sclPackages.put(string, bl);
    }

    static {
        TOP_CL = ProxyClassLoader.class.getClassLoader();
        boolean bl = System.getProperty("org.netbeans.ProxyClassLoader.level") != null;
        LOG_LOADING = bl || LOGGER.isLoggable(Level.FINE);
        arbitraryLoadWarnings = Collections.synchronizedSet(new HashSet());
        sclPackages = Collections.synchronizedMap(new HashMap());
    }
}

