/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.compiler.CompileObserver;
import bluej.compiler.Diagnostic;
import bluej.compiler.JobQueue;
import bluej.pkgmgr.Package;
import bluej.utility.Debug;
import java.io.File;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import rmiextension.wrappers.RCompileObserver;
import rmiextension.wrappers.RJobQueue;

public class RJobQueueImpl
extends UnicastRemoteObject
implements RJobQueue {
    private JobQueue queue = JobQueue.getJobQueue();
    private Package pkg;

    public RJobQueueImpl(Package pkg) throws RemoteException {
        this.pkg = pkg;
    }

    @Override
    public void compile(File[] files, final RCompileObserver observer) throws RemoteException {
        CompileObserver cobserver = new CompileObserver(){

            public void startCompile(File[] sources) {
                try {
                    observer.startCompile(sources);
                }
                catch (ServerError se) {
                    Debug.reportError((String)("Server error in RMI call: " + se.getCause()));
                }
                catch (ServerException se) {
                    Debug.reportError((String)("Server error in RMI call: " + se.getCause()));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            public void endCompile(File[] sources, boolean successful) {
                try {
                    observer.endCompile(sources, successful);
                }
                catch (ServerError se) {
                    Debug.reportError((String)("Server error in RMI call: " + se.getCause()));
                }
                catch (ServerException se) {
                    Debug.reportError((String)("Server error in RMI call: " + se.getCause()));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            public boolean compilerMessage(Diagnostic diagnostic) {
                try {
                    observer.compilerMessage(diagnostic);
                }
                catch (ServerError se) {
                    Debug.reportError((String)("Server error in RMI call: " + se.getCause()));
                }
                catch (ServerException se) {
                    Debug.reportError((String)("Server error in RMI call: " + se.getCause()));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                return true;
            }
        };
        this.queue.addJob(files, cobserver, this.pkg.getProject().getClassLoader(), this.pkg.getPath(), true, this.pkg.getProject().getProjectCharset());
    }
}

