/*
 * Decompiled with CFR 0.152.
 */
package rmiextension.wrappers;

import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeIndent;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.extensions.BClass;
import bluej.extensions.BConstructor;
import bluej.extensions.BField;
import bluej.extensions.BMethod;
import bluej.extensions.BPackage;
import bluej.extensions.ClassNotFoundException;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.extensions.editor.Editor;
import bluej.extensions.editor.EditorBridge;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import bluej.parser.nodes.RBTreeNode;
import bluej.utility.Debug;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import rmiextension.wrappers.RClass;
import rmiextension.wrappers.RConstructor;
import rmiextension.wrappers.RField;
import rmiextension.wrappers.RPackage;
import rmiextension.wrappers.WrapperPool;

public class RClassImpl
extends UnicastRemoteObject
implements RClass {
    private BClass bClass;
    private static ProjectNotOpenException pnoe;
    private static PackageNotFoundException pnfe;

    RClassImpl(BClass bClass) throws RemoteException {
        this.bClass = bClass;
        if (bClass == null) {
            throw new NullPointerException("Argument can't be null");
        }
    }

    @Override
    public void compile(boolean waitCompileEnd, boolean forceQuiet) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        this.bClass.compile(waitCompileEnd, forceQuiet);
    }

    @Override
    public boolean hasSourceCode() throws ProjectNotOpenException, PackageNotFoundException {
        return ExtensionBridge.hasSourceCode((BClass)this.bClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void edit() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Class<RClassImpl> clazz = RClassImpl.class;
        synchronized (RClassImpl.class) {
            pnoe = null;
            pnfe = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Editor editor = RClassImpl.this.bClass.getEditor();
                        if (editor != null) {
                            editor.setVisible(true);
                        }
                    }
                    catch (ProjectNotOpenException e) {
                        pnoe = e;
                    }
                    catch (PackageNotFoundException e) {
                        pnfe = e;
                    }
                }
            });
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEditor() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        Class<RClassImpl> clazz = RClassImpl.class;
        synchronized (RClassImpl.class) {
            pnoe = null;
            pnfe = null;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        Editor editor = RClassImpl.this.bClass.getEditor();
                        if (editor != null) {
                            editor.setVisible(false);
                        }
                    }
                    catch (ProjectNotOpenException e) {
                        pnoe = e;
                    }
                    catch (PackageNotFoundException e) {
                        pnfe = e;
                    }
                }
            });
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void showMessage(final String message) throws RemoteException, ProjectNotOpenException, PackageNotFoundException {
        final Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                e.showMessage(message);
            }
        });
    }

    @Override
    public void insertAppendMethod(final String comment, final String access, final String methodName, final String methodBody, final boolean showEditorOnCreate, final boolean showEditorOnAppend) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        final Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoeEditor bje = (MoeEditor)EditorBridge.getEditor((Editor)e);
                MoeSyntaxDocument doc = bje.getSourceDocument();
                NodeTree.NodeAndPosition classNode = RClassImpl.this.findClassNode(doc);
                if (classNode == null) {
                    return;
                }
                NodeTree.NodeAndPosition existingMethodNode = RClassImpl.this.findMethodNode(methodName, (NodeTree.NodeAndPosition<ParsedNode>)classNode);
                if (existingMethodNode != null) {
                    RClassImpl.this.appendTextToNode(e, bje, (NodeTree.NodeAndPosition<ParsedNode>)existingMethodNode, methodBody);
                    if (showEditorOnAppend) {
                        e.setVisible(true);
                    }
                } else {
                    String fullMethod = comment + "    " + access + " void " + methodName + "()\n    {\n" + methodBody + "    }\n";
                    RClassImpl.this.appendTextToNode(e, bje, (NodeTree.NodeAndPosition<ParsedNode>)classNode, fullMethod);
                    if (showEditorOnCreate) {
                        e.setVisible(true);
                    }
                }
            }
        });
    }

    private NodeTree.NodeAndPosition<ParsedNode> findClassNode(MoeSyntaxDocument doc) {
        NodeTree.NodeAndPosition root = new NodeTree.NodeAndPosition((RBTreeNode)doc.getParser(), 0, doc.getParser().getSize());
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable((NodeTree.NodeAndPosition<ParsedNode>)root)) {
            if (((ParsedNode)nap.getNode()).getNodeType() != 1) continue;
            return nap;
        }
        return null;
    }

    @Override
    public void insertMethodCallInConstructor(final String methodName, final boolean showEditor) throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        final Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoeEditor bje = (MoeEditor)EditorBridge.getEditor((Editor)e);
                MoeSyntaxDocument doc = bje.getSourceDocument();
                NodeTree.NodeAndPosition classNode = RClassImpl.this.findClassNode(doc);
                if (classNode == null) {
                    return;
                }
                NodeTree.NodeAndPosition constructor = RClassImpl.this.findMethodNode(RClassImpl.this.bClass.getName(), (NodeTree.NodeAndPosition<ParsedNode>)classNode);
                if (constructor != null && !RClassImpl.this.hasMethodCall(doc, methodName, (NodeTree.NodeAndPosition<ParsedNode>)constructor, true)) {
                    RClassImpl.this.appendTextToNode(e, bje, (NodeTree.NodeAndPosition<ParsedNode>)constructor, "\n        " + methodName + "();\n    ");
                }
                if (showEditor) {
                    e.setVisible(true);
                }
            }
        });
    }

    private void appendTextToNode(Editor e, MoeEditor bjEditor, NodeTree.NodeAndPosition<ParsedNode> node, String text) {
        for (int pos = node.getEnd() - 1; pos >= 0; --pos) {
            if (!"}".equals(e.getText(e.getTextLocationFromOffset(pos), e.getTextLocationFromOffset(pos + 1)))) continue;
            bjEditor.undoManager.beginCompoundEdit();
            int originalLength = node.getSize();
            e.setText(e.getTextLocationFromOffset(pos), e.getTextLocationFromOffset(pos), text);
            int oldPos = bjEditor.getSourcePane().getCaretPosition();
            MoeIndent.calculateIndentsAndApply((MoeSyntaxDocument)bjEditor.getSourceDocument(), (int)node.getPosition(), (int)(node.getPosition() + originalLength + text.length()), (int)oldPos);
            bjEditor.undoManager.endCompoundEdit();
            e.setCaretLocation(e.getTextLocationFromOffset(pos));
            return;
        }
        Debug.message((String)("Could not find end of node to append to: \"" + e.getText(e.getTextLocationFromOffset(node.getPosition()), e.getTextLocationFromOffset(node.getEnd())) + "\""));
    }

    private Iterable<NodeTree.NodeAndPosition<ParsedNode>> iterable(final NodeTree.NodeAndPosition<ParsedNode> parent) {
        return new Iterable<NodeTree.NodeAndPosition<ParsedNode>>(){

            @Override
            public Iterator<NodeTree.NodeAndPosition<ParsedNode>> iterator() {
                return ((ParsedNode)parent.getNode()).getChildren(parent.getPosition());
            }
        };
    }

    private boolean hasMethodCall(MoeSyntaxDocument doc, String methodName, NodeTree.NodeAndPosition<ParsedNode> methodNode, boolean root) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(methodNode)) {
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && root) {
                return this.hasMethodCall(doc, methodName, nap, false);
            }
            try {
                if (((ParsedNode)nap.getNode()).getNodeType() != 6 || !doc.getText(nap.getPosition(), nap.getSize()).startsWith(methodName)) continue;
                return true;
            }
            catch (BadLocationException e) {
            }
        }
        return false;
    }

    private NodeTree.NodeAndPosition<ParsedNode> findMethodNode(String methodName, NodeTree.NodeAndPosition<ParsedNode> start) {
        for (NodeTree.NodeAndPosition<ParsedNode> nap : this.iterable(start)) {
            NodeTree.NodeAndPosition<ParsedNode> r;
            if (((ParsedNode)nap.getNode()).getNodeType() == 0 && (r = this.findMethodNode(methodName, nap)) != null) {
                return r;
            }
            if (((ParsedNode)nap.getNode()).getNodeType() != 2 || !((ParsedNode)nap.getNode()).getName().equals(methodName)) continue;
            return nap;
        }
        return null;
    }

    @Override
    public RConstructor getConstructor(Class<?>[] signature) throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BConstructor bConstructor = this.bClass.getConstructor((Class[])signature);
        RConstructor rConstructor = WrapperPool.instance().getWrapper(bConstructor);
        return rConstructor;
    }

    @Override
    public RConstructor[] getConstructors() throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BConstructor[] bConstructors = this.bClass.getConstructors();
        int length = bConstructors.length;
        RConstructor[] rConstructors = new RConstructor[length];
        for (int i = 0; i < length; ++i) {
            rConstructors[i] = WrapperPool.instance().getWrapper(bConstructors[i]);
        }
        return rConstructors;
    }

    @Override
    public BMethod getDeclaredMethod(String methodName, Class<?>[] params) throws ProjectNotOpenException, ClassNotFoundException {
        return null;
    }

    @Override
    public BMethod[] getDeclaredMethods() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getDeclaredMethods();
    }

    @Override
    public RField getField(String fieldName) throws ProjectNotOpenException, ClassNotFoundException, RemoteException {
        BField wrapped = this.bClass.getField(fieldName);
        RField wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    @Override
    public BField[] getFields() throws ProjectNotOpenException, ClassNotFoundException {
        return this.bClass.getFields();
    }

    @Override
    public RPackage getPackage() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        BPackage wrapped = this.bClass.getPackage();
        RPackage wrapper = WrapperPool.instance().getWrapper(wrapped);
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RClass getSuperclass(boolean inRemoteCallback) throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        if (!inRemoteCallback) {
            Class<RClassImpl> clazz = RClassImpl.class;
            synchronized (RClassImpl.class) {
                final BClass[] wrapped = new BClass[1];
                final ClassNotFoundException[] cnfe = new ClassNotFoundException[1];
                pnoe = null;
                pnfe = null;
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                wrapped[0] = RClassImpl.this.bClass.getSuperclass();
                            }
                            catch (ProjectNotOpenException e) {
                                pnoe = e;
                            }
                            catch (PackageNotFoundException e) {
                                pnfe = e;
                            }
                            catch (ClassNotFoundException e) {
                                cnfe[0] = e;
                            }
                        }
                    });
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                catch (InvocationTargetException ite) {
                    throw new RuntimeException(ite.getCause());
                }
                if (pnoe != null) {
                    throw pnoe;
                }
                if (pnfe != null) {
                    throw pnfe;
                }
                if (cnfe[0] != null) {
                    throw cnfe[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return WrapperPool.instance().getWrapper(wrapped[0]);
            }
        }
        BClass sc = this.bClass.getSuperclass();
        return WrapperPool.instance().getWrapper(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompiled(boolean inRemoteCallback) throws ProjectNotOpenException, PackageNotFoundException {
        Class<RClassImpl> clazz = RClassImpl.class;
        synchronized (RClassImpl.class) {
            pnoe = null;
            pnfe = null;
            final boolean[] result = new boolean[1];
            try {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            result[0] = RClassImpl.this.bClass.isCompiled();
                        }
                        catch (ProjectNotOpenException e) {
                            pnoe = e;
                        }
                        catch (PackageNotFoundException e) {
                            pnfe = e;
                        }
                    }
                };
                if (inRemoteCallback) {
                    r.run();
                } else {
                    EventQueue.invokeAndWait(r);
                }
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
            catch (InvocationTargetException ite) {
                ite.printStackTrace();
            }
            if (pnoe != null) {
                throw pnoe;
            }
            if (pnfe != null) {
                throw pnfe;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result[0];
        }
    }

    public String getToString() {
        return this.bClass.getName();
    }

    @Override
    public String getQualifiedName() throws RemoteException {
        return this.bClass.getName();
    }

    @Override
    public File getJavaFile() throws ProjectNotOpenException, PackageNotFoundException, RemoteException {
        return this.bClass.getJavaFile();
    }

    @Override
    public void remove() throws ProjectNotOpenException, PackageNotFoundException, ClassNotFoundException, RemoteException {
        this.bClass.remove();
    }

    @Override
    public void setReadOnly(boolean b) throws RemoteException, ProjectNotOpenException, PackageNotFoundException {
        if (this.bClass != null && this.bClass.getEditor() != null) {
            this.bClass.getEditor().setReadOnly(b);
        }
    }

    @Override
    public void autoIndent() throws ProjectNotOpenException, PackageNotFoundException {
        final Editor e = this.bClass.getEditor();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MoeEditor bje = (MoeEditor)EditorBridge.getEditor((Editor)e);
                MoeSyntaxDocument doc = bje.getSourceDocument();
                MoeIndent.calculateIndentsAndApply((MoeSyntaxDocument)doc, (int)0);
            }
        });
    }
}

