/*
 * Decompiled with CFR 0.152.
 */
package rmiextension;

import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.SourceLocation;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionBridge;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import greenfoot.actions.ResetWorldAction;
import greenfoot.core.Simulation;
import greenfoot.core.SimulationDebugMonitor;
import java.awt.EventQueue;
import java.io.File;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import rmiextension.ProjectManager;
import rmiextension.wrappers.RProjectImpl;
import rmiextension.wrappers.WrapperPool;

public class GreenfootDebugHandler
implements DebuggerListener {
    private static final String SIMULATION_CLASS = Simulation.class.getName();
    private static final String[] INVOKE_METHODS = new String[]{"actWorld", "actActor", "newInstance", Simulation.RUN_QUEUED_TASKS, "worldStarted", "worldStopped"};
    private static final String SIMULATION_INVOKE_KEY = SIMULATION_CLASS + "INTERNAL";
    private static final String PAUSED_METHOD = "simulationWait";
    private static final String SIMULATION_THREAD_PAUSED_KEY = "SIMULATION_THREAD_PAUSED";
    private static final String SIMULATION_THREAD_RUN_KEY = "SIMULATION_THREAD_RUN";
    private static final String RESET_CLASS = ResetWorldAction.class.getName();
    private static final String RESET_METHOD = "resetWorld";
    private static final String RESET_KEY = "RESET_WORLD";
    private BProject project;
    private DebuggerThread simulationThread;
    private DebuggerClass simulationClass;

    private GreenfootDebugHandler(BProject project) {
        this.project = project;
    }

    static void addDebuggerListener(BProject project) {
        try {
            Project proj = Project.getProject((File)project.getDir());
            GreenfootDebugHandler handler = new GreenfootDebugHandler(project);
            int mstate = proj.getDebugger().addDebuggerListener((DebuggerListener)handler);
            Debugger debugger = proj.getDebugger();
            GreenfootDebugHandler greenfootDebugHandler = handler;
            greenfootDebugHandler.getClass();
            debugger.addDebuggerListener((DebuggerListener)greenfootDebugHandler.new GreenfootDebugControlsLink());
            if (mstate == 2) {
                handler.addRunResetBreakpoints(proj.getDebugger());
                ProjectManager.instance().openGreenfoot(project);
            }
        }
        catch (ProjectNotOpenException ex) {
            Debug.reportError((String)"Project not open when adding debugger listener in Greenfoot", (Throwable)ex);
        }
    }

    private void addRunResetBreakpoints(Debugger debugger) {
        try {
            this.simulationClass = debugger.getClass(SIMULATION_CLASS, true);
            HashMap<String, String> simulationRunBreakpointProperties = new HashMap<String, String>();
            simulationRunBreakpointProperties.put(SIMULATION_THREAD_RUN_KEY, "TRUE");
            simulationRunBreakpointProperties.put("VMReference.PERSIST_BREAKPOINT", "TRUE");
            debugger.toggleBreakpoint(this.simulationClass, "run", true, simulationRunBreakpointProperties);
            HashMap<String, String> resetBreakpointProperties = new HashMap<String, String>();
            resetBreakpointProperties.put(RESET_KEY, "yes");
            resetBreakpointProperties.put("VMReference.PERSIST_BREAKPOINT", "TRUE");
            debugger.toggleBreakpoint(RESET_CLASS, RESET_METHOD, true, resetBreakpointProperties);
        }
        catch (ClassNotFoundException cnfe) {
            Debug.reportError((String)"Simulation class could not be located. Possible installation problem.", (Throwable)cnfe);
        }
    }

    private boolean isSimulationThread(DebuggerThread dt) {
        return dt != null && this.simulationThread != null && this.simulationThread.sameThread(dt);
    }

    public boolean examineDebuggerEvent(final DebuggerEvent e) {
        Debugger debugger = (Debugger)e.getSource();
        List stack = e.getThread().getStack();
        if (e.getID() == 5 && e.getThread() != null && e.getBreakpointProperties().get((Object)SIMULATION_THREAD_RUN_KEY) != null) {
            this.simulationThread = e.getThread();
            try {
                RProjectImpl rproj = WrapperPool.instance().getWrapper(this.project);
                rproj.setSimulationThread(this.simulationThread);
            }
            catch (RemoteException re) {
                Debug.reportError((String)"Unexpected exception getting project wrapper: ", (Throwable)re);
            }
            e.getThread().cont();
            return true;
        }
        if (e.getID() == 5 && GreenfootDebugHandler.atResetBreakpoint(e.getBreakpointProperties())) {
            if (this.simulationThread.isSuspended()) {
                this.simulationThread.cont();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtensionBridge.clearObjectBench((BProject)GreenfootDebugHandler.this.project);
                    }
                    catch (ProjectNotOpenException projectNotOpenException) {
                        // empty catch block
                    }
                    e.getThread().cont();
                }
            });
            return true;
        }
        if (e.isHalt() && this.isSimulationThread(e.getThread())) {
            if (GreenfootDebugHandler.atPauseBreakpoint(e.getBreakpointProperties())) {
                debugger.removeBreakpointsForClass(SIMULATION_CLASS);
                e.getThread().cont();
                return true;
            }
            if (GreenfootDebugHandler.insideUserCode(stack)) {
                debugger.removeBreakpointsForClass(SIMULATION_CLASS);
                if (GreenfootDebugHandler.atInvokeBreakpoint(e.getBreakpointProperties())) {
                    e.getThread().stepInto();
                    return true;
                }
                if (GreenfootDebugHandler.inInvokeMethods(stack, 0)) {
                    this.runToInternalBreakpoint(debugger, e.getThread());
                    return true;
                }
            } else {
                if (GreenfootDebugHandler.inPauseMethod(stack)) {
                    e.getThread().cont();
                } else {
                    this.runToInternalBreakpoint(debugger, e.getThread());
                }
                return true;
            }
        }
        return false;
    }

    public void processDebuggerEvent(final DebuggerEvent e, boolean skipUpdate) {
        if (e.getNewState() == 2 && e.getOldState() == 1 && !ProjectManager.checkLaunchFailed()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GreenfootDebugHandler.this.addRunResetBreakpoints((Debugger)e.getSource());
                    ProjectManager.instance().openGreenfoot(GreenfootDebugHandler.this.project);
                }
            });
        }
    }

    private void runToInternalBreakpoint(Debugger debugger, DebuggerThread thread) {
        this.setSpecialBreakpoints(debugger);
        thread.cont();
    }

    private static boolean insideUserCode(List<SourceLocation> stack) {
        for (int i = 0; i < stack.size(); ++i) {
            if (!GreenfootDebugHandler.inInvokeMethods(stack, i)) continue;
            return true;
        }
        return false;
    }

    private static boolean inInvokeMethods(List<SourceLocation> stack, int frame) {
        if (frame < stack.size()) {
            String className = stack.get(frame).getClassName();
            if (className.equals(SIMULATION_CLASS)) {
                String methodName = stack.get(frame).getMethodName();
                for (String actMethod : INVOKE_METHODS) {
                    if (!actMethod.equals(methodName)) continue;
                    return true;
                }
            } else if (JavaNames.getBase((String)className).startsWith("__SHELL")) {
                return true;
            }
        }
        return false;
    }

    private static boolean atResetBreakpoint(DebuggerEvent.BreakpointProperties props) {
        return props != null && props.get((Object)RESET_KEY) != null;
    }

    private static boolean atPauseBreakpoint(DebuggerEvent.BreakpointProperties props) {
        return props != null && props.get((Object)SIMULATION_THREAD_PAUSED_KEY) != null;
    }

    private static boolean inPauseMethod(List<SourceLocation> stack) {
        for (SourceLocation loc : stack) {
            if (!loc.getClassName().equals(SIMULATION_CLASS) || !loc.getMethodName().equals(PAUSED_METHOD)) continue;
            return true;
        }
        return false;
    }

    private static boolean atInvokeBreakpoint(DebuggerEvent.BreakpointProperties props) {
        return props != null && props.get((Object)SIMULATION_INVOKE_KEY) != null;
    }

    private void setSpecialBreakpoints(Debugger debugger) {
        for (String method : INVOKE_METHODS) {
            String err = debugger.toggleBreakpoint(this.simulationClass, method, true, Collections.singletonMap(SIMULATION_INVOKE_KEY, "yes"));
            if (err == null) continue;
            Debug.reportError((String)("Problem setting special breakpoint: " + err));
        }
        String err = debugger.toggleBreakpoint(this.simulationClass, PAUSED_METHOD, true, Collections.singletonMap(SIMULATION_THREAD_PAUSED_KEY, "yes"));
        if (err != null) {
            Debug.reportError((String)("Problem setting special breakpoint: " + err));
        }
    }

    private class GreenfootDebugControlsLink
    implements DebuggerListener {
        private LinkedList<String> queuedStateVars = new LinkedList();
        private Object SEND_EVENT = new Object();
        private String CLASS_NAME = SimulationDebugMonitor.class.getName();

        private GreenfootDebugControlsLink() {
        }

        private void simplifyEvents() {
            while (this.queuedStateVars.size() > 1) {
                this.queuedStateVars.removeFirst();
            }
        }

        public boolean examineDebuggerEvent(DebuggerEvent e) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void processDebuggerEvent(DebuggerEvent e, boolean skipUpdate) {
            String stateVar;
            if (e.isHalt()) {
                if (!GreenfootDebugHandler.this.isSimulationThread(e.getThread())) return;
                stateVar = "NOT_RUNNING";
            } else {
                if (e.getID() != 6) return;
                if (!GreenfootDebugHandler.this.isSimulationThread(e.getThread())) return;
                stateVar = "RUNNING";
            }
            Debugger debugger = (Debugger)e.getSource();
            LinkedList<String> linkedList = this.queuedStateVars;
            synchronized (linkedList) {
                this.queuedStateVars.addLast(stateVar);
                new Thread(new SendNextEvent(debugger)).start();
                return;
            }
        }

        private class SendNextEvent
        implements Runnable {
            private Debugger debugger;

            public SendNextEvent(Debugger debugger) {
                this.debugger = debugger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = GreenfootDebugControlsLink.this.SEND_EVENT;
                synchronized (object) {
                    String stateVar;
                    LinkedList linkedList = GreenfootDebugControlsLink.this.queuedStateVars;
                    synchronized (linkedList) {
                        GreenfootDebugControlsLink.this.simplifyEvents();
                        if (GreenfootDebugControlsLink.this.queuedStateVars.isEmpty()) {
                            return;
                        }
                        stateVar = (String)GreenfootDebugControlsLink.this.queuedStateVars.removeFirst();
                    }
                    try {
                        DebuggerField simMonField;
                        DebuggerClass simMonClass = this.debugger.getClass(GreenfootDebugControlsLink.this.CLASS_NAME, true);
                        DebuggerObject stateObject = null;
                        int i = 0;
                        while (true) {
                            if ((simMonField = simMonClass.getStaticField(i)).getName().equals(stateVar)) break;
                            ++i;
                        }
                        stateObject = simMonField.getValueObject(null);
                        this.debugger.instantiateClass(GreenfootDebugControlsLink.this.CLASS_NAME, new String[]{"java.lang.Object"}, new DebuggerObject[]{stateObject});
                    }
                    catch (ClassNotFoundException ex) {
                        Debug.reportError((String)("Could not find internal class " + GreenfootDebugControlsLink.this.CLASS_NAME), (Throwable)ex);
                    }
                }
            }
        }
    }
}

