/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.localdebugger;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.Reflective;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import greenfoot.localdebugger.LocalClass;
import greenfoot.localdebugger.LocalObject;
import java.lang.reflect.Field;

public class LocalField
extends DebuggerField {
    private boolean hidden;
    private Field field;
    private LocalObject parentObject;

    public LocalField(LocalObject parentObject, Field field, boolean hidden) {
        this.parentObject = parentObject;
        this.field = field;
        this.hidden = hidden;
    }

    public DebuggerClass getDeclaringClass() {
        return new LocalClass(this.field.getDeclaringClass());
    }

    public int getModifiers() {
        return this.field.getModifiers();
    }

    public String getName() {
        return this.field.getName();
    }

    public JavaType getType() {
        try {
            JavaType fieldType = JavaUtils.getJavaUtils().getFieldType(this.field);
            if (this.parentObject != null) {
                GenTypeClass parentType = this.parentObject.getGenType();
                parentType = parentType.mapToSuper(this.field.getDeclaringClass().getName());
                fieldType = fieldType.mapTparsToTypes(parentType.getMap()).getUpperBound();
            }
            return fieldType;
        }
        catch (ClassNotFoundException cnfe) {
            return new GenTypeClass((Reflective)new JavaReflective(this.field.getType()));
        }
    }

    public DebuggerObject getValueObject(JavaType expectedType) {
        try {
            boolean accessible = this.field.isAccessible();
            this.field.setAccessible(true);
            Object resultObj = this.parentObject == null ? this.field.get(null) : this.field.get(this.parentObject.object);
            this.field.setAccessible(accessible);
            GenTypeClass fieldClass = this.getType().asClass();
            if (resultObj != null && fieldClass != null) {
                GenTypeClass objClass = fieldClass.mapToDerived((Reflective)new JavaReflective(resultObj.getClass()));
                return LocalObject.getLocalObject(resultObj, objClass.getMap());
            }
            return LocalObject.getLocalObject(resultObj);
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public String getValueString() {
        try {
            boolean accessible = this.field.isAccessible();
            this.field.setAccessible(true);
            Object pObj = this.parentObject == null ? null : this.parentObject.object;
            Object resultObj = this.field.get(pObj);
            this.field.setAccessible(accessible);
            if (this.field.getType().isPrimitive()) {
                return resultObj.toString();
            }
            return LocalField.valueStringForObject(resultObj);
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public static String valueStringForObject(Object o) {
        if (o instanceof String) {
            return "\"" + JavaUtils.escapeString((String)o.toString()) + "\"";
        }
        if (o == null) {
            return "null";
        }
        return "<object reference>";
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

