/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.localdebugger;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerField;
import bluej.debugger.DebuggerObject;
import greenfoot.Actor;
import greenfoot.World;
import greenfoot.localdebugger.LocalField;
import greenfoot.localdebugger.LocalObject;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LocalClass
extends DebuggerClass {
    private Class<?> cl;
    private static Field[] noFields = new Field[0];

    public LocalClass(Class<?> cl) {
        this.cl = cl;
    }

    public String getName() {
        return this.cl.getName();
    }

    public List<DebuggerField> getStaticFields() {
        Field[] fields = this.getFields();
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<DebuggerField> rlist = new ArrayList<DebuggerField>(fields.length);
        Field[] arr$ = fields;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field field;
            boolean visible = usedNames.add((field = arr$[i$]).getName());
            rlist.add(new LocalField(null, field, !visible));
        }
        return rlist;
    }

    public int getStaticFieldCount() {
        return this.getFields().length;
    }

    public String getStaticFieldName(int slot) {
        Field field = this.getFields()[slot];
        return field.getName();
    }

    public DebuggerObject getStaticFieldObject(int slot) {
        Field field = this.getFields()[slot];
        try {
            return LocalObject.getLocalObject(field.get(null));
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public List<String> getStaticFields(boolean includeModifiers, Map<String, List<String>> restrictedClasses) {
        ArrayList<String> r = new ArrayList<String>();
        Field[] fields = this.getFields();
        for (int i = 0; i < fields.length; ++i) {
            int mods = fields[i].getModifiers();
            String desc = "";
            if (includeModifiers) {
                desc = Modifier.toString(mods) + " ";
            }
            desc = desc + fields[i].getName() + " = ";
            try {
                Object fieldval;
                desc = fields[i].getType().isPrimitive() ? desc + fields[i].get(null) : ((fieldval = fields[i].get(null)) instanceof String ? desc + '\"' + fieldval.toString() + '\"' : (fieldval == null ? desc + "null" : desc + "<object reference>"));
            }
            catch (IllegalAccessException iae) {
                desc = desc + "?";
            }
            r.add(desc);
        }
        return r;
    }

    public boolean staticFieldIsPublic(int slot) {
        return false;
    }

    public boolean staticFieldIsObject(int slot) {
        Field field = this.getFields()[slot];
        return !field.getType().isPrimitive() && this.fieldNotNull(field);
    }

    public boolean isInterface() {
        return this.cl.isInterface();
    }

    public boolean isEnum() {
        return false;
    }

    private Field[] getFields() {
        ArrayList<AccessibleObject> allFields = new ArrayList<AccessibleObject>();
        for (Class<?> c = this.cl; c != null; c = c.getSuperclass()) {
            AccessibleObject[] declFields = c.getDeclaredFields();
            ArrayList<Field> sfields = new ArrayList<Field>();
            for (int i = 0; i < declFields.length; ++i) {
                Field field = declFields[i];
                if ((field.getModifiers() & 8) == 0 || !this.keepField(c, field)) continue;
                sfields.add(field);
            }
            declFields = sfields.toArray(noFields);
            AccessibleObject.setAccessible(declFields, true);
            allFields.addAll(Arrays.asList(declFields));
        }
        return allFields.toArray(noFields);
    }

    public boolean fieldNotNull(Field field) {
        try {
            Object v = field.get(null);
            return v != null;
        }
        catch (IllegalAccessException iae) {
            return false;
        }
    }

    private boolean keepField(Class<?> cls, Field field) {
        if (cls.equals(World.class)) {
            return false;
        }
        return !cls.equals(Actor.class);
    }
}

