/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.input.states;

import greenfoot.event.TriggeredKeyListener;
import greenfoot.event.TriggeredMouseListener;
import greenfoot.event.TriggeredMouseMotionListener;
import greenfoot.gui.input.InputManager;
import greenfoot.gui.input.states.ConstructorDragState;
import greenfoot.gui.input.states.MoveState;
import greenfoot.gui.input.states.QuickAddDragState;
import greenfoot.gui.input.states.RunningState;
import greenfoot.gui.input.states.State;

public class IdleState
extends State {
    protected static IdleState instance;

    public static synchronized IdleState getInstance() throws IllegalStateException {
        if (instance == null) {
            throw new IllegalStateException("Not initialized.");
        }
        return instance;
    }

    private IdleState(InputManager inputManager, TriggeredKeyListener keyListener, TriggeredMouseListener mouseListener, TriggeredMouseMotionListener mouseMotionListener) {
        super(inputManager, keyListener, mouseListener, mouseMotionListener);
    }

    public static synchronized IdleState initialize(InputManager inputManager, TriggeredKeyListener keyListener, TriggeredMouseListener mouseListener, TriggeredMouseMotionListener mouseMotionListener) {
        instance = new IdleState(inputManager, keyListener, mouseListener, mouseMotionListener);
        return instance;
    }

    @Override
    public void switchToNextState(State.Event event, Object obj) {
        super.switchToNextState(event, obj);
        switch (event) {
            case CONSTRUCTOR_INVOKED: {
                this.switchAndActivateState(ConstructorDragState.getInstance(), obj);
                break;
            }
            case OBJECT_MOVED: {
                this.switchAndActivateState(MoveState.getInstance(), obj);
                break;
            }
            case SIMULATION_STARTED: {
                this.switchAndActivateState(RunningState.getInstance(), obj);
                break;
            }
            case MOUSE_PRESSED: {
                this.switchAndActivateState(MoveState.getInstance(), obj);
                break;
            }
            case SHIFT_PRESSED: {
                this.switchAndActivateState(QuickAddDragState.getInstance(), obj);
            }
        }
    }
}

