/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.classbrowser.role;

import bluej.Config;
import bluej.debugmgr.ConstructAction;
import bluej.debugmgr.inspector.InspectorManager;
import bluej.debugmgr.objectbench.InvokeListener;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.prefmgr.PrefMgr;
import bluej.utility.Debug;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MemberView;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import greenfoot.actions.EditClassAction;
import greenfoot.actions.InspectClassAction;
import greenfoot.actions.NewSubclassAction;
import greenfoot.actions.RemoveClassAction;
import greenfoot.core.GClass;
import greenfoot.core.GProject;
import greenfoot.core.GreenfootMain;
import greenfoot.core.WorldHandler;
import greenfoot.core.WorldInvokeListener;
import greenfoot.event.WorldEvent;
import greenfoot.event.WorldListener;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.GreenfootInspectorManager;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.localdebugger.LocalClass;
import greenfoot.record.InteractionListener;
import java.awt.Color;
import java.awt.Dimension;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public abstract class ClassRole
implements WorldListener {
    protected static final Dimension iconSize = new Dimension(16, 16);
    private final Color envOpColour = new Color(152, 32, 32);

    public abstract void buildUI(ClassView var1, GClass var2);

    public abstract String getTemplateFileName();

    public List<Action> createConstructorActions(Class<?> realClass, GProject project, InteractionListener interactionListener) {
        View view = View.getView(realClass);
        ArrayList<Action> actions = new ArrayList<Action>();
        ConstructorView[] constructors = view.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            try {
                ConstructorView m = constructors[constructors.length - i - 1];
                ViewFilter filter = new ViewFilter(131073);
                if (!filter.accept((MemberView)m)) continue;
                ObjectBenchInterface ob = WorldHandler.getInstance().getObjectBench();
                GreenfootFrame frame = GreenfootMain.getInstance().getFrame();
                GreenfootInspectorManager inspectorManager = frame.getInspectorManager();
                WorldInvokeListener invocListener = new WorldInvokeListener((JFrame)frame, realClass, ob, (InspectorManager)inspectorManager, interactionListener, project);
                String prefix = "new ";
                ConstructAction callAction = new ConstructAction(m, (InvokeListener)invocListener, prefix + m.getLongDesc());
                actions.add((Action)callAction);
                continue;
            }
            catch (Exception e) {
                Debug.reportError((String)("Exception accessing methods: " + e));
                e.printStackTrace();
            }
        }
        return actions;
    }

    public JPopupMenu createPopupMenu(ClassBrowser classBrowser, ClassView classView, InteractionListener interactionListener, boolean isUncompiled) {
        Class<?> realClass;
        GClass gClass = classView.getGClass();
        JPopupMenu popupMenu = new JPopupMenu();
        GProject project = null;
        project = gClass.getPackage().getProject();
        if (isUncompiled) {
            JMenuItem needsCompileItem = popupMenu.add(Config.getString((String)"classPopup.needsCompile"));
            needsCompileItem.setEnabled(false);
            needsCompileItem.setFont(PrefMgr.getPopupMenuFont());
            popupMenu.addSeparator();
        }
        if ((realClass = gClass.getJavaClass()) != null) {
            GreenfootInspectorManager inspectorManager;
            if (!Modifier.isAbstract(realClass.getModifiers())) {
                List<Action> constructorItems = this.createConstructorActions(realClass, project, interactionListener);
                boolean hasEntries = false;
                for (Action callAction : constructorItems) {
                    JMenuItem item = popupMenu.add(callAction);
                    item.setFont(PrefMgr.getPopupMenuFont());
                    hasEntries = true;
                }
                if (hasEntries) {
                    popupMenu.addSeparator();
                }
            }
            ViewFilter filter = new ViewFilter(9);
            View view = View.getView(realClass);
            MethodView[] allMethods = view.getAllMethods();
            ObjectBenchInterface ob = WorldHandler.getInstance().getObjectBench();
            GreenfootFrame frame = GreenfootMain.getInstance().getFrame();
            WorldInvokeListener invocListener = new WorldInvokeListener((JFrame)frame, realClass, ob, (InspectorManager)(inspectorManager = frame.getInspectorManager()), interactionListener, project);
            if (bluej.pkgmgr.target.role.ClassRole.createMenuItems((JPopupMenu)popupMenu, (CallableView[])allMethods, (ViewFilter)filter, (int)0, (int)allMethods.length, (String)"", (InvokeListener)invocListener)) {
                popupMenu.addSeparator();
            }
        }
        if (!classView.isCoreClass()) {
            if (gClass.hasSourceCode()) {
                popupMenu.add(this.createMenuItem(new EditClassAction(classBrowser)));
            }
            this.addPopupMenuItems(popupMenu, false);
            if (classView.getRealClass() != null) {
                popupMenu.add(this.createMenuItem(new InspectClassAction(new LocalClass(classView.getRealClass()), null, classBrowser.getFrame().getInspectorManager(), classBrowser.getFrame())));
            }
            popupMenu.add(this.createMenuItem(new RemoveClassAction(classView, classBrowser.getFrame())));
        } else {
            this.addPopupMenuItems(popupMenu, true);
        }
        popupMenu.addSeparator();
        popupMenu.add(this.createMenuItem(new NewSubclassAction(classView, classBrowser, interactionListener)));
        return popupMenu;
    }

    protected JMenuItem createMenuItem(Action action) {
        JMenuItem item = new JMenuItem(action);
        item.setFont(PrefMgr.getPopupMenuFont());
        item.setForeground(this.envOpColour);
        return item;
    }

    public void addPopupMenuItems(JPopupMenu menu, boolean coreClass) {
    }

    @Override
    public void worldCreated(WorldEvent e) {
    }

    @Override
    public void worldRemoved(WorldEvent e) {
    }

    public abstract void remove();
}

